package nu.marginalia.functions.math.dict;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.zaxxer.hikari.HikariDataSource;
import nu.marginalia.api.math.model.DictionaryEntry;
import nu.marginalia.api.math.model.DictionaryResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.ArrayList;
import java.util.List;

@Singleton
public class DictionaryService {

    private final HikariDataSource dataSource;
    private final SpellChecker spellChecker;
    private final Logger logger = LoggerFactory.getLogger(getClass());

    @Inject
    public DictionaryService(HikariDataSource dataSource, SpellChecker spellChecker)
    {
        this.spellChecker = spellChecker;
        this.dataSource = dataSource;
    }

    public DictionaryResponse define(String word) {
        List<DictionaryEntry> entries = new ArrayList<>();

        try (var connection = dataSource.getConnection()) {
            var stmt = connection.prepareStatement("SELECT TYPE,WORD,DEFINITION FROM REF_DICTIONARY WHERE WORD=?");
            stmt.setString(1, word);

            var rsp = stmt.executeQuery();
            while (rsp.next()) {
                entries.add(new DictionaryEntry(rsp.getString(1), rsp.getString(2), rsp.getString(3)));
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }

        return new DictionaryResponse(word, entries);
    }

    public List<String> spellCheck(String word) {
        return spellChecker.correct(word);
    }
}
