ALTER TABLE FILE_STORAGE_BASE MODIFY COLUMN NAME VARCHAR(255) NOT NULL;
ALTER TABLE FILE_STORAGE_BASE MODIFY COLUMN PATH VARCHAR(255) NOT NULL;
DROP INDEX PATH ON FILE_STORAGE_BASE;
DROP INDEX NAME ON FILE_STORAGE_BASE;
ALTER TABLE FILE_STORAGE_BASE ADD COLUMN NODE INT NOT NULL DEFAULT -1;
CREATE UNIQUE INDEX FILE_STORAGE_BASE__NODE_NAME ON FILE_STORAGE_BASE(NODE, NAME);
CREATE UNIQUE INDEX FILE_STORAGE_BASE__NODE_PATH ON FILE_STORAGE_BASE(NODE, PATH);


DROP VIEW FILE_STORAGE_VIEW;
CREATE VIEW FILE_STORAGE_VIEW
AS SELECT
    CONCAT(BASE.PATH, '/', STORAGE.PATH) AS PATH,
    STORAGE.TYPE AS TYPE,
    NODE AS NODE,
    DESCRIPTION AS DESCRIPTION,
    CREATE_DATE AS CREATE_DATE,
    STORAGE.ID AS ID,
    BASE.ID AS BASE_ID
FROM FILE_STORAGE STORAGE
INNER JOIN FILE_STORAGE_BASE BASE ON STORAGE.BASE_ID=BASE.ID;
