CREATE TABLE IF NOT EXISTS DOMAIN_SELECTION_TYPE (
    ID INT PRIMARY KEY AUTO_INCREMENT,
    NAME VARCHAR(255) UNIQUE,
    SOURCE VARCHAR(255) NOT NULL
)
CHARACTER SET utf8mb4
COLLATE utf8mb4_bin;

CREATE TABLE DOMAIN_SELECTION (
    DOMAIN_NAME VARCHAR(255) PRIMARY KEY,
    DOMAIN_TYPE_ID INT,
    FOREIGN KEY (DOMAIN_TYPE_ID) REFERENCES DOMAIN_SELECTION_TYPE(ID) ON DELETE CASCADE
)
CHARACTER SET utf8mb4
COLLATE utf8mb4_unicode_ci;

INSERT IGNORE INTO DOMAIN_SELECTION_TYPE(NAME, SOURCE)
VALUES ('BLOG', 'https://raw.githubusercontent.com/MarginaliaSearch/PublicData/master/sets/blogs.txt'),
       ('TEST', 'https://downloads.marginalia.nu/domain-list-test.txt');