# Contributing to reliability-checklist

Thank you for your interest in contributing to reliability-checklist! Here are some guidelines to follow when contributing to the project:

## How to Contribute

- Fork the repository.
- Create a new branch with a descriptive name for your contribution.
- Make your changes and commit them with a clear commit message.
- Push your changes to your forked repository.
- Submit a pull request to the develop branch of the main repository.

## Coding Standards

We follow the [coding standards](https://google.github.io/styleguide/pyguide.html). Please ensure that your contributions adhere to these standards.

## Reporting Issues

If you encounter an issue with the project, please [submit an issue](https://github.com/Maitreyapatel/reliability-checklist/issues/new/choose) with a clear description of the problem, including steps to reproduce it.

## Feature Requests

If you have an idea for a new feature or enhancement to the project, please [submit a feature request](https://github.com/Maitreyapatel/reliability-checklist/issues/new/choose) with a clear description of the feature and why it would be beneficial to the project.

## Code of Conduct

We follow the [code of conduct](CODE_OF_CONDUCT.md). Please ensure that all contributions, discussions, and interactions adhere to this code of conduct.

Thank you for contributing to reliability-checklist!
