<?php

/**
 * Maho
 *
 * @category   Maho
 * @package    MahoCLI
 * @copyright  Copyright (c) 2023 The OpenMage Contributors (https://www.openmage.org)
 * @copyright  Copyright (c) 2024 Maho (https://mahocommerce.com)
 * @license    https://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
 */

namespace MahoCLI\Commands;

use Symfony\Component\Console\Attribute\AsCommand;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;

#[AsCommand(
    name: 'legacy:rename-mysql4-classes',
    description: 'Search for old Mysql4 classes and replaces them with Resource classes',
)]
class LegacyRenameMysql4Classes extends BaseMahoCommand
{
    #[\Override]
    protected function execute(InputInterface $input, OutputInterface $output): int
    {
        $todo = [
            'Mage_Admin_Model_Mysql4_Acl' => 'Mage_Admin_Model_Resource_Acl',
            'Mage_Admin_Model_Mysql4_Acl_Role' => 'Mage_Admin_Model_Resource_Acl_Role',
            'Mage_Admin_Model_Mysql4_Acl_Role_Collection' => 'Mage_Admin_Model_Resource_Acl_Role_Collection',
            'Mage_Admin_Model_Mysql4_Permissions_Collection' => 'Mage_Admin_Model_Resource_Permissions_Collection',
            'Mage_Admin_Model_Mysql4_Role' => 'Mage_Admin_Model_Resource_Role',
            'Mage_Admin_Model_Mysql4_Role_Collection' => 'Mage_Admin_Model_Resource_Role_Collection',
            'Mage_Admin_Model_Mysql4_Roles' => 'Mage_Admin_Model_Resource_Roles',
            'Mage_Admin_Model_Mysql4_Roles_Collection' => 'Mage_Admin_Model_Resource_Roles_Collection',
            'Mage_Admin_Model_Mysql4_Roles_User_Collection' => 'Mage_Admin_Model_Resource_Roles_User_Collection',
            'Mage_Admin_Model_Mysql4_Rules' => 'Mage_Admin_Model_Resource_Rules',
            'Mage_Admin_Model_Mysql4_Rules_Collection' => 'Mage_Admin_Model_Resource_Rules_Collection',
            'Mage_Admin_Model_Mysql4_User' => 'Mage_Admin_Model_Resource_User',
            'Mage_Admin_Model_Mysql4_User_Collection' => 'Mage_Admin_Model_Resource_User_Collection',
            'Mage_AdminNotification_Model_Mysql4_Inbox' => 'Mage_AdminNotification_Model_Resource_Inbox',
            'Mage_AdminNotification_Model_Mysql4_Inbox_Collection' => 'Mage_AdminNotification_Model_Resource_Inbox_Collection',
            'Mage_Api_Model_Mysql4_Acl' => 'Mage_Api_Model_Resource_Acl',
            'Mage_Api_Model_Mysql4_Acl_Role' => 'Mage_Api_Model_Resource_Acl_Role',
            'Mage_Api_Model_Mysql4_Acl_Role_Collection' => 'Mage_Api_Model_Resource_Acl_Role_Collection',
            'Mage_Api_Model_Mysql4_Permissions_Collection' => 'Mage_Api_Model_Resource_Permissions_Collection',
            'Mage_Api_Model_Mysql4_Role' => 'Mage_Api_Model_Resource_Role',
            'Mage_Api_Model_Mysql4_Role_Collection' => 'Mage_Api_Model_Resource_Role_Collection',
            'Mage_Api_Model_Mysql4_Roles' => 'Mage_Api_Model_Resource_Roles',
            'Mage_Api_Model_Mysql4_Roles_Collection' => 'Mage_Api_Model_Resource_Roles_Collection',
            'Mage_Api_Model_Mysql4_Roles_User_Collection' => 'Mage_Api_Model_Resource_Roles_User_Collection',
            'Mage_Api_Model_Mysql4_Rules' => 'Mage_Api_Model_Resource_Rules',
            'Mage_Api_Model_Mysql4_Rules_Collection' => 'Mage_Api_Model_Resource_Rules_Collection',
            'Mage_Api_Model_Mysql4_User' => 'Mage_Api_Model_Resource_User',
            'Mage_Api_Model_Mysql4_User_Collection' => 'Mage_Api_Model_Resource_User_Collection',
            'Mage_Bundle_Model_Mysql4_Bundle' => 'Mage_Bundle_Model_Resource_Bundle',
            'Mage_Bundle_Model_Mysql4_Indexer_Price' => 'Mage_Bundle_Model_Resource_Indexer_Price',
            'Mage_Bundle_Model_Mysql4_Indexer_Stock' => 'Mage_Bundle_Model_Resource_Indexer_Stock',
            'Mage_Bundle_Model_Mysql4_Option' => 'Mage_Bundle_Model_Resource_Option',
            'Mage_Bundle_Model_Mysql4_Option_Collection' => 'Mage_Bundle_Model_Resource_Option_Collection',
            'Mage_Bundle_Model_Mysql4_Price_Index' => 'Mage_Bundle_Model_Resource_Price_Index',
            'Mage_Bundle_Model_Mysql4_Selection' => 'Mage_Bundle_Model_Resource_Selection',
            'Mage_Bundle_Model_Mysql4_Selection_Collection' => 'Mage_Bundle_Model_Resource_Selection_Collection',
            'Mage_Catalog_Model_Resource_Eav_Mysql4_Abstract' => 'Mage_Catalog_Model_Resource_Abstract',
            'Mage_Catalog_Model_Resource_Eav_Mysql4_Attribute' => 'Mage_Catalog_Model_Resource_Attribute',
            'Mage_Catalog_Model_Resource_Eav_Mysql4_Category' => 'Mage_Catalog_Model_Resource_Category',
            'Mage_Catalog_Model_Resource_Eav_Mysql4_Category_Attribute_Collection' => 'Mage_Catalog_Model_Resource_Category_Attribute_Collection',
            'Mage_Catalog_Model_Resource_Eav_Mysql4_Category_Attribute_Frontend_Image' => 'Mage_Catalog_Model_Resource_Category_Attribute_Frontend_Image',
            'Mage_Catalog_Model_Resource_Eav_Mysql4_Category_Attribute_Source_Layout' => 'Mage_Catalog_Model_Resource_Category_Attribute_Source_Layout',
            'Mage_Catalog_Model_Resource_Eav_Mysql4_Category_Attribute_Source_Mode' => 'Mage_Catalog_Model_Resource_Category_Attribute_Source_Mode',
            'Mage_Catalog_Model_Resource_Eav_Mysql4_Category_Attribute_Source_Page' => 'Mage_Catalog_Model_Resource_Category_Attribute_Source_Page',
            'Mage_Catalog_Model_Resource_Eav_Mysql4_Category_Collection' => 'Mage_Catalog_Model_Resource_Category_Collection',
            'Mage_Catalog_Model_Resource_Eav_Mysql4_Category_Flat' => 'Mage_Catalog_Model_Resource_Category_Flat',
            'Mage_Catalog_Model_Resource_Eav_Mysql4_Category_Flat_Collection' => 'Mage_Catalog_Model_Resource_Category_Flat_Collection',
            'Mage_Catalog_Model_Resource_Eav_Mysql4_Category_Indexer_Product' => 'Mage_Catalog_Model_Resource_Category_Indexer_Product',
            'Mage_Catalog_Model_Resource_Eav_Mysql4_Category_Tree' => 'Mage_Catalog_Model_Resource_Category_Tree',
            'Mage_Catalog_Model_Resource_Eav_Mysql4_Collection_Abstract' => 'Mage_Catalog_Model_Resource_Collection_Abstract',
            'Mage_Catalog_Model_Resource_Eav_Mysql4_Config' => 'Mage_Catalog_Model_Resource_Config',
            'Mage_Catalog_Model_Resource_Eav_Mysql4_Layer_Filter_Attribute' => 'Mage_Catalog_Model_Resource_Layer_Filter_Attribute',
            'Mage_Catalog_Model_Resource_Eav_Mysql4_Layer_Filter_Decimal' => 'Mage_Catalog_Model_Resource_Layer_Filter_Decimal',
            'Mage_Catalog_Model_Resource_Eav_Mysql4_Layer_Filter_Price' => 'Mage_Catalog_Model_Resource_Layer_Filter_Price',
            'Mage_Catalog_Model_Resource_Eav_Mysql4_Product' => 'Mage_Catalog_Model_Resource_Product',
            'Mage_Catalog_Model_Resource_Eav_Mysql4_Product_Action' => 'Mage_Catalog_Model_Resource_Product_Action',
            'Mage_Catalog_Model_Resource_Eav_Mysql4_Product_Attribute_Backend_Image' => 'Mage_Catalog_Model_Resource_Product_Attribute_Backend_Image',
            'Mage_Catalog_Model_Resource_Eav_Mysql4_Product_Attribute_Backend_Media' => 'Mage_Catalog_Model_Resource_Product_Attribute_Backend_Media',
            'Mage_Catalog_Model_Resource_Eav_Mysql4_Product_Attribute_Backend_Tierprice' => 'Mage_Catalog_Model_Resource_Product_Attribute_Backend_Tierprice',
            'Mage_Catalog_Model_Resource_Eav_Mysql4_Product_Attribute_Backend_Urlkey' => 'Mage_Catalog_Model_Resource_Product_Attribute_Backend_Urlkey',
            'Mage_Catalog_Model_Resource_Eav_Mysql4_Product_Attribute_Collection' => 'Mage_Catalog_Model_Resource_Product_Attribute_Collection',
            'Mage_Catalog_Model_Resource_Eav_Mysql4_Product_Attribute_Frontend_Image' => 'Mage_Catalog_Model_Resource_Product_Attribute_Frontend_Image',
            'Mage_Catalog_Model_Resource_Eav_Mysql4_Product_Attribute_Frontend_Tierprice' => 'Mage_Catalog_Model_Resource_Product_Attribute_Frontend_Tierprice',
            'Mage_Catalog_Model_Resource_Eav_Mysql4_Product_Collection' => 'Mage_Catalog_Model_Resource_Product_Collection',
            'Mage_Catalog_Model_Resource_Eav_Mysql4_Product_Compare_Item' => 'Mage_Catalog_Model_Resource_Product_Compare_Item',
            'Mage_Catalog_Model_Resource_Eav_Mysql4_Product_Compare_Item_Collection' => 'Mage_Catalog_Model_Resource_Product_Compare_Item_Collection',
            'Mage_Catalog_Model_Resource_Eav_Mysql4_Product_Flat' => 'Mage_Catalog_Model_Resource_Product_Flat',
            'Mage_Catalog_Model_Resource_Eav_Mysql4_Product_Flat_Indexer' => 'Mage_Catalog_Model_Resource_Product_Flat_Indexer',
            'Mage_Catalog_Model_Resource_Eav_Mysql4_Product_Indexer_Abstract' => 'Mage_Catalog_Model_Resource_Product_Indexer_Abstract',
            'Mage_Catalog_Model_Resource_Eav_Mysql4_Product_Indexer_Eav' => 'Mage_Catalog_Model_Resource_Product_Indexer_Eav',
            'Mage_Catalog_Model_Resource_Eav_Mysql4_Product_Indexer_Eav_Abstract' => 'Mage_Catalog_Model_Resource_Product_Indexer_Eav_Abstract',
            'Mage_Catalog_Model_Resource_Eav_Mysql4_Product_Indexer_Eav_Decimal' => 'Mage_Catalog_Model_Resource_Product_Indexer_Eav_Decimal',
            'Mage_Catalog_Model_Resource_Eav_Mysql4_Product_Indexer_Eav_Source' => 'Mage_Catalog_Model_Resource_Product_Indexer_Eav_Source',
            'Mage_Catalog_Model_Resource_Eav_Mysql4_Product_Indexer_Price' => 'Mage_Catalog_Model_Resource_Product_Indexer_Price',
            'Mage_Catalog_Model_Resource_Eav_Mysql4_Product_Indexer_Price_Configurable' => 'Mage_Catalog_Model_Resource_Product_Indexer_Price_Configurable',
            'Mage_Catalog_Model_Resource_Eav_Mysql4_Product_Indexer_Price_Default' => 'Mage_Catalog_Model_Resource_Product_Indexer_Price_Default',
            'Mage_Catalog_Model_Resource_Eav_Mysql4_Product_Indexer_Price_Grouped' => 'Mage_Catalog_Model_Resource_Product_Indexer_Price_Grouped',
            'Mage_Catalog_Model_Resource_Eav_Mysql4_Product_Link' => 'Mage_Catalog_Model_Resource_Product_Link',
            'Mage_Catalog_Model_Resource_Eav_Mysql4_Product_Link_Collection' => 'Mage_Catalog_Model_Resource_Product_Link_Collection',
            'Mage_Catalog_Model_Resource_Eav_Mysql4_Product_Link_Product_Collection' => 'Mage_Catalog_Model_Resource_Product_Link_Product_Collection',
            'Mage_Catalog_Model_Resource_Eav_Mysql4_Product_Option' => 'Mage_Catalog_Model_Resource_Product_Option',
            'Mage_Catalog_Model_Resource_Eav_Mysql4_Product_Option_Collection' => 'Mage_Catalog_Model_Resource_Product_Option_Collection',
            'Mage_Catalog_Model_Resource_Eav_Mysql4_Product_Option_Value' => 'Mage_Catalog_Model_Resource_Product_Option_Value',
            'Mage_Catalog_Model_Resource_Eav_Mysql4_Product_Option_Value_Collection' => 'Mage_Catalog_Model_Resource_Product_Option_Value_Collection',
            'Mage_Catalog_Model_Resource_Eav_Mysql4_Product_Relation' => 'Mage_Catalog_Model_Resource_Product_Relation',
            'Mage_Catalog_Model_Resource_Eav_Mysql4_Product_Status' => 'Mage_Catalog_Model_Resource_Product_Status',
            'Mage_Catalog_Model_Resource_Eav_Mysql4_Product_Type_Configurable' => 'Mage_Catalog_Model_Resource_Product_Type_Configurable',
            'Mage_Catalog_Model_Resource_Eav_Mysql4_Product_Type_Configurable_Attribute' => 'Mage_Catalog_Model_Resource_Product_Type_Configurable_Attribute',
            'Mage_Catalog_Model_Resource_Eav_Mysql4_Product_Type_Configurable_Attribute_Collection' => 'Mage_Catalog_Model_Resource_Product_Type_Configurable_Attribute_Collection',
            'Mage_Catalog_Model_Resource_Eav_Mysql4_Product_Type_Configurable_Product_Collection' => 'Mage_Catalog_Model_Resource_Product_Type_Configurable_Product_Collection',
            'Mage_Catalog_Model_Resource_Eav_Mysql4_Product_Website' => 'Mage_Catalog_Model_Resource_Product_Website',
            'Mage_Catalog_Model_Resource_Eav_Mysql4_Setup' => 'Mage_Catalog_Model_Resource_Setup',
            'Mage_Catalog_Model_Resource_Eav_Mysql4_Url' => 'Mage_Catalog_Model_Resource_Url',
            'Mage_CatalogIndex_Model_Mysql4_Abstract' => 'Mage_CatalogIndex_Model_Resource_Abstract',
            'Mage_CatalogIndex_Model_Mysql4_Aggregation' => 'Mage_CatalogIndex_Model_Resource_Aggregation',
            'Mage_CatalogIndex_Model_Mysql4_Attribute' => 'Mage_CatalogIndex_Model_Resource_Attribute',
            'Mage_CatalogIndex_Model_Mysql4_Data_Abstract' => 'Mage_CatalogIndex_Model_Resource_Data_Abstract',
            'Mage_CatalogIndex_Model_Mysql4_Data_Configurable' => 'Mage_CatalogIndex_Model_Resource_Data_Configurable',
            'Mage_CatalogIndex_Model_Mysql4_Data_Grouped' => 'Mage_CatalogIndex_Model_Resource_Data_Grouped',
            'Mage_CatalogIndex_Model_Mysql4_Indexer' => 'Mage_CatalogIndex_Model_Resource_Indexer',
            'Mage_CatalogIndex_Model_Mysql4_Indexer_Abstract' => 'Mage_CatalogIndex_Model_Resource_Indexer_Abstract',
            'Mage_CatalogIndex_Model_Mysql4_Indexer_Eav' => 'Mage_CatalogIndex_Model_Resource_Indexer_Eav',
            'Mage_CatalogIndex_Model_Mysql4_Indexer_Minimalprice' => 'Mage_CatalogIndex_Model_Resource_Indexer_Minimalprice',
            'Mage_CatalogIndex_Model_Mysql4_Indexer_Price' => 'Mage_CatalogIndex_Model_Resource_Indexer_Price',
            'Mage_CatalogIndex_Model_Mysql4_Price' => 'Mage_CatalogIndex_Model_Resource_Price',
            'Mage_CatalogIndex_Model_Mysql4_Retreiver' => 'Mage_CatalogIndex_Model_Resource_Retreiver',
            'Mage_CatalogIndex_Model_Mysql4_Setup' => 'Mage_CatalogIndex_Model_Resource_Setup',
            'Mage_CatalogInventory_Model_Mysql4_Indexer_Stock' => 'Mage_CatalogInventory_Model_Resource_Indexer_Stock',
            'Mage_CatalogInventory_Model_Mysql4_Indexer_Stock_Configurable' => 'Mage_CatalogInventory_Model_Resource_Indexer_Stock_Configurable',
            'Mage_CatalogInventory_Model_Mysql4_Indexer_Stock_Default' => 'Mage_CatalogInventory_Model_Resource_Indexer_Stock_Default',
            'Mage_CatalogInventory_Model_Mysql4_Indexer_Stock_Grouped' => 'Mage_CatalogInventory_Model_Resource_Indexer_Stock_Grouped',
            'Mage_CatalogInventory_Model_Mysql4_Stock' => 'Mage_CatalogInventory_Model_Resource_Stock',
            'Mage_CatalogInventory_Model_Mysql4_Stock_Item' => 'Mage_CatalogInventory_Model_Resource_Stock_Item',
            'Mage_CatalogInventory_Model_Mysql4_Stock_Item_Collection' => 'Mage_CatalogInventory_Model_Resource_Stock_Item_Collection',
            'Mage_CatalogInventory_Model_Mysql4_Stock_Status' => 'Mage_CatalogInventory_Model_Resource_Stock_Status',
            'Mage_CatalogRule_Model_Mysql4_Rule' => 'Mage_CatalogRule_Model_Resource_Rule',
            'Mage_CatalogRule_Model_Mysql4_Rule_Collection' => 'Mage_CatalogRule_Model_Resource_Rule_Collection',
            'Mage_CatalogRule_Model_Mysql4_Rule_Product_Price' => 'Mage_CatalogRule_Model_Resource_Rule_Product_Price',
            'Mage_CatalogRule_Model_Mysql4_Rule_Product_Price_Collection' => 'Mage_CatalogRule_Model_Resource_Rule_Product_Price_Collection',
            'Mage_CatalogSearch_Model_Mysql4_Advanced' => 'Mage_CatalogSearch_Model_Resource_Advanced',
            'Mage_CatalogSearch_Model_Mysql4_Advanced_Collection' => 'Mage_CatalogSearch_Model_Resource_Advanced_Collection',
            'Mage_CatalogSearch_Model_Mysql4_Fulltext' => 'Mage_CatalogSearch_Model_Resource_Fulltext',
            'Mage_CatalogSearch_Model_Mysql4_Fulltext_Collection' => 'Mage_CatalogSearch_Model_Resource_Fulltext_Collection',
            'Mage_CatalogSearch_Model_Mysql4_Fulltext_Engine' => 'Mage_CatalogSearch_Model_Resource_Fulltext_Engine',
            'Mage_CatalogSearch_Model_Mysql4_Indexer_Fulltext' => 'Mage_CatalogSearch_Model_Resource_Indexer_Fulltext',
            'Mage_CatalogSearch_Model_Mysql4_Query' => 'Mage_CatalogSearch_Model_Resource_Query',
            'Mage_CatalogSearch_Model_Mysql4_Query_Collection' => 'Mage_CatalogSearch_Model_Resource_Query_Collection',
            'Mage_CatalogSearch_Model_Mysql4_Search_Collection' => 'Mage_CatalogSearch_Model_Resource_Search_Collection',
            'Mage_Checkout_Model_Mysql4_Agreement' => 'Mage_Checkout_Model_Resource_Agreement',
            'Mage_Checkout_Model_Mysql4_Agreement_Collection' => 'Mage_Checkout_Model_Resource_Agreement_Collection',
            'Mage_Checkout_Model_Mysql4_Cart' => 'Mage_Checkout_Model_Resource_Cart',
            'Mage_Checkout_Model_Mysql4_Setup' => 'Mage_Checkout_Model_Resource_Setup',
            'Mage_Cms_Model_Mysql4_Block' => 'Mage_Cms_Model_Resource_Block',
            'Mage_Cms_Model_Mysql4_Block_Collection' => 'Mage_Cms_Model_Resource_Block_Collection',
            'Mage_Cms_Model_Mysql4_Page' => 'Mage_Cms_Model_Resource_Page',
            'Mage_Cms_Model_Mysql4_Page_Collection' => 'Mage_Cms_Model_Resource_Page_Collection',
            'Mage_Cms_Model_Mysql4_Page_Service' => 'Mage_Cms_Model_Resource_Page_Service',
            'Mage_Core_Model_Mysql4_Abstract' => 'Mage_Core_Model_Resource_Db_Abstract',
            'Mage_Core_Model_Mysql4_Cache' => 'Mage_Core_Model_Resource_Cache',
            'Mage_Core_Model_Mysql4_Collection_Abstract' => 'Mage_Core_Model_Resource_Db_Collection_Abstract',
            'Mage_Core_Model_Mysql4_Config' => 'Mage_Core_Model_Resource_Config',
            'Mage_Core_Model_Mysql4_Config_Data' => 'Mage_Core_Model_Resource_Config_Data',
            'Mage_Core_Model_Mysql4_Config_Data_Collection' => 'Mage_Core_Model_Resource_Config_Data_Collection',
            'Mage_Core_Model_Mysql4_Design' => 'Mage_Core_Model_Resource_Design',
            'Mage_Core_Model_Mysql4_Design_Collection' => 'Mage_Core_Model_Resource_Design_Collection',
            'Mage_Core_Model_Mysql4_Design_Package_Collection' => 'Mage_Core_Model_Resource_Design_Package_Collection',
            'Mage_Core_Model_Mysql4_Design_Theme_Collection' => 'Varien_Directory_Collection',
            'Mage_Core_Model_Mysql4_Email_Template' => 'Mage_Core_Model_Resource_Email_Template',
            'Mage_Core_Model_Mysql4_Email_Template_Collection' => 'Mage_Core_Model_Resource_Email_Template_Collection',
            'Mage_Core_Model_Mysql4_File_Storage_Abstract' => 'Mage_Core_Model_Resource_File_Storage_Abstract',
            'Mage_Core_Model_Mysql4_File_Storage_Database' => 'Mage_Core_Model_Resource_File_Storage_Database',
            'Mage_Core_Model_Mysql4_File_Storage_Directory_Database' => 'Mage_Core_Model_Resource_File_Storage_Directory_Database',
            'Mage_Core_Model_Mysql4_File_Storage_File' => 'Mage_Core_Model_Resource_File_Storage_File',
            'Mage_Core_Model_Mysql4_Flag' => 'Mage_Core_Model_Resource_Flag',
            'Mage_Core_Model_Mysql4_Language' => 'Mage_Core_Model_Resource_Language',
            'Mage_Core_Model_Mysql4_Language_Collection' => 'Mage_Core_Model_Resource_Language_Collection',
            'Mage_Core_Model_Mysql4_Layout' => 'Mage_Core_Model_Resource_Layout',
            'Mage_Core_Model_Mysql4_Resource' => 'Mage_Core_Model_Resource_Resource',
            'Mage_Core_Model_Mysql4_Session' => 'Mage_Core_Model_Resource_Session',
            'Mage_Core_Model_Mysql4_Store' => 'Mage_Core_Model_Resource_Store',
            'Mage_Core_Model_Mysql4_Store_Collection' => 'Mage_Core_Model_Resource_Store_Collection',
            'Mage_Core_Model_Mysql4_Store_Group' => 'Mage_Core_Model_Resource_Store_Group',
            'Mage_Core_Model_Mysql4_Store_Group_Collection' => 'Mage_Core_Model_Resource_Store_Group_Collection',
            'Mage_Core_Model_Mysql4_Translate' => 'Mage_Core_Model_Resource_Translate',
            'Mage_Core_Model_Mysql4_Translate_String' => 'Mage_Core_Model_Resource_Translate_String',
            'Mage_Core_Model_Mysql4_Url_Rewrite' => 'Mage_Core_Model_Resource_Url_Rewrite',
            'Mage_Core_Model_Mysql4_Url_Rewrite_Collection' => 'Mage_Core_Model_Resource_Url_Rewrite_Collection',
            'Mage_Core_Model_Mysql4_Variable' => 'Mage_Core_Model_Resource_Variable',
            'Mage_Core_Model_Mysql4_Variable_Collection' => 'Mage_Core_Model_Resource_Variable_Collection',
            'Mage_Core_Model_Mysql4_Website' => 'Mage_Core_Model_Resource_Website',
            'Mage_Core_Model_Mysql4_Website_Collection' => 'Mage_Core_Model_Resource_Website_Collection',
            'Mage_Cron_Model_Mysql4_Schedule' => 'Mage_Cron_Model_Resource_Schedule',
            'Mage_Cron_Model_Mysql4_Schedule_Collection' => 'Mage_Cron_Model_Resource_Schedule_Collection',
            'Mage_Dataflow_Model_Mysql4_Batch' => 'Mage_Dataflow_Model_Resource_Batch',
            'Mage_Dataflow_Model_Mysql4_Batch_Abstract' => 'Mage_Dataflow_Model_Resource_Batch_Abstract',
            'Mage_Dataflow_Model_Mysql4_Batch_Collection' => 'Mage_Dataflow_Model_Resource_Batch_Collection',
            'Mage_Dataflow_Model_Mysql4_Batch_Export' => 'Mage_Dataflow_Model_Resource_Batch_Export',
            'Mage_Dataflow_Model_Mysql4_Batch_Import' => 'Mage_Dataflow_Model_Resource_Batch_Import',
            'Mage_Dataflow_Model_Mysql4_Import' => 'Mage_Dataflow_Model_Resource_Import',
            'Mage_Dataflow_Model_Mysql4_Import_Collection' => 'Mage_Dataflow_Model_Resource_Import_Collection',
            'Mage_Dataflow_Model_Mysql4_Profile' => 'Mage_Dataflow_Model_Resource_Profile',
            'Mage_Dataflow_Model_Mysql4_Profile_Collection' => 'Mage_Dataflow_Model_Resource_Profile_Collection',
            'Mage_Dataflow_Model_Mysql4_Profile_History' => 'Mage_Dataflow_Model_Resource_Profile_History',
            'Mage_Dataflow_Model_Mysql4_Profile_History_Collection' => 'Mage_Dataflow_Model_Resource_Profile_History_Collection',
            'Mage_Dataflow_Model_Mysql4_Session' => 'Mage_Dataflow_Model_Resource_Session',
            'Mage_Directory_Model_Mysql4_Country' => 'Mage_Directory_Model_Resource_Country',
            'Mage_Directory_Model_Mysql4_Country_Collection' => 'Mage_Directory_Model_Resource_Country_Collection',
            'Mage_Directory_Model_Mysql4_Country_Format' => 'Mage_Directory_Model_Resource_Country_Format',
            'Mage_Directory_Model_Mysql4_Country_Format_Collection' => 'Mage_Directory_Model_Resource_Country_Format_Collection',
            'Mage_Directory_Model_Mysql4_Currency' => 'Mage_Directory_Model_Resource_Currency',
            'Mage_Directory_Model_Mysql4_Currency_Collection' => 'Mage_Directory_Model_Resource_Currency_Collection',
            'Mage_Directory_Model_Mysql4_Region' => 'Mage_Directory_Model_Resource_Region',
            'Mage_Directory_Model_Mysql4_Region_Collection' => 'Mage_Directory_Model_Resource_Region_Collection',
            'Mage_Downloadable_Model_Mysql4_Indexer_Price' => 'Mage_Downloadable_Model_Resource_Indexer_Price',
            'Mage_Downloadable_Model_Mysql4_Link' => 'Mage_Downloadable_Model_Resource_Link',
            'Mage_Downloadable_Model_Mysql4_Link_Collection' => 'Mage_Downloadable_Model_Resource_Link_Collection',
            'Mage_Downloadable_Model_Mysql4_Link_Purchased' => 'Mage_Downloadable_Model_Resource_Link_Purchased',
            'Mage_Downloadable_Model_Mysql4_Link_Purchased_Collection' => 'Mage_Downloadable_Model_Resource_Link_Purchased_Collection',
            'Mage_Downloadable_Model_Mysql4_Link_Purchased_Item' => 'Mage_Downloadable_Model_Resource_Link_Purchased_Item',
            'Mage_Downloadable_Model_Mysql4_Link_Purchased_Item_Collection' => 'Mage_Downloadable_Model_Resource_Link_Purchased_Item_Collection',
            'Mage_Downloadable_Model_Mysql4_Sample' => 'Mage_Downloadable_Model_Resource_Sample',
            'Mage_Downloadable_Model_Mysql4_Sample_Collection' => 'Mage_Downloadable_Model_Resource_Sample_Collection',
            'Mage_Eav_Model_Mysql4_Config' => 'Mage_Eav_Model_Resource_Config',
            'Mage_Eav_Model_Mysql4_Entity_Attribute' => 'Mage_Eav_Model_Resource_Entity_Attribute',
            'Mage_Eav_Model_Mysql4_Entity_Attribute_Collection' => 'Mage_Eav_Model_Resource_Entity_Attribute_Collection',
            'Mage_Eav_Model_Mysql4_Entity_Attribute_Group' => 'Mage_Eav_Model_Resource_Entity_Attribute_Group',
            'Mage_Eav_Model_Mysql4_Entity_Attribute_Group_Collection' => 'Mage_Eav_Model_Resource_Entity_Attribute_Group_Collection',
            'Mage_Eav_Model_Mysql4_Entity_Attribute_Option' => 'Mage_Eav_Model_Resource_Entity_Attribute_Option',
            'Mage_Eav_Model_Mysql4_Entity_Attribute_Option_Collection' => 'Mage_Eav_Model_Resource_Entity_Attribute_Option_Collection',
            'Mage_Eav_Model_Mysql4_Entity_Attribute_Set' => 'Mage_Eav_Model_Resource_Entity_Attribute_Set',
            'Mage_Eav_Model_Mysql4_Entity_Attribute_Set_Collection' => 'Mage_Eav_Model_Resource_Entity_Attribute_Set_Collection',
            'Mage_Eav_Model_Mysql4_Entity_Store' => 'Mage_Eav_Model_Resource_Entity_Store',
            'Mage_Eav_Model_Mysql4_Entity_Type' => 'Mage_Eav_Model_Resource_Entity_Type',
            'Mage_Eav_Model_Mysql4_Entity_Type_Collection' => 'Mage_Eav_Model_Resource_Entity_Type_Collection',
            'Mage_Eav_Model_Mysql4_Form_Element' => 'Mage_Eav_Model_Resource_Form_Element',
            'Mage_Eav_Model_Mysql4_Form_Element_Collection' => 'Mage_Eav_Model_Resource_Form_Element_Collection',
            'Mage_Eav_Model_Mysql4_Form_Fieldset' => 'Mage_Eav_Model_Resource_Form_Fieldset',
            'Mage_Eav_Model_Mysql4_Form_Fieldset_Collection' => 'Mage_Eav_Model_Resource_Form_Fieldset_Collection',
            'Mage_Eav_Model_Mysql4_Form_Type' => 'Mage_Eav_Model_Resource_Form_Type',
            'Mage_Eav_Model_Mysql4_Form_Type_Collection' => 'Mage_Eav_Model_Resource_Form_Type_Collection',
            'Mage_GiftMessage_Model_Mysql4_Message' => 'Mage_GiftMessage_Model_Resource_Message',
            'Mage_GiftMessage_Model_Mysql4_Message_Collection' => 'Mage_GiftMessage_Model_Resource_Message_Collection',
            'Mage_GiftMessage_Model_Mysql4_Setup' => 'Mage_GiftMessage_Model_Resource_Setup',
            'Mage_ImportExport_Model_Mysql4_Import_Data' => 'Mage_ImportExport_Model_Resource_Import_Data',
            'Mage_ImportExport_Model_Mysql4_Setup' => 'Mage_ImportExport_Model_Resource_Setup',
            'Mage_Index_Model_Mysql4_Abstract' => 'Mage_Index_Model_Resource_Abstract',
            'Mage_Index_Model_Mysql4_Event' => 'Mage_Index_Model_Resource_Event',
            'Mage_Index_Model_Mysql4_Event_Collection' => 'Mage_Index_Model_Resource_Event_Collection',
            'Mage_Index_Model_Mysql4_Process' => 'Mage_Index_Model_Resource_Process',
            'Mage_Index_Model_Mysql4_Process_Collection' => 'Mage_Index_Model_Resource_Process_Collection',
            'Mage_Index_Model_Mysql4_Setup' => 'Mage_Index_Model_Resource_Setup',
            'Mage_Log_Model_Mysql4_Aggregation' => 'Mage_Log_Model_Resource_Aggregation',
            'Mage_Log_Model_Mysql4_Customer' => 'Mage_Log_Model_Resource_Customer',
            'Mage_Log_Model_Mysql4_Log' => 'Mage_Log_Model_Resource_Log',
            'Mage_Log_Model_Mysql4_Visitor' => 'Mage_Log_Model_Resource_Visitor',
            'Mage_Log_Model_Mysql4_Visitor_Collection' => 'Mage_Log_Model_Resource_Visitor_Collection',
            'Mage_Log_Model_Mysql4_Visitor_Online' => 'Mage_Log_Model_Resource_Visitor_Online',
            'Mage_Log_Model_Mysql4_Visitor_Online_Collection' => 'Mage_Log_Model_Resource_Visitor_Online_Collection',
            'Mage_Newsletter_Model_Mysql4_Problem' => 'Mage_Newsletter_Model_Resource_Problem',
            'Mage_Newsletter_Model_Mysql4_Problem_Collection' => 'Mage_Newsletter_Model_Resource_Problem_Collection',
            'Mage_Newsletter_Model_Mysql4_Queue' => 'Mage_Newsletter_Model_Resource_Queue',
            'Mage_Newsletter_Model_Mysql4_Queue_Collection' => 'Mage_Newsletter_Model_Resource_Queue_Collection',
            'Mage_Newsletter_Model_Mysql4_Subscriber' => 'Mage_Newsletter_Model_Resource_Subscriber',
            'Mage_Newsletter_Model_Mysql4_Subscriber_Collection' => 'Mage_Newsletter_Model_Resource_Subscriber_Collection',
            'Mage_Newsletter_Model_Mysql4_Template' => 'Mage_Newsletter_Model_Resource_Template',
            'Mage_Newsletter_Model_Mysql4_Template_Collection' => 'Mage_Newsletter_Model_Resource_Template_Collection',
            'Mage_Paygate_Model_Mysql4_Authorizenet_Debug' => 'Mage_Paygate_Model_Resource_Authorizenet_Debug',
            'Mage_Paygate_Model_Mysql4_Authorizenet_Debug_Collection' => 'Mage_Paygate_Model_Resource_Authorizenet_Debug_Collection',
            'Mage_Paypal_Model_Mysql4_Cert' => 'Mage_Paypal_Model_Resource_Cert',
            'Mage_Paypal_Model_Mysql4_Report_Settlement' => 'Mage_Paypal_Model_Resource_Report_Settlement',
            'Mage_Paypal_Model_Mysql4_Report_Settlement_Row' => 'Mage_Paypal_Model_Resource_Report_Settlement_Row',
            'Mage_Paypal_Model_Mysql4_Report_Settlement_Row_Collection' => 'Mage_Paypal_Model_Resource_Report_Settlement_Row_Collection',
            'Mage_Paypal_Model_Mysql4_Setup' => 'Mage_Paypal_Model_Resource_Setup',
            'Mage_Poll_Model_Mysql4_Poll' => 'Mage_Poll_Model_Resource_Poll',
            'Mage_Poll_Model_Mysql4_Poll_Answer' => 'Mage_Poll_Model_Resource_Poll_Answer',
            'Mage_Poll_Model_Mysql4_Poll_Answer_Collection' => 'Mage_Poll_Model_Resource_Poll_Answer_Collection',
            'Mage_Poll_Model_Mysql4_Poll_Collection' => 'Mage_Poll_Model_Resource_Poll_Collection',
            'Mage_Poll_Model_Mysql4_Poll_Vote' => 'Mage_Poll_Model_Resource_Poll_Vote',
            'Mage_ProductAlert_Model_Mysql4_Price' => 'Mage_ProductAlert_Model_Resource_Price',
            'Mage_ProductAlert_Model_Mysql4_Price_Collection' => 'Mage_ProductAlert_Model_Resource_Price_Collection',
            'Mage_ProductAlert_Model_Mysql4_Price_Customer_Collection' => 'Mage_ProductAlert_Model_Resource_Price_Customer_Collection',
            'Mage_ProductAlert_Model_Mysql4_Stock' => 'Mage_ProductAlert_Model_Resource_Stock',
            'Mage_ProductAlert_Model_Mysql4_Stock_Collection' => 'Mage_ProductAlert_Model_Resource_Stock_Collection',
            'Mage_ProductAlert_Model_Mysql4_Stock_Customer_Collection' => 'Mage_ProductAlert_Model_Resource_Stock_Customer_Collection',
            'Mage_Rating_Model_Mysql4_Rating' => 'Mage_Rating_Model_Resource_Rating',
            'Mage_Rating_Model_Mysql4_Rating_Collection' => 'Mage_Rating_Model_Resource_Rating_Collection',
            'Mage_Rating_Model_Mysql4_Rating_Entity' => 'Mage_Rating_Model_Resource_Rating_Entity',
            'Mage_Rating_Model_Mysql4_Rating_Option' => 'Mage_Rating_Model_Resource_Rating_Option',
            'Mage_Rating_Model_Mysql4_Rating_Option_Collection' => 'Mage_Rating_Model_Resource_Rating_Option_Collection',
            'Mage_Rating_Model_Mysql4_Rating_Option_Vote' => 'Mage_Rating_Model_Resource_Rating_Option_Vote',
            'Mage_Rating_Model_Mysql4_Rating_Option_Vote_Collection' => 'Mage_Rating_Model_Resource_Rating_Option_Vote_Collection',
            'Mage_Reports_Model_Mysql4_Accounts_Collection' => 'Mage_Reports_Model_Resource_Accounts_Collection',
            'Mage_Reports_Model_Mysql4_Coupons_Collection' => 'Mage_Reports_Model_Resource_Coupons_Collection',
            'Mage_Reports_Model_Mysql4_Customer_Collection' => 'Mage_Reports_Model_Resource_Customer_Collection',
            'Mage_Reports_Model_Mysql4_Customer_Orders_Collection' => 'Mage_Reports_Model_Resource_Customer_Orders_Collection',
            'Mage_Reports_Model_Mysql4_Customer_Totals_Collection' => 'Mage_Reports_Model_Resource_Customer_Totals_Collection',
            'Mage_Reports_Model_Mysql4_Entity_Summary_Collection_Abstract' => 'Mage_Reports_Model_Resource_Entity_Summary_Collection_Abstract',
            'Mage_Reports_Model_Mysql4_Event' => 'Mage_Reports_Model_Resource_Event',
            'Mage_Reports_Model_Mysql4_Event_Collection' => 'Mage_Reports_Model_Resource_Event_Collection',
            'Mage_Reports_Model_Mysql4_Event_Type' => 'Mage_Reports_Model_Resource_Event_Type',
            'Mage_Reports_Model_Mysql4_Event_Type_Collection' => 'Mage_Reports_Model_Resource_Event_Type_Collection',
            'Mage_Reports_Model_Mysql4_Invoiced_Collection' => 'Mage_Reports_Model_Resource_Invoiced_Collection',
            'Mage_Reports_Model_Mysql4_Order_Collection' => 'Mage_Reports_Model_Resource_Order_Collection',
            'Mage_Reports_Model_Mysql4_Product_Collection' => 'Mage_Reports_Model_Resource_Product_Collection',
            'Mage_Reports_Model_Mysql4_Product_Downloads_Collection' => 'Mage_Reports_Model_Resource_Product_Downloads_Collection',
            'Mage_Reports_Model_Mysql4_Product_Index_Abstract' => 'Mage_Reports_Model_Resource_Product_Index_Abstract',
            'Mage_Reports_Model_Mysql4_Product_Index_Collection_Abstract' => 'Mage_Reports_Model_Resource_Product_Index_Collection_Abstract',
            'Mage_Reports_Model_Mysql4_Product_Index_Compared' => 'Mage_Reports_Model_Resource_Product_Index_Compared',
            'Mage_Reports_Model_Mysql4_Product_Index_Compared_Collection' => 'Mage_Reports_Model_Resource_Product_Index_Compared_Collection',
            'Mage_Reports_Model_Mysql4_Product_Index_Viewed' => 'Mage_Reports_Model_Resource_Product_Index_Viewed',
            'Mage_Reports_Model_Mysql4_Product_Index_Viewed_Collection' => 'Mage_Reports_Model_Resource_Product_Index_Viewed_Collection',
            'Mage_Reports_Model_Mysql4_Product_Lowstock_Collection' => 'Mage_Reports_Model_Resource_Product_Lowstock_Collection',
            'Mage_Reports_Model_Mysql4_Product_Ordered_Collection' => 'Mage_Reports_Model_Resource_Product_Ordered_Collection',
            'Mage_Reports_Model_Mysql4_Product_Sold_Collection' => 'Mage_Reports_Model_Resource_Product_Sold_Collection',
            'Mage_Reports_Model_Mysql4_Product_Viewed_Collection' => 'Mage_Reports_Model_Resource_Product_Viewed_Collection',
            'Mage_Reports_Model_Mysql4_Quote_Collection' => 'Mage_Reports_Model_Resource_Quote_Collection',
            'Mage_Reports_Model_Mysql4_Refunded_Collection' => 'Mage_Reports_Model_Resource_Refunded_Collection',
            'Mage_Reports_Model_Mysql4_Report_Abstract' => 'Mage_Reports_Model_Resource_Report_Abstract',
            'Mage_Reports_Model_Mysql4_Report_Collection' => 'Mage_Reports_Model_Resource_Report_Collection',
            'Mage_Reports_Model_Mysql4_Review_Collection' => 'Mage_Reports_Model_Resource_Review_Collection',
            'Mage_Reports_Model_Mysql4_Review_Customer_Collection' => 'Mage_Reports_Model_Resource_Review_Customer_Collection',
            'Mage_Reports_Model_Mysql4_Review_Product_Collection' => 'Mage_Reports_Model_Resource_Review_Product_Collection',
            'Mage_Reports_Model_Mysql4_Shipping_Collection' => 'Mage_Reports_Model_Resource_Shipping_Collection',
            'Mage_Reports_Model_Mysql4_Shopcart_Product_Collection' => 'Mage_Reports_Model_Resource_Shopcart_Product_Collection',
            'Mage_Reports_Model_Mysql4_Tag_Collection' => 'Mage_Reports_Model_Resource_Tag_Collection',
            'Mage_Reports_Model_Mysql4_Tag_Customer_Collection' => 'Mage_Reports_Model_Resource_Tag_Customer_Collection',
            'Mage_Reports_Model_Mysql4_Tag_Product_Collection' => 'Mage_Reports_Model_Resource_Tag_Product_Collection',
            'Mage_Reports_Model_Mysql4_Tax_Collection' => 'Mage_Reports_Model_Resource_Tax_Collection',
            'Mage_Reports_Model_Mysql4_Wishlist_Collection' => 'Mage_Reports_Model_Resource_Wishlist_Collection',
            'Mage_Reports_Model_Mysql4_Wishlist_Product_Collection' => 'Mage_Reports_Model_Resource_Wishlist_Product_Collection',
            'Mage_Review_Model_Mysql4_Review' => 'Mage_Review_Model_Resource_Review',
            'Mage_Review_Model_Mysql4_Review_Collection' => 'Mage_Review_Model_Resource_Review_Collection',
            'Mage_Review_Model_Mysql4_Review_Product_Collection' => 'Mage_Review_Model_Resource_Review_Product_Collection',
            'Mage_Review_Model_Mysql4_Review_Status_Collection' => 'Mage_Review_Model_Resource_Review_Status_Collection',
            'Mage_Review_Model_Mysql4_Review_Summary' => 'Mage_Review_Model_Resource_Review_Summary',
            'Mage_Review_Model_Mysql4_Review_Summary_Collection' => 'Mage_Review_Model_Resource_Review_Summary_Collection',
            'Mage_Rss_Model_Mysql4_Order' => 'Mage_Rss_Model_Resource_Order',
            'Mage_Rule_Model_Mysql4_Rule' => 'Mage_Rule_Model_Resource_Rule',
            'Mage_Rule_Model_Mysql4_Rule_Collection' => 'Mage_Rule_Model_Resource_Rule_Collection',
            'Mage_Sales_Model_Mysql4_Abstract' => 'Mage_Sales_Model_Resource_Abstract',
            'Mage_Sales_Model_Mysql4_Billing_Agreement' => 'Mage_Sales_Model_Resource_Billing_Agreement',
            'Mage_Sales_Model_Mysql4_Billing_Agreement_Collection' => 'Mage_Sales_Model_Resource_Billing_Agreement_Collection',
            'Mage_Sales_Model_Mysql4_Collection_Abstract' => 'Mage_Sales_Model_Resource_Collection_Abstract',
            'Mage_Sales_Model_Mysql4_Order' => 'Mage_Sales_Model_Resource_Order',
            'Mage_Sales_Model_Mysql4_Order_Abstract' => 'Mage_Sales_Model_Resource_Order_Abstract',
            'Mage_Sales_Model_Mysql4_Order_Address' => 'Mage_Sales_Model_Resource_Order_Address',
            'Mage_Sales_Model_Mysql4_Order_Address_Collection' => 'Mage_Sales_Model_Resource_Order_Address_Collection',
            'Mage_Sales_Model_Mysql4_Order_Attribute_Backend_Billing' => 'Mage_Sales_Model_Resource_Order_Attribute_Backend_Billing',
            'Mage_Sales_Model_Mysql4_Order_Attribute_Backend_Child' => 'Mage_Sales_Model_Resource_Order_Attribute_Backend_Child',
            'Mage_Sales_Model_Mysql4_Order_Attribute_Backend_Parent' => 'Mage_Sales_Model_Resource_Order_Attribute_Backend_Parent',
            'Mage_Sales_Model_Mysql4_Order_Attribute_Backend_Shipping' => 'Mage_Sales_Model_Resource_Order_Attribute_Backend_Shipping',
            'Mage_Sales_Model_Mysql4_Order_Collection' => 'Mage_Sales_Model_Resource_Order_Collection',
            'Mage_Sales_Model_Mysql4_Order_Collection_Abstract' => 'Mage_Sales_Model_Resource_Order_Collection_Abstract',
            'Mage_Sales_Model_Mysql4_Order_Comment_Collection_Abstract' => 'Mage_Sales_Model_Resource_Order_Comment_Collection_Abstract',
            'Mage_Sales_Model_Mysql4_Order_Creditmemo' => 'Mage_Sales_Model_Resource_Order_Creditmemo',
            'Mage_Sales_Model_Mysql4_Order_Creditmemo_Attribute_Backend_Child' => 'Mage_Sales_Model_Resource_Order_Creditmemo_Attribute_Backend_Child',
            'Mage_Sales_Model_Mysql4_Order_Creditmemo_Attribute_Backend_Parent' => 'Mage_Sales_Model_Resource_Order_Creditmemo_Attribute_Backend_Parent',
            'Mage_Sales_Model_Mysql4_Order_Creditmemo_Collection' => 'Mage_Sales_Model_Resource_Order_Creditmemo_Collection',
            'Mage_Sales_Model_Mysql4_Order_Creditmemo_Comment' => 'Mage_Sales_Model_Resource_Order_Creditmemo_Comment',
            'Mage_Sales_Model_Mysql4_Order_Creditmemo_Comment_Collection' => 'Mage_Sales_Model_Resource_Order_Creditmemo_Comment_Collection',
            'Mage_Sales_Model_Mysql4_Order_Creditmemo_Grid_Collection' => 'Mage_Sales_Model_Resource_Order_Creditmemo_Grid_Collection',
            'Mage_Sales_Model_Mysql4_Order_Creditmemo_Item' => 'Mage_Sales_Model_Resource_Order_Creditmemo_Item',
            'Mage_Sales_Model_Mysql4_Order_Creditmemo_Item_Collection' => 'Mage_Sales_Model_Resource_Order_Creditmemo_Item_Collection',
            'Mage_Sales_Model_Mysql4_Order_Grid_Collection' => 'Mage_Sales_Model_Resource_Order_Grid_Collection',
            'Mage_Sales_Model_Mysql4_Order_Invoice' => 'Mage_Sales_Model_Resource_Order_Invoice',
            'Mage_Sales_Model_Mysql4_Order_Invoice_Attribute_Backend_Child' => 'Mage_Sales_Model_Resource_Order_Invoice_Attribute_Backend_Child',
            'Mage_Sales_Model_Mysql4_Order_Invoice_Attribute_Backend_Item' => 'Mage_Sales_Model_Resource_Order_Invoice_Attribute_Backend_Item',
            'Mage_Sales_Model_Mysql4_Order_Invoice_Attribute_Backend_Order' => 'Mage_Sales_Model_Resource_Order_Invoice_Attribute_Backend_Order',
            'Mage_Sales_Model_Mysql4_Order_Invoice_Attribute_Backend_Parent' => 'Mage_Sales_Model_Resource_Order_Invoice_Attribute_Backend_Parent',
            'Mage_Sales_Model_Mysql4_Order_Invoice_Collection' => 'Mage_Sales_Model_Resource_Order_Invoice_Collection',
            'Mage_Sales_Model_Mysql4_Order_Invoice_Comment' => 'Mage_Sales_Model_Resource_Order_Invoice_Comment',
            'Mage_Sales_Model_Mysql4_Order_Invoice_Comment_Collection' => 'Mage_Sales_Model_Resource_Order_Invoice_Comment_Collection',
            'Mage_Sales_Model_Mysql4_Order_Invoice_Grid_Collection' => 'Mage_Sales_Model_Resource_Order_Invoice_Grid_Collection',
            'Mage_Sales_Model_Mysql4_Order_Invoice_Item' => 'Mage_Sales_Model_Resource_Order_Invoice_Item',
            'Mage_Sales_Model_Mysql4_Order_Invoice_Item_Collection' => 'Mage_Sales_Model_Resource_Order_Invoice_Item_Collection',
            'Mage_Sales_Model_Mysql4_Order_Item' => 'Mage_Sales_Model_Resource_Order_Item',
            'Mage_Sales_Model_Mysql4_Order_Item_Collection' => 'Mage_Sales_Model_Resource_Order_Item_Collection',
            'Mage_Sales_Model_Mysql4_Order_Payment' => 'Mage_Sales_Model_Resource_Order_Payment',
            'Mage_Sales_Model_Mysql4_Order_Payment_Collection' => 'Mage_Sales_Model_Resource_Order_Payment_Collection',
            'Mage_Sales_Model_Mysql4_Order_Payment_Transaction' => 'Mage_Sales_Model_Resource_Order_Payment_Transaction',
            'Mage_Sales_Model_Mysql4_Order_Payment_Transaction_Collection' => 'Mage_Sales_Model_Resource_Order_Payment_Transaction_Collection',
            'Mage_Sales_Model_Mysql4_Order_Shipment' => 'Mage_Sales_Model_Resource_Order_Shipment',
            'Mage_Sales_Model_Mysql4_Order_Shipment_Attribute_Backend_Child' => 'Mage_Sales_Model_Resource_Order_Shipment_Attribute_Backend_Child',
            'Mage_Sales_Model_Mysql4_Order_Shipment_Attribute_Backend_Parent' => 'Mage_Sales_Model_Resource_Order_Shipment_Attribute_Backend_Parent',
            'Mage_Sales_Model_Mysql4_Order_Shipment_Collection' => 'Mage_Sales_Model_Resource_Order_Shipment_Collection',
            'Mage_Sales_Model_Mysql4_Order_Shipment_Comment' => 'Mage_Sales_Model_Resource_Order_Shipment_Comment',
            'Mage_Sales_Model_Mysql4_Order_Shipment_Comment_Collection' => 'Mage_Sales_Model_Resource_Order_Shipment_Comment_Collection',
            'Mage_Sales_Model_Mysql4_Order_Shipment_Grid_Collection' => 'Mage_Sales_Model_Resource_Order_Shipment_Grid_Collection',
            'Mage_Sales_Model_Mysql4_Order_Shipment_Item' => 'Mage_Sales_Model_Resource_Order_Shipment_Item',
            'Mage_Sales_Model_Mysql4_Order_Shipment_Item_Collection' => 'Mage_Sales_Model_Resource_Order_Shipment_Item_Collection',
            'Mage_Sales_Model_Mysql4_Order_Shipment_Track' => 'Mage_Sales_Model_Resource_Order_Shipment_Track',
            'Mage_Sales_Model_Mysql4_Order_Shipment_Track_Collection' => 'Mage_Sales_Model_Resource_Order_Shipment_Track_Collection',
            'Mage_Sales_Model_Mysql4_Order_Status' => 'Mage_Sales_Model_Resource_Order_Status',
            'Mage_Sales_Model_Mysql4_Order_Status_Collection' => 'Mage_Sales_Model_Resource_Order_Status_Collection',
            'Mage_Sales_Model_Mysql4_Order_Status_History' => 'Mage_Sales_Model_Resource_Order_Status_History',
            'Mage_Sales_Model_Mysql4_Order_Status_History_Collection' => 'Mage_Sales_Model_Resource_Order_Status_History_Collection',
            'Mage_Sales_Model_Mysql4_Order_Tax' => 'Mage_Sales_Model_Resource_Order_Tax',
            'Mage_Sales_Model_Mysql4_Order_Tax_Collection' => 'Mage_Sales_Model_Resource_Order_Tax_Collection',
            'Mage_Sales_Model_Mysql4_Quote' => 'Mage_Sales_Model_Resource_Quote',
            'Mage_Sales_Model_Mysql4_Quote_Address' => 'Mage_Sales_Model_Resource_Quote_Address',
            'Mage_Sales_Model_Mysql4_Quote_Address_Attribute_Backend' => 'Mage_Sales_Model_Resource_Quote_Address_Attribute_Backend',
            'Mage_Sales_Model_Mysql4_Quote_Address_Attribute_Backend_Child' => 'Mage_Sales_Model_Resource_Quote_Address_Attribute_Backend_Child',
            'Mage_Sales_Model_Mysql4_Quote_Address_Attribute_Backend_Parent' => 'Mage_Sales_Model_Resource_Quote_Address_Attribute_Backend_Parent',
            'Mage_Sales_Model_Mysql4_Quote_Address_Attribute_Backend_Region' => 'Mage_Sales_Model_Resource_Quote_Address_Attribute_Backend_Region',
            'Mage_Sales_Model_Mysql4_Quote_Address_Attribute_Frontend' => 'Mage_Sales_Model_Resource_Quote_Address_Attribute_Frontend',
            'Mage_Sales_Model_Mysql4_Quote_Address_Attribute_Frontend_Custbalance' => 'Mage_Sales_Model_Resource_Quote_Address_Attribute_Frontend_Custbalance',
            'Mage_Sales_Model_Mysql4_Quote_Address_Attribute_Frontend_Discount' => 'Mage_Sales_Model_Resource_Quote_Address_Attribute_Frontend_Discount',
            'Mage_Sales_Model_Mysql4_Quote_Address_Attribute_Frontend_Grand' => 'Mage_Sales_Model_Resource_Quote_Address_Attribute_Frontend_Grand',
            'Mage_Sales_Model_Mysql4_Quote_Address_Attribute_Frontend_Shipping' => 'Mage_Sales_Model_Resource_Quote_Address_Attribute_Frontend_Shipping',
            'Mage_Sales_Model_Mysql4_Quote_Address_Attribute_Frontend_Subtotal' => 'Mage_Sales_Model_Resource_Quote_Address_Attribute_Frontend_Subtotal',
            'Mage_Sales_Model_Mysql4_Quote_Address_Attribute_Frontend_Tax' => 'Mage_Sales_Model_Resource_Quote_Address_Attribute_Frontend_Tax',
            'Mage_Sales_Model_Mysql4_Quote_Address_Collection' => 'Mage_Sales_Model_Resource_Quote_Address_Collection',
            'Mage_Sales_Model_Mysql4_Quote_Address_Item' => 'Mage_Sales_Model_Resource_Quote_Address_Item',
            'Mage_Sales_Model_Mysql4_Quote_Address_Item_Collection' => 'Mage_Sales_Model_Resource_Quote_Address_Item_Collection',
            'Mage_Sales_Model_Mysql4_Quote_Address_Rate' => 'Mage_Sales_Model_Resource_Quote_Address_Rate',
            'Mage_Sales_Model_Mysql4_Quote_Address_Rate_Collection' => 'Mage_Sales_Model_Resource_Quote_Address_Rate_Collection',
            'Mage_Sales_Model_Mysql4_Quote_Collection' => 'Mage_Sales_Model_Resource_Quote_Collection',
            'Mage_Sales_Model_Mysql4_Quote_Item' => 'Mage_Sales_Model_Resource_Quote_Item',
            'Mage_Sales_Model_Mysql4_Quote_Item_Collection' => 'Mage_Sales_Model_Resource_Quote_Item_Collection',
            'Mage_Sales_Model_Mysql4_Quote_Item_Option' => 'Mage_Sales_Model_Resource_Quote_Item_Option',
            'Mage_Sales_Model_Mysql4_Quote_Item_Option_Collection' => 'Mage_Sales_Model_Resource_Quote_Item_Option_Collection',
            'Mage_Sales_Model_Mysql4_Quote_Payment' => 'Mage_Sales_Model_Resource_Quote_Payment',
            'Mage_Sales_Model_Mysql4_Quote_Payment_Collection' => 'Mage_Sales_Model_Resource_Quote_Payment_Collection',
            'Mage_Sales_Model_Mysql4_Recurring_Profile' => 'Mage_Sales_Model_Resource_Recurring_Profile',
            'Mage_Sales_Model_Mysql4_Recurring_Profile_Collection' => 'Mage_Sales_Model_Resource_Recurring_Profile_Collection',
            'Mage_Sales_Model_Mysql4_Report' => 'Mage_Sales_Model_Resource_Report',
            'Mage_Sales_Model_Mysql4_Report_Abstract' => 'Mage_Sales_Model_Resource_Report_Abstract',
            'Mage_Sales_Model_Mysql4_Report_Bestsellers' => 'Mage_Sales_Model_Resource_Report_Bestsellers',
            'Mage_Sales_Model_Mysql4_Report_Bestsellers_Collection' => 'Mage_Sales_Model_Resource_Report_Bestsellers_Collection',
            'Mage_Sales_Model_Mysql4_Report_Collection_Abstract' => 'Mage_Sales_Model_Resource_Report_Collection_Abstract',
            'Mage_Sales_Model_Mysql4_Report_Invoiced' => 'Mage_Sales_Model_Resource_Report_Invoiced',
            'Mage_Sales_Model_Mysql4_Report_Invoiced_Collection_Invoiced' => 'Mage_Sales_Model_Resource_Report_Invoiced_Collection_Invoiced',
            'Mage_Sales_Model_Mysql4_Report_Invoiced_Collection_Order' => 'Mage_Sales_Model_Resource_Report_Invoiced_Collection_Order',
            'Mage_Sales_Model_Mysql4_Report_Order' => 'Mage_Sales_Model_Resource_Report_Order',
            'Mage_Sales_Model_Mysql4_Report_Order_Collection' => 'Mage_Sales_Model_Resource_Report_Order_Collection',
            'Mage_Sales_Model_Mysql4_Report_Order_Updatedat_Collection' => 'Mage_Sales_Model_Resource_Report_Order_Updatedat_Collection',
            'Mage_Sales_Model_Mysql4_Report_Refunded' => 'Mage_Sales_Model_Resource_Report_Refunded',
            'Mage_Sales_Model_Mysql4_Report_Refunded_Collection_Order' => 'Mage_Sales_Model_Resource_Report_Refunded_Collection_Order',
            'Mage_Sales_Model_Mysql4_Report_Refunded_Collection_Refunded' => 'Mage_Sales_Model_Resource_Report_Refunded_Collection_Refunded',
            'Mage_Sales_Model_Mysql4_Report_Shipping' => 'Mage_Sales_Model_Resource_Report_Shipping',
            'Mage_Sales_Model_Mysql4_Report_Shipping_Collection_Order' => 'Mage_Sales_Model_Resource_Report_Shipping_Collection_Order',
            'Mage_Sales_Model_Mysql4_Report_Shipping_Collection_Shipment' => 'Mage_Sales_Model_Resource_Report_Shipping_Collection_Shipment',
            'Mage_Sales_Model_Mysql4_Sale_Collection' => 'Mage_Sales_Model_Resource_Sale_Collection',
            'Mage_Sales_Model_Mysql4_Setup' => 'Mage_Sales_Model_Resource_Setup',
            'Mage_SalesRule_Model_Mysql4_Coupon' => 'Mage_SalesRule_Model_Resource_Coupon',
            'Mage_SalesRule_Model_Mysql4_Coupon_Collection' => 'Mage_SalesRule_Model_Resource_Coupon_Collection',
            'Mage_SalesRule_Model_Mysql4_Coupon_Usage' => 'Mage_SalesRule_Model_Resource_Coupon_Usage',
            'Mage_SalesRule_Model_Mysql4_Report_Collection' => 'Mage_SalesRule_Model_Resource_Report_Collection',
            'Mage_SalesRule_Model_Mysql4_Report_Rule' => 'Mage_SalesRule_Model_Resource_Report_Rule',
            'Mage_SalesRule_Model_Mysql4_Report_Updatedat_Collection' => 'Mage_SalesRule_Model_Resource_Report_Updatedat_Collection',
            'Mage_SalesRule_Model_Mysql4_Rule' => 'Mage_SalesRule_Model_Resource_Rule',
            'Mage_SalesRule_Model_Mysql4_Rule_Collection' => 'Mage_SalesRule_Model_Resource_Rule_Collection',
            'Mage_SalesRule_Model_Mysql4_Rule_Customer' => 'Mage_SalesRule_Model_Resource_Rule_Customer',
            'Mage_SalesRule_Model_Mysql4_Rule_Customer_Collection' => 'Mage_SalesRule_Model_Resource_Rule_Customer_Collection',
            'Mage_SalesRule_Model_Mysql4_Rule_Product' => 'Mage_SalesRule_Model_Resource_Rule_Product',
            'Mage_SalesRule_Model_Mysql4_Rule_Product_Collection' => 'Mage_SalesRule_Model_Resource_Rule_Product_Collection',
            'Mage_Shipping_Model_Mysql4_Carrier_Tablerate' => 'Mage_Shipping_Model_Resource_Carrier_Tablerate',
            'Mage_Shipping_Model_Mysql4_Carrier_Tablerate_Collection' => 'Mage_Shipping_Model_Resource_Carrier_Tablerate_Collection',
            'Mage_Sitemap_Model_Mysql4_Catalog_Category' => 'Mage_Sitemap_Model_Resource_Catalog_Category',
            'Mage_Sitemap_Model_Mysql4_Catalog_Product' => 'Mage_Sitemap_Model_Resource_Catalog_Product',
            'Mage_Sitemap_Model_Mysql4_Cms_Page' => 'Mage_Sitemap_Model_Resource_Cms_Page',
            'Mage_Sitemap_Model_Mysql4_Sitemap' => 'Mage_Sitemap_Model_Resource_Sitemap',
            'Mage_Sitemap_Model_Mysql4_Sitemap_Collection' => 'Mage_Sitemap_Model_Resource_Sitemap_Collection',
            'Mage_Tag_Model_Mysql4_Customer_Collection' => 'Mage_Tag_Model_Resource_Customer_Collection',
            'Mage_Tag_Model_Mysql4_Indexer_Summary' => 'Mage_Tag_Model_Resource_Indexer_Summary',
            'Mage_Tag_Model_Mysql4_Popular_Collection' => 'Mage_Tag_Model_Resource_Popular_Collection',
            'Mage_Tag_Model_Mysql4_Product_Collection' => 'Mage_Tag_Model_Resource_Product_Collection',
            'Mage_Tag_Model_Mysql4_Tag' => 'Mage_Tag_Model_Resource_Tag',
            'Mage_Tag_Model_Mysql4_Tag_Collection' => 'Mage_Tag_Model_Resource_Tag_Collection',
            'Mage_Tag_Model_Mysql4_Tag_Relation' => 'Mage_Tag_Model_Resource_Tag_Relation',
            'Mage_Tax_Model_Mysql4_Calculation' => 'Mage_Tax_Model_Resource_Calculation',
            'Mage_Tax_Model_Mysql4_Calculation_Collection' => 'Mage_Tax_Model_Resource_Calculation_Collection',
            'Mage_Tax_Model_Mysql4_Calculation_Rate' => 'Mage_Tax_Model_Resource_Calculation_Rate',
            'Mage_Tax_Model_Mysql4_Calculation_Rate_Collection' => 'Mage_Tax_Model_Resource_Calculation_Rate_Collection',
            'Mage_Tax_Model_Mysql4_Calculation_Rate_Title' => 'Mage_Tax_Model_Resource_Calculation_Rate_Title',
            'Mage_Tax_Model_Mysql4_Calculation_Rate_Title_Collection' => 'Mage_Tax_Model_Resource_Calculation_Rate_Title_Collection',
            'Mage_Tax_Model_Mysql4_Calculation_Rule' => 'Mage_Tax_Model_Resource_Calculation_Rule',
            'Mage_Tax_Model_Mysql4_Calculation_Rule_Collection' => 'Mage_Tax_Model_Resource_Calculation_Rule_Collection',
            'Mage_Tax_Model_Mysql4_Class' => 'Mage_Tax_Model_Resource_Class',
            'Mage_Tax_Model_Mysql4_Class_Collection' => 'Mage_Tax_Model_Resource_Class_Collection',
            'Mage_Tax_Model_Mysql4_Report_Collection' => 'Mage_Tax_Model_Resource_Report_Collection',
            'Mage_Tax_Model_Mysql4_Report_Tax' => 'Mage_Tax_Model_Resource_Report_Tax',
            'Mage_Tax_Model_Mysql4_Report_Updatedat_Collection' => 'Mage_Tax_Model_Resource_Report_Updatedat_Collection',
            'Mage_Tax_Model_Mysql4_Sales_Order_Tax' => 'Mage_Tax_Model_Resource_Sales_Order_Tax',
            'Mage_Tax_Model_Mysql4_Sales_Order_Tax_Collection' => 'Mage_Tax_Model_Resource_Sales_Order_Tax_Collection',
            'Mage_Tax_Model_Mysql4_Setup' => 'Mage_Tax_Model_Resource_Setup',
            'Mage_Weee_Model_Mysql4_Attribute_Backend_Weee_Tax' => 'Mage_Weee_Model_Resource_Attribute_Backend_Weee_Tax',
            'Mage_Weee_Model_Mysql4_Setup' => 'Mage_Weee_Model_Resource_Setup',
            'Mage_Weee_Model_Mysql4_Tax' => 'Mage_Weee_Model_Resource_Tax',
            'Mage_Widget_Model_Mysql4_Widget' => 'Mage_Widget_Model_Resource_Widget',
            'Mage_Widget_Model_Mysql4_Widget_Instance' => 'Mage_Widget_Model_Resource_Widget_Instance',
            'Mage_Widget_Model_Mysql4_Widget_Instance_Collection' => 'Mage_Widget_Model_Resource_Widget_Instance_Collection',
            'Mage_Wishlist_Model_Mysql4_Item' => 'Mage_Wishlist_Model_Resource_Item',
            'Mage_Wishlist_Model_Mysql4_Item_Collection' => 'Mage_Wishlist_Model_Resource_Item_Collection',
            'Mage_Wishlist_Model_Mysql4_Item_Option' => 'Mage_Wishlist_Model_Resource_Item_Option',
            'Mage_Wishlist_Model_Mysql4_Item_Option_Collection' => 'Mage_Wishlist_Model_Resource_Item_Option_Collection',
            'Mage_Wishlist_Model_Mysql4_Product_Collection' => 'Mage_Wishlist_Model_Resource_Product_Collection',
            'Mage_Wishlist_Model_Mysql4_Wishlist' => 'Mage_Wishlist_Model_Resource_Wishlist',
            'Mage_Wishlist_Model_Mysql4_Wishlist_Collection' => 'Mage_Wishlist_Model_Resource_Wishlist_Collection',
            'Mage_Catalog_Model_Resource_Eav_Mysql4_Product_Indexer_Price_Interface' => 'Mage_Catalog_Model_Resource_Product_Indexer_Price_Interface',
            'Mage_CatalogInventory_Model_Mysql4_Indexer_Stock_Interface' => 'Mage_CatalogInventory_Model_Resource_Indexer_Stock_Interface',
            '<admin_mysql4>' => '<admin_resource>',
            '<adminnotification_mysql4>' => '<adminnotification_resource>',
            '<adminhtml_mysql4>' => '<adminhtml_resource>',
            '<api_mysql4>' => '<api_resource>',
            '<backup_mysql4>' => '<backup_resource>',
            '<bundle_mysql4>' => '<bundle_resource>',
            '<catalog_resource_eav_mysql4>' => '<catalog_resource>',
            '<catalogindex_mysql4>' => '<catalogindex_resource>',
            '<cataloginventory_mysql4>' => '<cataloginventory_resource>',
            '<catalogrule_mysql4>' => '<catalogrule_resource>',
            '<catalogsearch_mysql4>' => '<catalogsearch_resource>',
            '<checkout_mysql4>' => '<checkout_resource>',
            '<cms_mysql4>' => '<cms_resource>',
            '<cron_mysql4>' => '<cron_resource>',
            '<customer_mysql4>' => '<customer_resource>',
            '<dataflow_mysql4>' => '<dataflow_resource>',
            '<directory_mysql4>' => '<directory_resource>',
            '<downloadable_mysql4>' => '<downloadable_resource>',
            '<eav_mysql4>' => '<eav_resource>',
            '<giftmessage_mysql4>' => '<giftmessage_resource>',
            '<index_mysql4>' => '<index_resource>',
            '<install_mysql4>' => '<install_resource>',
            '<log_mysql4>' => '<log_resource>',
            '<media_file>' => '<media_resource>',
            '<newsletter_mysql4>' => '<newsletter_resource>',
            '<paygate_mysql4>' => '<paygate_resource>',
            '<paypal_mysql4>' => '<paypal_resource>',
            '<paypaluk_mysql4>' => '<paypaluk_resource>',
            '<poll_mysql4>' => '<poll_resource>',
            '<productalert_mysql4>' => '<productalert_resource>',
            '<rating_mysql4>' => '<rating_resource>',
            '<reports_mysql4>' => '<reports_resource>',
            '<review_mysql4>' => '<review_resource>',
            '<rss_mysql4>' => '<rss_resource>',
            '<rule_mysql4>' => '<rule_resource>',
            '<sales_mysql4>' => '<sales_resource>',
            '<salesrule_mysql4>' => '<salesrule_resource>',
            '<shipping_mysql4>' => '<shipping_resource>',
            '<sitemap_mysql4>' => '<sitemap_resource>',
            '<tag_mysql4>' => '<tag_resource>',
            '<tax_mysql4>' => '<tax_resource>',
            '<weee_mysql4>' => '<weee_resource>',
            '<widget_mysql4>' => '<widget_resource>',
            '<wishlist_mysql4>' => '<wishlist_resource>',
            '<core_mysql4>' => '<core_resource>',
        ];

        foreach ($todo as $search => $replace) {
            $output->writeln("Searching for <info>$search</info>");

            $files = [];
            exec('grep -Hlrn "' . $search . '" app/', $files);

            if ($search[0] == '<') {
                foreach ($files as $file) {
                    $output->writeln("  Processing <info>$file</info>");
                    file_put_contents($file, preg_replace('#[[:<:]]' . $search . '[[:>:]]#', $replace, file_get_contents($file)));
                    file_put_contents($file, preg_replace('#[[:<:]]' . str_replace('<', '</', $search) . '[[:>:]]#', str_replace('<', '</', $replace), file_get_contents($file)));
                }
            } else {
                foreach ($files as $file) {
                    if (stripos($file, 'code/core') !== false) {
                        continue;
                    }
                    $output->writeln("  {$file}");
                    file_put_contents($file, preg_replace('#[[:<:]]' . $search . '[[:>:]]#', $replace, file_get_contents($file)));
                }
            }
        }

        $output->writeln('<info>Done!</info>');
        return Command::SUCCESS;
    }
}
