<?php

/**
 * Maho
 *
 * @category   Mage
 * @package    Mage_Adminhtml
 * @copyright  Copyright (c) 2006-2020 Magento, Inc. (https://magento.com)
 * @copyright  Copyright (c) 2022-2024 The OpenMage Contributors (https://openmage.org)
 * @license    https://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
 */

/**
 * @category   Mage
 * @package    Mage_Adminhtml
 */
class Mage_Adminhtml_Model_System_Config_Source_Currency_Service
{
    protected $_options;

    public function toOptionArray($isMultiselect)
    {
        if (!$this->_options) {
            $services = Mage::getConfig()->getNode('global/currency/import/services')->asArray();
            $currencyConfig = Mage::getStoreConfig('currency');
            $this->_options = [];
            foreach ($services as $code => $options) {
                if (isset($currencyConfig[$code]['active']) && $currencyConfig[$code]['active'] === '0') {
                    continue;
                }
                $this->_options[] = [
                    'label' => $options['name'],
                    'value' => $code,
                ];
            }
        }

        return $this->_options;
    }
}
