<?php

/**
 * Maho
 *
 * @category   Mage
 * @package    Mage_Adminhtml
 * @copyright  Copyright (c) 2006-2020 Magento, Inc. (https://magento.com)
 * @copyright  Copyright (c) 2022-2024 The OpenMage Contributors (https://openmage.org)
 * @license    https://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
 */

/**
 * @category   Mage
 * @package    Mage_Adminhtml
 */
class Mage_Adminhtml_Block_Catalog_Product_Edit_Js extends Mage_Adminhtml_Block_Template
{
    /**
     * Get currently edited product
     *
     * @return Mage_Catalog_Model_Product
     */
    public function getProduct()
    {
        return Mage::registry('current_product');
    }

    /**
     * Get store object of currently edited product
     *
     * @return Mage_Core_Model_Store
     */
    public function getStore()
    {
        $product = $this->getProduct();
        if ($product) {
            return Mage::app()->getStore($product->getStoreId());
        }
        return Mage::app()->getStore();
    }
}
