
# Author = Mahdi Safsafi.

my $MXCSRType = 'TMXCSR';
my $MXCSRHlp  = 'TMXCSRHlp';

my @mxcsr = qw/FZ 0 0 PM UM OM ZM DM IM DAZ PE UE OE ZE DE IE/;
@mxcsr = reverse @mxcsr;

open( F, '>', 'mxcsr.inc' );
print F "\n";
print F" { Do not edit ! => $MXCSRHlp was auto generated by $0 }\n";
print F"type\n  $MXCSRHlp = record helper for $MXCSRType\n  private\n";

foreach (@mxcsr) {
	next if (/0|1/);
	print F"    function Get$_:Boolean;\n";
	print F"    procedure Set$_(Value:Boolean);\n";
}

# custom GetRC/SetRC !
print F"    function GetRC:ShortInt;\n";
print F"    procedure SetRC(Value:ShortInt);\n";

print F"  public\n";

foreach (@mxcsr) {
	next if (/0|1/);
	print F"    property $_:Boolean read Get$_ write Set$_;\n";
}
print F"    property RC:ShortInt read GetRC write SetRC;\n";
print F"end;\n\n";

print F "{ $MXCSRHlp }\n\n";

my $i = -1;
foreach (@mxcsr) {
	$i++;
	next if (/0|1/);

	# Implement GetX
	print F"function $MXCSRHlp.Get$_:Boolean;\n";
	print F"begin\n";
	my $mask = 1 << $i;
	printf F"  Result:= (Self and \$%.6X <> \$00);\n", $mask;
	print F"end;\n\n";

	# Implement SetX
	print F"procedure $MXCSRHlp.Set$_(Value:Boolean);\n";
	print F"begin\n";
	$mask = ( ~$mask ) & 0xFFFFFFFF;
	printf F "  Self:= (Self and \$%X) or (Cardinal(Value) shl \$%.2X);\n",
	  $mask, $i;
	print F"end;\n\n";
}

my $RC = <<"__@__";
function $MXCSRHlp.GetRC: ShortInt;
begin
  Result := (Self and \$006000) shr \$0D;
end;

procedure $MXCSRHlp.SetRC(Value: ShortInt);
begin
  Self := (Self and \$FFFF9FFF) or (Cardinal(Value and \$03) shl \$0D);
end;
__@__

print F $RC;

close(F);
print "Done.\n";
