import * as React from "react";

function LeafPattern(props) {
    return (
        <svg
            xmlns="http://www.w3.org/2000/svg"
            preserveAspectRatio="xMinYMin meet"
            viewBox="0 0 1200 343"
            width="100%"
            height="auto"
            fill="none"
            {...props}
        >
            <g clipPath="url(#prefix__clip0_520:659)" fill="#E6E3E1">
                <path
                    opacity={0.72}
                    d="M104.151 34.33a1.157 1.157 0 01-.764 1.484c-15.797 4.75-35.606-5.384-41.008-20.999a1.155 1.155 0 01.765-1.485c15.796-4.75 35.588 5.385 41.007 21z"
                />
                <path
                    opacity={0.88}
                    d="M412.167 17.169a1.146 1.146 0 01.373 1.624c-8.945 13.895-30.612 18.992-44.837 10.595a1.138 1.138 0 01-.537-.732 1.147 1.147 0 01.164-.892c8.944-13.86 30.612-18.993 44.837-10.595z"
                />
                <path
                    opacity={0.49}
                    d="M463.196 12.914a1.145 1.145 0 011.294 1.05c1.389 16.448-12.627 33.748-29.015 35.788a1.15 1.15 0 01-1.166-.613 1.145 1.145 0 01-.127-.446c-1.381-16.44 12.627-33.739 29.014-35.78z"
                />
                <path
                    opacity={0.09}
                    d="M585.662 16.231a1.139 1.139 0 01.579.698 1.141 1.141 0 01-.11.9c-8.111 14.364-29.44 20.764-44.134 13.226a1.148 1.148 0 01-.579-.703 1.169 1.169 0 01.11-.904c8.112-14.372 29.44-20.772 44.134-13.217z"
                />
                <path
                    opacity={0.12}
                    d="M1115.67 175.154a1.166 1.166 0 01-.85-.326c-.11-.109-.2-.239-.26-.383a1.015 1.015 0 01-.08-.455c.13-16.5 15.68-32.436 32.18-33a1.149 1.149 0 011.11.715c.06.145.09.3.09.457-.14 16.553-15.69 32.488-32.19 32.992z"
                />
                <path
                    opacity={0.46}
                    d="M942.779 171.594a1.16 1.16 0 01-.369.83 1.146 1.146 0 01-.856.307c-16.5-.868-31.715-17.091-31.515-33.608a1.157 1.157 0 011.225-1.138c16.474.86 31.715 17.091 31.515 33.609z"
                />
                <path
                    opacity={0.66}
                    d="M919.896 91.125a1.147 1.147 0 01-.054-.907 1.162 1.162 0 01.618-.665c15.041-6.774 36.023.695 43.422 15.466a1.166 1.166 0 01.054.907 1.16 1.16 0 01-.619.665c-15.067 6.774-36.048-.686-43.421-15.466z"
                />
                <path
                    opacity={0.73}
                    d="M1010.59 133.548c-.15-.066-.27-.16-.38-.276a1.191 1.191 0 01-.29-.859c.01-.156.06-.308.13-.446 7.48-14.703 28.51-22.015 43.51-15.119.15.065.27.159.38.275a1.191 1.191 0 01.29.859 1.01 1.01 0 01-.13.446c-7.48 14.703-28.51 21.989-43.51 15.12z"
                />
                <path
                    opacity={0.06}
                    d="M1114.11 266.27a1.19 1.19 0 01-.25-.389 1.033 1.033 0 01-.08-.458c0-.157.04-.311.1-.453a1.2 1.2 0 01.28-.376c12.15-11.177 34.39-10.725 46.02.964.11.11.2.242.26.387.06.145.08.3.08.456 0 .156-.04.31-.11.452-.06.141-.15.268-.27.372-12.1 11.186-34.36 10.734-46.03-.955z"
                />
                <path
                    opacity={0.88}
                    d="M283.986 159.844a1.161 1.161 0 01-.605-.676 1.141 1.141 0 01.076-.905c7.581-14.659 28.658-21.841 43.612-14.841a1.137 1.137 0 01.661 1.136 1.14 1.14 0 01-.131.444c-7.573 14.651-28.65 21.841-43.613 14.842z"
                />
                <path
                    opacity={0.09}
                    d="M531.211 125.541a1.181 1.181 0 01-.325-.332 1.167 1.167 0 01-.151-.898c.037-.152.105-.295.198-.42 9.805-13.27 31.75-17.03 45.411-7.764a1.146 1.146 0 01.278 1.65c-9.805 13.269-31.794 17.03-45.411 7.764z"
                />
                <path
                    opacity={0.14}
                    d="M995.927 55.528a1.148 1.148 0 011.581.52c7.172 14.86.26 36.032-14.321 43.787a1.144 1.144 0 01-1.58-.521c-7.174-14.859-.261-36.031 14.32-43.786z"
                />
                <path
                    opacity={0.09}
                    d="M229.866 18.628a1.162 1.162 0 01.558.717 1.165 1.165 0 01-.133.898c-8.528 14.12-30.03 19.913-44.498 11.95a1.153 1.153 0 01-.426-1.615c8.519-14.13 30.022-19.914 44.499-11.95z"
                />
                <path
                    opacity={0.77}
                    d="M710.109 57.681a1.146 1.146 0 011.667 0c11.741 11.594 12.332 33.87 1.207 46.027a1.136 1.136 0 01-.834.36 1.147 1.147 0 01-.833-.36c-11.785-11.567-12.375-33.825-1.207-46.027z"
                />
                <path
                    opacity={0.54}
                    d="M343.413 296.83a1.16 1.16 0 01.397-.813 1.152 1.152 0 01.862-.272c16.431 1.511 31.021 18.332 30.161 34.824a1.136 1.136 0 01-.393.819 1.143 1.143 0 01-.866.275c-16.431-1.511-31.021-18.341-30.161-34.833z"
                />
                <path
                    opacity={0.51}
                    d="M1096.97 179.931c.05.146.08.302.07.458 0 .156-.04.31-.11.45-.07.141-.17.266-.28.368-.12.103-.26.179-.41.226-15.68 5.15-35.75-4.49-41.52-19.974a1.191 1.191 0 01-.08-.457c.01-.156.05-.309.12-.45.06-.14.16-.266.28-.368.11-.103.25-.18.4-.227 15.68-5.133 35.75 4.498 41.53 19.974z"
                />
                <path
                    opacity={0.8}
                    d="M791.88 200.382a1.142 1.142 0 01.077-1.317 1.14 1.14 0 01.357-.298c14.434-7.998 35.953-2.293 44.525 11.828a1.13 1.13 0 01.132.898 1.142 1.142 0 01-.566.708c-14.434 7.999-35.98 2.293-44.525-11.819z"
                />
                <path
                    opacity={0.05}
                    d="M506.192 102.206a1.153 1.153 0 01-.67.606 1.131 1.131 0 01-.902-.068c-14.711-7.477-22.041-28.502-15.145-43.508a1.138 1.138 0 01.67-.607 1.147 1.147 0 01.902.068c14.711 7.451 22.04 28.476 15.145 43.509z"
                />
                <path
                    opacity={0.54}
                    d="M136.639 47.442a1.15 1.15 0 01-1.296-.223 1.153 1.153 0 01-.258-.385c-6.348-15.232 1.737-35.996 16.691-42.943a1.158 1.158 0 011.555.607c6.339 15.207-1.72 35.988-16.692 42.944z"
                />
                <path
                    opacity={0.14}
                    d="M1073.92 46.166c-.1.122-.22.223-.35.298a1.168 1.168 0 01-.91.08 1.25 1.25 0 01-.4-.23c-12.47-10.804-14.5-33-4.19-45.88.09-.122.21-.223.35-.297a1.169 1.169 0 01.91-.08c.14.048.28.126.4.23 12.47 10.812 14.51 32.983 4.19 45.879z"
                />
                <path
                    opacity={0.32}
                    d="M792.61 120.226a1.151 1.151 0 01.44-1.252c.128-.092.274-.157.428-.19 16.023-3.925 35.302 7.217 39.87 23.083a1.144 1.144 0 01-.436 1.257c-.13.091-.277.154-.433.185-16.022 3.934-35.293-7.234-39.869-23.083z"
                />
                <path
                    opacity={0.29}
                    d="M39.54 131.663a1.155 1.155 0 01.745.528 1.141 1.141 0 01.123.905c-4.342 15.927-23.387 27.399-39.487 23.726a1.157 1.157 0 01-.746-.528 1.15 1.15 0 01-.123-.905C4.36 139.462 23.44 127.99 39.54 131.663z"
                />
                <path
                    opacity={0.17}
                    d="M603.838 57.586a1.147 1.147 0 011.607.451c7.868 14.503 1.963 35.97-12.236 44.412a1.157 1.157 0 01-1.607-.443c-7.859-14.511-1.954-35.98 12.236-44.42z"
                />
                <path
                    opacity={0.73}
                    d="M926.4 34.564a1.133 1.133 0 01-.561-.711 1.125 1.125 0 01.136-.896c8.571-14.103 30.091-19.826 44.533-11.82a1.161 1.161 0 01.584 1.18 1.155 1.155 0 01-.159.436c-8.571 14.103-30.091 19.818-44.533 11.81z"
                />
                <path
                    opacity={0.64}
                    d="M374.025 108.467c.134.079.251.185.344.31a1.141 1.141 0 01.207.883 1.14 1.14 0 01-.169.431c-8.919 13.895-30.577 19.106-44.811 10.699a1.141 1.141 0 01-.545-.728 1.139 1.139 0 01.163-.896c8.867-13.877 30.525-19.062 44.811-10.699z"
                />
                <path
                    opacity={0.4}
                    d="M1090.08 289.44c-.09.122-.21.223-.35.297a1.15 1.15 0 01-.9.085 1.194 1.194 0 01-.41-.226c-12.55-10.716-14.76-32.87-4.54-45.844a1.193 1.193 0 01.8-.441c.16-.016.31.001.46.048.15.048.29.125.41.228 12.54 10.716 14.75 32.87 4.53 45.853z"
                />
                <path
                    opacity={0.69}
                    d="M921.511 276.544a1.143 1.143 0 01-.834.359 1.147 1.147 0 01-.834-.359c-11.576-11.759-11.854-34.026-.547-46.027a1.146 1.146 0 011.668 0c11.567 11.715 11.845 33.981.547 46.027z"
                />
                <path
                    opacity={0.07}
                    d="M1122.85 84.472c0-.155.04-.308.1-.45a1.16 1.16 0 01.68-.6c.15-.05.31-.067.46-.052 16.5 1.241 31.32 17.82 30.73 34.329 0 .155-.04.308-.11.449-.06.14-.16.266-.28.369-.11.103-.25.181-.4.23-.14.049-.3.068-.46.055-16.44-1.242-31.3-17.821-30.72-34.33z"
                />
                <path
                    opacity={0.19}
                    d="M736.882 230.829a1.14 1.14 0 01-.749-.531 1.162 1.162 0 01-.155-.442 1.156 1.156 0 01.036-.468c4.49-15.875 23.7-27.139 39.757-23.274a1.138 1.138 0 01.868 1.441c-4.489 15.875-23.699 27.13-39.757 23.274zM1085.85 221.181c.11.114.19.248.25.394.05.147.07.302.07.458-.01.156-.05.309-.12.449-.07.14-.17.265-.28.366-12.44 10.847-34.68 9.788-46.03-2.214a1.058 1.058 0 01-.24-.394 1.027 1.027 0 01-.07-.458c0-.156.04-.309.11-.449s.17-.265.29-.366c12.44-10.882 34.68-9.822 46.02 2.214z"
                />
                <path
                    opacity={0.31}
                    d="M895.232 90.82a1.155 1.155 0 01-1.511-.72c-5.21-15.632 4.282-35.77 19.722-41.641a1.157 1.157 0 011.503.72c5.245 15.684-4.282 35.78-19.714 41.642z"
                />
                <path
                    opacity={0.2}
                    d="M805.506 15.363a1.137 1.137 0 01.781-1.468c15.858-4.542 35.545 5.853 40.721 21.537a1.144 1.144 0 01-.781 1.476c-15.858 4.508-35.545-5.914-40.721-21.546z"
                />
                <path
                    opacity={0.33}
                    d="M862.162 16.97a1.154 1.154 0 01-.053-.904 1.152 1.152 0 01.618-.66c15.058-6.748 36.022.755 43.369 15.545a1.15 1.15 0 01-.185 1.304 1.14 1.14 0 01-.379.268c-15.059 6.747-36.023-.756-43.37-15.554z"
                />
                <path
                    opacity={0.32}
                    d="M152.835 188.042a1.154 1.154 0 01-.904.049 1.131 1.131 0 01-.659-.622c-6.652-15.103.973-36.023 15.814-43.274a1.148 1.148 0 011.564.573c6.652 15.102-.982 36.014-15.815 43.274z"
                />
                <path
                    opacity={0.58}
                    d="M245.68 196.309a1.15 1.15 0 01-.167-.89 1.151 1.151 0 01.531-.734c14.052-8.641 35.815-3.925 45.02 9.787.087.13.147.277.175.431a1.144 1.144 0 01-.54 1.202c-14.051 8.641-35.814 3.917-45.019-9.796z"
                />
                <path
                    opacity={0.11}
                    d="M104.533 230.569a1.137 1.137 0 01-.876-.231 1.14 1.14 0 01-.435-.794c-1.737-16.413 11.984-33.982 28.328-36.335a1.155 1.155 0 01.885.239 1.145 1.145 0 01.427.812c1.702 16.387-11.985 33.955-28.329 36.309z"
                />
                <path
                    opacity={0.34}
                    d="M214.737 137.62a1.141 1.141 0 01-.271.866 1.145 1.145 0 01-.814.402c-16.5.99-33.435-13.434-35.085-29.865a1.161 1.161 0 01.638-1.15c.14-.069.292-.109.448-.118 16.474-.99 33.434 13.435 35.084 29.865z"
                />
                <path
                    opacity={0.29}
                    d="M987.833 161.798a1.14 1.14 0 01-.646.639 1.137 1.137 0 01-.909-.031c-14.98-6.948-23.091-27.66-16.769-42.91a1.14 1.14 0 01.646-.639 1.135 1.135 0 01.908.031c14.981 6.922 23.092 27.651 16.77 42.91z"
                />
                <path
                    opacity={0.02}
                    d="M1000.24 202.762a1.146 1.146 0 01.75-.518c.15-.032.31-.032.46-.001.15.03.3.092.43.18 13.66 9.249 18.31 31.029 9.61 45.054-.08.134-.19.25-.32.341-.13.09-.27.154-.43.186-.15.033-.31.033-.46.003-.16-.031-.3-.093-.43-.182-13.662-9.275-18.317-30.986-9.61-45.063z"
                />
                <path
                    opacity={0.82}
                    d="M439.826 320.955a1.157 1.157 0 01-.252 1.65c-13.452 9.553-35.475 6.288-45.575-6.791a1.153 1.153 0 01.252-1.65c13.452-9.553 35.475-6.287 45.575 6.791z"
                />
                <path
                    opacity={0.03}
                    d="M236.969 170.908a1.155 1.155 0 01.747 1.493c-5.506 15.554-25.393 25.558-41.172 20.678a1.158 1.158 0 01-.747-1.494c5.506-15.562 25.384-25.558 41.172-20.677z"
                />
                <path
                    opacity={0.34}
                    d="M972.992 306.496a1.147 1.147 0 01.589.688c.046.149.062.305.046.46a1.163 1.163 0 01-.14.441c-7.92 14.477-29.154 21.173-43.943 13.834a1.148 1.148 0 01-.643-1.153c.016-.156.063-.308.139-.445 7.92-14.468 29.154-21.163 43.952-13.825z"
                />
                <path
                    opacity={0.5}
                    d="M243.1 252.818a1.141 1.141 0 01.259.87 1.152 1.152 0 01-.45.789c-13.13 9.995-35.249 7.46-45.775-5.272a1.157 1.157 0 01-.108-1.312c.078-.135.183-.253.308-.346 13.131-9.996 35.25-7.46 45.766 5.271z"
                />
                <path
                    opacity={0.43}
                    d="M949.474 265.471a1.15 1.15 0 01-.266-1.288c.062-.143.153-.272.266-.379 12.158-11.168 34.399-10.691 46.027 1.007a1.136 1.136 0 01.36.834 1.147 1.147 0 01-.36.833c-12.114 11.151-34.372 10.656-46.027-1.007z"
                />
                <path
                    opacity={0.69}
                    d="M868.397 297.716a1.154 1.154 0 01.734.518 1.15 1.15 0 01.135.889c-3.752 16.066-22.414 28.198-38.637 25.089a1.16 1.16 0 01-.868-1.407c3.752-16.066 22.423-28.198 38.636-25.089z"
                />
                <path
                    opacity={0.59}
                    d="M323.118 47.495a1.152 1.152 0 01-1.308.137 1.146 1.146 0 01-.351-.302c-10.256-12.923-8.155-35.094 4.342-45.862a1.161 1.161 0 01.869-.276 1.161 1.161 0 01.798.44c10.265 12.914 8.164 35.085-4.35 45.863z"
                />
                <path
                    opacity={0.23}
                    d="M892.141 287.868c.07-.139.168-.263.287-.364a1.159 1.159 0 011.311-.122c14.424 8.015 20.972 29.292 13.53 44.038a1.155 1.155 0 01-1.598.486c-14.425-8.015-21.007-29.301-13.53-44.038z"
                />
                <path
                    opacity={0.62}
                    d="M624.012 152.149a1.143 1.143 0 01-.711.562 1.142 1.142 0 01-.895-.136c-14.13-8.528-19.905-30.031-11.941-44.499a1.147 1.147 0 011.615-.425c14.121 8.528 19.87 30.03 11.932 44.498z"
                />
                <path
                    opacity={0.67}
                    d="M732.028 255.371a1.14 1.14 0 01.608 1.169 1.146 1.146 0 01-.156.438c-8.32 14.242-29.744 20.33-44.29 12.575a1.149 1.149 0 01-.452-1.607c8.294-14.242 29.709-20.339 44.29-12.575z"
                />
                <path
                    opacity={0.17}
                    d="M117.777 330.221a1.169 1.169 0 01-.776-.469 1.16 1.16 0 01-.197-.885c2.961-16.231 21.008-29.275 37.343-26.965a1.153 1.153 0 01.778.467 1.142 1.142 0 01.194.888c-2.935 16.231-20.99 29.274-37.342 26.964z"
                />
                <path
                    opacity={0.86}
                    d="M472.87 283.838a1.156 1.156 0 01.36.834 1.143 1.143 0 01-.36.834c-11.637 11.698-33.869 12.201-46.027 1.025a1.153 1.153 0 01-.265-1.288c.061-.143.152-.273.265-.38 11.603-11.689 33.869-12.201 46.027-1.025z"
                />
                <path
                    opacity={0.08}
                    d="M1022.28 70.43c-.1-.121-.18-.262-.22-.412-.04-.151-.06-.309-.04-.465.02-.155.08-.305.16-.44.08-.134.18-.25.31-.342 13.23-9.865 35.32-7.112 45.72 5.723.1.121.17.262.21.412.05.151.06.31.04.465-.02.155-.07.305-.16.44-.08.134-.18.25-.31.342-13.22 9.865-35.32 7.112-45.71-5.723z"
                />
                <path
                    opacity={0.56}
                    d="M270.056 277.716a1.148 1.148 0 01-.908-.022 1.153 1.153 0 01-.611-.673c-5.55-15.536 3.56-35.849 18.871-42.032a1.148 1.148 0 01.908.022 1.153 1.153 0 01.611.673c5.558 15.536-3.551 35.866-18.871 42.032z"
                />
                <path
                    opacity={0.87}
                    d="M413.782 115.311a1.144 1.144 0 01.909-.014 1.164 1.164 0 01.637.647c6.079 15.328-2.301 35.954-17.369 42.667a1.157 1.157 0 01-1.546-.634c-6.113-15.337 2.284-35.962 17.369-42.666z"
                />
                <path
                    opacity={0.06}
                    d="M1120.14 339.019c-.12.098-.26.17-.42.211-.15.042-.3.053-.46.032-.15-.021-.3-.074-.44-.155a1.17 1.17 0 01-.34-.314c-9.8-13.261-6.95-35.345 5.92-45.688a1.132 1.132 0 01.87-.247c.16.021.31.072.44.152.14.08.25.186.34.312 9.82 13.269 6.98 35.354-5.91 45.697z"
                />
                <path
                    opacity={0.1}
                    d="M787.825 153.626a1.144 1.144 0 01.706.571 1.155 1.155 0 01.075.905c-5.045 15.71-24.637 26.279-40.547 21.859a1.149 1.149 0 01-.79-1.468c5.045-15.71 24.637-26.288 40.556-21.867zM734.242 162.562a1.147 1.147 0 01-1.033 1.311c-16.414 1.676-33.956-12.036-36.284-28.389a1.161 1.161 0 01.591-1.175c.137-.075.288-.121.443-.136 16.413-1.668 33.956 12.045 36.283 28.389z"
                />
                <path
                    opacity={0.54}
                    d="M1.954 317.933a1.148 1.148 0 01-.06-1.667c11.445-11.889 33.694-12.757 46.026-1.781a1.149 1.149 0 01.06 1.668c-11.436 11.845-33.686 12.714-46.026 1.78z"
                />
                <path
                    opacity={0.67}
                    d="M144.959 90.369a1.142 1.142 0 011.254.438c.091.13.155.276.187.43 4.021 16.006-7.034 35.337-22.874 39.948a1.148 1.148 0 01-.914-.118 1.174 1.174 0 01-.347-.319 1.175 1.175 0 01-.19-.431c-4.012-15.953 7.052-35.293 22.884-39.948z"
                />
                <path
                    opacity={0.72}
                    d="M1196.36 152.636c-.02.155-.07.304-.15.439-.08.135-.18.253-.31.346-.13.093-.27.16-.42.197-.15.037-.31.042-.46.016-16.28-2.674-29.64-20.486-27.62-36.873.02-.156.07-.306.14-.441.08-.136.19-.254.31-.347.13-.094.27-.161.42-.197.15-.036.31-.041.47-.014 16.28 2.666 29.64 20.478 27.62 36.874z"
                />
                <path
                    opacity={0.67}
                    d="M182.666 199.548a1.145 1.145 0 01.906-.053 1.136 1.136 0 01.657.627c6.635 15.11-1.016 36.013-15.866 43.256a1.146 1.146 0 01-.906.043 1.168 1.168 0 01-.657-.625c-6.635-15.102 1.025-36.014 15.866-43.248z"
                />
                <path
                    opacity={0.12}
                    d="M561.268 341.745a1.155 1.155 0 01-1.659-.217c-9.796-13.269-6.947-35.353 5.949-45.688a1.156 1.156 0 01.871-.246 1.15 1.15 0 01.779.463c9.804 13.279 6.939 35.363-5.94 45.688z"
                />
                <path
                    opacity={0.62}
                    d="M630.334 334.946a1.164 1.164 0 01-.754.507 1.164 1.164 0 01-.887-.195c-13.461-9.552-17.655-31.411-8.684-45.254a1.139 1.139 0 01.755-.506 1.152 1.152 0 01.886.202c13.495 9.518 17.69 31.351 8.684 45.246z"
                />
                <path
                    opacity={0.58}
                    d="M528.467 26.852a1.15 1.15 0 01.13 1.309c-.076.136-.18.255-.304.35-13.026 10.143-35.162 7.816-45.827-4.76a1.153 1.153 0 01-.267-.868 1.15 1.15 0 01.45-.79c13.009-10.143 35.162-7.85 45.818 4.759z"
                />
                <path
                    opacity={0.93}
                    d="M1181.3 97.195c-.1.118-.23.213-.37.28-.14.067-.29.105-.45.11-.15.006-.31-.02-.46-.077a1.307 1.307 0 01-.39-.252c-11.89-11.438-12.8-33.687-1.84-46.027.11-.118.23-.213.37-.28.15-.067.3-.105.45-.11.16-.006.32.02.46.077.15.056.28.142.39.252 11.9 11.42 12.79 33.67 1.84 46.027z"
                />
                <path
                    opacity={0.66}
                    d="M663.882 102.571a1.147 1.147 0 011.167-.61c.155.02.304.07.439.149 14.26 8.294 20.4 29.701 12.679 44.29a1.142 1.142 0 01-.706.569 1.164 1.164 0 01-.9-.117c-14.216-8.285-20.4-29.683-12.679-44.281z"
                />
                <path
                    opacity={0.91}
                    d="M950.873 179.939a1.172 1.172 0 01.767-.488 1.17 1.17 0 01.883.219c13.252 9.831 16.96 31.785 7.659 45.428a1.155 1.155 0 01-1.65.278c-13.243-9.831-16.96-31.785-7.659-45.437z"
                />
                <path
                    opacity={0.47}
                    d="M341.112 180.269a1.157 1.157 0 01-.775-.479 1.14 1.14 0 01-.181-.893c3.17-16.196 21.381-28.997 37.708-26.478a1.13 1.13 0 01.769.482 1.14 1.14 0 01.177.89c-3.161 16.153-21.381 28.997-37.698 26.478z"
                />
                <path
                    opacity={0.06}
                    d="M1070.96 102.119c.01-.156.05-.308.12-.448.07-.14.16-.264.28-.366a1.19 1.19 0 01.87-.272c16.42 1.59 30.92 18.489 29.99 34.972-.01.156-.05.308-.11.448-.07.14-.17.264-.29.366-.12.101-.26.178-.4.224-.15.047-.31.063-.46.048-16.44-1.589-30.94-18.481-30-34.972z"
                />
                <path
                    opacity={0.56}
                    d="M208.424 293.122a1.13 1.13 0 01.811.406 1.126 1.126 0 01.257.871c-1.737 16.404-18.741 30.768-35.224 29.691a1.148 1.148 0 01-1.068-1.276c1.728-16.414 18.741-30.769 35.224-29.692z"
                />
                <path
                    opacity={0.39}
                    d="M718.793 3.604a1.14 1.14 0 01.834-.36 1.15 1.15 0 01.833.36c11.768 11.559 12.419 33.817 1.329 46.027a1.162 1.162 0 01-.824.377 1.156 1.156 0 01-.843-.334c-11.811-11.584-12.462-33.842-1.329-46.07z"
                />
                <path
                    opacity={0.61}
                    d="M1025.35 247.946c.08-.135.18-.254.31-.348.12-.094.26-.163.41-.201a1.142 1.142 0 01.9.141c14.05 8.641 19.66 30.195 11.57 44.594-.08.136-.18.255-.3.35-.13.095-.27.164-.42.202a1.135 1.135 0 01-.89-.144c-14.09-8.641-19.7-30.195-11.58-44.594z"
                />
                <path
                    opacity={0.7}
                    d="M3.526 256.839a1.147 1.147 0 01.66-1.529c15.45-5.801 35.91 2.996 42.319 18.237a1.152 1.152 0 01-.267 1.286 1.154 1.154 0 01-.393.243c-15.45 5.775-35.91-3.022-42.32-18.237z"
                />
                <path
                    opacity={0.19}
                    d="M579.262 283.804a1.148 1.148 0 01-.829-.375 1.16 1.16 0 01-.3-.858c1.051-16.501 17.464-31.516 33.973-31.125a1.155 1.155 0 01.826.375 1.153 1.153 0 01.294.858c-1.05 16.466-17.455 31.516-33.964 31.125z"
                />
                <path
                    opacity={0.08}
                    d="M657.924 52.818a1.147 1.147 0 011.607.452c7.877 14.494 1.997 35.97-12.158 44.429a1.165 1.165 0 01-1.615-.452c-7.903-14.494-2.015-35.97 12.166-44.429z"
                />
                <path
                    opacity={0.45}
                    d="M753.808 331.567a1.156 1.156 0 01-.351.836 1.144 1.144 0 01-.848.32c-16.5-.513-32.062-16.431-32.201-32.94a1.139 1.139 0 011.198-1.164c16.492.513 32.063 16.431 32.202 32.948z"
                />
                <path
                    opacity={0.94}
                    d="M357.395 272.497a1.126 1.126 0 01-.076.906 1.125 1.125 0 01-.715.561c-15.883 4.473-35.518-6.018-40.625-21.71a1.158 1.158 0 01.79-1.468c15.884-4.49 35.545 6.001 40.626 21.711z"
                />
                <path
                    opacity={0.83}
                    d="M76.813 96.995a1.147 1.147 0 011.511.704c5.445 15.571-3.804 35.823-19.166 41.893a1.149 1.149 0 01-1.511-.695c-5.446-15.58 3.803-35.823 19.166-41.902z"
                />
                <path
                    opacity={0.92}
                    d="M1048.35 301.077c-.01-.156.01-.312.06-.459.05-.148.13-.284.24-.399a1.113 1.113 0 01.82-.375c16.5-.582 33.08 14.268 34.32 30.742.01.156-.01.313-.06.461a1.08 1.08 0 01-.24.4 1.108 1.108 0 01-.82.372c-16.5.591-33.08-14.242-34.32-30.742z"
                />
                <path
                    opacity={0.33}
                    d="M317.794 79.965a1.15 1.15 0 01.605 1.169 1.157 1.157 0 01-.153.438c-8.372 14.216-29.814 20.234-44.369 12.436a1.146 1.146 0 01-.442-1.607c8.371-14.225 29.804-20.243 44.359-12.436z"
                />
                <path
                    opacity={0.74}
                    d="M755.093 127.442a1.151 1.151 0 01-1.658-.217c-9.831-13.252-7.026-35.336 5.835-45.697a1.144 1.144 0 01.873-.25 1.14 1.14 0 01.777.468c9.84 13.243 7.026 35.336-5.827 45.696z"
                />
                <path
                    opacity={0.99}
                    d="M541.633 46.478a1.144 1.144 0 011.632-.338c13.643 9.275 18.237 31.055 9.553 45.072a1.146 1.146 0 01-1.633.338c-13.669-9.275-18.289-31.029-9.552-45.072z"
                />
                <path
                    opacity={0.58}
                    d="M1148.06 41.546c.02.155 0 .312-.04.462-.05.15-.12.289-.22.409a1.138 1.138 0 01-.81.414c-16.45 1.25-33.64-12.905-35.54-29.31-.02-.154-.01-.311.03-.461.05-.15.12-.289.22-.41a1.14 1.14 0 01.81-.414c16.45-1.216 33.64 12.905 35.55 29.31z"
                />
                <path
                    opacity={0.66}
                    d="M1186.75 289.561c.14-.062.29-.094.45-.095.16-.001.31.029.45.089.15.06.28.149.38.26.11.112.2.244.25.389 6.02 15.363-2.48 35.944-17.61 42.553a1.12 1.12 0 01-.9.01c-.15-.06-.28-.149-.39-.261-.1-.112-.19-.246-.24-.391-6.02-15.346 2.48-35.928 17.61-42.554z"
                />
                <path
                    opacity={0.52}
                    d="M1198.97 235.076c.15.015.3.061.44.136.13.075.25.177.35.299.1.123.17.264.21.415.04.15.04.307.02.461-2.33 16.336-19.88 30.057-36.31 28.363-.15-.014-.3-.061-.44-.136a1.156 1.156 0 01-.35-.299 1.08 1.08 0 01-.2-.415 1.027 1.027 0 01-.02-.461c2.33-16.379 19.87-30.1 36.3-28.363z"
                />
                <path
                    opacity={0.3}
                    d="M225.688 321.138a1.159 1.159 0 01-.703-1.511c5.966-15.389 26.157-24.785 41.78-19.427a1.132 1.132 0 01.675.604 1.128 1.128 0 01.02.907c-5.967 15.38-26.149 24.785-41.772 19.427z"
                />
                <path
                    opacity={0.82}
                    d="M247.13 18.558a1.165 1.165 0 01.096-.904 1.147 1.147 0 01.72-.555c15.953-4.212 35.424 6.592 40.278 22.371a1.15 1.15 0 01-.092.906 1.146 1.146 0 01-.724.553c-15.953 4.22-35.424-6.583-40.278-22.37z"
                />
                <path d="M102.145 133.469a1.148 1.148 0 011.659-.217c12.922 10.265 15.901 32.323 6.157 45.654a1.16 1.16 0 01-.783.468 1.155 1.155 0 01-.876-.251c-12.914-10.248-15.9-32.315-6.157-45.654z" />
                <path
                    opacity={0.8}
                    d="M841.12 59.957a1.154 1.154 0 011.077-.745c.155 0 .309.032.452.093 15.197 6.435 23.968 26.922 18.133 42.354a1.154 1.154 0 01-.623.657 1.144 1.144 0 01-.906-.006c-15.197-6.435-23.968-26.904-18.133-42.353z"
                />
                <path
                    opacity={0.65}
                    d="M1028.05 327.173c.04.15.05.307.03.461-.03.153-.08.301-.16.433-.08.133-.19.247-.32.337a1.12 1.12 0 01-.42.185c-16.13 3.474-35.065-8.259-39.164-24.264a1.156 1.156 0 01.13-.894 1.142 1.142 0 01.738-.522c16.136-3.447 35.066 8.268 39.166 24.264z"
                />
                <path
                    opacity={0.4}
                    d="M103.074 302.545a1.142 1.142 0 01.487 1.597c-8.077 14.382-29.388 20.843-44.1 13.34a1.155 1.155 0 01-.583-.696 1.146 1.146 0 01.106-.902c8.068-14.39 29.37-20.843 44.09-13.339z"
                />
                <path
                    opacity={0.2}
                    d="M650.187 274.329a1.158 1.158 0 01-1.607-.469c-7.72-14.581-1.606-35.988 12.662-44.29a1.164 1.164 0 01.904-.11 1.16 1.16 0 01.702.579c7.729 14.59 1.624 35.979-12.661 44.29z"
                />
                <path
                    opacity={0.98}
                    d="M41.606 9.023a1.146 1.146 0 011.173 1.19c-.452 16.5-16.31 32.132-32.818 32.331a1.146 1.146 0 01-1.173-1.19c.495-16.49 16.31-32.131 32.819-32.331z"
                />
                <path
                    opacity={0.7}
                    d="M549.7 257.89a1.15 1.15 0 01.914.118 1.16 1.16 0 01.537.75c4.055 15.988-6.948 35.354-22.771 40.052a1.16 1.16 0 01-.914-.118 1.162 1.162 0 01-.536-.75c-4.056-15.971 6.939-35.354 22.77-40.052z"
                />
                <path
                    opacity={0.51}
                    d="M101.858 256.596a1.148 1.148 0 01-.079 1.316 1.175 1.175 0 01-.355.299c-14.442 7.972-35.962 2.241-44.516-11.889a1.148 1.148 0 01.434-1.606c14.469-7.981 35.962-2.241 44.516 11.88z"
                />
                <path
                    opacity={0.88}
                    d="M843.96 259.062a1.155 1.155 0 01-.729-1.094 1.14 1.14 0 01.104-.452c6.722-15.067 27.347-23.447 42.683-17.368a1.14 1.14 0 01.73 1.094c-.004.156-.039.31-.104.451-6.722 15.094-27.347 23.492-42.684 17.369z"
                />
                <path
                    opacity={0.44}
                    d="M316.804 230.821a1.129 1.129 0 01-.907-.12 1.13 1.13 0 01-.526-.749c-3.795-16.057 7.512-35.232 23.448-39.67a1.159 1.159 0 01.905.123 1.15 1.15 0 01.528.746c3.769 16.057-7.547 35.241-23.448 39.67z"
                />
                <path
                    opacity={0.85}
                    d="M570.421 239.878a1.136 1.136 0 01-.301.856 1.15 1.15 0 01-.828.369c-16.5.382-32.913-14.651-33.964-31.133a1.16 1.16 0 01.307-.856 1.15 1.15 0 01.83-.369c16.457-.391 32.957 14.651 33.956 31.133z"
                />
                <path
                    opacity={0.63}
                    d="M701.919 319.027a1.141 1.141 0 01.065.904 1.155 1.155 0 01-.612.668c-14.989 6.904-36.031-.382-43.535-15.093a1.171 1.171 0 01-.061-.91 1.148 1.148 0 01.617-.671c14.989-6.895 36.023.391 43.526 15.102z"
                />
                <path
                    opacity={0.47}
                    d="M691.932 21.086a1.142 1.142 0 01.483 1.221 1.147 1.147 0 01-.196.42c-9.709 13.339-31.628 17.247-45.358 8.068a1.142 1.142 0 01-.483-1.222c.036-.152.103-.295.196-.42 9.692-13.339 31.628-17.264 45.358-8.067z"
                />
                <path
                    opacity={0.31}
                    d="M831.211 182.605a1.133 1.133 0 01-.733-.518 1.133 1.133 0 01-.158-.431 1.124 1.124 0 01.023-.458c3.89-16.04 22.657-28.015 38.854-24.759a1.16 1.16 0 01.733.519c.082.131.135.278.158.43.024.153.016.309-.023.458-3.891 16.04-22.657 28.007-38.854 24.759z"
                />
                <path
                    opacity={0.69}
                    d="M810.846 332.566a1.148 1.148 0 01-.848 1.005 1.148 1.148 0 01-.463.029c-16.344-2.276-30.126-19.757-28.51-36.197a1.137 1.137 0 01.438-.798 1.135 1.135 0 01.882-.226c16.343 2.266 30.151 19.757 28.501 36.187z"
                />
                <path
                    opacity={0.18}
                    d="M169.944 48.363a1.146 1.146 0 011.667 0c11.472 11.863 11.559 34.13.156 46.07a1.144 1.144 0 01-1.667 0c-11.515-11.845-11.602-34.112-.156-46.07z"
                />
                <path
                    opacity={0.98}
                    d="M599.696 192.523a1.153 1.153 0 01-1.035.812 1.155 1.155 0 01-.459-.065c-15.562-5.489-25.584-25.367-20.72-41.147a1.131 1.131 0 01.585-.696 1.152 1.152 0 01.908-.051c15.562 5.541 25.584 25.393 20.721 41.147z"
                />
                <path
                    opacity={0.02}
                    d="M885.011 179.01a1.154 1.154 0 011.598-.512c14.52 7.815 21.329 29.04 14.077 43.873a1.171 1.171 0 01-.692.591 1.165 1.165 0 01-.906-.088c-14.52-7.833-21.328-29.031-14.077-43.864z"
                />
                <path
                    opacity={0.55}
                    d="M408.024 244.481a1.166 1.166 0 011.19 1.173c-.174 16.5-15.753 32.409-32.253 32.896a1.141 1.141 0 01-.849-.329 1.15 1.15 0 01-.341-.844c.165-16.5 15.745-32.401 32.253-32.896z"
                />
                <path
                    opacity={0.57}
                    d="M1030.69 13.904c.15.046.29.123.41.225.11.102.21.228.28.369.07.14.1.294.11.45.01.157-.02.313-.08.458-5.7 15.484-25.74 25.184-41.44 20.113a1.136 1.136 0 01-.69-.594 1.155 1.155 0 01-.04-.908c5.715-15.476 25.74-25.211 41.45-20.113z"
                />
                <path
                    opacity={0.51}
                    d="M775.918 73.443a1.147 1.147 0 01-.262-.866 1.138 1.138 0 01.453-.784c13.122-10.013 35.241-7.494 45.775 5.21a1.159 1.159 0 01.115 1.311 1.143 1.143 0 01-.306.349c-13.122 10.021-35.241 7.503-45.775-5.22z"
                />
                <path
                    opacity={0.8}
                    d="M52.705 166.314a1.147 1.147 0 011.485-.756c15.632 5.376 25.767 25.185 21.016 40.999a1.15 1.15 0 01-1.485.755c-15.623-5.367-25.783-25.21-21.016-40.998z"
                />
                <path
                    opacity={0.34}
                    d="M497.343 161.45a1.16 1.16 0 01-1.263.386 1.17 1.17 0 01-.405-.229c-12.549-10.717-14.763-32.871-4.542-45.845a1.164 1.164 0 011.668-.165c12.583 10.716 14.789 32.87 4.542 45.853z"
                />
                <path
                    opacity={0.66}
                    d="M785.601 47.078a1.16 1.16 0 01-.374.828 1.16 1.16 0 01-.859.3c-16.5-1.007-31.567-17.368-31.263-33.868a1.153 1.153 0 01.375-.826 1.143 1.143 0 01.858-.295c16.509.982 31.611 17.352 31.263 33.86z"
                />
                <path
                    opacity={0.97}
                    d="M1177.33 170.621c.1-.114.23-.204.37-.266a1.135 1.135 0 01.91 0c.15.062.28.152.38.266 11.4 11.932 11.29 34.199-.15 46.027-.11.113-.24.204-.38.266a1.151 1.151 0 01-1.29-.266c-11.41-11.898-11.34-34.164.16-46.027z"
                />
                <path
                    opacity={0.62}
                    d="M538.871 195.059a1.153 1.153 0 01-1.667.078c-12.019-11.29-13.166-33.539-2.345-46.027a1.161 1.161 0 011.273-.331c.147.054.281.137.394.244 12.054 11.368 13.166 33.556 2.345 46.036z"
                />
                <path
                    opacity={0.71}
                    d="M243.335 100.017a1.156 1.156 0 01-.664.622 1.148 1.148 0 01-.908-.057c-14.764-7.321-22.336-28.268-15.632-43.352a1.147 1.147 0 01.667-.613 1.157 1.157 0 01.905.057c14.815 7.32 22.362 28.267 15.632 43.343z"
                />
                <path
                    opacity={0.59}
                    d="M317.212 329.683a1.151 1.151 0 01-.405.814 1.148 1.148 0 01-.871.263c-16.414-1.737-30.743-18.793-29.649-35.276a1.162 1.162 0 01.414-.809 1.17 1.17 0 01.872-.259c16.404 1.754 30.742 18.819 29.639 35.267z"
                />
                <path
                    opacity={0.2}
                    d="M115.45 83.335a1.152 1.152 0 01-.171.893 1.147 1.147 0 01-.767.488C98.237 87.45 79.844 74.902 76.457 58.74a1.154 1.154 0 01.947-1.381c16.274-2.727 34.667 9.813 38.046 25.975z"
                />
                <path
                    opacity={0.38}
                    d="M449.188 252.627a1.146 1.146 0 01-.75.517 1.156 1.156 0 01-.891-.187c-13.591-9.353-18.081-31.159-9.266-45.158a1.141 1.141 0 01.746-.513 1.141 1.141 0 01.886.183c13.591 9.37 18.081 31.194 9.275 45.158z"
                />
                <path
                    opacity={0.76}
                    d="M260.599 113.235a1.162 1.162 0 011.308.144c.118.103.214.228.282.368 7.242 14.833.434 36.032-14.112 43.856a1.139 1.139 0 01-.903.091 1.115 1.115 0 01-.402-.231 1.113 1.113 0 01-.276-.372c-7.243-14.824-.434-36.023 14.103-43.856z"
                />
                <path
                    opacity={0.4}
                    d="M597.368 13.33a1.151 1.151 0 01.558-1.192 1.15 1.15 0 01.441-.145c16.361-2.093 34.251 11.177 36.995 27.46a1.164 1.164 0 01-.213.882 1.161 1.161 0 01-.785.455c-16.37 2.084-34.26-11.176-36.996-27.46z"
                />
                <path
                    opacity={0.62}
                    d="M1099.8 205.775a1.19 1.19 0 01-.04-.91c.06-.146.15-.28.25-.392.11-.112.24-.201.39-.261 15.21-6.4 36 1.572 43 16.5.07.141.11.294.12.45a1.186 1.186 0 01-.33.846c-.11.111-.24.199-.39.259-15.2 6.435-35.99-1.546-43-16.492z"
                />
                <path
                    opacity={0.26}
                    d="M1198.91 10.586c.15.034.29.097.42.187.12.09.23.205.31.337.08.132.13.279.16.432.02.153.01.31-.03.46-3.92 16.022-22.72 27.955-38.9 24.672a1.21 1.21 0 01-.42-.19c-.13-.09-.23-.204-.31-.336a1.12 1.12 0 01-.16-.43c-.02-.154-.02-.31.02-.46 3.93-16.022 22.73-27.963 38.91-24.672z"
                />
                <path
                    opacity={0.18}
                    d="M629.345 233.339a1.158 1.158 0 01-1.225 1.138c-16.5-.808-31.767-16.995-31.611-33.504a1.153 1.153 0 01.756-1.08c.147-.054.304-.076.46-.067 16.457.782 31.75 17.013 31.62 33.513z"
                />
                <path
                    opacity={0.31}
                    d="M785.219 278.923a1.146 1.146 0 01-.325 1.275c-.118.103-.256.18-.404.228-15.676 5.149-35.754-4.49-41.529-19.974a1.157 1.157 0 01.73-1.503c15.675-5.132 35.753 4.499 41.528 19.974z"
                />
                <path
                    opacity={0.68}
                    d="M475.302 265.228a1.162 1.162 0 01-.665-.625 1.155 1.155 0 01-.004-.912c6.296-15.25 26.67-24.221 42.18-18.532a1.136 1.136 0 01.659.622 1.155 1.155 0 01.001.906c-6.288 15.25-26.67 24.221-42.171 18.541z"
                />
                <path
                    opacity={0.66}
                    d="M13.33 231.385a1.146 1.146 0 01-.905.032 1.16 1.16 0 01-.65-.631c-6.434-15.198 1.512-36.005 16.449-43.04a1.155 1.155 0 01.909-.032 1.173 1.173 0 01.654.632c6.418 15.197-1.52 35.996-16.457 43.039z"
                />
                <path
                    opacity={0.84}
                    d="M357.586 87.633a1.15 1.15 0 01-1.205.53 1.15 1.15 0 01-.428-.182c-13.677-9.231-18.358-30.994-9.674-45.046a1.15 1.15 0 01.742-.522 1.153 1.153 0 01.891.175c13.678 9.249 18.358 31.003 9.674 45.045z"
                />
                <path
                    opacity={0.27}
                    d="M508.224 334.703a1.155 1.155 0 01-.432.8 1.153 1.153 0 01-.879.233c-16.344-2.241-30.17-19.705-28.58-36.144a1.137 1.137 0 01.438-.798 1.153 1.153 0 01.882-.227c16.344 2.241 30.16 19.696 28.571 36.136z"
                />
                <path
                    opacity={0.84}
                    d="M890.69 104.472a1.153 1.153 0 01.911.001 1.139 1.139 0 01.618.668c5.766 15.458-3.074 35.892-18.307 42.275a1.16 1.16 0 01-1.285-.274 1.15 1.15 0 01-.243-.394c-5.767-15.467 3.074-35.858 18.306-42.276z"
                />
                <path
                    opacity={0.17}
                    d="M389.127 61.676a1.153 1.153 0 01.732-1.096c.146-.056.302-.082.458-.076 16.5.477 32.132 16.352 32.288 32.861a1.136 1.136 0 01-.341.844 1.15 1.15 0 01-.848.328c-16.492-.477-32.106-16.352-32.289-32.861z"
                />
                <path
                    opacity={0.85}
                    d="M22.753 57.047a1.148 1.148 0 011.659-.156c12.548 10.716 14.763 32.87 4.524 45.845a1.16 1.16 0 01-.796.435 1.14 1.14 0 01-.863-.279c-12.549-10.751-14.746-32.905-4.524-45.845z"
                />
                <path
                    opacity={0.3}
                    d="M647.234 158.037a1.153 1.153 0 011.18-.587c.154.024.303.079.435.162 14.104 8.571 19.827 30.091 11.82 44.533a1.151 1.151 0 01-1.181.58 1.154 1.154 0 01-.435-.163c-14.077-8.563-19.826-30.083-11.819-44.525z"
                />
                <path
                    opacity={0.79}
                    d="M517.316 202.71a1.142 1.142 0 01-.156 1.658c-12.905 10.283-35.076 8.224-45.87-4.272a1.155 1.155 0 01-.28-.863 1.15 1.15 0 01.436-.796c12.87-10.256 35.05-8.224 45.87 4.273z"
                />
                <path
                    opacity={0.37}
                    d="M1110.39 89.118c-.06.146-.14.28-.25.392-.11.112-.24.202-.38.263-.15.06-.3.092-.46.091-.15 0-.31-.032-.45-.094-15.19-6.453-23.95-26.922-18.11-42.371.06-.145.14-.277.25-.39.11-.11.24-.2.38-.26a1.155 1.155 0 01.91 0c15.19 6.451 23.95 26.92 18.11 42.37z"
                />
                <path
                    opacity={0.65}
                    d="M724.603 201.285a1.15 1.15 0 01.448 1.235c-.04.151-.109.292-.205.415-10.091 13.027-32.132 16.335-45.575 6.757a1.17 1.17 0 01-.474-.773 1.15 1.15 0 01.23-.877c10.092-13.053 32.115-16.327 45.576-6.757z"
                />
                <path
                    opacity={0.84}
                    d="M451.394 193.087a1.152 1.152 0 01-1.633.356c-13.73-9.153-18.549-30.89-9.952-44.984a1.152 1.152 0 011.633-.357c13.73 9.145 18.558 30.882 9.952 44.985z"
                />
                <path
                    opacity={0.09}
                    d="M1040.26 184.855c.07.137.12.288.13.443.01.155-.01.311-.06.458-.05.147-.13.282-.24.398-.1.115-.23.208-.37.272-14.94 7-36.03-.156-43.619-14.824a1.146 1.146 0 01.547-1.58c14.932-7.026 36.022.165 43.612 14.833z"
                />
                <path
                    opacity={0.97}
                    d="M428.927 105.68a1.164 1.164 0 01-.469-1.232c.038-.151.106-.294.2-.418 9.883-13.218 31.846-16.857 45.463-7.504a1.14 1.14 0 01.26 1.642c-9.874 13.235-31.837 16.882-45.454 7.512z"
                />
                <path
                    opacity={0.61}
                    d="M837.212 257.82a1.14 1.14 0 01.4.817 1.161 1.161 0 01-.321.851c-11.29 12.019-33.539 13.156-46.027 2.336a1.14 1.14 0 01-.399-.817 1.143 1.143 0 01.321-.851c11.315-12.054 33.556-13.156 46.026-2.336z"
                />
                <path
                    opacity={0.31}
                    d="M415.71 204.542a1.15 1.15 0 01.266 1.288 1.157 1.157 0 01-.266.379c-11.985 11.342-34.251 11.177-46.027-.356a1.148 1.148 0 01-.356-.833 1.163 1.163 0 01.356-.834c11.915-11.342 34.181-11.177 46.027.356z"
                />
                <path
                    opacity={0.66}
                    d="M166.331 265.15a1.15 1.15 0 01.266 1.288 1.157 1.157 0 01-.266.379c-12.063 11.29-34.329 10.951-46.027-.66a1.148 1.148 0 01-.356-.833 1.163 1.163 0 01.356-.834c12.019-11.264 34.286-10.951 46.027.66z"
                />
            </g>
            <defs>
                <clipPath id="prefix__clip0_520:659">
                    <path fill="#fff" d="M0 0h1200v342.006H0z" />
                </clipPath>
            </defs>
        </svg>
    );
}

export default LeafPattern;
