export default function StaticCSSPosition() {
    return (
      <svg
        style={{ maxWidth: "100%", maxHeight: "max-content" }}
        viewBox="0 0 1024 900"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
      >
        <g filter="url(#filter0_d_1026_128)">
          <path
            d="M12 17.7682C12 14.0302 15.0302 11 18.7682 11H1005.23C1008.97 11 1012 14.0302 1012 17.7682V70.6091H12V17.7682Z"
            fill="#FAFAFA"
          />
          <rect
            x="32.5584"
            y="35.1364"
            width="11.3367"
            height="11.3367"
            rx="5.66836"
            fill="#EE6A5F"
            stroke="#C7493E"
            stroke-width="0.507614"
          />
          <rect
            x="51.171"
            y="35.1364"
            width="11.3367"
            height="11.3367"
            rx="5.66836"
            fill="#F4BE50"
            stroke="#CD9B35"
            stroke-width="0.507614"
          />
          <rect
            x="69.7835"
            y="35.1364"
            width="11.3367"
            height="11.3367"
            rx="5.66836"
            fill="#5FC454"
            stroke="#39A430"
            stroke-width="0.507614"
          />
          <path
            d="M113.1 34.4595L106.755 40.8047L113.1 47.1498"
            stroke="#9A9593"
            stroke-width="1.26904"
            stroke-linecap="round"
            stroke-linejoin="round"
          />
          <path
            d="M141.019 34.4595L147.364 40.8047L141.019 47.1498"
            stroke="#D3D3D1"
            stroke-width="1.26904"
            stroke-linecap="round"
            stroke-linejoin="round"
          />
          <path
            d="M469.159 45.7837C469.645 45.7837 470.059 45.7267 470.401 45.6127C470.749 45.4987 471.031 45.3427 471.247 45.1447C471.469 44.9467 471.631 44.7127 471.733 44.4427C471.835 44.1667 471.886 43.8667 471.886 43.5427C471.886 42.9007 471.664 42.3967 471.22 42.0307C470.776 41.6587 470.089 41.4727 469.159 41.4727H466.459V45.7837H469.159ZM466.459 35.8837V40.1137H468.664C469.606 40.1137 470.305 39.9247 470.761 39.5467C471.223 39.1627 471.454 38.6467 471.454 37.9987C471.454 37.2607 471.235 36.7237 470.797 36.3877C470.359 36.0517 469.678 35.8837 468.754 35.8837H466.459ZM468.754 34.3807C469.564 34.3807 470.257 34.4587 470.833 34.6147C471.415 34.7707 471.892 34.9957 472.264 35.2897C472.636 35.5837 472.909 35.9407 473.083 36.3607C473.263 36.7747 473.353 37.2457 473.353 37.7737C473.353 38.0857 473.305 38.3857 473.209 38.6737C473.113 38.9617 472.966 39.2317 472.768 39.4837C472.57 39.7297 472.321 39.9517 472.021 40.1497C471.721 40.3477 471.367 40.5127 470.959 40.6447C472.837 41.0167 473.776 41.9977 473.776 43.5877C473.776 44.1397 473.674 44.6437 473.47 45.0997C473.266 45.5497 472.969 45.9397 472.579 46.2697C472.189 46.5997 471.709 46.8547 471.139 47.0347C470.569 47.2147 469.921 47.3047 469.195 47.3047H464.542V34.3807H468.754ZM481.587 40.6087C482.079 40.6087 482.511 40.5487 482.883 40.4287C483.261 40.3087 483.576 40.1407 483.828 39.9247C484.08 39.7027 484.269 39.4417 484.395 39.1417C484.521 38.8357 484.584 38.4997 484.584 38.1337C484.584 37.3897 484.338 36.8287 483.846 36.4507C483.36 36.0727 482.628 35.8837 481.65 35.8837H479.841V40.6087H481.587ZM487.617 47.3047H485.907C485.565 47.3047 485.316 47.1697 485.16 46.8997L481.965 42.4177C481.863 42.2677 481.752 42.1627 481.632 42.1027C481.512 42.0367 481.332 42.0037 481.092 42.0037H479.841V47.3047H477.924V34.3807H481.65C482.484 34.3807 483.201 34.4677 483.801 34.6417C484.407 34.8097 484.905 35.0527 485.295 35.3707C485.691 35.6827 485.982 36.0607 486.168 36.5047C486.36 36.9487 486.456 37.4467 486.456 37.9987C486.456 38.4487 486.387 38.8717 486.249 39.2677C486.111 39.6637 485.907 40.0207 485.637 40.3387C485.373 40.6507 485.049 40.9207 484.665 41.1487C484.281 41.3767 483.846 41.5507 483.36 41.6707C483.6 41.8147 483.807 42.0157 483.981 42.2737L487.617 47.3047ZM502.873 40.8427C502.873 41.8087 502.717 42.6967 502.405 43.5067C502.099 44.3107 501.664 45.0067 501.1 45.5947C500.536 46.1767 499.861 46.6297 499.075 46.9537C498.289 47.2777 497.416 47.4397 496.456 47.4397C495.502 47.4397 494.629 47.2777 493.837 46.9537C493.051 46.6297 492.376 46.1767 491.812 45.5947C491.254 45.0067 490.819 44.3107 490.507 43.5067C490.195 42.6967 490.039 41.8087 490.039 40.8427C490.039 39.8827 490.195 38.9977 490.507 38.1877C490.819 37.3777 491.254 36.6817 491.812 36.0997C492.376 35.5117 493.051 35.0557 493.837 34.7317C494.629 34.4017 495.502 34.2367 496.456 34.2367C497.416 34.2367 498.289 34.4017 499.075 34.7317C499.861 35.0557 500.536 35.5117 501.1 36.0997C501.664 36.6817 502.099 37.3777 502.405 38.1877C502.717 38.9977 502.873 39.8827 502.873 40.8427ZM500.911 40.8427C500.911 40.0747 500.806 39.3847 500.596 38.7727C500.386 38.1607 500.086 37.6417 499.696 37.2157C499.312 36.7897 498.844 36.4627 498.292 36.2347C497.746 36.0067 497.134 35.8927 496.456 35.8927C495.778 35.8927 495.163 36.0067 494.611 36.2347C494.065 36.4627 493.597 36.7897 493.207 37.2157C492.817 37.6417 492.517 38.1607 492.307 38.7727C492.097 39.3847 491.992 40.0747 491.992 40.8427C491.992 41.6167 492.097 42.3097 492.307 42.9217C492.517 43.5277 492.817 44.0437 493.207 44.4697C493.597 44.8957 494.065 45.2227 494.611 45.4507C495.163 45.6727 495.778 45.7837 496.456 45.7837C497.134 45.7837 497.746 45.6727 498.292 45.4507C498.844 45.2227 499.312 44.8957 499.696 44.4697C500.086 44.0437 500.386 43.5277 500.596 42.9217C500.806 42.3097 500.911 41.6167 500.911 40.8427ZM523.636 34.3807L519.604 47.3047H517.876L514.726 37.7197C514.654 37.5277 514.591 37.2967 514.537 37.0267C514.471 37.3027 514.408 37.5337 514.348 37.7197L511.162 47.3047H509.443L505.411 34.3807H507.013C507.181 34.3807 507.322 34.4227 507.436 34.5067C507.55 34.5847 507.625 34.6927 507.661 34.8307L510.208 43.4797C510.256 43.6477 510.298 43.8307 510.334 44.0287C510.376 44.2267 510.418 44.4337 510.46 44.6497C510.502 44.4337 510.544 44.2267 510.586 44.0287C510.634 43.8307 510.688 43.6477 510.748 43.4797L513.664 34.8307C513.7 34.7107 513.775 34.6057 513.889 34.5157C514.009 34.4257 514.15 34.3807 514.312 34.3807H514.861C515.029 34.3807 515.167 34.4227 515.275 34.5067C515.383 34.5907 515.461 34.6987 515.509 34.8307L518.416 43.4797C518.524 43.8097 518.62 44.1847 518.704 44.6047C518.776 44.1907 518.854 43.8157 518.938 43.4797L521.494 34.8307C521.524 34.7107 521.599 34.6057 521.719 34.5157C521.839 34.4257 521.98 34.3807 522.142 34.3807H523.636ZM533.72 36.4867C533.66 36.5887 533.597 36.6637 533.531 36.7117C533.465 36.7597 533.381 36.7837 533.279 36.7837C533.171 36.7837 533.048 36.7357 532.91 36.6397C532.772 36.5377 532.598 36.4267 532.388 36.3067C532.184 36.1807 531.938 36.0697 531.65 35.9737C531.362 35.8717 531.017 35.8207 530.615 35.8207C530.237 35.8207 529.904 35.8717 529.616 35.9737C529.334 36.0697 529.097 36.2047 528.905 36.3787C528.713 36.5467 528.566 36.7477 528.464 36.9817C528.368 37.2097 528.32 37.4587 528.32 37.7287C528.32 38.0767 528.407 38.3647 528.581 38.5927C528.761 38.8207 528.995 39.0157 529.283 39.1777C529.571 39.3397 529.898 39.4807 530.264 39.6007C530.63 39.7207 531.005 39.8467 531.389 39.9787C531.773 40.1047 532.148 40.2517 532.514 40.4197C532.88 40.5877 533.207 40.8007 533.495 41.0587C533.783 41.3107 534.014 41.6227 534.188 41.9947C534.368 42.3607 534.458 42.8107 534.458 43.3447C534.458 43.9147 534.359 44.4487 534.161 44.9467C533.969 45.4447 533.687 45.8797 533.315 46.2517C532.943 46.6237 532.484 46.9177 531.938 47.1337C531.398 47.3437 530.783 47.4487 530.093 47.4487C529.679 47.4487 529.277 47.4067 528.887 47.3227C528.497 47.2447 528.128 47.1337 527.78 46.9897C527.432 46.8397 527.105 46.6627 526.799 46.4587C526.499 46.2487 526.229 46.0147 525.989 45.7567L526.538 44.8387C526.592 44.7667 526.655 44.7067 526.727 44.6587C526.805 44.6107 526.892 44.5867 526.988 44.5867C527.114 44.5867 527.258 44.6527 527.42 44.7847C527.588 44.9167 527.792 45.0637 528.032 45.2257C528.278 45.3817 528.569 45.5257 528.905 45.6577C529.247 45.7897 529.661 45.8557 530.147 45.8557C530.543 45.8557 530.897 45.8047 531.209 45.7027C531.521 45.5947 531.782 45.4447 531.992 45.2527C532.208 45.0547 532.373 44.8177 532.487 44.5417C532.601 44.2657 532.658 43.9597 532.658 43.6237C532.658 43.2457 532.571 42.9367 532.397 42.6967C532.223 42.4567 531.992 42.2557 531.704 42.0937C531.416 41.9317 531.089 41.7937 530.723 41.6797C530.357 41.5657 529.982 41.4487 529.598 41.3287C529.214 41.2027 528.839 41.0587 528.473 40.8967C528.107 40.7347 527.78 40.5247 527.492 40.2667C527.204 40.0027 526.973 39.6757 526.799 39.2857C526.625 38.8897 526.538 38.4037 526.538 37.8277C526.538 37.3657 526.628 36.9187 526.808 36.4867C526.988 36.0547 527.249 35.6737 527.591 35.3437C527.939 35.0077 528.365 34.7407 528.869 34.5427C529.373 34.3387 529.949 34.2367 530.597 34.2367C531.323 34.2367 531.989 34.3537 532.595 34.5877C533.207 34.8157 533.738 35.1457 534.188 35.5777L533.72 36.4867ZM546.535 45.7477L546.526 47.3047H538.516V34.3807H546.526V35.9377H540.442V40.0327H545.338V41.5357H540.442V45.7477H546.535ZM554.26 40.6087C554.752 40.6087 555.184 40.5487 555.556 40.4287C555.934 40.3087 556.249 40.1407 556.501 39.9247C556.753 39.7027 556.942 39.4417 557.068 39.1417C557.194 38.8357 557.257 38.4997 557.257 38.1337C557.257 37.3897 557.011 36.8287 556.519 36.4507C556.033 36.0727 555.301 35.8837 554.323 35.8837H552.514V40.6087H554.26ZM560.29 47.3047H558.58C558.238 47.3047 557.989 47.1697 557.833 46.8997L554.638 42.4177C554.536 42.2677 554.425 42.1627 554.305 42.1027C554.185 42.0367 554.005 42.0037 553.765 42.0037H552.514V47.3047H550.597V34.3807H554.323C555.157 34.3807 555.874 34.4677 556.474 34.6417C557.08 34.8097 557.578 35.0527 557.968 35.3707C558.364 35.6827 558.655 36.0607 558.841 36.5047C559.033 36.9487 559.129 37.4467 559.129 37.9987C559.129 38.4487 559.06 38.8717 558.922 39.2677C558.784 39.6637 558.58 40.0207 558.31 40.3387C558.046 40.6507 557.722 40.9207 557.338 41.1487C556.954 41.3767 556.519 41.5507 556.033 41.6707C556.273 41.8147 556.48 42.0157 556.654 42.2737L560.29 47.3047Z"
            fill="#777472"
          />
          <path
            d="M979.005 40.6355L991.696 40.6355"
            stroke="#9A9593"
            stroke-width="1.26904"
            stroke-linecap="round"
          />
          <path
            d="M985.35 34.4595L985.35 47.1498"
            stroke="#9A9593"
            stroke-width="1.26904"
            stroke-linecap="round"
          />
          <path
            d="M1012 70.6091V71.4552H1012.85V70.6091H1012ZM12 70.6091H11.154V71.4552H12V70.6091ZM18.7682 11.846H1005.23V10.154H18.7682V11.846ZM1011.15 17.7682V70.6091H1012.85V17.7682H1011.15ZM1012 69.7631H12V71.4552H1012V69.7631ZM12.846 70.6091V17.7682H11.154V70.6091H12.846ZM1005.23 11.846C1008.5 11.846 1011.15 14.4975 1011.15 17.7682H1012.85C1012.85 13.563 1009.44 10.154 1005.23 10.154V11.846ZM18.7682 10.154C14.563 10.154 11.154 13.563 11.154 17.7682H12.846C12.846 14.4975 15.4975 11.846 18.7682 11.846V10.154Z"
            fill="#D3D3D1"
          />
          <mask id="path-12-inside-1_1026_128" fill="white">
            <path d="M12 70.6091H1012V680.592C1012 684.33 1008.97 687.36 1005.23 687.36H18.7682C15.0302 687.36 12 684.33 12 680.592V70.6091Z" />
          </mask>
          <path
            d="M12 70.6091H1012V680.592C1012 684.33 1008.97 687.36 1005.23 687.36H18.7682C15.0302 687.36 12 684.33 12 680.592V70.6091Z"
            fill="#F7F7F7"
          />
          <path
            d="M12 70.6091H1012H12ZM1013 680.592C1013 684.882 1009.52 688.36 1005.23 688.36H18.7682C14.4779 688.36 11 684.882 11 680.592H13C13 683.778 15.5825 686.36 18.7682 686.36H1005.23C1008.42 686.36 1011 683.778 1011 680.592H1013ZM18.7682 688.36C14.4779 688.36 11 684.882 11 680.592V70.6091H13V680.592C13 683.778 15.5825 686.36 18.7682 686.36V688.36ZM1013 70.6091V680.592C1013 684.882 1009.52 688.36 1005.23 688.36V686.36C1008.42 686.36 1011 683.778 1011 680.592V70.6091H1013Z"
            fill="#D3D3D1"
            mask="url(#path-12-inside-1_1026_128)"
          />
          <g filter="url(#filter1_d_1026_128)">
            <rect
              x="45.423"
              y="99.4093"
              width="933.164"
              height="763.959"
              rx="6.34518"
              fill="white"
              stroke="#E6E3E1"
              stroke-width="0.846024"
            />
            <rect
              x="191"
              y="441"
              width="642"
              height="270"
              rx="6.76819"
              fill="#E6E3E1"
            />
            <rect
              opacity="0.9"
              x="190.511"
              y="251.271"
              width="169.205"
              height="169.205"
              rx="6.76819"
              fill="#04A5BB"
            />
            <path
              d="M232.843 343.783C232.843 343.551 232.883 343.335 232.963 343.135C233.051 342.927 233.167 342.747 233.311 342.595C233.463 342.443 233.639 342.323 233.839 342.235C234.047 342.147 234.267 342.103 234.499 342.103C234.731 342.103 234.947 342.147 235.147 342.235C235.355 342.323 235.535 342.443 235.687 342.595C235.839 342.747 235.959 342.927 236.047 343.135C236.135 343.335 236.179 343.551 236.179 343.783C236.179 344.023 236.135 344.243 236.047 344.443C235.959 344.643 235.839 344.819 235.687 344.971C235.535 345.123 235.355 345.239 235.147 345.319C234.947 345.407 234.731 345.451 234.499 345.451C234.267 345.451 234.047 345.407 233.839 345.319C233.639 345.239 233.463 345.123 233.311 344.971C233.167 344.819 233.051 344.643 232.963 344.443C232.883 344.243 232.843 344.023 232.843 343.783ZM242.835 345.463C241.819 345.463 241.035 345.179 240.483 344.611C239.939 344.035 239.667 343.227 239.667 342.187V335.059H238.323C238.179 335.059 238.055 335.015 237.951 334.927C237.847 334.831 237.795 334.691 237.795 334.507V333.463L239.775 333.175L240.339 329.635C240.379 329.499 240.447 329.391 240.543 329.311C240.639 329.223 240.767 329.179 240.927 329.179H242.247V333.199H245.643V335.059H242.247V342.007C242.247 342.447 242.355 342.783 242.571 343.015C242.787 343.247 243.075 343.363 243.435 343.363C243.635 343.363 243.807 343.339 243.951 343.291C244.095 343.235 244.219 343.179 244.323 343.123C244.427 343.059 244.515 343.003 244.587 342.955C244.667 342.899 244.743 342.871 244.815 342.871C244.959 342.871 245.075 342.951 245.163 343.111L245.931 344.371C245.531 344.723 245.059 344.995 244.515 345.187C243.971 345.371 243.411 345.463 242.835 345.463ZM255.611 337.771C255.611 337.339 255.547 336.939 255.419 336.571C255.299 336.195 255.119 335.871 254.879 335.599C254.639 335.319 254.339 335.103 253.979 334.951C253.627 334.791 253.219 334.711 252.755 334.711C251.819 334.711 251.083 334.979 250.547 335.515C250.011 336.051 249.671 336.803 249.527 337.771H255.611ZM249.455 339.355C249.487 340.051 249.595 340.655 249.779 341.167C249.963 341.671 250.207 342.091 250.511 342.427C250.823 342.763 251.191 343.015 251.615 343.183C252.047 343.343 252.527 343.423 253.055 343.423C253.559 343.423 253.995 343.367 254.363 343.255C254.731 343.135 255.051 343.007 255.323 342.871C255.595 342.727 255.827 342.599 256.019 342.487C256.211 342.367 256.387 342.307 256.547 342.307C256.755 342.307 256.915 342.387 257.027 342.547L257.759 343.495C257.455 343.855 257.111 344.159 256.727 344.407C256.343 344.655 255.935 344.859 255.503 345.019C255.071 345.171 254.627 345.279 254.171 345.343C253.715 345.415 253.271 345.451 252.839 345.451C251.991 345.451 251.203 345.311 250.475 345.031C249.755 344.743 249.127 344.323 248.591 343.771C248.063 343.219 247.647 342.535 247.343 341.719C247.047 340.903 246.899 339.963 246.899 338.899C246.899 338.051 247.031 337.259 247.295 336.523C247.567 335.787 247.951 335.147 248.447 334.603C248.951 334.059 249.559 333.631 250.271 333.319C250.991 332.999 251.803 332.839 252.707 332.839C253.459 332.839 254.155 332.963 254.795 333.211C255.435 333.451 255.987 333.807 256.451 334.279C256.915 334.751 257.275 335.331 257.531 336.019C257.795 336.699 257.927 337.475 257.927 338.347C257.927 338.747 257.883 339.015 257.795 339.151C257.707 339.287 257.547 339.355 257.315 339.355H249.455ZM266.873 339.919C265.953 339.951 265.177 340.027 264.545 340.147C263.913 340.259 263.401 340.407 263.009 340.591C262.617 340.767 262.333 340.979 262.157 341.227C261.989 341.475 261.905 341.747 261.905 342.043C261.905 342.331 261.949 342.579 262.037 342.787C262.133 342.987 262.261 343.155 262.421 343.291C262.589 343.419 262.781 343.515 262.997 343.579C263.221 343.635 263.465 343.663 263.729 343.663C264.401 343.663 264.977 343.539 265.457 343.291C265.945 343.035 266.417 342.667 266.873 342.187V339.919ZM260.033 334.735C261.417 333.447 263.065 332.803 264.977 332.803C265.681 332.803 266.305 332.919 266.849 333.151C267.401 333.375 267.861 333.695 268.229 334.111C268.605 334.527 268.889 335.023 269.081 335.599C269.281 336.167 269.381 336.799 269.381 337.495V345.271H268.229C267.981 345.271 267.793 345.235 267.665 345.163C267.537 345.083 267.429 344.927 267.341 344.695L267.089 343.699C266.777 343.979 266.469 344.231 266.165 344.455C265.861 344.671 265.545 344.855 265.217 345.007C264.897 345.159 264.549 345.271 264.173 345.343C263.805 345.423 263.397 345.463 262.949 345.463C262.453 345.463 261.989 345.395 261.557 345.259C261.133 345.123 260.765 344.919 260.453 344.647C260.141 344.367 259.893 344.023 259.709 343.615C259.533 343.207 259.445 342.727 259.445 342.175C259.445 341.703 259.569 341.243 259.817 340.795C260.073 340.347 260.489 339.947 261.065 339.595C261.649 339.235 262.413 338.939 263.357 338.707C264.309 338.475 265.481 338.343 266.873 338.311V337.495C266.873 336.615 266.685 335.959 266.309 335.527C265.933 335.095 265.381 334.879 264.653 334.879C264.157 334.879 263.741 334.943 263.405 335.071C263.069 335.191 262.777 335.323 262.529 335.467C262.281 335.611 262.061 335.747 261.869 335.875C261.677 335.995 261.473 336.055 261.257 336.055C261.081 336.055 260.929 336.011 260.801 335.923C260.681 335.827 260.581 335.711 260.501 335.575L260.033 334.735ZM275.031 327.511V345.271H272.451V327.511H275.031ZM284.796 343.051C285.428 343.051 285.96 342.979 286.392 342.835C286.832 342.683 287.188 342.479 287.46 342.223C287.74 341.967 287.94 341.667 288.06 341.323C288.188 340.971 288.252 340.595 288.252 340.195C288.252 339.379 287.972 338.739 287.412 338.275C286.86 337.803 285.984 337.567 284.784 337.567H281.316V343.051H284.796ZM281.316 330.187V335.587H284.124C285.324 335.587 286.22 335.355 286.812 334.891C287.404 334.427 287.7 333.759 287.7 332.887C287.7 331.935 287.42 331.247 286.86 330.823C286.308 330.399 285.44 330.187 284.256 330.187H281.316ZM284.256 327.991C285.36 327.991 286.304 328.099 287.088 328.315C287.872 328.523 288.516 328.823 289.02 329.215C289.524 329.607 289.892 330.087 290.124 330.655C290.364 331.215 290.484 331.847 290.484 332.551C290.484 332.959 290.42 333.355 290.292 333.739C290.172 334.115 289.98 334.471 289.716 334.807C289.46 335.135 289.136 335.431 288.744 335.695C288.352 335.959 287.888 336.179 287.352 336.355C289.8 336.875 291.024 338.175 291.024 340.255C291.024 340.991 290.884 341.667 290.604 342.283C290.332 342.891 289.932 343.419 289.404 343.867C288.884 344.307 288.24 344.651 287.472 344.899C286.704 345.147 285.828 345.271 284.844 345.271H278.508V327.991H284.256ZM298.813 332.839C299.717 332.839 300.533 332.987 301.261 333.283C301.997 333.579 302.621 333.999 303.133 334.543C303.653 335.087 304.053 335.747 304.333 336.523C304.613 337.299 304.753 338.171 304.753 339.139C304.753 340.107 304.613 340.979 304.333 341.755C304.053 342.531 303.653 343.195 303.133 343.747C302.621 344.291 301.997 344.711 301.261 345.007C300.533 345.303 299.717 345.451 298.813 345.451C297.901 345.451 297.077 345.303 296.341 345.007C295.613 344.711 294.989 344.291 294.469 343.747C293.949 343.195 293.549 342.531 293.269 341.755C292.989 340.979 292.849 340.107 292.849 339.139C292.849 338.171 292.989 337.299 293.269 336.523C293.549 335.747 293.949 335.087 294.469 334.543C294.989 333.999 295.613 333.579 296.341 333.283C297.077 332.987 297.901 332.839 298.813 332.839ZM298.813 343.435C299.917 343.435 300.737 343.067 301.273 342.331C301.817 341.587 302.089 340.527 302.089 339.151C302.089 337.775 301.817 336.715 301.273 335.971C300.737 335.219 299.917 334.843 298.813 334.843C297.693 334.843 296.861 335.219 296.317 335.971C295.773 336.715 295.501 337.775 295.501 339.151C295.501 340.527 295.773 341.587 296.317 342.331C296.861 343.067 297.693 343.435 298.813 343.435ZM317.181 345.271H314.709C314.509 345.271 314.349 345.219 314.229 345.115C314.117 345.011 314.025 344.895 313.953 344.767L311.133 340.243C311.061 340.515 310.965 340.751 310.845 340.951L308.289 344.767C308.201 344.895 308.101 345.011 307.989 345.115C307.885 345.219 307.745 345.271 307.569 345.271H305.265L309.501 338.959L305.433 333.031H307.905C308.105 333.031 308.249 333.063 308.337 333.127C308.433 333.183 308.517 333.271 308.589 333.391L311.361 337.711C311.433 337.447 311.545 337.195 311.697 336.955L314.037 333.439C314.197 333.167 314.401 333.031 314.649 333.031H317.013L312.945 338.851L317.181 345.271Z"
              fill="white"
            />
            <rect
              x="379.531"
              y="251.542"
              width="452.623"
              height="169.205"
              rx="6.76819"
              fill="#E6E3E1"
            />
            <path
              d="M465.933 142.365C465.933 143.331 465.777 144.21 465.465 145.002C465.159 145.794 464.724 146.475 464.16 147.045C463.596 147.609 462.921 148.047 462.135 148.359C461.349 148.671 460.476 148.827 459.516 148.827H454.656V135.903H459.516C460.476 135.903 461.349 136.059 462.135 136.371C462.921 136.683 463.596 137.124 464.16 137.694C464.724 138.258 465.159 138.939 465.465 139.737C465.777 140.529 465.933 141.405 465.933 142.365ZM463.971 142.365C463.971 141.597 463.866 140.91 463.656 140.304C463.446 139.692 463.146 139.176 462.756 138.756C462.372 138.33 461.904 138.006 461.352 137.784C460.806 137.562 460.194 137.451 459.516 137.451H456.582V147.279H459.516C460.194 147.279 460.806 147.168 461.352 146.946C461.904 146.724 462.372 146.403 462.756 145.983C463.146 145.557 463.446 145.041 463.656 144.435C463.866 143.829 463.971 143.139 463.971 142.365ZM482.084 142.365C482.084 143.331 481.928 144.219 481.616 145.029C481.31 145.833 480.875 146.529 480.311 147.117C479.747 147.699 479.072 148.152 478.286 148.476C477.5 148.8 476.627 148.962 475.667 148.962C474.713 148.962 473.84 148.8 473.048 148.476C472.262 148.152 471.587 147.699 471.023 147.117C470.465 146.529 470.03 145.833 469.718 145.029C469.406 144.219 469.25 143.331 469.25 142.365C469.25 141.405 469.406 140.52 469.718 139.71C470.03 138.9 470.465 138.204 471.023 137.622C471.587 137.034 472.262 136.578 473.048 136.254C473.84 135.924 474.713 135.759 475.667 135.759C476.627 135.759 477.5 135.924 478.286 136.254C479.072 136.578 479.747 137.034 480.311 137.622C480.875 138.204 481.31 138.9 481.616 139.71C481.928 140.52 482.084 141.405 482.084 142.365ZM480.122 142.365C480.122 141.597 480.017 140.907 479.807 140.295C479.597 139.683 479.297 139.164 478.907 138.738C478.523 138.312 478.055 137.985 477.503 137.757C476.957 137.529 476.345 137.415 475.667 137.415C474.989 137.415 474.374 137.529 473.822 137.757C473.276 137.985 472.808 138.312 472.418 138.738C472.028 139.164 471.728 139.683 471.518 140.295C471.308 140.907 471.203 141.597 471.203 142.365C471.203 143.139 471.308 143.832 471.518 144.444C471.728 145.05 472.028 145.566 472.418 145.992C472.808 146.418 473.276 146.745 473.822 146.973C474.374 147.195 474.989 147.306 475.667 147.306C476.345 147.306 476.957 147.195 477.503 146.973C478.055 146.745 478.523 146.418 478.907 145.992C479.297 145.566 479.597 145.05 479.807 144.444C480.017 143.832 480.122 143.139 480.122 142.365ZM495.21 146.055C495.318 146.055 495.411 146.097 495.489 146.181L496.245 147.009C495.717 147.633 495.072 148.116 494.31 148.458C493.554 148.8 492.642 148.971 491.574 148.971C490.638 148.971 489.789 148.809 489.027 148.485C488.271 148.161 487.623 147.708 487.083 147.126C486.549 146.544 486.135 145.848 485.841 145.038C485.547 144.228 485.4 143.337 485.4 142.365C485.4 141.393 485.553 140.502 485.859 139.692C486.171 138.882 486.606 138.186 487.164 137.604C487.722 137.022 488.388 136.569 489.162 136.245C489.942 135.921 490.803 135.759 491.745 135.759C492.663 135.759 493.479 135.909 494.193 136.209C494.907 136.509 495.528 136.908 496.056 137.406L495.426 138.297C495.384 138.363 495.33 138.417 495.264 138.459C495.204 138.501 495.123 138.522 495.021 138.522C494.907 138.522 494.772 138.465 494.616 138.351C494.466 138.237 494.265 138.111 494.013 137.973C493.767 137.829 493.461 137.7 493.095 137.586C492.729 137.472 492.273 137.415 491.727 137.415C491.085 137.415 490.497 137.529 489.963 137.757C489.429 137.979 488.967 138.303 488.577 138.729C488.193 139.149 487.893 139.668 487.677 140.286C487.467 140.898 487.362 141.591 487.362 142.365C487.362 143.151 487.473 143.85 487.695 144.462C487.917 145.074 488.223 145.593 488.613 146.019C489.003 146.445 489.462 146.769 489.99 146.991C490.518 147.213 491.088 147.324 491.7 147.324C492.072 147.324 492.405 147.303 492.699 147.261C492.999 147.213 493.272 147.144 493.518 147.054C493.77 146.964 494.007 146.85 494.229 146.712C494.451 146.568 494.67 146.397 494.886 146.199C494.934 146.157 494.985 146.124 495.039 146.1C495.093 146.07 495.15 146.055 495.21 146.055ZM504.903 147.288C505.419 147.288 505.881 147.201 506.289 147.027C506.697 146.853 507.042 146.61 507.324 146.298C507.606 145.98 507.822 145.605 507.972 145.173C508.122 144.735 508.197 144.252 508.197 143.724V135.903H510.105V143.724C510.105 144.48 509.985 145.179 509.745 145.821C509.505 146.463 509.16 147.018 508.71 147.486C508.26 147.954 507.714 148.32 507.072 148.584C506.43 148.848 505.707 148.98 504.903 148.98C504.099 148.98 503.376 148.848 502.734 148.584C502.092 148.32 501.546 147.954 501.096 147.486C500.646 147.018 500.301 146.463 500.061 145.821C499.821 145.179 499.701 144.48 499.701 143.724V135.903H501.618V143.715C501.618 144.243 501.69 144.726 501.834 145.164C501.984 145.602 502.2 145.98 502.482 146.298C502.764 146.61 503.109 146.853 503.517 147.027C503.925 147.201 504.387 147.288 504.903 147.288ZM528.417 135.903V148.827H526.743V139.629C526.743 139.491 526.746 139.344 526.752 139.188C526.764 139.032 526.776 138.873 526.788 138.711L522.486 146.604C522.336 146.898 522.105 147.045 521.793 147.045H521.523C521.211 147.045 520.983 146.898 520.839 146.604L516.456 138.684C516.492 139.02 516.51 139.335 516.51 139.629V148.827H514.827V135.903H516.249C516.417 135.903 516.546 135.921 516.636 135.957C516.732 135.987 516.822 136.077 516.906 136.227L521.226 143.967C521.31 144.123 521.388 144.288 521.46 144.462C521.532 144.636 521.601 144.81 521.667 144.984C521.793 144.63 521.94 144.288 522.108 143.958L526.347 136.227C526.425 136.077 526.509 135.987 526.599 135.957C526.695 135.921 526.827 135.903 526.995 135.903H528.417ZM541.325 147.27L541.316 148.827H533.306V135.903H541.316V137.46H535.232V141.555H540.128V143.058H535.232V147.27H541.325ZM555.971 135.903V148.827H554.999C554.849 148.827 554.723 148.8 554.621 148.746C554.525 148.692 554.426 148.605 554.324 148.485L547.025 139.044C547.037 139.206 547.046 139.365 547.052 139.521C547.064 139.677 547.07 139.824 547.07 139.962V148.827H545.387V135.903H546.377C546.545 135.903 546.671 135.924 546.755 135.966C546.839 136.002 546.932 136.089 547.034 136.227L554.351 145.677C554.333 145.503 554.318 145.335 554.306 145.173C554.3 145.005 554.297 144.849 554.297 144.705V135.903H555.971ZM569.671 137.505H565.567V148.827H563.659V137.505H559.537V135.903H569.671V137.505Z"
              fill="#777472"
            />
          </g>
        </g>
        <defs>
          <filter
            id="filter0_d_1026_128"
            x="-3.38409"
            y="-1.69205"
            width="1030.77"
            height="906.768"
            filterUnits="userSpaceOnUse"
            color-interpolation-filters="sRGB"
          >
            <feFlood flood-opacity="0" result="BackgroundImageFix" />
            <feColorMatrix
              in="SourceAlpha"
              type="matrix"
              values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
              result="hardAlpha"
            />
            <feOffset dy="1.69205" />
            <feGaussianBlur stdDeviation="1.5" />
            <feColorMatrix
              type="matrix"
              values="0 0 0 0 0.361215 0 0 0 0 0.384319 0 0 0 0 0.429167 0 0 0 0.1 0"
            />
            <feBlend
              mode="multiply"
              in2="BackgroundImageFix"
              result="effect1_dropShadow_1026_128"
            />
            <feBlend
              mode="normal"
              in="SourceGraphic"
              in2="effect1_dropShadow_1026_128"
              result="shape"
            />
          </filter>
          <filter
            id="filter1_d_1026_128"
            x="28.23"
            y="70"
            width="967.55"
            height="798.345"
            filterUnits="userSpaceOnUse"
            color-interpolation-filters="sRGB"
          >
            <feFlood flood-opacity="0" result="BackgroundImageFix" />
            <feColorMatrix
              in="SourceAlpha"
              type="matrix"
              values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
              result="hardAlpha"
            />
            <feOffset dy="2.53807" />
            <feGaussianBlur stdDeviation="0.4" />
            <feColorMatrix
              type="matrix"
              values="0 0 0 0 0.361215 0 0 0 0 0.384319 0 0 0 0 0.429167 0 0 0 0.07 0"
            />
            <feBlend
              mode="multiply"
              in2="BackgroundImageFix"
              result="effect1_dropShadow_1026_128"
            />
            <feBlend
              mode="normal"
              in="SourceGraphic"
              in2="effect1_dropShadow_1026_128"
              result="shape"
            />
          </filter>
        </defs>
      </svg>
    );
  }