// import React from "react";
import FullWidthBackground from "../mdx/FullWidthBackground";
import styled from "styled-components";

function DarkVoid(props) {
  return (
    <svg
      style={{ maxWidth: "100%", marginLeft: "-1rem", zIndex: "-10" }}
      width="1000px"
      height="auto"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
      preserveAspectRatio="xMinYMin meet"
      preserveAspectRatio="xMidYMid"
      viewBox="0 0 1187.63 1564.17"
      alt="a dark, mysterious void where your code executes"
      {...props}
    >
      <defs>
        <style>
          {
            ".mvoid__cls-1{fill:#615bb3}.mvoid__cls-2{fill:#c9c8de}.mvoid__cls-3{fill:#fff}.mvoid__cls-4{fill:none;stroke:#615bb3;stroke-miterlimit:10;stroke-width:2.26px}.mvoid__cls-5{fill:#1a1d2f;filter:blur(2rem);}"
          }
        </style>
      </defs>
      <g id="mvoid__Layer_2" data-name="Layer 2">
        <g id="mvoid__Layer_1-2" data-name="Layer 1">
          <path
            className="mvoid__cls-1"
            d="M181.08 438.76c6.2-2.31 9.36-4.88 11.56-10.77a.78.78 0 01.3-.37.75.75 0 01.46-.15.79.79 0 01.46.15.82.82 0 01.29.37c2.19 5.89 5.36 8.46 11.56 10.77a.7.7 0 01.37.29.71.71 0 01.14.43.76.76 0 01-.14.43.87.87 0 01-.37.28c-6.2 2.31-9.36 4.89-11.56 10.76a.82.82 0 01-.29.37.86.86 0 01-.46.14.81.81 0 01-.46-.14.78.78 0 01-.3-.37c-2.18-5.89-5.36-8.46-11.56-10.76a.87.87 0 01-.37-.28.76.76 0 01-.14-.43.71.71 0 01.14-.43.7.7 0 01.37-.29z"
          />
          <path
            className="mvoid__cls-2"
            d="M1162.49 515.24c6.2-2.3 9.37-4.88 11.57-10.76a.73.73 0 01.29-.38.81.81 0 01.46-.14.86.86 0 01.46.14.84.84 0 01.29.38c2.19 5.88 5.36 8.46 11.56 10.76a.82.82 0 01.37.29.76.76 0 01.14.43.74.74 0 01-.14.43.82.82 0 01-.37.29c-6.2 2.3-9.36 4.88-11.56 10.76a.82.82 0 01-.29.37.86.86 0 01-.46.14.81.81 0 01-.46-.14.7.7 0 01-.29-.37c-2.19-5.89-5.37-8.46-11.57-10.76a.87.87 0 01-.37-.29.73.73 0 01-.13-.43.75.75 0 01.13-.43.87.87 0 01.37-.29z"
          />
          <path
            className="mvoid__cls-1"
            d="M1112.43 925.49c2.42-1 3.65-2 4.51-4.5a.33.33 0 01.11-.15.3.3 0 01.36 0 .33.33 0 01.11.15c.86 2.46 2.09 3.53 4.51 4.5a.33.33 0 01.15.11.41.41 0 010 .18.35.35 0 010 .18.29.29 0 01-.15.12 6.66 6.66 0 00-4.51 4.49.33.33 0 01-.11.15.3.3 0 01-.36 0 .33.33 0 01-.11-.15 6.65 6.65 0 00-4.51-4.49.29.29 0 01-.15-.12.35.35 0 010-.18.41.41 0 010-.18.33.33 0 01.15-.11z"
          />
          <path
            className="mvoid__cls-3"
            d="M921.52 486c2.42-1 3.65-2 4.51-4.5a.33.33 0 01.11-.15.3.3 0 01.36 0 .33.33 0 01.11.15c.86 2.46 2.09 3.53 4.51 4.5a.33.33 0 01.15.11.41.41 0 01.05.18.35.35 0 01-.05.18.29.29 0 01-.15.12 6.66 6.66 0 00-4.51 4.49.33.33 0 01-.11.15.3.3 0 01-.36 0 .33.33 0 01-.11-.15 6.65 6.65 0 00-4.51-4.49.29.29 0 01-.15-.12.35.35 0 010-.18.41.41 0 010-.18.33.33 0 01.15-.11zM996.83 1066.73c2.42-1 3.65-2 4.51-4.5a.33.33 0 01.11-.15.3.3 0 01.36 0 .33.33 0 01.11.15c.86 2.46 2.09 3.53 4.51 4.5a.33.33 0 01.15.11.41.41 0 010 .18.35.35 0 010 .18.29.29 0 01-.15.12 6.66 6.66 0 00-4.51 4.49.33.33 0 01-.11.15.3.3 0 01-.36 0 .33.33 0 01-.11-.15 6.65 6.65 0 00-4.51-4.49.29.29 0 01-.15-.12.35.35 0 010-.18.41.41 0 010-.18.33.33 0 01.15-.11z"
          />
          <path
            className="mvoid__cls-1"
            d="M62.06 927.54c2.42-1 3.65-2 4.51-4.5a.33.33 0 01.11-.15.3.3 0 01.36 0 .33.33 0 01.11.15c.86 2.46 2.09 3.53 4.51 4.5a.33.33 0 01.15.11.41.41 0 010 .18.35.35 0 010 .18.29.29 0 01-.15.12 6.66 6.66 0 00-4.51 4.49.33.33 0 01-.11.15.3.3 0 01-.36 0 .33.33 0 01-.11-.15 6.65 6.65 0 00-4.51-4.49.29.29 0 01-.15-.12.35.35 0 010-.18.41.41 0 010-.18.33.33 0 01.15-.11z"
          />
          <path
            className="mvoid__cls-3"
            d="M298.81 542.76c2.42-1 3.65-2 4.51-4.5a.33.33 0 01.11-.15.3.3 0 01.36 0 .33.33 0 01.11.15c.86 2.46 2.1 3.53 4.51 4.5a.33.33 0 01.15.11.41.41 0 01.05.18.35.35 0 01-.05.18.29.29 0 01-.15.12 6.68 6.68 0 00-4.51 4.49.33.33 0 01-.11.15.3.3 0 01-.36 0 .33.33 0 01-.11-.15 6.65 6.65 0 00-4.51-4.49.29.29 0 01-.15-.12.35.35 0 01-.05-.18.41.41 0 01.05-.18.33.33 0 01.15-.11z"
          />
          <path
            className="mvoid__cls-2"
            d="M.26 981.49c3.13-1.25 4.73-2.64 5.84-5.83a.43.43 0 01.14-.19.41.41 0 01.24-.08.4.4 0 01.23.08.45.45 0 01.15.19c1.1 3.19 2.71 4.58 5.84 5.83a.42.42 0 01.18.14.44.44 0 01.07.24.44.44 0 01-.25.39c-3.13 1.24-4.7 2.64-5.84 5.81a.48.48 0 01-.15.2.39.39 0 01-.23.07.4.4 0 01-.24-.07.46.46 0 01-.14-.2c-1.1-3.18-2.71-4.57-5.84-5.81a.37.37 0 01-.19-.16.35.35 0 01-.07-.23.44.44 0 01.07-.24.45.45 0 01.19-.14z"
          />
          <path
            className="mvoid__cls-1"
            d="M224.73 1140.45c5.69-2.26 8.59-4.8 10.61-10.57a.78.78 0 01.27-.37.71.71 0 01.42-.14.74.74 0 01.43.14.76.76 0 01.26.37c2 5.77 4.93 8.31 10.62 10.57a.72.72 0 01.34.28.77.77 0 01.13.42.75.75 0 01-.13.42.67.67 0 01-.34.28c-5.69 2.27-8.6 4.8-10.62 10.56a.72.72 0 01-.26.37.74.74 0 01-.43.14.71.71 0 01-.42-.14.73.73 0 01-.27-.37c-2-5.77-4.92-8.3-10.61-10.56a.67.67 0 01-.34-.28.75.75 0 01-.13-.42.77.77 0 01.13-.42.72.72 0 01.34-.28z"
          />
          <path
            className="mvoid__cls-4"
            d="M638 310.49c-55.5-103.12 55.5-206.24 0-309.36H499.28c55.5 103.12-55.49 206.24 0 309.36s-55.49 206.25 0 309.37H638c-55.47-103.12 55.53-206.24 0-309.37z"
          />
          <path
            className="mvoid__cls-4"
            d="M653.44 310.49c-55.5-103.12 55.5-206.24 0-309.36H514.69c55.5 103.12-55.5 206.24 0 309.36s-55.5 206.25 0 309.37h138.75c-55.5-103.12 55.5-206.24 0-309.37z"
          />
          <path
            className="mvoid__cls-4"
            d="M666.85 310.49c-55.5-103.12 55.49-206.24 0-309.36H528.1c55.5 103.12-55.5 206.24 0 309.36s-55.5 206.25 0 309.37h138.75c-55.5-103.12 55.49-206.24 0-309.37z"
          />
          <path
            className="mvoid__cls-4"
            d="M680.25 310.49c-55.49-103.12 55.5-206.24 0-309.36H541.51c55.5 103.12-55.5 206.24 0 309.36s-55.5 206.25 0 309.37h138.74c-55.49-103.12 55.5-206.24 0-309.37z"
          />
          <path
            className="mvoid__cls-4"
            d="M693.66 310.49c-55.5-103.12 55.5-206.24 0-309.36H554.92c55.49 103.12-55.5 206.24 0 309.36s-55.5 206.25 0 309.37h138.74c-55.5-103.12 55.5-206.24 0-309.37z"
          />
          <path
            className="mvoid__cls-4"
            d="M707.07 310.49c-55.5-103.12 55.5-206.24 0-309.36H568.32c55.5 103.12-55.49 206.24 0 309.36s-55.49 206.25 0 309.37h138.75c-55.5-103.12 55.5-206.24 0-309.37z"
          />
          <path
            className="mvoid__cls-4"
            d="M720.48 310.49C665 207.37 776 104.25 720.48 1.13H581.73c55.5 103.12-55.5 206.24 0 309.36s-55.5 206.25 0 309.37h138.75c-55.48-103.12 55.52-206.24 0-309.37z"
          />
          <path
            className="mvoid__cls-4"
            d="M733.89 310.49c-55.5-103.12 55.49-206.24 0-309.36H595.14c55.5 103.12-55.5 206.24 0 309.36s-55.5 206.25 0 309.37h138.75c-55.5-103.12 55.49-206.24 0-309.37z"
          />
          <path
            className="mvoid__cls-4"
            d="M747.29 310.49c-55.49-103.12 55.5-206.24 0-309.36H608.55c55.5 103.12-55.5 206.24 0 309.36s-55.5 206.25 0 309.37h138.74c-55.49-103.12 55.5-206.24 0-309.37z"
          />
          <path
            className="mvoid__cls-4"
            d="M762.7 310.49c-55.5-103.12 55.5-206.24 0-309.36H624c55.5 103.12-55.5 206.24 0 309.36s-55.5 206.25 0 309.37h138.7c-55.5-103.12 55.5-206.24 0-309.37zM626.15 1253.68c-55.5-103.13 55.5-206.25 0-309.37H487.4c55.5 103.12-55.5 206.24 0 309.37s-55.5 206.24 0 309.36h138.75c-55.5-103.12 55.5-206.24 0-309.36z"
          />
          <path
            className="mvoid__cls-4"
            d="M641.56 1253.68c-55.5-103.13 55.49-206.25 0-309.37H502.81c55.5 103.12-55.5 206.24 0 309.37s-55.5 206.24 0 309.36h138.75c-55.5-103.12 55.49-206.24 0-309.36z"
          />
          <path
            className="mvoid__cls-4"
            d="M655 1253.68c-55.49-103.13 55.5-206.25 0-309.37H516.22c55.5 103.12-55.5 206.24 0 309.37s-55.5 206.24 0 309.36H655c-55.53-103.12 55.46-206.24 0-309.36z"
          />
          <path
            className="mvoid__cls-4"
            d="M668.37 1253.68c-55.5-103.13 55.5-206.25 0-309.37H529.63c55.49 103.12-55.5 206.24 0 309.37s-55.5 206.24 0 309.36h138.74c-55.5-103.12 55.5-206.24 0-309.36z"
          />
          <path
            className="mvoid__cls-4"
            d="M681.78 1253.68c-55.5-103.13 55.5-206.25 0-309.37H543c55.5 103.12-55.49 206.24 0 309.37s-55.49 206.24 0 309.36h138.78c-55.5-103.12 55.5-206.24 0-309.36z"
          />
          <path
            className="mvoid__cls-4"
            d="M695.19 1253.68c-55.5-103.13 55.5-206.25 0-309.37H556.44c55.5 103.12-55.5 206.24 0 309.37s-55.5 206.24 0 309.36h138.75c-55.5-103.12 55.5-206.24 0-309.36z"
          />
          <path
            className="mvoid__cls-4"
            d="M708.6 1253.68c-55.5-103.13 55.49-206.25 0-309.37H569.85c55.5 103.12-55.5 206.24 0 309.37s-55.5 206.24 0 309.36H708.6c-55.5-103.12 55.49-206.24 0-309.36z"
          />
          <path
            className="mvoid__cls-4"
            d="M722 1253.68c-55.49-103.13 55.5-206.25 0-309.37H583.26c55.5 103.12-55.5 206.24 0 309.37s-55.5 206.24 0 309.36H722c-55.49-103.12 55.5-206.24 0-309.36z"
          />
          <path
            className="mvoid__cls-4"
            d="M735.41 1253.68c-55.5-103.13 55.5-206.25 0-309.37H596.67c55.49 103.12-55.5 206.24 0 309.37s-55.5 206.24 0 309.36h138.74c-55.5-103.12 55.5-206.24 0-309.36z"
          />
          <path
            className="mvoid__cls-4"
            d="M750.82 1253.68c-55.5-103.13 55.5-206.25 0-309.37H612.07c55.5 103.12-55.49 206.24 0 309.37s-55.49 206.24 0 309.36h138.75c-55.5-103.12 55.5-206.24 0-309.36z"
          />
          <path
            className="mvoid__cls-5"
            d="M180.57 502.67h887.26v513.88H180.57zM406.8 2.02h461.8v55.04H406.8zM406.8 1507.11h461.8v55.93H406.8z"
          />
          <path
            className="mvoid__cls-1"
            d="M271 677.74q.19-3.62.2-9.59v-27.84c0-4-.07-7.18-.2-9.6s-.38-5.06-.74-7.94h23.83q16.74 0 26.15 7.86t9.39 23.6q0 15.25-9.39 23.36t-26.15 8.1h-23.86c.36-2.89.61-5.53.77-7.95zm36.18-1.53q5-7.59 5-22 0-14.87-4.95-22.22a15.62 15.62 0 00-13.68-7.35h-6.06v59.16h6.06q8.6 0 13.6-7.59zM365.23 685.69a42.08 42.08 0 01-.86-7.48 13.67 13.67 0 01-5.63 6.65 19 19 0 01-10.1 2.4 18.72 18.72 0 01-9.95-2.56q-4.21-2.55-4.21-8.14a9.75 9.75 0 013.18-7.59 19.18 19.18 0 017.24-4.12 87.31 87.31 0 019.48-2.29q5.42-.94 7.67-2.71a6.54 6.54 0 002.24-5.46q0-6.76-5.9-6.77a8.38 8.38 0 00-5.43 1.54 18.32 18.32 0 00-3.77 4.52l-1.19 1.81a7.5 7.5 0 01-2.56 2.24 6.53 6.53 0 01-3 .75 6.08 6.08 0 01-4-1.54 6.93 6.93 0 01-2.28-4.28 45.67 45.67 0 0124.22-7q8.41 0 13.14 2.94t4.8 9.88v10.22q0 5.5.19 8.77t1 8.22zm-3.3-6.49a14.2 14.2 0 002.36-8.38v-10.46a5.77 5.77 0 01-2.09 1.64 27.86 27.86 0 01-2.79 1.18c-1 .37-1.68.61-2 .71a12.31 12.31 0 00-5.75 3.93 10.4 10.4 0 00-1.88 6.37c0 2.84.52 4.93 1.57 6.3a5.17 5.17 0 004.33 2 7.34 7.34 0 006.25-3.29zM425.39 649.27a6.72 6.72 0 01-1.49 4.6 5.17 5.17 0 01-4.09 1.69 10.78 10.78 0 01-3-.47 12.47 12.47 0 00-3.62-.63 9.05 9.05 0 00-5 1.77 37.5 37.5 0 00-6.57 6.26v6.44q0 5.36.16 8.58c.1 2.15.37 4.87.79 8.18H386.7c.42-3.31.68-6 .79-8.18s.15-5 .15-8.58V664c0-3.51-.05-6.36-.15-8.53s-.37-4.92-.79-8.22h15.89a119.23 119.23 0 00-.95 12.42q3.47-4.39 5.86-7a21 21 0 015.66-4.24 15.93 15.93 0 017.44-1.69 24.1 24.1 0 014.64.47 10.47 10.47 0 01.15 2.06zM480.05 682c1.1 1.39 2.18 2.63 3.23 3.74h-17.07a30.73 30.73 0 00-1.81-4c-.63-1.12-1.62-2.66-3-4.6a24.48 24.48 0 00-6.84-7.11 20.23 20.23 0 00-9-2.87c-.06.57-.08 1.44-.08 2.59q0 4.49.16 7.94t.78 8h-15.91c.41-3.36.68-6.2.78-8.54s.16-5.33.16-9v-27.84q0-5.5-.16-9c-.1-2.33-.37-5.17-.78-8.53h15.88q-.63 5-.78 8.53t-.16 9v19a18.51 18.51 0 016.55-10.15q4.68-3.51 11.92-3.5a14.36 14.36 0 018.58 2.34 8.13 8.13 0 013.31 7.07q0 10.54-21.63 11.72a55.83 55.83 0 0110.58 1.89 22.52 22.52 0 016.8 3.22 21 21 0 014.87 5.19q1.97 2.78 3.62 4.91zm-30.51-28.51q-3.23 4.17-3.93 12.35 8 0 12.58-2.71a8.74 8.74 0 004.56-8 6 6 0 00-1.42-4.28 5 5 0 00-3.93-1.54 9.64 9.64 0 00-7.86 4.13zM490.83 680.73l6.52-6.53 6.53 6.53-12.35 20.21-.7-.63 6.52-13zM589.84 677.11c.1-2.15.16-5 .16-8.41v-12.58a13.39 13.39 0 00-.63-4.72 2.4 2.4 0 00-2.44-1.58 6.44 6.44 0 00-4.33 2.09 29.7 29.7 0 00-4.72 6.33c.06.58.08 1.49.08 2.75v7.71c0 3.46.06 6.26.16 8.41s.37 5 .79 8.58H563q.63-5.36.79-8.58t.15-8.41v-12.58a12.83 12.83 0 00-.66-4.72 2.48 2.48 0 00-2.48-1.58q-4.41 0-9 9v10.06c0 3.57.06 6.43.16 8.58s.37 4.87.79 8.18h-15.84c.42-3.31.68-6 .79-8.18s.15-5 .15-8.58V664c0-3.51-.05-6.36-.15-8.53s-.37-4.92-.79-8.22h15.89a68.78 68.78 0 00-.79 8.41 23.22 23.22 0 015.9-7.15 12.81 12.81 0 018.26-2.83q9.58 0 11.32 10.06a29.73 29.73 0 016.53-7.31 13 13 0 018.26-2.75q11.79 0 11.79 15.33v7.71q0 5.19.16 8.41t.79 8.58h-16q.66-5.37.82-8.6zM653.31 647.23a51.9 51.9 0 00-3.15 7.39l-10.62 31.07a37.35 37.35 0 01-4.2 8.88 13.27 13.27 0 01-5.16 4.6 16.2 16.2 0 01-7 1.38 24.33 24.33 0 01-7.87-1.34 16 16 0 01-6.45-3.93 5.53 5.53 0 01-.08-1 4.91 4.91 0 011.54-3.74 5 5 0 013.58-1.45 5.19 5.19 0 012.87.9 5.55 5.55 0 012.08 2.72 14.49 14.49 0 002.83 4.56 5.5 5.5 0 003.93 1.33c2 0 4.13-1 6.26-2.87s3.94-5.1 5.46-9.55l.16-.47h-14l-12-31.07c-.53-1.36-1.05-2.57-1.58-3.62s-1.23-2.3-2.12-3.77h17.07a22.11 22.11 0 00.74 3.46c.29.89.75 2.15 1.38 3.77l11.25 29.18 10.06-29.18a46.7 46.7 0 001.73-7.23zM655.9 672.79a6.6 6.6 0 013.46-.95 6.83 6.83 0 014.17 1.42 6.41 6.41 0 012.44 3.85 12.9 12.9 0 002.51 6q1.82 2.16 6 2.16a6.59 6.59 0 005.07-1.81 6.39 6.39 0 001.7-4.56 5.42 5.42 0 00-1-3.22 11.16 11.16 0 00-3.34-2.79c-1.6-1-4.05-2.25-7.35-3.82q-5.43-2.6-7.91-4a16 16 0 01-4.4-3.73 8.28 8.28 0 01-1.93-5.47 7.53 7.53 0 012.56-5.9 15.28 15.28 0 016.37-3.3 29.8 29.8 0 017.74-1 24.44 24.44 0 0111.6 2.63 16.3 16.3 0 017.28 7.27 6.62 6.62 0 01-5 2.6 5.49 5.49 0 01-3.43-1.18 6.74 6.74 0 01-2.24-3.3 9.92 9.92 0 00-2.67-4.64q-1.65-1.42-5.19-1.42a8 8 0 00-4.56 1.18 3.69 3.69 0 00-1.73 3.23 4.3 4.3 0 00.9 2.67 10 10 0 003.07 2.4q2.16 1.21 6.25 3l1.89.86q5 2.21 7.71 3.78a15.2 15.2 0 014.6 4 9.72 9.72 0 011.84 6.05 10.41 10.41 0 01-5 9.09q-5 3.33-13.41 3.34a27.72 27.72 0 01-13.37-3 13.79 13.79 0 01-7.08-8.65 6.2 6.2 0 012.45-2.79zM728.41 669.64a38.59 38.59 0 01-2.79 10.86A12 12 0 01721 686a13.6 13.6 0 01-6.88 1.61q-6.84 0-9.71-3.54t-2.87-10.69v-24.19H693v-2h1.34q5.26 0 7.63-2.16a8.91 8.91 0 002.83-5.43 71.33 71.33 0 00.47-9.4h11.8q0 12.9-10.38 17H727v2h-11.49v26.43q0 4.64.87 6.53a3.09 3.09 0 003.07 1.88q5.19 0 7.31-14.39zM780.79 670.66q-5.19 16.61-22.57 16.6a32.35 32.35 0 01-12.59-2.4 21.23 21.23 0 01-9.16-7.08 20.16 20.16 0 010-22.53 21.8 21.8 0 019-7.16 29.59 29.59 0 0112-2.43 26.66 26.66 0 0111.4 2.28 17.57 17.57 0 017.47 6.21 15.77 15.77 0 012.68 8.65h-30.63c-.06.53-.08 1.36-.08 2.52 0 5.34 1.27 9.74 3.81 13.17s6.15 5.15 10.82 5.15a16 16 0 009.59-3.14q4.32-3.15 6.69-9.84zm-29.49-19.77q-2.28 3.25-2.83 9.94h15.88q0-6.44-1.69-9.83a5.64 5.64 0 00-5.39-3.38 7 7 0 00-5.97 3.27zM824.6 649.27a6.67 6.67 0 01-1.5 4.6 5.17 5.17 0 01-4.09 1.69 10.78 10.78 0 01-3-.47 12.47 12.47 0 00-3.61-.63 9.05 9.05 0 00-5 1.77 37.86 37.86 0 00-6.57 6.26v6.44c0 3.57.06 6.43.16 8.58s.37 4.87.79 8.18H785.9c.42-3.31.68-6 .79-8.18s.16-5 .16-8.58V664c0-3.51-.06-6.36-.16-8.53s-.37-4.92-.79-8.22h15.89a119.23 119.23 0 00-.95 12.42q3.46-4.39 5.86-7a20.93 20.93 0 015.67-4.24 15.86 15.86 0 017.43-1.69 24 24 0 014.64.47 10.32 10.32 0 01.16 2.06zM829.47 632l8.73-7.63 8.73 7.63-8.73 7.63zm15.89 23.48c-.11 2.17-.16 5-.16 8.53v4.95q0 5.36.16 8.58c.1 2.15.36 4.87.78 8.18h-15.88c.42-3.31.68-6 .78-8.18s.16-5 .16-8.58V664c0-3.51-.05-6.36-.16-8.53s-.36-4.92-.78-8.22h15.88q-.63 4.93-.78 8.2zM866.28 684.9a20.84 20.84 0 01-9.44-7.08 20.33 20.33 0 010-22.69 21.27 21.27 0 019.44-7.08 39.46 39.46 0 0127.05 0 21.27 21.27 0 019.44 7.08 20.33 20.33 0 010 22.69 20.84 20.84 0 01-9.44 7.08 39.94 39.94 0 01-27.05 0zm21.9-4.17Q891 676.1 891 666.5t-2.79-14.24a9.88 9.88 0 00-16.75 0q-2.79 4.65-2.79 14.24t2.79 14.23a9.88 9.88 0 0016.75 0zM957.11 647.23v38.46h-15q.55-4.34.87-8.34a22.22 22.22 0 01-6.69 7.27 17.1 17.1 0 01-9.75 2.64q-6.45 0-9.91-3.74t-3.46-12.23v-7.07c0-3.46 0-6.26-.16-8.38s-.39-5-.86-8.61h15.1v29.18q0 7.23 4.87 7.23 6.23 0 10.94-9.36c.05-1.1.08-2.88.08-5.35v-4.71c0-3.46-.06-6.26-.16-8.38s-.42-5-1-8.61zM965.21 672.79a6.6 6.6 0 013.46-.95 6.83 6.83 0 014.17 1.42 6.41 6.41 0 012.44 3.85 12.8 12.8 0 002.52 6q1.8 2.16 6 2.16a6.62 6.62 0 005.08-1.81 6.43 6.43 0 001.69-4.56 5.42 5.42 0 00-.95-3.22 11.16 11.16 0 00-3.34-2.79c-1.6-1-4-2.25-7.35-3.82q-5.43-2.6-7.91-4a16 16 0 01-4.4-3.73 8.28 8.28 0 01-1.93-5.47 7.53 7.53 0 012.56-5.9 15.28 15.28 0 016.37-3.3 29.8 29.8 0 017.74-1 24.49 24.49 0 0111.61 2.63 16.33 16.33 0 017.27 7.27 6.62 6.62 0 01-5 2.6 5.44 5.44 0 01-3.42-1.18 6.76 6.76 0 01-2.25-3.3 9.92 9.92 0 00-2.67-4.64q-1.65-1.42-5.19-1.42a8 8 0 00-4.56 1.18 3.69 3.69 0 00-1.73 3.23 4.3 4.3 0 00.9 2.67 10 10 0 003.07 2.4c1.44.81 3.53 1.82 6.25 3l1.89.86q4.95 2.21 7.71 3.78a15.2 15.2 0 014.6 4 9.72 9.72 0 011.85 6.05 10.42 10.42 0 01-5 9.09q-5 3.33-13.41 3.34a27.72 27.72 0 01-13.37-3 13.74 13.74 0 01-7.07-8.65 6.13 6.13 0 012.37-2.79zM318.28 742.23a12.55 12.55 0 015.78-.63 16.86 16.86 0 011 5.59 16.09 16.09 0 01-1.57 6.84l-8.73 19.74a32 32 0 00-1.46 3.62 6.78 6.78 0 00-.19 2.67h-16.89l-13.37-30.75a36.69 36.69 0 00-2-4c-.63-1.08-1.44-2.32-2.43-3.74h17.46a31.36 31.36 0 00.9 3.54q.51 1.58 1.53 3.93l12.59 28.63 9-20.53a6.7 6.7 0 00.63-2.51 4.5 4.5 0 00-.59-2.28 17.52 17.52 0 00-1.77-2.44 19.22 19.22 0 01-1.81-2.44 4.11 4.11 0 01-.55-2.12 3.26 3.26 0 012.47-3.12zM341.83 779.27a20.86 20.86 0 01-9.43-7.07 20.33 20.33 0 010-22.69 21.24 21.24 0 019.43-7.08 39.34 39.34 0 0127.06 0 21.24 21.24 0 019.43 7.08 20.28 20.28 0 010 22.69 20.86 20.86 0 01-9.43 7.07 40 40 0 01-27.06 0zm21.91-4.16q2.79-4.65 2.79-14.24t-2.79-14.23a9.88 9.88 0 00-16.75 0q-2.81 4.64-2.8 14.23t2.8 14.24a9.88 9.88 0 0016.75 0zM388.23 726.35l8.73-7.63 8.73 7.63L397 734zm15.89 23.47c-.1 2.18-.16 5-.16 8.53v5c0 3.56.06 6.42.16 8.57s.37 4.88.79 8.18H389q.63-4.95.79-8.18c.1-2.15.16-5 .16-8.57v-5c0-3.51-.06-6.35-.16-8.53s-.37-4.91-.79-8.22h15.89q-.61 4.97-.77 8.22zM450 780.06a51.54 51.54 0 01-.94-9 15.18 15.18 0 01-5.59 7.71q-3.93 2.84-10.53 2.83a24.87 24.87 0 01-10-2 17.38 17.38 0 01-7.75-6.69q-3-4.64-3-12t3-12.07a17.7 17.7 0 017.55-6.73 22.45 22.45 0 019.32-2 21.14 21.14 0 019.44 2A24.44 24.44 0 01449 748v-13.87q0-5.26-.16-8.45c-.11-2.13-.42-5-.94-8.54H463v46.17q0 5.19.19 8.37t1 8.38zm-4.05-6q3.1-4 3.11-11.6V750.8a24 24 0 00-5.78-5.58 11.57 11.57 0 00-6.49-2.12q-4.33 0-6.84 4.36t-2.52 13.41q0 7.64 2.6 12.39a8.55 8.55 0 008 4.76 9.62 9.62 0 007.89-4.02zM569.19 747.19a17.11 17.11 0 01-1.49 6.81l-8.7 19.77a31.52 31.52 0 00-1.45 3.62 6.59 6.59 0 00-.2 2.67h-16.94l-6.21-14.23-3.54 7.94a32 32 0 00-1.46 3.62 6.78 6.78 0 00-.19 2.67H512.1l-13.37-30.75a36.69 36.69 0 00-2-4c-.63-1.08-1.44-2.32-2.43-3.74h17.45a33.55 33.55 0 00.91 3.54q.51 1.58 1.53 3.93l12.61 28.66 6.3-14.31-6.1-14.08a36.61 36.61 0 00-1.88-3.93c-.63-1.1-1.45-2.36-2.44-3.78h17.42a22.55 22.55 0 00.82 3.54q.51 1.58 1.53 3.93l12.67 28.63 9-20.53a6.38 6.38 0 00.55-2.43 4.8 4.8 0 00-.59-2.4 16 16 0 00-1.77-2.48 15 15 0 01-1.69-2.28 4.37 4.37 0 01-.59-2.2 3.26 3.26 0 012.4-3.15 12.55 12.55 0 015.78-.63 16.7 16.7 0 01.98 5.59zM604.66 771.49q.17-3.22.16-8.42V751q0-7.31-4.87-7.31-6.13 0-11 9.67v9.2c0 3.67.06 6.67.16 9s.37 5.18.79 8.53H574c.42-3.35.68-6.2.79-8.53s.16-5.34.16-9v-27.88c0-3.67-.06-6.67-.16-9s-.37-5.18-.79-8.54h15.89c-.42 3.36-.68 6.2-.79 8.54s-.16 5.33-.16 9v15.57a22.5 22.5 0 016.73-7.51 17.1 17.1 0 019.87-2.71q6.45 0 9.91 3.77t3.46 12.27v7q0 5.19.16 8.42t.78 8.57h-16q.66-5.34.81-8.57zM673.48 765q-5.19 16.59-22.57 16.59a32.32 32.32 0 01-12.59-2.4 21.13 21.13 0 01-9.16-7.07 20.18 20.18 0 010-22.54 21.78 21.78 0 019-7.15 29.43 29.43 0 0112-2.44 26.66 26.66 0 0111.4 2.28 17.63 17.63 0 017.47 6.21 16 16 0 012.68 8.65h-30.63c-.06.53-.08 1.37-.08 2.52q0 8 3.81 13.17t10.81 5.18a15.91 15.91 0 009.6-3.15q4.32-3.15 6.68-9.83zM644 745.26q-2.29 3.27-2.84 10H657q0-6.45-1.69-9.83A5.63 5.63 0 00650 742a7 7 0 00-6 3.26zM717.28 743.65a6.68 6.68 0 01-1.49 4.6 5.17 5.17 0 01-4.09 1.69 11.17 11.17 0 01-3-.47 12.47 12.47 0 00-3.62-.63 9.05 9.05 0 00-5 1.77 37.37 37.37 0 00-6.57 6.25v6.45q0 5.34.16 8.57c.1 2.15.37 4.88.79 8.18h-15.87q.63-4.95.79-8.18t.15-8.57v-5q0-5.26-.15-8.53t-.79-8.22h15.89a119.21 119.21 0 00-1 12.43q3.47-4.41 5.86-7a21.07 21.07 0 015.66-4.25 15.93 15.93 0 017.44-1.69 24.92 24.92 0 014.64.47 10.58 10.58 0 01.2 2.13zM766.75 765q-5.19 16.59-22.57 16.59a32.27 32.27 0 01-12.58-2.4 21.08 21.08 0 01-9.16-7.07 20.18 20.18 0 010-22.54 21.75 21.75 0 019-7.15 29.46 29.46 0 0112-2.44 26.67 26.67 0 0111.41 2.28 17.63 17.63 0 017.47 6.21 15.89 15.89 0 012.67 8.65h-30.64c-.05.53-.08 1.37-.08 2.52q0 8 3.82 13.17T748.9 778a16 16 0 009.6-3.15q4.32-3.15 6.68-9.83zm-29.49-19.78q-2.28 3.27-2.83 10h15.89q0-6.45-1.7-9.83a5.62 5.62 0 00-5.38-3.38 7 7 0 00-5.98 3.25zM840.6 741.6a52.08 52.08 0 00-3.15 7.4l-10.61 31.06a37.42 37.42 0 01-4.21 8.89 13.32 13.32 0 01-5.15 4.6 16.4 16.4 0 01-7 1.37 24.4 24.4 0 01-7.87-1.33 16.09 16.09 0 01-6.45-3.94 5.66 5.66 0 01-.07-1 4.92 4.92 0 011.53-3.73 5 5 0 013.58-1.46 5.12 5.12 0 012.87.91 5.47 5.47 0 012.08 2.71 14.43 14.43 0 002.83 4.56 5.53 5.53 0 003.94 1.34q3.06 0 6.25-2.87t5.46-9.56l.16-.47h-14l-12-31.06c-.52-1.37-1-2.57-1.57-3.62s-1.24-2.31-2.13-3.78h17.07a21.73 21.73 0 00.75 3.46c.28.9.74 2.15 1.37 3.78L825.5 778l10.07-29.18a49.54 49.54 0 001.73-7.24zM854.05 779.27a20.89 20.89 0 01-9.44-7.07 20.33 20.33 0 010-22.69 21.27 21.27 0 019.44-7.08 39.31 39.31 0 0127.05 0 21.27 21.27 0 019.44 7.08 20.33 20.33 0 010 22.69 20.89 20.89 0 01-9.44 7.07 39.94 39.94 0 01-27.05 0zm21.9-4.16q2.79-4.65 2.79-14.24T876 746.64a9.88 9.88 0 00-16.75 0q-2.79 4.64-2.79 14.23t2.79 14.24a9.88 9.88 0 0016.75 0zM944.88 741.6v38.46h-15q.55-4.32.87-8.34A22.25 22.25 0 01924 779a17.17 17.17 0 01-9.75 2.63q-6.45 0-9.91-3.73t-3.46-12.23v-7.08q0-5.19-.16-8.38t-.86-8.61H915v29.18q0 7.23 4.87 7.24 6.23 0 10.94-9.36c.05-1.1.08-2.89.08-5.35v-4.72c0-3.46-.06-6.25-.16-8.38s-.42-5-1-8.61zM991.83 743.65a6.68 6.68 0 01-1.49 4.6 5.17 5.17 0 01-4.09 1.69 11.17 11.17 0 01-3-.47 12.47 12.47 0 00-3.62-.63 9.05 9.05 0 00-5 1.77 37.37 37.37 0 00-6.57 6.25v6.45c0 3.56.06 6.42.16 8.57s.37 4.88.79 8.18h-15.87q.63-4.95.79-8.18t.15-8.57v-5q0-5.26-.15-8.53t-.79-8.22H969a119.21 119.21 0 00-.95 12.43q3.46-4.41 5.86-7a21 21 0 015.67-4.25 15.86 15.86 0 017.43-1.69 24.92 24.92 0 014.64.47 10.58 10.58 0 01.18 2.13zM340.46 843.8a19.37 19.37 0 018.57-7 30.11 30.11 0 0112.11-2.36q7.86 0 12.74 3.35a14.94 14.94 0 016.29 8.53 7.29 7.29 0 01-2.36 2.16 5.53 5.53 0 01-2.75.75 5.35 5.35 0 01-3.73-1.46 6.46 6.46 0 01-2-4 12.09 12.09 0 00-2.16-5.46q-1.53-1.93-5.31-1.93a7.44 7.44 0 00-7.12 4.09q-2.16 4.1-2.16 13 0 8.34 3.11 13.33t10.1 5a13.37 13.37 0 009-3.3q3.84-3.31 5.66-9.76h1.65a27.5 27.5 0 01-7.47 12.63q-5 4.59-14.23 4.6a28.06 28.06 0 01-11.57-2.36 19.33 19.33 0 01-8.37-7 22.34 22.34 0 010-22.81zM400.39 873.65a20.86 20.86 0 01-9.44-7.08 20.33 20.33 0 010-22.69 21.22 21.22 0 019.44-7.08 39.31 39.31 0 0127.05 0 21.33 21.33 0 019.44 7.08 20.33 20.33 0 010 22.69 21 21 0 01-9.44 7.08 39.94 39.94 0 01-27.05 0zm21.9-4.17q2.79-4.63 2.79-14.24T422.29 841a9.88 9.88 0 00-16.75 0q-2.79 4.63-2.8 14.23t2.8 14.24a9.88 9.88 0 0016.75 0zM484.38 874.43a51.32 51.32 0 01-.94-9 15.33 15.33 0 01-5.59 7.71q-3.93 2.86-10.54 2.86a24.69 24.69 0 01-10-2 17.41 17.41 0 01-7.75-6.68q-3-4.65-3-12t3-12.07a17.56 17.56 0 017.55-6.72 22.43 22.43 0 019.32-2.05 21.17 21.17 0 019.44 2 24.63 24.63 0 017.55 5.94v-13.91c0-3.52-.06-6.34-.16-8.46s-.42-5-.95-8.53h15.1v46.16q0 5.19.2 8.38t1 8.37zm-4.05-6q3.1-4 3.11-11.6v-11.65a23.81 23.81 0 00-5.78-5.59 11.65 11.65 0 00-6.49-2.12q-4.34 0-6.84 4.37t-2.52 13.4q0 7.63 2.59 12.39a8.56 8.56 0 008 4.76 9.61 9.61 0 007.93-3.97zM552.8 859.41Q547.61 876 530.23 876a32.27 32.27 0 01-12.58-2.4 21.2 21.2 0 01-9.17-7.08 20.16 20.16 0 010-22.53 21.8 21.8 0 019.05-7.16 29.6 29.6 0 0111.95-2.44 26.66 26.66 0 0111.4 2.28 17.75 17.75 0 017.48 6.22 15.84 15.84 0 012.67 8.65H520.4c0 .52-.08 1.36-.08 2.51q0 8 3.81 13.18t10.87 5.16a15.91 15.91 0 009.59-3.15q4.32-3.13 6.69-9.83zm-29.49-19.78q-2.28 3.27-2.83 10h15.88c0-4.3-.56-7.57-1.69-9.83a5.64 5.64 0 00-5.38-3.38 7 7 0 00-5.98 3.21zM629.63 859.41Q624.44 876 607.06 876a32.3 32.3 0 01-12.58-2.4 21.17 21.17 0 01-9.16-7.08 20.16 20.16 0 010-22.53 21.77 21.77 0 019-7.16 29.64 29.64 0 0112-2.44 26.66 26.66 0 0111.4 2.28 17.72 17.72 0 017.47 6.22 15.84 15.84 0 012.67 8.65h-30.63c-.05.52-.08 1.36-.08 2.51q0 8 3.82 13.18t10.81 5.15a16 16 0 009.6-3.15q4.32-3.13 6.68-9.83zm-29.49-19.78q-2.28 3.27-2.83 10h15.89c0-4.3-.57-7.57-1.69-9.83a5.65 5.65 0 00-5.39-3.38 7 7 0 00-5.98 3.21zM669.35 872.15a20.31 20.31 0 001.89 2.28h-18.09a26 26 0 00-2.28-4.56l-6.29-10.46-7.08 10.93a27 27 0 00-2.28 4.09h-3a34 34 0 003.07-4.09l8.18-12.81-10-16.52c-.58-.94-1.13-1.82-1.65-2.63A21 21 0 00630 836h18a21.4 21.4 0 002.36 5l6.13 10.07 7.63-11 1.06-1.58a21.36 21.36 0 001.46-2.51h2.75c-.52.63-.93 1.15-1.22 1.57s-.56.79-.82 1.1l-1 1.42-8.73 12.82 10.31 17a20.56 20.56 0 001.42 2.26zM720.39 859.41Q715.2 876 697.82 876a32.27 32.27 0 01-12.58-2.4 21.17 21.17 0 01-9.16-7.08 20.14 20.14 0 010-22.53 21.86 21.86 0 019-7.16 29.63 29.63 0 0112-2.44 26.74 26.74 0 0111.41 2.28 17.72 17.72 0 017.51 6.23 15.84 15.84 0 012.67 8.65H688c0 .52-.08 1.36-.08 2.51q0 8 3.82 13.18t10.81 5.15a15.91 15.91 0 009.59-3.15q4.33-3.13 6.69-9.83zm-29.49-19.78q-2.28 3.27-2.83 10H704c0-4.3-.56-7.57-1.69-9.83a5.63 5.63 0 00-5.38-3.38 7 7 0 00-6.03 3.21zM728.18 843.8a19.37 19.37 0 018.57-7 30.11 30.11 0 0112.11-2.36q7.86 0 12.74 3.35a14.94 14.94 0 016.29 8.53 7.4 7.4 0 01-2.36 2.16 5.53 5.53 0 01-2.75.75 5.35 5.35 0 01-3.73-1.46 6.46 6.46 0 01-2-4 12.09 12.09 0 00-2.16-5.46q-1.53-1.93-5.31-1.93a7.44 7.44 0 00-7.12 4.09q-2.16 4.1-2.16 13 0 8.34 3.11 13.33t10.1 5a13.37 13.37 0 009-3.3q3.85-3.31 5.66-9.76h1.65a27.5 27.5 0 01-7.47 12.63q-5 4.59-14.23 4.6a28.06 28.06 0 01-11.57-2.36 19.33 19.33 0 01-8.37-7 22.34 22.34 0 010-22.81zM819.64 836v38.45h-15q.55-4.32.87-8.33a22.22 22.22 0 01-6.69 7.27 17.1 17.1 0 01-9.75 2.64q-6.45 0-9.91-3.74T775.68 860v-7q0-5.19-.16-8.37t-.86-8.61h15.1v29.17q0 7.25 4.87 7.24 6.21 0 10.93-9.36c.06-1.1.08-2.88.08-5.35V853q0-5.19-.15-8.37c-.11-2.13-.42-5-1-8.61zM860.46 858.39a38.51 38.51 0 01-2.79 10.85 12.07 12.07 0 01-4.64 5.55 13.66 13.66 0 01-6.89 1.61q-6.84 0-9.71-3.54t-2.87-10.69v-24.23h-8.49v-2h1.33q5.28 0 7.63-2.17a8.79 8.79 0 002.83-5.42 69.29 69.29 0 00.48-9.4h11.79q0 12.9-10.38 17H859v2h-11.44v26.43c0 3.09.29 5.27.86 6.52a3.1 3.1 0 003.07 1.89q5.19 0 7.32-14.39zM912.83 859.41Q907.64 876 890.26 876a32.3 32.3 0 01-12.58-2.4 21.17 21.17 0 01-9.16-7.08 20.16 20.16 0 010-22.53 21.77 21.77 0 019-7.16 29.63 29.63 0 0111.95-2.44 26.67 26.67 0 0111.53 2.29 17.72 17.72 0 017.47 6.22 15.84 15.84 0 012.67 8.65h-30.71c0 .52-.08 1.36-.08 2.51q0 8 3.82 13.18t10.83 5.15a16 16 0 009.6-3.15q4.32-3.13 6.68-9.83zm-29.49-19.78q-2.28 3.27-2.83 10h15.89c0-4.3-.57-7.57-1.69-9.83a5.65 5.65 0 00-5.39-3.38 7 7 0 00-5.98 3.21zM919.13 861.54a6.57 6.57 0 013.46-.95 6.71 6.71 0 014.16 1.42 6.37 6.37 0 012.44 3.85 12.8 12.8 0 002.52 6c1.2 1.44 3.2 2.16 6 2.16a6.61 6.61 0 005.07-1.81 6.38 6.38 0 001.69-4.56 5.49 5.49 0 00-.94-3.22 11.23 11.23 0 00-3.35-2.8q-2.4-1.46-7.35-3.81-5.43-2.6-7.9-4a16 16 0 01-4.41-3.74 8.27 8.27 0 01-1.92-5.46 7.55 7.55 0 012.55-5.9 15.34 15.34 0 016.37-3.3 29.89 29.89 0 017.75-1 24.48 24.48 0 0111.6 2.64 16.28 16.28 0 017.27 7.27 6.65 6.65 0 01-5 2.6 5.44 5.44 0 01-3.42-1.18 6.74 6.74 0 01-2.24-3.3 9.93 9.93 0 00-2.68-4.64q-1.65-1.42-5.19-1.42a7.93 7.93 0 00-4.56 1.18 3.71 3.71 0 00-1.73 3.22 4.26 4.26 0 00.91 2.68 10.27 10.27 0 003.06 2.4q2.16 1.21 6.26 3l1.88.87c3.31 1.47 5.87 2.73 7.71 3.77a15.11 15.11 0 014.6 4 9.72 9.72 0 011.85 6.05 10.39 10.39 0 01-5 9.08q-5 3.35-13.4 3.35a27.69 27.69 0 01-13.37-3 13.79 13.79 0 01-7.08-8.65 6.15 6.15 0 012.39-2.8z"
          />
        </g>
      </g>
    </svg>
  );
}

export default function MysteriousVoid() {
  return (
    <GridContainer>
      <StyledImage
        topImage
        src="https://res.cloudinary.com/dxj9qr5gj/image/upload/c_scale,f_auto,q_auto:good,w_1200/v1614174727/maggieappleton.com/notes/learnable-programming/learnprog_2_ieudi6.png"
        alt="The interface of VS Code – one of the most popular apps for professional programming. If you're writing front-end code, you check the results in a separate browser window."
      />
      <FullWidthBackground background="#1A1D2F">
        <div>
          <DarkVoid />
        </div>
      </FullWidthBackground>
      <StyledImage
        src="https://res.cloudinary.com/dxj9qr5gj/image/upload/c_scale,f_auto,q_auto:good,w_1200/v1626441440/maggieappleton.com/notes/learnable-programming/Screenshot_-_2021-07-16_14.16.33_shrink_qfioaj.png"
        alt="A screenshot of this website rendered in a browser"
      />
    </GridContainer>
  );
}

const GridContainer = styled.div`
  width: 100%;
  max-width: 100vw;
  grid-column: 1/4 !important;
  margin: 2rem auto;
`;

const StyledImage = styled.img`
  margin: ${(props) => (props.topImage ? "0 auto -4rem" : "-5rem auto 2rem")};
  z-index: 10;
  width: 1000px;
  border-radius: var(--border-radius-base);
  box-shadow: var(--box-shadow-md);
  border: 1px solid var(--color-gray-100);
`;
