const DribbbleIcon = (props) => {
	return (
		<svg
			height={props.height || "30px"}
			width={props.width || "30px"}
			fill="currentColor"
			viewBox="0 0 48 48"
			xmlns="http://www.w3.org/2000/svg"
			{...props}
		>
			<title>Link to Maggie's Dribbble</title>
			<path d="M 24 4 C 12.972066 4 4 12.972074 4 24 C 4 35.027926 12.972066 44 24 44 C 35.027934 44 44 35.027926 44 24 C 44 12.972074 35.027934 4 24 4 z M 24 7 C 28.142307 7 31.929518 8.4763377 34.875 10.927734 C 32.122374 13.351092 28.974768 15.323142 25.580078 16.835938 C 23.811529 13.61959 21.891654 10.500767 19.736328 7.5585938 C 21.100562 7.2070927 22.524179 7 24 7 z M 16.785156 8.6171875 C 18.997535 11.542724 20.949628 14.664262 22.746094 17.886719 C 19.050465 19.170625 15.137713 20 11 20 C 9.8323552 20 8.6813446 19.922155 7.5390625 19.810547 C 8.7969115 14.835264 12.230939 10.75149 16.785156 8.6171875 z M 37.001953 13.046875 C 39.461176 15.964926 40.9535 19.721786 40.992188 23.837891 C 38.832662 23.296195 36.575941 23 34.25 23 C 32.4219 23 30.655764 23.235969 28.925781 23.574219 C 28.323231 22.178362 27.663283 20.821807 26.984375 19.46875 C 30.643681 17.813906 34.040456 15.676234 37.001953 13.046875 z M 24.177734 20.570312 C 24.811258 21.821635 25.45011 23.063845 26.015625 24.353516 C 19.953229 26.24965 14.749259 30.09875 11.257812 35.238281 C 8.6153572 32.243192 7 28.319322 7 24 C 7 23.585614 7.0335222 23.180292 7.0625 22.773438 C 8.3577913 22.906235 9.665848 23 11 23 C 15.643379 23 20.045102 22.063249 24.177734 20.570312 z M 34.25 26 C 36.498791 26 38.668342 26.319367 40.738281 26.882812 C 39.953494 31.489342 37.336086 35.457573 33.644531 38.001953 C 32.755328 34.064901 31.510607 30.269114 30.085938 26.5625 C 31.460152 26.325929 32.807024 26 34.25 26 z M 27.091797 27.125 C 28.662683 31.125628 30.006215 35.241408 30.90625 39.53125 C 28.795754 40.468547 26.462824 41 24 41 C 20.010678 41 16.357113 39.622608 13.460938 37.332031 C 16.608874 32.477365 21.430763 28.841138 27.091797 27.125 z" />
		</svg>
	);
};

const GithubIcon = (props) => {
	return (
		<svg
			height={props.height || "30px"}
			width={props.width || "30px"}
			fill="currentColor"
			viewBox="0 0 30 30"
			xmlns="http://www.w3.org/2000/svg"
			{...props}
		>
			<title>Link to Maggie's Github</title>
			<path d="M15,3C8.373,3,3,8.373,3,15c0,5.623,3.872,10.328,9.092,11.63C12.036,26.468,12,26.28,12,26.047v-2.051 c-0.487,0-1.303,0-1.508,0c-0.821,0-1.551-0.353-1.905-1.009c-0.393-0.729-0.461-1.844-1.435-2.526 c-0.289-0.227-0.069-0.486,0.264-0.451c0.615,0.174,1.125,0.596,1.605,1.222c0.478,0.627,0.703,0.769,1.596,0.769 c0.433,0,1.081-0.025,1.691-0.121c0.328-0.833,0.895-1.6,1.588-1.962c-3.996-0.411-5.903-2.399-5.903-5.098 c0-1.162,0.495-2.286,1.336-3.233C9.053,10.647,8.706,8.73,9.435,8c1.798,0,2.885,1.166,3.146,1.481C13.477,9.174,14.461,9,15.495,9 c1.036,0,2.024,0.174,2.922,0.483C18.675,9.17,19.763,8,21.565,8c0.732,0.731,0.381,2.656,0.102,3.594 c0.836,0.945,1.328,2.066,1.328,3.226c0,2.697-1.904,4.684-5.894,5.097C18.199,20.49,19,22.1,19,23.313v2.734 c0,0.104-0.023,0.179-0.035,0.268C23.641,24.676,27,20.236,27,15C27,8.373,21.627,3,15,3z" />
		</svg>
	);
};

const LinkedInIcon = (props) => {
	return (
		<svg
			height={props.height || "30px"}
			width={props.width || "30px"}
			fill="currentColor"
			viewBox="0 0 30 30"
			xmlns="http://www.w3.org/2000/svg"
			{...props}
		>
			<title>Link to Maggie's LinkedIn</title>
			<path d="M24,4H6C4.895,4,4,4.895,4,6v18c0,1.105,0.895,2,2,2h18c1.105,0,2-0.895,2-2V6C26,4.895,25.105,4,24,4z M10.954,22h-2.95 v-9.492h2.95V22z M9.449,11.151c-0.951,0-1.72-0.771-1.72-1.72c0-0.949,0.77-1.719,1.72-1.719c0.948,0,1.719,0.771,1.719,1.719 C11.168,10.38,10.397,11.151,9.449,11.151z M22.004,22h-2.948v-4.616c0-1.101-0.02-2.517-1.533-2.517 c-1.535,0-1.771,1.199-1.771,2.437V22h-2.948v-9.492h2.83v1.297h0.04c0.394-0.746,1.356-1.533,2.791-1.533 c2.987,0,3.539,1.966,3.539,4.522V22z" />
		</svg>
	);
};

const TwitterIcon = (props) => {
	return (
		<svg
			height={props.height || "30px"}
			width={props.width || "30px"}
			fill="currentColor"
			viewBox="0 0 30 30"
			xmlns="http://www.w3.org/2000/svg"
			{...props}
		>
			<title>Link to Maggie's Twitter</title>
			<path d="M28,6.937c-0.957,0.425-1.985,0.711-3.064,0.84c1.102-0.66,1.947-1.705,2.345-2.951c-1.03,0.611-2.172,1.055-3.388,1.295 c-0.973-1.037-2.359-1.685-3.893-1.685c-2.946,0-5.334,2.389-5.334,5.334c0,0.418,0.048,0.826,0.138,1.215 c-4.433-0.222-8.363-2.346-10.995-5.574C3.351,6.199,3.088,7.115,3.088,8.094c0,1.85,0.941,3.483,2.372,4.439 c-0.874-0.028-1.697-0.268-2.416-0.667c0,0.023,0,0.044,0,0.067c0,2.585,1.838,4.741,4.279,5.23 c-0.447,0.122-0.919,0.187-1.406,0.187c-0.343,0-0.678-0.034-1.003-0.095c0.679,2.119,2.649,3.662,4.983,3.705 c-1.825,1.431-4.125,2.284-6.625,2.284c-0.43,0-0.855-0.025-1.273-0.075c2.361,1.513,5.164,2.396,8.177,2.396 c9.812,0,15.176-8.128,15.176-15.177c0-0.231-0.005-0.461-0.015-0.69C26.38,8.945,27.285,8.006,28,6.937z" />
		</svg>
	);
};

const MastodonIcon = (props) => {
	return (
		<svg
			height={props.height || "30px"}
			width={props.width || "30px"}
			fill="currentColor"
			viewBox="0 0 417.8 512"
			xmlns="http://www.w3.org/2000/svg"
			{...props}
		>
			<title>Link to Maggie's Mastodon</title>
			<path d="M417.8 179.1c0-97.2-63.7-125.7-63.7-125.7-62.5-28.7-228.5-28.4-290.4 0 0 0-63.7 28.5-63.7 125.7 0 115.7-6.6 259.4 105.6 289.1 40.5 10.7 75.3 13 103.3 11.4 50.8-2.8 79.3-18.1 79.3-18.1l-1.7-36.9s-36.3 11.4-77.1 10.1c-40.4-1.4-83-4.4-89.6-54-.6-4.4-.9-9-.9-13.9 85.6 20.9 158.6 9.1 178.7 6.7 56.1-6.7 105-41.3 111.2-72.9 9.8-49.8 9-121.5 9-121.5zm-75.1 125.2h-46.6V190.1c0-49.7-64-51.6-64 6.9v62.5h-46.3V197c0-58.5-64-56.6-64-6.9v114.2H75.1c0-122.1-5.2-147.9 18.4-175 25.9-28.9 79.8-30.8 103.8 6.1l11.6 19.5 11.6-19.5c24.1-37.1 78.1-34.8 103.8-6.1 23.7 27.3 18.4 53 18.4 175z" />
		</svg>
	);
};

const RedditIcon = (props) => {
	return (
		<svg
			height={props.height || "30px"}
			width={props.width || "30px"}
			fill="currentColor"
			viewBox="0 0 512 512"
			xmlns="http://www.w3.org/2000/svg"
			{...props}
		>
			<title>Link to Maggie's Reddit</title>
			<path d="M256 8C119.033 8 8 119.033 8 256s111.033 248 248 248 248-111.033 248-248S392.967 8 256 8zm0 0" />
		</svg>
	);
};

const BlueSkyIcon = (props) => {
	return (
		<svg
			height={props.height || "30px"}
			width={props.width || "30px"}
			fill="currentColor"
			viewBox="0 0 600 530"
			version="1.1"
			xmlns="http://www.w3.org/2000/svg"
			{...props}
		>
			<title>Link to Maggie's BlueSky</title>
			<path d="m135.72 44.03c66.496 49.921 138.02 151.14 164.28 205.46 26.262-54.316 97.782-155.54 164.28-205.46 47.98-36.021 125.72-63.892 125.72 24.795 0 17.712-10.155 148.79-16.111 170.07-20.703 73.984-96.144 92.854-163.25 81.433 117.3 19.964 147.14 86.092 82.697 152.22-122.39 125.59-175.91-31.511-189.63-71.766-2.514-7.3797-3.6904-10.832-3.7077-7.8964-0.0174-2.9357-1.1937 0.51669-3.7077 7.8964-13.714 40.255-67.233 197.36-189.63 71.766-64.444-66.128-34.605-132.26 82.697-152.22-67.108 11.421-142.55-7.4491-163.25-81.433-5.9562-21.282-16.111-152.36-16.111-170.07 0-88.687 77.742-60.816 125.72-24.795z" />
		</svg>
	);
};

export {
	TwitterIcon,
	LinkedInIcon,
	DribbbleIcon,
	GithubIcon,
	MastodonIcon,
	RedditIcon,
	BlueSkyIcon,
};
