// this keymap is identical to SDL2 and taken from OMF_keycode.h

#define OMFK_SCANCODE_MASK (1 << 30)
#define OMF_SCANCODE_TO_KEYCODE(X) (X | OMFK_SCANCODE_MASK)

typedef enum {
    OMF_SCANCODE_UNKNOWN = 0,

    /**
     *  \name Usage page 0x07
     *
     *  These values are from usage page 0x07 (USB keyboard page).
     */
    /* @{ */

    OMF_SCANCODE_A = 4,
    OMF_SCANCODE_B = 5,
    OMF_SCANCODE_C = 6,
    OMF_SCANCODE_D = 7,
    OMF_SCANCODE_E = 8,
    OMF_SCANCODE_F = 9,
    OMF_SCANCODE_G = 10,
    OMF_SCANCODE_H = 11,
    OMF_SCANCODE_I = 12,
    OMF_SCANCODE_J = 13,
    OMF_SCANCODE_K = 14,
    OMF_SCANCODE_L = 15,
    OMF_SCANCODE_M = 16,
    OMF_SCANCODE_N = 17,
    OMF_SCANCODE_O = 18,
    OMF_SCANCODE_P = 19,
    OMF_SCANCODE_Q = 20,
    OMF_SCANCODE_R = 21,
    OMF_SCANCODE_S = 22,
    OMF_SCANCODE_T = 23,
    OMF_SCANCODE_U = 24,
    OMF_SCANCODE_V = 25,
    OMF_SCANCODE_W = 26,
    OMF_SCANCODE_X = 27,
    OMF_SCANCODE_Y = 28,
    OMF_SCANCODE_Z = 29,

    OMF_SCANCODE_1 = 30,
    OMF_SCANCODE_2 = 31,
    OMF_SCANCODE_3 = 32,
    OMF_SCANCODE_4 = 33,
    OMF_SCANCODE_5 = 34,
    OMF_SCANCODE_6 = 35,
    OMF_SCANCODE_7 = 36,
    OMF_SCANCODE_8 = 37,
    OMF_SCANCODE_9 = 38,
    OMF_SCANCODE_0 = 39,

    OMF_SCANCODE_RETURN = 40,
    OMF_SCANCODE_ESCAPE = 41,
    OMF_SCANCODE_BACKSPACE = 42,
    OMF_SCANCODE_TAB = 43,
    OMF_SCANCODE_SPACE = 44,

    OMF_SCANCODE_MINUS = 45,
    OMF_SCANCODE_EQUALS = 46,
    OMF_SCANCODE_LEFTBRACKET = 47,
    OMF_SCANCODE_RIGHTBRACKET = 48,
    OMF_SCANCODE_BACKSLASH = 49, /**< Located at the lower left of the return
                                  *   key on ISO keyboards and at the right end
                                  *   of the QWERTY row on ANSI keyboards.
                                  *   Produces REVERSE SOLIDUS (backslash) and
                                  *   VERTICAL LINE in a US layout, REVERSE
                                  *   SOLIDUS and VERTICAL LINE in a UK Mac
                                  *   layout, NUMBER SIGN and TILDE in a UK
                                  *   Windows layout, DOLLAR SIGN and POUND SIGN
                                  *   in a Swiss German layout, NUMBER SIGN and
                                  *   APOSTROPHE in a German layout, GRAVE
                                  *   ACCENT and POUND SIGN in a French Mac
                                  *   layout, and ASTERISK and MICRO SIGN in a
                                  *   French Windows layout.
                                  */
    OMF_SCANCODE_NONUSHASH = 50, /**< ISO USB keyboards actually use this code
                                  *   instead of 49 for the same key, but all
                                  *   OSes I've seen treat the two codes
                                  *   identically. So, as an implementor, unless
                                  *   your keyboard generates both of those
                                  *   codes and your OS treats them differently,
                                  *   you should generate OMF_SCANCODE_BACKSLASH
                                  *   instead of this code. As a user, you
                                  *   should not rely on this code because SDL
                                  *   will never generate it with most (all?)
                                  *   keyboards.
                                  */
    OMF_SCANCODE_SEMICOLON = 51,
    OMF_SCANCODE_APOSTROPHE = 52,
    OMF_SCANCODE_GRAVE = 53, /**< Located in the top left corner (on both ANSI
                              *   and ISO keyboards). Produces GRAVE ACCENT and
                              *   TILDE in a US Windows layout and in US and UK
                              *   Mac layouts on ANSI keyboards, GRAVE ACCENT
                              *   and NOT SIGN in a UK Windows layout, SECTION
                              *   SIGN and PLUS-MINUS SIGN in US and UK Mac
                              *   layouts on ISO keyboards, SECTION SIGN and
                              *   DEGREE SIGN in a Swiss German layout (Mac:
                              *   only on ISO keyboards), CIRCUMFLEX ACCENT and
                              *   DEGREE SIGN in a German layout (Mac: only on
                              *   ISO keyboards), SUPERSCRIPT TWO and TILDE in a
                              *   French Windows layout, COMMERCIAL AT and
                              *   NUMBER SIGN in a French Mac layout on ISO
                              *   keyboards, and LESS-THAN SIGN and GREATER-THAN
                              *   SIGN in a Swiss German, German, or French Mac
                              *   layout on ANSI keyboards.
                              */
    OMF_SCANCODE_COMMA = 54,
    OMF_SCANCODE_PERIOD = 55,
    OMF_SCANCODE_SLASH = 56,

    OMF_SCANCODE_CAPSLOCK = 57,

    OMF_SCANCODE_F1 = 58,
    OMF_SCANCODE_F2 = 59,
    OMF_SCANCODE_F3 = 60,
    OMF_SCANCODE_F4 = 61,
    OMF_SCANCODE_F5 = 62,
    OMF_SCANCODE_F6 = 63,
    OMF_SCANCODE_F7 = 64,
    OMF_SCANCODE_F8 = 65,
    OMF_SCANCODE_F9 = 66,
    OMF_SCANCODE_F10 = 67,
    OMF_SCANCODE_F11 = 68,
    OMF_SCANCODE_F12 = 69,

    OMF_SCANCODE_PRINTSCREEN = 70,
    OMF_SCANCODE_SCROLLLOCK = 71,
    OMF_SCANCODE_PAUSE = 72,
    OMF_SCANCODE_INSERT = 73, /**< insert on PC, help on some Mac keyboards (but
                                   does send code 73, not 117) */
    OMF_SCANCODE_HOME = 74,
    OMF_SCANCODE_PAGEUP = 75,
    OMF_SCANCODE_DELETE = 76,
    OMF_SCANCODE_END = 77,
    OMF_SCANCODE_PAGEDOWN = 78,
    OMF_SCANCODE_RIGHT = 79,
    OMF_SCANCODE_LEFT = 80,
    OMF_SCANCODE_DOWN = 81,
    OMF_SCANCODE_UP = 82,

    OMF_SCANCODE_NUMLOCKCLEAR = 83, /**< num lock on PC, clear on Mac keyboards
                                     */
    OMF_SCANCODE_KP_DIVIDE = 84,
    OMF_SCANCODE_KP_MULTIPLY = 85,
    OMF_SCANCODE_KP_MINUS = 86,
    OMF_SCANCODE_KP_PLUS = 87,
    OMF_SCANCODE_KP_ENTER = 88,
    OMF_SCANCODE_KP_1 = 89,
    OMF_SCANCODE_KP_2 = 90,
    OMF_SCANCODE_KP_3 = 91,
    OMF_SCANCODE_KP_4 = 92,
    OMF_SCANCODE_KP_5 = 93,
    OMF_SCANCODE_KP_6 = 94,
    OMF_SCANCODE_KP_7 = 95,
    OMF_SCANCODE_KP_8 = 96,
    OMF_SCANCODE_KP_9 = 97,
    OMF_SCANCODE_KP_0 = 98,
    OMF_SCANCODE_KP_PERIOD = 99,

    OMF_SCANCODE_NONUSBACKSLASH = 100, /**< This is the additional key that ISO
                                        *   keyboards have over ANSI ones,
                                        *   located between left shift and Y.
                                        *   Produces GRAVE ACCENT and TILDE in a
                                        *   US or UK Mac layout, REVERSE SOLIDUS
                                        *   (backslash) and VERTICAL LINE in a
                                        *   US or UK Windows layout, and
                                        *   LESS-THAN SIGN and GREATER-THAN SIGN
                                        *   in a Swiss German, German, or French
                                        *   layout. */
    OMF_SCANCODE_APPLICATION = 101,    /**< windows contextual menu, compose */
    OMF_SCANCODE_POWER = 102,          /**< The USB document says this is a status flag,
                               *   not a physical key - but some Mac keyboards
                               *   do have a power key. */
    OMF_SCANCODE_KP_EQUALS = 103,
    OMF_SCANCODE_F13 = 104,
    OMF_SCANCODE_F14 = 105,
    OMF_SCANCODE_F15 = 106,
    OMF_SCANCODE_F16 = 107,
    OMF_SCANCODE_F17 = 108,
    OMF_SCANCODE_F18 = 109,
    OMF_SCANCODE_F19 = 110,
    OMF_SCANCODE_F20 = 111,
    OMF_SCANCODE_F21 = 112,
    OMF_SCANCODE_F22 = 113,
    OMF_SCANCODE_F23 = 114,
    OMF_SCANCODE_F24 = 115,
    OMF_SCANCODE_EXECUTE = 116,
    OMF_SCANCODE_HELP = 117,
    OMF_SCANCODE_MENU = 118,
    OMF_SCANCODE_SELECT = 119,
    OMF_SCANCODE_STOP = 120,
    OMF_SCANCODE_AGAIN = 121, /**< redo */
    OMF_SCANCODE_UNDO = 122,
    OMF_SCANCODE_CUT = 123,
    OMF_SCANCODE_COPY = 124,
    OMF_SCANCODE_PASTE = 125,
    OMF_SCANCODE_FIND = 126,
    OMF_SCANCODE_MUTE = 127,
    OMF_SCANCODE_VOLUMEUP = 128,
    OMF_SCANCODE_VOLUMEDOWN = 129,
    /* not sure whether there's a reason to enable these */
    /*     OMF_SCANCODE_LOCKINGCAPSLOCK = 130,  */
    /*     OMF_SCANCODE_LOCKINGNUMLOCK = 131, */
    /*     OMF_SCANCODE_LOCKINGSCROLLLOCK = 132, */
    OMF_SCANCODE_KP_COMMA = 133,
    OMF_SCANCODE_KP_EQUALSAS400 = 134,

    OMF_SCANCODE_INTERNATIONAL1 = 135, /**< used on Asian keyboards, see
                                            footnotes in USB doc */
    OMF_SCANCODE_INTERNATIONAL2 = 136,
    OMF_SCANCODE_INTERNATIONAL3 = 137, /**< Yen */
    OMF_SCANCODE_INTERNATIONAL4 = 138,
    OMF_SCANCODE_INTERNATIONAL5 = 139,
    OMF_SCANCODE_INTERNATIONAL6 = 140,
    OMF_SCANCODE_INTERNATIONAL7 = 141,
    OMF_SCANCODE_INTERNATIONAL8 = 142,
    OMF_SCANCODE_INTERNATIONAL9 = 143,
    OMF_SCANCODE_LANG1 = 144, /**< Hangul/English toggle */
    OMF_SCANCODE_LANG2 = 145, /**< Hanja conversion */
    OMF_SCANCODE_LANG3 = 146, /**< Katakana */
    OMF_SCANCODE_LANG4 = 147, /**< Hiragana */
    OMF_SCANCODE_LANG5 = 148, /**< Zenkaku/Hankaku */
    OMF_SCANCODE_LANG6 = 149, /**< reserved */
    OMF_SCANCODE_LANG7 = 150, /**< reserved */
    OMF_SCANCODE_LANG8 = 151, /**< reserved */
    OMF_SCANCODE_LANG9 = 152, /**< reserved */

    OMF_SCANCODE_ALTERASE = 153, /**< Erase-Eaze */
    OMF_SCANCODE_SYSREQ = 154,
    OMF_SCANCODE_CANCEL = 155,
    OMF_SCANCODE_CLEAR = 156,
    OMF_SCANCODE_PRIOR = 157,
    OMF_SCANCODE_RETURN2 = 158,
    OMF_SCANCODE_SEPARATOR = 159,
    OMF_SCANCODE_OUT = 160,
    OMF_SCANCODE_OPER = 161,
    OMF_SCANCODE_CLEARAGAIN = 162,
    OMF_SCANCODE_CRSEL = 163,
    OMF_SCANCODE_EXSEL = 164,

    OMF_SCANCODE_KP_00 = 176,
    OMF_SCANCODE_KP_000 = 177,
    OMF_SCANCODE_THOUSANDSSEPARATOR = 178,
    OMF_SCANCODE_DECIMALSEPARATOR = 179,
    OMF_SCANCODE_CURRENCYUNIT = 180,
    OMF_SCANCODE_CURRENCYSUBUNIT = 181,
    OMF_SCANCODE_KP_LEFTPAREN = 182,
    OMF_SCANCODE_KP_RIGHTPAREN = 183,
    OMF_SCANCODE_KP_LEFTBRACE = 184,
    OMF_SCANCODE_KP_RIGHTBRACE = 185,
    OMF_SCANCODE_KP_TAB = 186,
    OMF_SCANCODE_KP_BACKSPACE = 187,
    OMF_SCANCODE_KP_A = 188,
    OMF_SCANCODE_KP_B = 189,
    OMF_SCANCODE_KP_C = 190,
    OMF_SCANCODE_KP_D = 191,
    OMF_SCANCODE_KP_E = 192,
    OMF_SCANCODE_KP_F = 193,
    OMF_SCANCODE_KP_XOR = 194,
    OMF_SCANCODE_KP_POWER = 195,
    OMF_SCANCODE_KP_PERCENT = 196,
    OMF_SCANCODE_KP_LESS = 197,
    OMF_SCANCODE_KP_GREATER = 198,
    OMF_SCANCODE_KP_AMPERSAND = 199,
    OMF_SCANCODE_KP_DBLAMPERSAND = 200,
    OMF_SCANCODE_KP_VERTICALBAR = 201,
    OMF_SCANCODE_KP_DBLVERTICALBAR = 202,
    OMF_SCANCODE_KP_COLON = 203,
    OMF_SCANCODE_KP_HASH = 204,
    OMF_SCANCODE_KP_SPACE = 205,
    OMF_SCANCODE_KP_AT = 206,
    OMF_SCANCODE_KP_EXCLAM = 207,
    OMF_SCANCODE_KP_MEMSTORE = 208,
    OMF_SCANCODE_KP_MEMRECALL = 209,
    OMF_SCANCODE_KP_MEMCLEAR = 210,
    OMF_SCANCODE_KP_MEMADD = 211,
    OMF_SCANCODE_KP_MEMSUBTRACT = 212,
    OMF_SCANCODE_KP_MEMMULTIPLY = 213,
    OMF_SCANCODE_KP_MEMDIVIDE = 214,
    OMF_SCANCODE_KP_PLUSMINUS = 215,
    OMF_SCANCODE_KP_CLEAR = 216,
    OMF_SCANCODE_KP_CLEARENTRY = 217,
    OMF_SCANCODE_KP_BINARY = 218,
    OMF_SCANCODE_KP_OCTAL = 219,
    OMF_SCANCODE_KP_DECIMAL = 220,
    OMF_SCANCODE_KP_HEXADECIMAL = 221,

    OMF_SCANCODE_LCTRL = 224,
    OMF_SCANCODE_LSHIFT = 225,
    OMF_SCANCODE_LALT = 226, /**< alt, option */
    OMF_SCANCODE_LGUI = 227, /**< windows, command (apple), meta */
    OMF_SCANCODE_RCTRL = 228,
    OMF_SCANCODE_RSHIFT = 229,
    OMF_SCANCODE_RALT = 230, /**< alt gr, option */
    OMF_SCANCODE_RGUI = 231, /**< windows, command (apple), meta */

    OMF_SCANCODE_MODE = 257, /**< I'm not sure if this is really not covered
                                 *   by any of the above, but since there's a
                                 *   special KMOD_MODE for it I'm adding it here
                                 */

    /* @} */ /* Usage page 0x07 */

    /**
     *  \name Usage page 0x0C
     *
     *  These values are mapped from usage page 0x0C (USB consumer page).
     */
    /* @{ */

    OMF_SCANCODE_AUDIONEXT = 258,
    OMF_SCANCODE_AUDIOPREV = 259,
    OMF_SCANCODE_AUDIOSTOP = 260,
    OMF_SCANCODE_AUDIOPLAY = 261,
    OMF_SCANCODE_AUDIOMUTE = 262,
    OMF_SCANCODE_MEDIASELECT = 263,
    OMF_SCANCODE_WWW = 264,
    OMF_SCANCODE_MAIL = 265,
    OMF_SCANCODE_CALCULATOR = 266,
    OMF_SCANCODE_COMPUTER = 267,
    OMF_SCANCODE_AC_SEARCH = 268,
    OMF_SCANCODE_AC_HOME = 269,
    OMF_SCANCODE_AC_BACK = 270,
    OMF_SCANCODE_AC_FORWARD = 271,
    OMF_SCANCODE_AC_STOP = 272,
    OMF_SCANCODE_AC_REFRESH = 273,
    OMF_SCANCODE_AC_BOOKMARKS = 274,

    /* @} */ /* Usage page 0x0C */

    /**
     *  \name Walther keys
     *
     *  These are values that Christian Walther added (for mac keyboard?).
     */
    /* @{ */

    OMF_SCANCODE_BRIGHTNESSDOWN = 275,
    OMF_SCANCODE_BRIGHTNESSUP = 276,
    OMF_SCANCODE_DISPLAYSWITCH = 277, /**< display mirroring/dual display
                                           switch, video mode switch */
    OMF_SCANCODE_KBDILLUMTOGGLE = 278,
    OMF_SCANCODE_KBDILLUMDOWN = 279,
    OMF_SCANCODE_KBDILLUMUP = 280,
    OMF_SCANCODE_EJECT = 281,
    OMF_SCANCODE_SLEEP = 282,

    OMF_SCANCODE_APP1 = 283,
    OMF_SCANCODE_APP2 = 284,

    /* @} */ /* Walther keys */

    /**
     *  \name Usage page 0x0C (additional media keys)
     *
     *  These values are mapped from usage page 0x0C (USB consumer page).
     */
    /* @{ */

    OMF_SCANCODE_AUDIOREWIND = 285,
    OMF_SCANCODE_AUDIOFASTFORWARD = 286,

    /* @} */ /* Usage page 0x0C (additional media keys) */

    /* Add any other keys here. */

    OMF_NUM_SCANCODES = 512 /**< not a key, just marks the number of scancodes
                                 for array bounds */
} OMF_Scancode;

enum
{
    OMFK_UNKNOWN = 0,

    OMFK_RETURN = '\r',
    OMFK_ESCAPE = '\033',
    OMFK_BACKSPACE = '\b',
    OMFK_TAB = '\t',
    OMFK_SPACE = ' ',
    OMFK_EXCLAIM = '!',
    OMFK_QUOTEDBL = '"',
    OMFK_HASH = '#',
    OMFK_PERCENT = '%',
    OMFK_DOLLAR = '$',
    OMFK_AMPERSAND = '&',
    OMFK_QUOTE = '\'',
    OMFK_LEFTPAREN = '(',
    OMFK_RIGHTPAREN = ')',
    OMFK_ASTERISK = '*',
    OMFK_PLUS = '+',
    OMFK_COMMA = ',',
    OMFK_MINUS = '-',
    OMFK_PERIOD = '.',
    OMFK_SLASH = '/',
    OMFK_0 = '0',
    OMFK_1 = '1',
    OMFK_2 = '2',
    OMFK_3 = '3',
    OMFK_4 = '4',
    OMFK_5 = '5',
    OMFK_6 = '6',
    OMFK_7 = '7',
    OMFK_8 = '8',
    OMFK_9 = '9',
    OMFK_COLON = ':',
    OMFK_SEMICOLON = ';',
    OMFK_LESS = '<',
    OMFK_EQUALS = '=',
    OMFK_GREATER = '>',
    OMFK_QUESTION = '?',
    OMFK_AT = '@',
    /*
       Skip uppercase letters
     */
    OMFK_LEFTBRACKET = '[',
    OMFK_BACKSLASH = '\\',
    OMFK_RIGHTBRACKET = ']',
    OMFK_CARET = '^',
    OMFK_UNDERSCORE = '_',
    OMFK_BACKQUOTE = '`',
    OMFK_a = 'a',
    OMFK_b = 'b',
    OMFK_c = 'c',
    OMFK_d = 'd',
    OMFK_e = 'e',
    OMFK_f = 'f',
    OMFK_g = 'g',
    OMFK_h = 'h',
    OMFK_i = 'i',
    OMFK_j = 'j',
    OMFK_k = 'k',
    OMFK_l = 'l',
    OMFK_m = 'm',
    OMFK_n = 'n',
    OMFK_o = 'o',
    OMFK_p = 'p',
    OMFK_q = 'q',
    OMFK_r = 'r',
    OMFK_s = 's',
    OMFK_t = 't',
    OMFK_u = 'u',
    OMFK_v = 'v',
    OMFK_w = 'w',
    OMFK_x = 'x',
    OMFK_y = 'y',
    OMFK_z = 'z',

    OMFK_CAPSLOCK = OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_CAPSLOCK),

    OMFK_F1 = OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_F1),
    OMFK_F2 = OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_F2),
    OMFK_F3 = OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_F3),
    OMFK_F4 = OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_F4),
    OMFK_F5 = OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_F5),
    OMFK_F6 = OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_F6),
    OMFK_F7 = OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_F7),
    OMFK_F8 = OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_F8),
    OMFK_F9 = OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_F9),
    OMFK_F10 = OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_F10),
    OMFK_F11 = OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_F11),
    OMFK_F12 = OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_F12),

    OMFK_PRINTSCREEN = OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_PRINTSCREEN),
    OMFK_SCROLLLOCK = OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_SCROLLLOCK),
    OMFK_PAUSE = OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_PAUSE),
    OMFK_INSERT = OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_INSERT),
    OMFK_HOME = OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_HOME),
    OMFK_PAGEUP = OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_PAGEUP),
    OMFK_DELETE = '\177',
    OMFK_END = OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_END),
    OMFK_PAGEDOWN = OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_PAGEDOWN),
    OMFK_RIGHT = OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_RIGHT),
    OMFK_LEFT = OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_LEFT),
    OMFK_DOWN = OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_DOWN),
    OMFK_UP = OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_UP),

    OMFK_NUMLOCKCLEAR = OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_NUMLOCKCLEAR),
    OMFK_KP_DIVIDE = OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_KP_DIVIDE),
    OMFK_KP_MULTIPLY = OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_KP_MULTIPLY),
    OMFK_KP_MINUS = OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_KP_MINUS),
    OMFK_KP_PLUS = OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_KP_PLUS),
    OMFK_KP_ENTER = OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_KP_ENTER),
    OMFK_KP_1 = OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_KP_1),
    OMFK_KP_2 = OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_KP_2),
    OMFK_KP_3 = OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_KP_3),
    OMFK_KP_4 = OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_KP_4),
    OMFK_KP_5 = OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_KP_5),
    OMFK_KP_6 = OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_KP_6),
    OMFK_KP_7 = OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_KP_7),
    OMFK_KP_8 = OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_KP_8),
    OMFK_KP_9 = OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_KP_9),
    OMFK_KP_0 = OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_KP_0),
    OMFK_KP_PERIOD = OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_KP_PERIOD),

    OMFK_APPLICATION = OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_APPLICATION),
    OMFK_POWER = OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_POWER),
    OMFK_KP_EQUALS = OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_KP_EQUALS),
    OMFK_F13 = OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_F13),
    OMFK_F14 = OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_F14),
    OMFK_F15 = OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_F15),
    OMFK_F16 = OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_F16),
    OMFK_F17 = OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_F17),
    OMFK_F18 = OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_F18),
    OMFK_F19 = OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_F19),
    OMFK_F20 = OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_F20),
    OMFK_F21 = OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_F21),
    OMFK_F22 = OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_F22),
    OMFK_F23 = OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_F23),
    OMFK_F24 = OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_F24),
    OMFK_EXECUTE = OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_EXECUTE),
    OMFK_HELP = OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_HELP),
    OMFK_MENU = OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_MENU),
    OMFK_SELECT = OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_SELECT),
    OMFK_STOP = OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_STOP),
    OMFK_AGAIN = OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_AGAIN),
    OMFK_UNDO = OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_UNDO),
    OMFK_CUT = OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_CUT),
    OMFK_COPY = OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_COPY),
    OMFK_PASTE = OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_PASTE),
    OMFK_FIND = OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_FIND),
    OMFK_MUTE = OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_MUTE),
    OMFK_VOLUMEUP = OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_VOLUMEUP),
    OMFK_VOLUMEDOWN = OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_VOLUMEDOWN),
    OMFK_KP_COMMA = OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_KP_COMMA),
    OMFK_KP_EQUALSAS400 =
        OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_KP_EQUALSAS400),

    OMFK_ALTERASE = OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_ALTERASE),
    OMFK_SYSREQ = OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_SYSREQ),
    OMFK_CANCEL = OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_CANCEL),
    OMFK_CLEAR = OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_CLEAR),
    OMFK_PRIOR = OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_PRIOR),
    OMFK_RETURN2 = OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_RETURN2),
    OMFK_SEPARATOR = OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_SEPARATOR),
    OMFK_OUT = OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_OUT),
    OMFK_OPER = OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_OPER),
    OMFK_CLEARAGAIN = OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_CLEARAGAIN),
    OMFK_CRSEL = OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_CRSEL),
    OMFK_EXSEL = OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_EXSEL),

    OMFK_KP_00 = OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_KP_00),
    OMFK_KP_000 = OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_KP_000),
    OMFK_THOUSANDSSEPARATOR =
        OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_THOUSANDSSEPARATOR),
    OMFK_DECIMALSEPARATOR =
        OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_DECIMALSEPARATOR),
    OMFK_CURRENCYUNIT = OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_CURRENCYUNIT),
    OMFK_CURRENCYSUBUNIT =
        OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_CURRENCYSUBUNIT),
    OMFK_KP_LEFTPAREN = OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_KP_LEFTPAREN),
    OMFK_KP_RIGHTPAREN = OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_KP_RIGHTPAREN),
    OMFK_KP_LEFTBRACE = OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_KP_LEFTBRACE),
    OMFK_KP_RIGHTBRACE = OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_KP_RIGHTBRACE),
    OMFK_KP_TAB = OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_KP_TAB),
    OMFK_KP_BACKSPACE = OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_KP_BACKSPACE),
    OMFK_KP_A = OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_KP_A),
    OMFK_KP_B = OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_KP_B),
    OMFK_KP_C = OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_KP_C),
    OMFK_KP_D = OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_KP_D),
    OMFK_KP_E = OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_KP_E),
    OMFK_KP_F = OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_KP_F),
    OMFK_KP_XOR = OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_KP_XOR),
    OMFK_KP_POWER = OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_KP_POWER),
    OMFK_KP_PERCENT = OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_KP_PERCENT),
    OMFK_KP_LESS = OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_KP_LESS),
    OMFK_KP_GREATER = OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_KP_GREATER),
    OMFK_KP_AMPERSAND = OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_KP_AMPERSAND),
    OMFK_KP_DBLAMPERSAND =
        OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_KP_DBLAMPERSAND),
    OMFK_KP_VERTICALBAR =
        OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_KP_VERTICALBAR),
    OMFK_KP_DBLVERTICALBAR =
        OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_KP_DBLVERTICALBAR),
    OMFK_KP_COLON = OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_KP_COLON),
    OMFK_KP_HASH = OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_KP_HASH),
    OMFK_KP_SPACE = OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_KP_SPACE),
    OMFK_KP_AT = OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_KP_AT),
    OMFK_KP_EXCLAM = OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_KP_EXCLAM),
    OMFK_KP_MEMSTORE = OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_KP_MEMSTORE),
    OMFK_KP_MEMRECALL = OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_KP_MEMRECALL),
    OMFK_KP_MEMCLEAR = OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_KP_MEMCLEAR),
    OMFK_KP_MEMADD = OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_KP_MEMADD),
    OMFK_KP_MEMSUBTRACT =
        OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_KP_MEMSUBTRACT),
    OMFK_KP_MEMMULTIPLY =
        OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_KP_MEMMULTIPLY),
    OMFK_KP_MEMDIVIDE = OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_KP_MEMDIVIDE),
    OMFK_KP_PLUSMINUS = OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_KP_PLUSMINUS),
    OMFK_KP_CLEAR = OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_KP_CLEAR),
    OMFK_KP_CLEARENTRY = OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_KP_CLEARENTRY),
    OMFK_KP_BINARY = OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_KP_BINARY),
    OMFK_KP_OCTAL = OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_KP_OCTAL),
    OMFK_KP_DECIMAL = OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_KP_DECIMAL),
    OMFK_KP_HEXADECIMAL =
        OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_KP_HEXADECIMAL),

    OMFK_LCTRL = OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_LCTRL),
    OMFK_LSHIFT = OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_LSHIFT),
    OMFK_LALT = OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_LALT),
    OMFK_LGUI = OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_LGUI),
    OMFK_RCTRL = OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_RCTRL),
    OMFK_RSHIFT = OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_RSHIFT),
    OMFK_RALT = OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_RALT),
    OMFK_RGUI = OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_RGUI),

    OMFK_MODE = OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_MODE),

    OMFK_AUDIONEXT = OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_AUDIONEXT),
    OMFK_AUDIOPREV = OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_AUDIOPREV),
    OMFK_AUDIOSTOP = OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_AUDIOSTOP),
    OMFK_AUDIOPLAY = OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_AUDIOPLAY),
    OMFK_AUDIOMUTE = OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_AUDIOMUTE),
    OMFK_MEDIASELECT = OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_MEDIASELECT),
    OMFK_WWW = OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_WWW),
    OMFK_MAIL = OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_MAIL),
    OMFK_CALCULATOR = OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_CALCULATOR),
    OMFK_COMPUTER = OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_COMPUTER),
    OMFK_AC_SEARCH = OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_AC_SEARCH),
    OMFK_AC_HOME = OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_AC_HOME),
    OMFK_AC_BACK = OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_AC_BACK),
    OMFK_AC_FORWARD = OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_AC_FORWARD),
    OMFK_AC_STOP = OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_AC_STOP),
    OMFK_AC_REFRESH = OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_AC_REFRESH),
    OMFK_AC_BOOKMARKS = OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_AC_BOOKMARKS),

    OMFK_BRIGHTNESSDOWN =
        OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_BRIGHTNESSDOWN),
    OMFK_BRIGHTNESSUP = OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_BRIGHTNESSUP),
    OMFK_DISPLAYSWITCH = OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_DISPLAYSWITCH),
    OMFK_KBDILLUMTOGGLE =
        OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_KBDILLUMTOGGLE),
    OMFK_KBDILLUMDOWN = OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_KBDILLUMDOWN),
    OMFK_KBDILLUMUP = OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_KBDILLUMUP),
    OMFK_EJECT = OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_EJECT),
    OMFK_SLEEP = OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_SLEEP),
    OMFK_APP1 = OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_APP1),
    OMFK_APP2 = OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_APP2),

    OMFK_AUDIOREWIND = OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_AUDIOREWIND),
    OMFK_AUDIOFASTFORWARD = OMF_SCANCODE_TO_KEYCODE(OMF_SCANCODE_AUDIOFASTFORWARD)
};