/*This file is colon.def, from which is created colon.c.
It implements the builtin ":" in Bash.

Copyright (C) 1987-2019 Free Software Foundation, Inc.

This file is part of GNU Bash, the Bourne Again SHell.

Bash is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Bash is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Bash.  If not, see <http://www.gnu.org/licenses/>.

$PRODUCES colon.c

$BUILTIN :
$DOCNAME colon
$FUNCTION colon_builtin
$SHORT_DOC :
Null command.

No effect; the command does nothing.

Exit Status:
Always succeeds.
$END

$BUILTIN true
$FUNCTION colon_builtin
$SHORT_DOC true
Return a successful result.

Exit Status:
Always succeeds.
$END

$BUILTIN false
$FUNCTION false_builtin
$SHORT_DOC false
Return an unsuccessful result.

Exit Status:
Always fails.
$END
*/
#include <config.h>

#if defined (HAVE_UNISTD_H)
#  include <unistd.h>
#endif

#include "../bashansi.h"
#include "../shell.h"

/* Return a successful result. */
int
colon_builtin (ignore)
     WORD_LIST *ignore;
{
  return (0);
}

/* Return an unsuccessful result. */
int
false_builtin (ignore)
     WORD_LIST *ignore;
{
  return (1);
}
