# mao-rules
### A complete documentation of rules for the card game Mao in 2E, through the weeks.

*Start date: 9/2/2017*

## Stock Rules
* Players may not touch cards before the game has begun
* Players may not speak excessively during normal gameplay, they may only say words and phrases as required by cards
* Game start - one player flips over the top card and says “the game of mao has begun”
* Players take turns
* Players may play any card from their hand that is of the same suit or same value
* Play goes counterclockwise, unless switched
* If a player has no playable card, they must draw from the deck
* Players issue penalties to other players if a rule is not followed
* Players may issue a penalty if a player takes too long or doesn't recognize their turn
* Players may skip others by playing a card of the same value and suit, but they must say “to-it”
* Player receives a card for breaking a rule - that player must say “thank you”
* 2 - reverses order
* A - skips one player
* 7 - player must say “have a nice day”
* For each additional 7 played on top of the base 7, the next player must add a “very” before the “nice”.
  * For example, if it is the fourth 7 played, the player who placed that 7 must say “have a very, very, very nice day”
* Face card - all players say “all hail”
* Spade - player must say card value + “of spades”
* “Point of order” - all players drop their cards
  * Players may speak freely
  * Players may not touch their cards
  * May only be ended when the player who called the PoO says “end point of order”
* One card left - player must say ”mao”
* Playing last card - player must say “the game of mao has now ended”

## Rules: Games starting 9/2
* Card of same value but different suit is played - player must say “change of suit”
* Card with prime value played - player must say “prime”
* Last two cards sum up to prime number - player must say “prime”
* 6 - player must say “six”
* Suit change to clubs - player must say “welcome to the clubhouse”
* Player draws a card - player must say “never lucky”
* Player points (with a finger or two) - player must say “yeah boii”
* Player is not penalized because next player goes too quickly - player must say “teamwork”
* 5 cards of same color are played - player must say “racist”
* Card of same suit and value of 1 greater than last time is played - player must say “pancake”
* Ace, 5,10 - player must say “Rome wasn't built in a day”
* Player “two-it”’s with an even value card (no face cards) - player must say “shannic speed”
* Queen - skips (floor(n/2)-1) players and reverse order
* King after Jack, or Jack after King - player must say “joker”

## Rules: Games starting 9/7
* Jack, Queen, or King - next player must play in 2 seconds or less
* Player draws a card and plays that one immediately - player must say "ez game"
* Suit changes - player must knock
  * Number of knocks is determined by how many suit changes in a row there are
* Jack - player must announce a suit and the next person must play that suit
* Third card of a new suit played - player must say "three"
* Third card of a new suit played - skips 3 players
* Player "two-it"'s - player who was supposed to be next must say "rip"
* 2, 3, 4 of hearts - player must say "angery"
* Card played after a 7, excluding another 7 - player must say "lucky"
* Player is penalized twice in one turn - player must snap
* Player plays a card when another player was about to - player must say "swish"
* 3 (or more) face cards in a row are played - player must say "sea cucumber"
* 6 - player must roll the dice, and that many people are skipped

## Rules: Games starting 9/17
* Player says 2 statements after playing a card -
  * Player must say "black" if they played a red card
  * Player must say "red" if they played a black card
* Red, then black, then red card played - Player must dab and say "Paipo paipo paipo"
* Jack, Queen, or King - next player must hit the previous card before playing theirs
* 3 strictly increasing/decreasing cards played (with ace low):
  * Player must say "music" with pitch getting higher if increasing
  * Player must say "music" with pitch getting lower if decreasing
* Player switches suit to diamonds - player must say "oof", next player must say "ouch", and next player must say "owie"
* 6 then 6, 6 then 9, 9 then 6, or 9 then 9 played - player must say "nice"
* Ace, 4, 9 - player must say "circle"
* Card with value 1 above previous played (with loops) - player must say "upvote"
* 3 - Player must name a card value (defined as calling a "cockblock")
  * Next player may not play the named card
  * If they do, they are penalized with the rule call: "cockblocked"
* 10 - Must be played either to left or right instead of on the pile
  * If the 10 is red, must be played to player next in opposite of current order. Playing this also reverses the order.
  * If the 10 is black, must be played to player next in current order.


## Rules: Games starting 9/25
* Playing an exact copy of the previous card (but not a "two-it") - player says "me too thanks"
* Playing a card with the same value as starting card - player must say the card value
  * On a reshuffle, the card that activates this switches to the card on top after the shuffling
* Any player touches the played card stack in the middle - forces "without any milk" to be said with next card played
* Playing any card where past 2 cards add up to 10 - player must recite any haiku
* 3 - player must say "green"
* 4 - player must say "blue"
* Playing a card that completes a pattern of value, decreasing value, increasing value - player must acknowledge Chicago (point to it on board)
* Playing any card that sandwiches a Jack with non-Jacks- player must say "I'm sorry, Jack"
* Queen or King - player must kneel on the card (bend fingers onto it)
  * This establishes an "emperor", at which point you cannot play a card of the same value but different suit until a full rotation of players passes.
  * e.g. A Queen of Spades is played, and the player kneels. The Queen of Clubs, Diamonds, and Hearts cannot be played until a round of plays passes.
* Card played perpendicular to previous card - player must say "jenga"
* Playing the a copy of any red card ("two-it" or normal) - player must "take a selfie" (make a clicking noise)
* 6 or 4 - player can play a 4 of any suit on a 6 while saying "going to chicago"
  * A player cannot play a 4 on a 4 or a 6 on a 6
* Playing a card that completes a pattern of 3 strictly increasing cards - player must declare a step size, and then from then on play steps by this amount from turn to turn, instead of by 1
* Playing any card after a 10 - player must say "{card value * 10} percent chub"
* Playing a card with a left hand - player must say "right hand rule"

## Rules: Games starting 10/6
* 7, 9, 10 - player must say "nani"
* 6, 8, 9, 10, Q after a 6, 8, 9, 10, or Q - player must say "oh no"
* 3 card straight - player must say "up, up, and away"
* Absolute value of difference in card values is >= 8 - player must say "going to Malaysia"
  * In other words, (A or 2 to 10, J, Q, K) or vice versa.
* Player completes a blackjack (A and 10, J, Q, K) - player must say "bluejay"
* Drawing after the previous player drew as well - player must say "same"
* 3 - player must swap a card from their hand with the top one on the deck
* Value of card played matches number of letters in player's name - player must say "me irl"
* Player after someone who said "me irl" also meets the requirements to say "me irl" - player should say "2 me irl 4 me irl" instead
  * If the next person should as well, they should say "2 me irl 4 2 me irl 4 me irl" and so on
* Switch to a diamond - player says the card value, and next players continue counting down
  * Switching to a suit other than diamond - player must say "break" and all players stop counting down
* A switch of suit that also changes colors - player must cluck like a chicken
* Joker - this can be played anytime, player must laugh when it is played, it skips a number of players corresponding to how many Jokers have been played so far, and a player can play any card after a joker
* Odd valued heart - the bottom of the hearts on the card will point to someone, this player must say anything involving "senpai"; if the bottom of the heart points to the player who played the card, they must say anything involving "kouhai"
* 9 after a King - player must make a dog noise
* Spade after at least 2 hearts - player must say "shot through the heart"
* Player completes the pattern A, B, A, C (in terms of card values) - player must say "boba"
* Queen - player must say "I'm a believer"
* 4 or 8 of clubs - player must say "always lucky"

## Rules: Games starting 10/15
* 7 - player must say "do", and next players continue with "re", "mi", and so on
  * This chain stops on another 7 or when players reach "do" again
* King after Jack, or Jack after King - player must make a jacking off motion
* Starting turn with 2 cards in hand - player must present a card and ask for a card matching any specification
  * Others can present their cards and then a trade occurs.
  * If no card is presented within 10 seconds, original player must "go fish" from the drawing pile
* Player plays a card when another player was about to - player must say "skrt"
* Any card > 3 after a 3 - player must say "hartz"
* Player changes suit and needs to say another thing - player must say "announcement first"
* Even-numbered card played onto a different even-numbered card - player must say "north" if direction is CCW, "south" if direction is CW
* Card with value 3 greater than previous card - player must "hunt" and flip a card from the draw pile onto the play pile
* Playing a non-face card after a face card - player must play next card with both hands
* Red, black, red or black, red, black - player must say "you hate to see that happen"
* 5, 3, 4, 5, any card - player must play a 1-stock in smash with another player, loser must draw a card
* Diamond after a spade - player must ask a question
  * Next player must answer the question with any answer
* Players cannot play a card with their elbows on the table - associated penalty is "lack of chivalry"

## Worst of: Game played 10/18
* Queen - skips (floor(n/2)-1) players and reverse order
* Any player touches the played card stack in the middle - forces "without any milk" to be said with next card played
* Player says 2 statements after playing a card -
  * Player must say "black" if they played a red card
  * Player must say "red" if they played a black card
* Odd valued heart - the bottom of the hearts on the card will point to someone, this player must say anything involving "senpai"; if the bottom of the heart points to the player who played the card, they must say anything involving "kouhai"
* 3 (or more) face cards in a row are played - player must say "sea cucumber"
* Ace - players must vote on a player, highest voted player must then play an Ace or draw a card and say "Tanner confirmed"

## Best of: Game played 10/18
* Third card of a new suit played - player must say "three"
* Third card of a new suit played - skips 3 players
* Player is not penalized because next player goes too quickly - player must say “teamwork”
* Player points (with a finger or two) - player must say “yeah boii”
* Jack, Queen, or King - next player must hit the previous card before playing theirs
* Playing a card that completes a pattern of value, decreasing value, increasing value - player must acknowledge Chicago (point to it on board)
* Player draws a card and plays that one immediately - player must say "ez game"
* Red, black, red or black, red, black - player must say "you hate to see that happen"
* Playing any card after a 10 - player must say "{card value * 10} percent chub"
* 3 - Player must name a card value (defined as calling a "cockblock")
  * Next player may not play the named card
  * If they do, they are penalized with the rule call: "cockblocked"
* Player draws a card - player must say “never lucky”
* Value of card played matches number of letters in player's name - player must say "me irl"
* Playing a non-face card after a face card - player must play next card with both hands

## Rules: Games starting 10/31
* 3 even cards in a row - player must say "good"
* 3 odd cards in a row - player must say "bad"
* 4 even cards in a row - player must say "better" (but not say "good")
* 4 odd cards in a row - player must say "worse" (but not say "bad")
* 3 - player must say "sideways river"
* Player changes color - players must say "c________ parmesan"
* King after Queen or Queen after King - player must tap next player to play Rock, Paper, Scissors; loser draws a card
* Player says a word with a "b" on their turn - player must say "boolin'"
* Player breaks a 3 in a row streak - player must say "TL;DR"
* 6 - player must say "he/she dead" and next player must say "I am a male/female" respectively
* 8 - player must declare "the king is dead" and other players must repeat in a two direction cascade
* Player says any phrase that affects game flow containing a word beginning with "e" - player must say "forward aerial"
* Player needs to say a phrase on a spade that is not "x of spades" - player must say "happyou" before saying phrases
* Ace - exactly min(num_players, 6) must touch the ace played or everyone is penalized for "failure to play ouija"

## Rules: Games starting 11/27
* Suit change - Player must say a 4 syllable word/phrase as well as "on a stick"
* Card played with value +/- previous card - Player must place hand down and spin it around
* 6 - Player must say "Matt is dead"; skip 2 players
* Change of parity - Player levels up (tally on paper)
  * J - Player must challenge next player to a dual, player with lower level loses and draws a card
* K - Player must challenge next player to "War" - players show their highest value card, smaller card loses and that player draws a card
* Two parity changes in a row (with face cards even, Ace odd) - Player must laugh
* Two cards played that skip or redirect player flow - Player must name an animal
* BS implemented, max of one usage per game
  * Player can play 1-4 cards face down, and must name the value
  * Other players can call "BS", if player was truthful, the one who called out takes the cards and draws a card, if player was lying, they take the cards back and draw a card
* Two 8's in a row - Player must say "lol boobies" or "kek boobies"
* 8 after 5 - Player must say "I vote Bamo"
* Player can call a vote by holding a spin up or spin down hand for 2 seconds
  * Other players must vote (hold spin up or down) within 2 seconds, or are penalized

## Rules: Games starting 12/8
* Playing immediately after a "two-it" - Player must say "drift"
* Player who plays a card that a player "two-it"'s onto - Player becomes a "lead"
  * Next time it is that player's turn, they must say "lead"
* 3 suit changes in a row - Player must say "supersonic"
* Past 2 cards add to 4 - Player must say "that's numberwang"
* Changing suit with a 4 - Player must say "let's rotate the board"
* Playing a different card on 2 of the same card - Player must say "not drift"
* Playing a 6 or a 7
  * And then playing a card with a greater value - Player must say "unlimited power"
  * And then playing a card with a lower value - Player must say "limited power"
* 3, 4, 5 - Player must pay 1 peso (card from different deck treated as currency)
* J, Q, K - Player must take 1 peso
* 10 - Player is added to a persistent game list
  * Any future 10 - That player must say "one of us"
* Playing after a 9 then J or J then 9 - Player must not say anything on card play
* Queen of Hearts after a {King of Hearts, Jack of Hearts, Queen of Clubs, Queen of Spades, or Queen of Diamonds} - Player must say "card deleted" and place a card from hand back into the deck.
* 2 of the same face card - Player must name a suit and declare "a ward has been set"
  * For one iteration of players, no one can play that suit
* If a ward is declared, you can place you card face down to "hide" from the ward
  * The player who called the ward can "detect" the card by turning the card face up.

## Rules: Games starting 12/16
* Ace - Players are stunned, and cannot two-it or change suit with the Ace
* 2 - Player must say "ult", cannot be punished through next play
* 3 - Player is "silenced" and cannot say anything, unless they played the 3 on a 3
* 4 - Player must play card quickly and say "flash"
* 6 - Next player is "charmed" and must align card with previous one
* Red 8 - Player is "airborne" and must play the 8 with body parts off table
* Black 8 - Player is "grounded" and must play the 8 with a body part on the table
* 3 cards of the same number in a row - Player must place card down and compress card pile multiple times
* 5 - Player must flick card and have it rotate and land on pile
* Completion of consecutive cycle (i.e. play goes around the whole table with no skips or direction changes) - Player who started the cycle must say "aw geez"
  * Next player must say "aw man", unless the next play isn't standard order
* Red 6, 8, or 9 after a red 6, 8, or 9 - Player must say "communist propaganda"
* Players must play aligned on top of a heart - or else "heart break" is called
* Player is penalized - Next player must say "assertion", assertively
* Player draws a card - Player must bring card to hand level before playing the card - or else "failure to load in" is called

## Rules: Games starting 3/6
* Flag card played:
  * If next card is greater - player must say "made friends"
  * If next card is lesser - player must say "bamboozled"
  * This card becomes the new flag card.
  * First flag card is 7.
* Playing any card after a 7 - player must say "wrecked"
* Double time:
  * Activated by 2 of the same red card - n = (2, 4, 6, 8)
  * DT is active for the next n/2 turns
  * On every turn during DT - add one to the existing number of skips (i.e. 0 if non-Ace, 1 if Ace)
  * If DT is activated on DT, the old DT is overriden.
* 2 parity switches - player must straighten the pile (doing "laundry")
* Player penalized by a non-stock rule - player must add "pendejo" after "thanks"/"thank you"
* Player is skipped (by non-to-it) - player must say "no mames"

## Rules: Games starting 4/28
* Playing greater value face card on a face card - player must drop card to play it
* Playing a 2 - player must say how many red back cards they have + " cans"
* Player switches to black suit after 3 red cards - player must tell a story with the number of words equal to the value of the card played
* Playing a Jack -
  * If the card has an orange back - player must say "I have orange juice"
  * If the card has a blue back - player must say "I do not have orange juice"
* Playing a blue back card after an "orange juice" call - player must apologize for their disgusting combo
* Playing an 8 - player must deliver an insult with "Jessica" in it
* 2 red 6's in a row - player must put the bottom card of the play pile on top
* Playing a 5 - player must shake someone's hand (with the exception of the player right before them) and it becomes that player's turn
* Playing a card whose value equals the number of cards in hand - player must say the card value
* Playing a Jack or a King - player must say "bois located at " + some clock direction or "everywhere"
