---
sidebar_position: 1
---

# Core Plugins List

| name                                                                                                                     | description                                                                                                                | optional? |
| ------------------------------------------------------------------------------------------------------------------------ | -------------------------------------------------------------------------------------------------------------------------- | --------- |
| <a href='https://github.com/folke/lazy.nvim'>folke/lazy.nvim</a>                                                         | A modern plugin manager for Neovim                                                                                         |           |
| <a href='https://github.com/neovim/nvim-lspconfig'>neovim/nvim-lspconfig</a>                                             | Quickstart configurations for the Nvim LSP client                                                                          |           |
| <a href='https://github.com/tamago324/nlsp-settings.nvim'>tamago324/nlsp-settings.nvim</a>                               | A plugin for setting Neovim LSP with JSON or YAML files                                                                    |           |
| <a href='https://github.com/nvimtools/none-ls.nvim/'>nvimtools/none-ls.nvim</a>                                          | Use Neovim as a language server to inject LSP diagnostics, code actions, and more via Lua.                                 |           |
| <a href='https://github.com/williamboman/mason-lspconfig.nvim'>williamboman/mason-lspconfig.nvim</a>                     | Extension to mason.nvim that makes it easier to use lspconfig with mason.nvim                                              |           |
| <a href='https://github.com/williamboman/mason.nvim'>williamboman/mason.nvim</a>                                         | Easily install and manage LSP servers, DAP servers, linters, and formatters                                                |           |
| <a href='https://github.com/folke/tokyonight.nvim'>folke/tokyonight.nvim</a>                                             | A clean, dark Neovim theme                                                                                                 |           |
| <a href='https://github.com/lunarvim/lunar.nvim'>lunarvim/lunar.nvim</a>                                                 | LunarVim Colorscheme                                                                                                       |           |
| <a href='https://github.com/Tastyep/structlog.nvim'>Tastyep/structlog.nvim</a>                                           | Structured Logging for nvim, using Lua                                                                                     |           |
| <a href='https://github.com/nvim-lua/popup.nvim'>nvim-lua/popup.nvim</a>                                                 | [WIP] An implementation of the Popup API from vim in Neovim. Hope to upstream when complete                                |           |
| <a href='https://github.com/nvim-lua/plenary.nvim'>nvim-lua/plenary.nvim</a>                                             | plenary: full; complete; entire; absolute; unqualified. All the lua functions I don't want to write twice.                 |           |
| <a href='https://github.com/nvim-telescope/telescope.nvim'>nvim-telescope/telescope.nvim</a>                             | Find, Filter, Preview, Pick. All lua, all the time.                                                                        | optional  |
| <a href='https://github.com/nvim-telescope/telescope-fzf-native.nvim'>nvim-telescope/telescope-fzf-native.nvim</a>       | FZF sorter for telescope written in c                                                                                      |           |
| <a href='https://github.com/hrsh7th/nvim-cmp'>hrsh7th/nvim-cmp</a>                                                       | A completion plugin for neovim coded in Lua.                                                                               |           |
| <a href='https://github.com/rafamadriz/friendly-snippets'>rafamadriz/friendly-snippets</a>                               | Set of preconfigured snippets for different languages.                                                                     | optional  |
| <a href='https://github.com/L3MON4D3/LuaSnip'>L3MON4D3/LuaSnip</a>                                                       | Snippet Engine for Neovim written in Lua.                                                                                  |           |
| <a href='https://github.com/hrsh7th/cmp-nvim-lsp'>hrsh7th/cmp-nvim-lsp</a>                                               | nvim-cmp source for neovim builtin LSP client                                                                              |           |
| <a href='https://github.com/saadparwaiz1/cmp_luasnip'>saadparwaiz1/cmp_luasnip</a>                                       | luasnip completion source for nvim-cmp                                                                                     |           |
| <a href='https://github.com/hrsh7th/cmp-buffer'>hrsh7th/cmp-buffer</a>                                                   | nvim-cmp source for buffer words                                                                                           |           |
| <a href='https://github.com/hrsh7th/cmp-path'>hrsh7th/cmp-path</a>                                                       | nvim-cmp source for paths                                                                                                  |           |
| <a href='https://github.com/folke/neodev.nvim'>folke/neodev.nvim</a>                                                     | 💻 Dev setup for init.lua and plugin development with full signature help, docs and completion for the nvim lua API.       |           |
| <a href='https://github.com/windwp/nvim-autopairs'>windwp/nvim-autopairs</a>                                             | autopairs for neovim written by lua                                                                                        | optional  |
| <a href='https://github.com/nvim-treesitter/nvim-treesitter'>nvim-treesitter/nvim-treesitter</a>                         | Nvim Treesitter configurations and abstraction layer                                                                       |           |
| <a href='https://github.com/JoosepAlviste/nvim-ts-context-commentstring'>JoosepAlviste/nvim-ts-context-commentstring</a> | Neovim treesitter plugin for setting the commentstring based on the cursor location in a file.                             |           |
| <a href='https://github.com/kyazdani42/nvim-tree.lua'>kyazdani42/nvim-tree.lua</a>                                       | A file explorer tree for neovim written in lua                                                                             | optional  |
| <a href='https://github.com/tamago324/lir.nvim'>tamago324/lir.nvim</a>                                                   | Neovim file explorer                                                                                                       | optional  |
| <a href='https://github.com/lewis6991/gitsigns.nvim'>lewis6991/gitsigns.nvim</a>                                         | Git integration for buffers                                                                                                | optional  |
| <a href='https://github.com/folke/which-key.nvim'>folke/which-key.nvim</a>                                               | Displays a popup with possible keybindings of the command you started typing.                                              | optional  |
| <a href='https://github.com/numToStr/Comment.nvim'>numToStr/Comment.nvim</a>                                             | Smart and powerful comment plugin for neovim. Supports treesitter, dot repeat, left-right/up-down motions, hooks, and more | optional  |
| <a href='https://github.com/ahmedkhalf/project.nvim'>ahmedkhalf/project.nvim</a>                                         | The superior project management solution for neovim                                                                        | optional  |
| <a href='https://github.com/nvim-tree/nvim-web-devicons'>nvim-tree/nvim-web-devicons</a>                               | lua `fork` of vim-web-devicons for neovim                                                                                  | optional  |
| <a href='https://github.com/nvim-lualine/lualine.nvim'>nvim-lualine/lualine.nvim</a>                                     | A blazing fast and easy to configure neovim statusline plugin written in pure lua                                          | optional  |
| <a href='https://github.com/SmiteshP/nvim-navic'>SmiteshP/nvim-navic</a>                                                 | winbar/statusline plugin that shows your current code context                                                              | optional  |
| <a href='https://github.com/akinsho/bufferline.nvim'>akinsho/bufferline.nvim</a>                                         | A snazzy bufferline for Neovim                                                                                             | optional  |
| <a href='https://github.com/mfussenegger/nvim-dap'>mfussenegger/nvim-dap</a>                                             | Debug Adapter Protocol client implementation for Neovim (>= 0.5)                                                           | optional  |
| <a href='https://github.com/rcarriga/nvim-dap-ui'>rcarriga/nvim-dap-ui</a>                                               | A UI for nvim-dap which provides a good out of the box configuration                                                       | optional  |
| <a href='https://github.com/goolord/alpha-nvim'>goolord/alpha-nvim</a>                                                   | a lua powered greeter like vim-startify / dashboard-nvim                                                                   | optional  |
| <a href='https://github.com/akinsho/toggleterm.nvim'>akinsho/toggleterm.nvim</a>                                         | A neovim lua plugin to help easily manage multiple terminal windows                                                        | optional  |
| <a href='https://github.com/b0o/schemastore.nvim'>b0o/schemastore.nvim</a>                                               | 🛍 JSON schemas for Neovim                                                                                                  |           |
| <a href='https://github.com/RRethy/vim-illuminate'>RRethy/vim-illuminate</a>                                             | highlight word under the cursor using either LSP, Tree-sitter, or regex matching                                           | optional  |
| <a href='https://github.com/lunarvim/onedarker.nvim'>lunarvim/onedarker.nvim</a>                                         | Onedark inspired colorscheme written in lua.                                                                               | optional  |
| <a href='https://github.com/lukas-reineke/indent-blankline.nvim'>lukas-reineke/indent-blankline.nvim</a>                 | Indent guides for Neovim                                                                                                   | optional  |
