---
title: Nerd Fonts
sidebar_position: 4
---

# [ Nerd Fonts ](https://www.nerdfonts.com/)

From the repo:

> "Nerd Fonts is a project that patches developer targeted fonts with a high number of glyphs (icons). Specifically to add a high number of extra glyphs from popular 'iconic fonts' such as Font Awesome ➶, Devicons ➶, Octicons ➶, and others."

## Installing a font

### Video Explanation

<iframe width="560" height="315" src="https://www.youtube.com/embed/fR4ThXzhQYI" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen="1"></iframe>

### Easy Installer

Visit [this repo](https://github.com/ronniedroid/getnf) for an easy way to install nerd fonts.

### Manual Install

1. Go to the [pached fonts directory](https://www.nerdfonts.com/font-downloads)
1. Copy the downloaded files to `~/.local/share/fonts`

### Curl Download

```bash
mkdir -p ~/.local/share/fonts
cd ~/.local/share/fonts && curl -fLo "Droid Sans Mono for Powerline Nerd Font Complete.otf" https://github.com/ryanoasis/nerd-fonts/raw/master/patched-fonts/DroidSansMono/complete/Droid%20Sans%20Mono%20Nerd%20Font%20Complete.otf
```

### TTF vs OTF

OTF is a newer standard based on TTF, when given the option you should generally choose OTF.

[ Here ](https://www.makeuseof.com/tag/otf-vs-ttf-fonts-one-better/) is good article explaining the difference.

## Terminal settings

After installing your font, you will have to refresh your font cache by doing `fc-cache -f -v`. Then you will have to change your terminal settings to use the font you just installed. Please refer to your terminal's documentation for changing the terminal font.
