---
sidebar_position: 1
---

# Список основних плагінів

| назва                                                                                                                    | опис                                                                                                                             | необов'язковий? |
|--------------------------------------------------------------------------------------------------------------------------|----------------------------------------------------------------------------------------------------------------------------------|-----------------|
| <a href='https://github.com/folke/lazy.nvim'>folke/lazy.nvim</a>                                                         | Сучасний менеджер плагінів для Neovim                                                                                            |                 |
| <a href='https://github.com/neovim/nvim-lspconfig'>neovim/nvim-lspconfig</a>                                             | Конфігурації швидкого запуску для клієнта Nvim LSP                                                                               |                 |
| <a href='https://github.com/tamago324/nlsp-settings.nvim'>tamago324/nlsp-settings.nvim</a>                               | Плагін для налаштування Neovim LSP за допомогою JSON або YAML файлів                                                             |                 |
| <a href='https://github.com/jose-elias-alvarez/null-ls.nvim'>jose-elias-alvarez/null-ls.nvim</a>                         | Використовуйте Neovim як мовний сервер для впровадження діагностики LSP, дій з кодом та іншого через Lua                         |                 |
| <a href='https://github.com/williamboman/mason-lspconfig.nvim'>williamboman/mason-lspconfig.nvim</a>                     | Розширення до mason.nvim, яке полегшує використання lspconfig з mason.nvim                                                       |                 |
| <a href='https://github.com/williamboman/mason.nvim'>williamboman/mason.nvim</a>                                         | Легке встановлення та керування LSP-серверами, DAP-серверами, лінкерами та форматерами                                           |                 |
| <a href='https://github.com/folke/tokyonight.nvim'>folke/tokyonight.nvim</a>                                             | Чиста, темна тема Neovim                                                                                                         |                 |
| <a href='https://github.com/lunarvim/lunar.nvim'>lunarvim/lunar.nvim</a>                                                 | Кольорова схема LunarVim                                                                                                         |                 |
| <a href='https://github.com/Tastyep/structlog.nvim'>Tastyep/structlog.nvim</a>                                           | Структуроване ведення логів для nvim за допомогою Lua                                                                            |                 |
| <a href='https://github.com/nvim-lua/popup.nvim'>nvim-lua/popup.nvim</a>                                                 | [РОБОТА ТРИВАЄ] Реалізація Popup API з Vim у Neovim. Сподіваємося випустити по завершенню                                        |                 | | 
| <a href='https://github.com/nvim-lua/plenary.nvim'>nvim-lua/plenary.nvim</a>                                             | plenary: завершений; цілковитий; абсолютний; беззастережний. Всі функції lua я не хочу писати двічі                              |                 |
| <a href='https://github.com/nvim-telescope/telescope.nvim'>nvim-telescope/telescope.nvim</a>                             | Знаходьте, фільтруйте, переглядайте, вибирайте. Все на Lua, весь час                                                             | необов'язковий  |
| <a href='https://github.com/nvim-telescope/telescope-fzf-native.nvim'>nvim-telescope/telescope-fzf-native.nvim</a>       | FZF сортувальник для плагіна telescope, написаний на C                                                                           |                 |
| <a href='https://github.com/hrsh7th/nvim-cmp'>hrsh7th/nvim-cmp</a>                                                       | Плагін автодоповнення для neovim, написаний на Lua                                                                               |                 |
| <a href='https://github.com/rafamadriz/friendly-snippets'>rafamadriz/friendly-snippets</a>                               | Набір попередньо налаштованих зразків для різних мов                                                                             | необов'язковий  |
| <a href='https://github.com/L3MON4D3/LuaSnip'>L3MON4D3/LuaSnip</a>                                                       | Рушій фрагментів для Neovim, написаний на Lua                                                                                    |                 |
| <a href='https://github.com/hrsh7th/cmp-nvim-lsp'>hrsh7th/cmp-nvim-lsp</a>                                               | nvim-cmp для вбудованого LSP-клієнта neovim                                                                                      |                 |
| <a href='https://github.com/saadparwaiz1/cmp_luasnip'>saadparwaiz1/cmp_luasnip</a>                                       | Джерело завершення luasnip для nvim-cmp                                                                                          |                 |
| <a href='https://github.com/hrsh7th/cmp-buffer'>hrsh7th/cmp-buffer</a>                                                   | nvim-cmp джерело для буферних слів                                                                                               |                 |
| <a href='https://github.com/hrsh7th/cmp-path'>hrsh7th/cmp-path</a>                                                       | nvim-cmp джерело для шляхів                                                                                                      |                 |
| <a href='https://github.com/folke/neodev.nvim'>folke/neodev.nvim</a>                                                     | 💻 Налаштування init.lua та розробка плагінів з повною довідкою про підписи, документацією та завершенням для API nvim lua       |                 |
| <a href='https://github.com/windwp/nvim-autopairs'>windwp/nvim-autopairs</a>                                             | Автопари для neovim, написані на lua                                                                                             | необов'язковий  |
| <a href='https://github.com/nvim-treesitter/nvim-treesitter'>nvim-treesitter/nvim-treesitter</a>                         | Nvim Treesitter конфігурації та рівень абстракції                                                                                |                 |
| <a href='https://github.com/JoosepAlviste/nvim-ts-context-commentstring'>JoosepAlviste/nvim-ts-context-commentstring</a> | Плагін Neovim treesitter коментування поточного рядка                                                                            |                 |
| <a href='https://github.com/kyazdani42/nvim-tree.lua'>kyazdani42/nvim-tree.lua</a>                                       | Дерево файлового провідника для NeoVim, написане на Lua                                                                          | необов'язковий  |
| <a href='https://github.com/tamago324/lir.nvim'>tamago324/lir.nvim</a>                                                   | Файловий провідник Neovim                                                                                                        | необов'язковий  |
| <a href='https://github.com/lewis6991/gitsigns.nvim'>lewis6991/gitsigns.nvim</a>                                         | Інтеграція з Git для буферів                                                                                                     | необов'язковий  |
| <a href='https://github.com/folke/which-key.nvim'>folke/which-key.nvim</a>                                               | Відображає спливаюче вікно з можливими поєднаннями клавіш для команди, яку ви почали вводити                                     | необов'язковий  |
| <a href='https://github.com/numToStr/Comment.nvim'>numToStr/Comment.nvim</a>                                             | Розумний та потужний плагін коментарів для neovim. Підтримує treesitter, dot repeat, left-right/up-down motions, hooks, and more | необов'язковий  |
| <a href='https://github.com/ahmedkhalf/project.nvim'>ahmedkhalf/project.nvim</a>                                         | Чудове рішення для управління проектами для neovim                                                                               | необов'язковий  |
| <a href='https://github.com/nvim-tree/nvim-web-devicons'>nvim-tree/nvim-web-devicons</a>                                 | Lua `форк` vim-web-devicons для neovim                                                                                           | необов'язковий  |
| <a href='https://github.com/nvim-lualine/lualine.nvim'>nvim-lualine/lualine.nvim</a>                                     | Надзвичайно швидкий і простий у налаштуванні плагін для рядка статусу neovim, написаний на чистому Lua                           | необов'язковий  |
| <a href='https://github.com/SmiteshP/nvim-navic'>SmiteshP/nvim-navic</a>                                                 | winbar/statusline плагін, який показує поточний контекст коду                                                                    | необов'язковий  |
| <a href='https://github.com/akinsho/bufferline.nvim'>akinsho/bufferline.nvim</a>                                         | Стильна буферна лінія для Neovim                                                                                                 | необов'язковий  |
| <a href='https://github.com/mfussenegger/nvim-dap'>mfussenegger/nvim-dap</a>                                             | Клієнстька імплементація DA для Neovim (>= 0.5)                                                                                  | необов'язковий  |
| <a href='https://github.com/rcarriga/nvim-dap-ui'>rcarriga/nvim-dap-ui</a>                                               | Інтерфейс для nvim-dap, який забезпечує хорошу конфігурацію з коробки                                                            | необов'язковий  |
| <a href='https://github.com/goolord/alpha-nvim'>goolord/alpha-nvim</a>                                                   | Lua-привітання на кшталт vim-startify / dashboard-nvim                                                                           | необов'язковий  |
| <a href='https://github.com/akinsho/toggleterm.nvim'>akinsho/toggleterm.nvim</a>                                         | Плагін NeoVim на Lua для легкого керування кількома вікнами терміналу                                                            | необов'язковий  |
| <a href='https://github.com/b0o/schemastore.nvim'>b0o/schemastore.nvim</a>                                               | 🛍 JSON схеми для Neovim                                                                                                         |                 |
| <a href='https://github.com/RRethy/vim-illuminate'>RRethy/vim-illuminate</a>                                             | Виділіть слово під курсором за допомогою LSP, Tree-sitter або регулярних відступів                                               | необов'язковий  |
| <a href='https://github.com/lunarvim/onedarker.nvim'>lunarvim/onedarker.nvim</a>                                         | Натхненна Onedark кольорова схема написана на Lua                                                                                | необов'язковий  |
| <a href='https://github.com/lukas-reineke/indent-blankline.nvim'>lukas-reineke/indent-blankline.nvim</a>                 | Допоміжні лінії відступів Neovim                                                                                                 | необов'язковий  |
