---
sidebar_position: 3
---

# Користувацькі фрагменти

## Опис

Ви можете додавати власні фрагменти до LunarVim.

Спеціальні фрагменти можна визначити як json або lua.

### JSON-версія

Спочатку створіть папку: `~/.config/lvim/snippets/` поруч із вашим `config.lua`

Тоді вам потрібно принаймні 2 файли.

Перший файл описує, де знаходяться ваші фрагменти:

`package.json` :

```json
{
  "name": "nvim-snippets",
  "author": "authorname",
  "engines": {
    "vscode": "^1.11.0"
  },
  "contributes": {
    "snippets": [
      {
        "language": "python",
        "path": "./python.json"
      }
    ]
  }
}
```

Для кожної мови створіть такий файл:

`python.json` :

```json
{
  "hello": {
    "prefix": "hello",
    "body": ["print('Hello, World!')"],
    "description": "print Hello, World!"
  }
}
```

ви повинні мати можливість розгорнути `hello` на `print("hello, world!")`

### Lua-версія

Спочатку створіть папку з назвою `luasnippets` поруч із вашим `config.lua`. Наприклад `~/.config/lvim/luasnippets/`

Потім у цій папці створіть файл lua з назвою типу файлу, для якого ви хочете створити фрагменти. Наприклад, щоб створити фрагменти для lua, створіть (зайвий, але правильний) файл під назвою `lua.lua`. Потім ви розмістите туди свої файли так:

```lua
return {
	s("foo", { t("Expands to bar") }),
}
```

LuaSnip може зробити гаряче перезавантажування фрагментів, визначених в lua, коли ви їх зберігаєте, але вам може знадобитися перезапустити LunarVim під час першого створення файлів фрагментів.
Будь ласка, зверніть увагу, що LuaSnip додає купу службових глобальних даних, коли він завантажує ваші фрагменти (у цьому прикладі функції `s` і `t`), тому вам не потрібно піклуватися про їхні огошення або визначення. Для отримання детальнішої інформації та прикладів, прочитайте [документацію LuaSnip на цю тему](https://github.com/L3MON4D3/LuaSnip/blob/master/DOC.md#lua)

### TODO: snipmate-версія
