---
sidebar_position: 3
---

# Огляд прив'язок клавіш

Тут наведено огляд найпоширеніших прив'язок клавіш.
Це не повний список, ви можете знайти більше, натиснувши `<leader>sk` для пошуку,
або `<leader>`, щоб показати, з якою клавішею (спливаюче вікно зв'язок клавіш)

Також перегляньте:
[vim mappings](https://devhints.io/vim)

**Підказка:** `<leader>` це типово пробіл, прочитайте [`:help keycodes`](https://neovim.io/doc/user/intro.html#keycodes)
для отримання додаткових імен клавіш
**Підказка:** `<M>` це `alt` на Windows/Linux та `option` на macOS

**Підказка:** Для користувачів macOS: щоб клавіша `option` (`⌥`) працювала як `<M>`, вам може знадобитися змінити деякі
налаштування:

- Для iTerm2: Виберіть `Esc+` як параметр клавіші Option
  у [ Параметри - Профілі - Клавіші ](https://github.com/LunarVim/lunarvim.org/pull/377#discussion_r1140747022)
- Для Alacritty: Переконайтеся, що у вас версія Alacritty >= 0.12.0. У файлі конфігурації `alacritty.yml` встановіть для
  параметра `window.option_as_alt` значення `Both` або `OnlyLeft` \ `OnlyRight` відповідно до ваших
  уподобань (https://github.com/alacritty/alacritty/issues/62).

**Підказка:** Нелідерні сполучення клавіш (наприклад, `<C-\>`, згадані нижче та інші) можна переглянути
натиснувши `<backspace>` у головному меню which-key (перше спливне вікно після натискання `<leader>`)

## Плагіни

| клавіші                       | опис                                                                                                                     | режим      |
|-------------------------------|--------------------------------------------------------------------------------------------------------------------------|------------|
| `<leader>`                    | [whichkey](https://github.com/folke/which-key.nvim) (спливаюче вікно з прив'язками клавіш (з'являється через 1 секунду)) | нормальний |
| `<leader>e`                   | [nvimtree](https://github.com/nvim-tree/nvim-tree.lua) (бічний файловий провідник)                                       | нормальний |
| `<leader>f` `<leader>s`(menu) | [telescope](https://github.com/nvim-telescope/telescope.nvim) (знайти файли, текст та більше)                            | нормальний |
| `<leader>;`                   | [alpha](https://github.com/goolord/alpha-nvim) (інформаційна панель)                                                     | нормальний |
| `<C-\>` `<M-1/2/3>`           | [toggleterm](https://github.com/akinsho/toggleterm.nvim) (термінал)                                                      | нормальний |

## LSP

| клавіші | опис                                                                | режим      |
|---------|---------------------------------------------------------------------|------------|
| `K`     | інформація при наведення (двічі натисніть, щоб потрапити всередину) | нормальний |
| `KK`    | перемістит курсор всередину вікна `K`                               | нормальний |
| `gd`    | перейти до визначення                                               | нормальний |
| `gD`    | перейти до оголошення                                               | нормальний |
| `gr`    | go to references                                                    | нормальний |
| `gI`    | перейти до імплементації                                            | нормальний |
| `gs`    | show signature help                                                 | нормальний |
| `gl`    | показати лінію діагностики                                          | нормальний |
| `glgl`  | перемістити курсор всередину `gl` діагностичного вікна              | нормальний |

## Редагування

| клавіші     | опис                              | режим                  |
|-------------|-----------------------------------|------------------------|
| `<leader>/` | закоментувати                     | нормальний, візуальний |
| `gb`        | закоментувати блок                | візуальний             |
| `<M-k>`     | перемістити лінію або лінії вгору | нормальний, візуальний |
| `<M-j>`     | перемістити лінію або лінії вниз  | нормальний, візуальний |

## Completion

| клавіші                    | опис                                         | режим      |
|----------------------------|----------------------------------------------|------------|
| `<C-space>`                | показати меню автозавершення                 | вставлення |
| `<CR>` `<C-y>`             | підтвердити                                  | вставлення |
| `<C-e>`                    | скасувати                                    | вставлення |
| `<C-k>` `<Up>` `<Tab>`     | вибрати попередній предмет                   | вставлення |
| `<C-j>` `<Down>` `<S-Tab>` | вибрати наступний предмет                    | вставлення |
| `<C-d>`                    | прокрутити докуменацію вгору                 | вставлення |
| `<C-f>`                    | прокрутити документацію вниз                 | вставлення |
| `<CR>` `<Tab>`             | перейти до наступного переходу у фрагменті   | вставлення |
| `<S-Tab>`                  | перейти до попереднього переходу у фрагменті | вставлення |

## Вікна

| клавіші     | опис                   | режим      |
|-------------|------------------------|------------|
| `<C-h>`     | перейти в ліве вікно   | нормальний |
| `<C-j>`     | перейти в нижнє вікно  | нормальний |
| `<C-k>`     | перейти в верхнє вікно | нормальний |
| `<C-l>`     | перейти в праве вікно  | нормальний |
| `<C-Up>`    | зменшити висоту вікна  | нормальний |
| `<C-Down>`  | збільшити висоту вікна | нормальний |
| `<C-Left>`  | зменшити ширину вікна  | нормальний |
| `<C-Right>` | збільшити ширину вікна | нормальний |

## Різне

| клавіші      | опис                         | режим      |
|--------------|------------------------------|------------|
| `<leader>Lc` | редагувати config.lua        | нормальний |
| `<leader>h`  | очистити підсвітку пошуку    | нормальний |
| `<leader>sh` | шукати в `:help`             | нормальний |
| `<leader>sr` | відкрити нещодавні файли     | нормальний |
| `<leader>pS` | список встановлених плагінів | нормальний |

## [nvimtree](https://github.com/nvim-tree/nvim-tree.lua) (бічний файловий провідник)

`g?` показати сполучення клавіш 
