﻿// Copyright (c) LumexUI 2024
// LumexUI licenses this file to you under the MIT license
// See the license here https://github.com/LumexUI/lumexui/blob/main/LICENSE

namespace LumexUI.Common;

/// <summary>
/// Specifies the selection mode for a component.
/// </summary>
public enum SelectionMode
{
    /// <summary>
    /// No selection is allowed.
    /// </summary>
    None,

    /// <summary>
    /// Single item selection is allowed.
    /// </summary>
    Single,

    /// <summary>
    /// Multiple items selection is allowed.
    /// </summary>
    Multiple
}