/**
 * @file      communication_field_test.cpp
 *
 * @brief     Implementation of the communication field test interface.
 *
 * Revised BSD License
 * Copyright Semtech Corporation 2020. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of the Semtech corporation nor the
 *       names of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL SEMTECH CORPORATION BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "communication_field_test.h"
#include "field_test_log.h"

CommunicationFieldTest::CommunicationFieldTest( Hci* hci ) : hci( hci ) {}

CommunicationFieldTest::~CommunicationFieldTest( ) {}

void CommunicationFieldTest::Init( ) { this->hci->Start( ); }

void CommunicationFieldTest::DeInit( ) { this->hci->Stop( ); }

void CommunicationFieldTest::Runtime( ) { this->hci->Runtime( ); }

void CommunicationFieldTest::Store( const demo_wifi_scan_all_results_t& wifi_results ) { return; }

void CommunicationFieldTest::Store( const demo_gnss_all_results_t& gnss_results, uint32_t delay_since_capture )
{
    return;
}

void CommunicationFieldTest::Store( const version_handler_t& version ) { return; }

void CommunicationFieldTest::EraseDataStored( ) { return; }

void CommunicationFieldTest::SendDataStoredToServer( ) { return; }

bool CommunicationFieldTest::GetDateAndApproximateLocation( uint32_t& gps_second, float& latitude, float& longitude,
                                                            float& altitude )
{
    return false;
}

bool CommunicationFieldTest::GetResults( float& latitude, float& longitude, float& altitude, float& accuracy,
                                         char* geo_coding, const uint8_t geo_coding_max_length )
{
    return false;
}

void CommunicationFieldTest::vLog( const char* fmt, va_list argp )
{
    FieldTestLog::GetOrCreateInstance( *this->hci )->vTrySendLog( fmt, argp );
}

void CommunicationFieldTest::EventNotify( ) { this->hci->EventNotify( ); }

bool CommunicationFieldTest::HasNewCommand( ) const { return this->hci->HasNewCommand( ); }

CommandInterface* CommunicationFieldTest::FetchCommand( ) { return this->hci->FetchCommand( ); }
