# Contributing

Thank you for considering contributing to Project Evoli! We welcome any contributions that can enhance the project and make it even better. To ensure a smooth collaboration, please follow the guidelines below.

## Code of Conduct

In order to create a positive and inclusive environment, we adhere to a Code of Conduct. We expect all contributors to follow these guidelines when participating in the project. Please be respectful and considerate towards others. If you encounter any inappropriate behavior, please report it to the project team at [pinkyhax@gmail.com]. We will review and take appropriate action.

## Pull Request Process

If you would like to contribute to Project Evoli, please follow these steps:

1. Before making any changes, discuss the proposed changes with the project owners. You can do this by opening an issue, sending an email, or using any other method of communication.
2. Fork the repository and create a new branch for your feature or bug fix.
3. Make your changes, ensuring that you adhere to the coding style and conventions of the project.
4. Update the README.md file to include details of your changes. This should include any new environment variables, exposed ports, useful file locations, or any other relevant information.
5. If applicable, update the version numbers in relevant files and the README.md according to the [SemVer](http://semver.org/) versioning scheme.
6. Ensure that your changes do not introduce any new issues and that all existing tests pass successfully.
7. Submit a pull request, providing a clear and concise description of the changes you made. If your changes address any open issues, please reference them in the pull request.
8. Your pull request will be reviewed by the project maintainers. They may request additional changes or provide feedback. Be responsive to any feedback and make the necessary adjustments.
9. Once your pull request is approved, it will be merged into the main repository. Congratulations on your contribution!

## Scope

This Code of Conduct applies to all interactions within the project, whether in project spaces or in public spaces. This includes discussions, comments, commits, code, documentation, issues, pull requests, and any other contributions.

## Enforcement

Instances of abusive, harassing, or otherwise unacceptable behavior may be reported by contacting the project team at [pinkyhax@gmail.com]. All complaints will be reviewed and investigated promptly. The project team is committed to maintaining confidentiality and will respect the privacy of the reporter. Enforcement actions will be taken as deemed necessary and appropriate.

Project maintainers who do not follow or enforce the Code of Conduct may face temporary or permanent consequences as determined by other members of the project's leadership.

## Attribution

This Code of Conduct is adapted from the [Contributor Covenant][homepage], version 1.4, available at [http://contributor-covenant.org/version/1/4][version].

[homepage]: http://contributor-covenant.org
[version]: http://contributor-covenant.org/version/1/4

We appreciate your contributions and thank you for your support in making Project Evoli a better tool.
