# Theme Guidelines

Use the following guidelines for selecting a theme song. Most of these rules are not 100% absolute, but they
are used as a general guideline for selecting and approving themes.

## Theme Length

| Length             | Grade |
|--------------------|-------|
| 0:30-1:00          | A     |
| 1:01-2:00          | B     |
| 2:01-2:45          | C     |
| 2:46-5:00          | D     |
| < 0:30 *or* > 5:00 | F     |

> [!NOTE]
> These are not strict rules, but the preference is to generally avoid themes that are too short or too long.

## Volume

Themes should have noticeable audio within the first 15 seconds. Themes that start with a slow fade-in are not
preferred.

## Age Restrictions

YouTube restricts videos based on age. If the video is not available to users under the age of 18, it will not be
approved.

> [!NOTE]
> This rule is absolute.

## Geo Restrictions

YouTube restricts videos in some geographical locations. If the video is not available in the United States, it will
not be approved.

> [!NOTE]
> This rule is absolute.

## Replacing Existing Themes

A theme can be replaced by submitting a new "issue". If you are replacing an existing theme, please leave a comment on
the issue to let us know the reasoning behind the change.

You can view and search the existing themes at [ThemerrDB](https://app.lizardbyte.dev/ThemerrDB).

## Miscellaneous

- Theme videos should NOT be an actual scene from the movie or game.
- Themes should be representative of the movie or game.
- Themes should ideally NOT be from the opening sequence of the movie.
- Themes should NOT contain racial slurs.
