# Contributing Guide

Contributions are welcome from anyone interested in improving this project, and there are multiple ways you can contribute that we will explain in detail. We know that working on Litlyx can be intimidating at first, so you can contact us and talk with the team on [Discord](https://discord.com/invite/9cQykjsmWX).

## Contributing - Code 🧑‍💻

Take a look at the [issues tab](https://github.com/litlyx/litlyx/issues) and look for those labeled with `help wanted`. 

Please ensure that you are familiar with the technology we used in this project where it applies to your code. The technology stack used in this project includes:

- [TypeScript](https://www.typescriptlang.org)
- [Nuxt](https://nuxt.com)
- [Vue](https://vuejs.org/)
- [Tailwind CSS](https://tailwindcss.com/)
- [Mintlify](https://mintlify.com/)

## Contributing - Ideas 💫

If you have an **Idea** or just want to share a thought with us, open a [Discussion](https://github.com/orgs/Litlyx/discussions) to discuss the changes that you would like to make or implement yourself contributing to this project.

## Contributing - Documentation 📚

We are changing our documentation. We decided to use [Mintlify](https://mintlify.com/). 
In the future, we will need help in these areas:

- Use Cases
- Community Libraries
- General Documentation
- Improvements in Design

## Code of Conduct 👮‍♀️

Please read our [Code of Conduct](CODE_OF_CONDUCT.md). By participating in this project, you agree to follow and accept these terms.

## License 👩‍⚖️

By contributing to this project, you agree that your contributions will be licensed under the [Apache License 2.0](LICENSE).

## Discord

If you want to interact with the team behind Litlyx (Founding Team) join our [Discord](https://discord.com/invite/9cQykjsmWX).

## Note

Note that this file can change multiple times based on the needs of the project in future phases. If you decide to contribute, always keep an eye on this file.

Thank you for your interest in contributing to this project!
