# MakeoverMonday Learning Project

[MakeoverMonday](https://www.makeovermonday.co.uk/) is a data viz challenge aimed at the Tableau community. Every week, a new chart is shared including its underlying data set. Data viz pracitioners are then tasked to think about what works and what could be improved in the original. And then come up with a better solution using the Tableau dashboard software. 

I decided to use this challenge as a way to improve my data viz skills using different tools:

- [Matplotlib](https://matplotlib.org/), a charting library for python, 
- [D3](https://d3js.org/), an interactive charting library based on javascript. 
- [Tableau](https://public.tableau.com/app/profile/lisa.hornung7353)

It means that I don't have to come up with new project ideas for myself all the time as well as source suitable data sets and clean them. 

This weekly challenges makes it a more contained task that is easier to finish, so that I can focus more on picking up some new technical skills in the different charting library. 

So when looking through my creations, don't expect any amazing solutions just yet. 

## 2021

### Week 12

Easy start experimenting with matplotlib. Tried to recreate the original chart but added secondary axis to show trendline for total personal spending as comparison. Final chart [here](https://github.com/Lisa-Ho/makeover-monday/blob/main/20210321/final-chart.png). I also had a go at creating a chart in D3 but didn't get to finalise it.

### Week 16

Decided to start exploring Tableau a bit and had a go at creating my first dashboard for week 16. Inspiration from [Taylor Johnson](https://twitter.com/TF_Johnston/status/1384518109617430535?s=20). Final result [here](https://public.tableau.com/profile/lisa.hornung7353#!/vizhome/MakeoverMonday-2021-W16/Dashboard).

### Week 19

Second Tableau data viz trying to replicate [this dashboard](https://public.tableau.com/profile/priyanka.dobhal0993#!/vizhome/MakeoverMonday2021Week19-WhatDoes1GBofMobileDataCostinEveryCountry_16216222730720/MOM2021W19) made by Priyanka Dobhal. I learned how to create a beeswarm chart and how to highlight individual data points using a dropdown list. Interactive version [here](https://public.tableau.com/profile/lisa.hornung7353#!/vizhome/MakeoverMonday-2021-W19/Dashboard1).

### Week 22

Third Tableau data viz looking into single plastic producers. Spent a bit more time with design elements and am quite pleased with the end result. Interactive version [here](https://public.tableau.com/app/profile/lisa.hornung7353/viz/MakeoverMonday-2021-W22/Dashboard1). 
![makeovermonday-2021-w22-final](https://user-images.githubusercontent.com/50448656/154820433-1750780f-6ec4-4350-85b3-61ee9dcebae0.PNG)

## 2020

### Week 1

Revived this repository and had a go at week 1 for 2020. Final chart made in matplotlib is using a complex layout of subplots and small multiples with highlights. Super grateful for the amazing guides posted on the [Python Gallery](https://www.python-graph-gallery.com/web-highlighted-lineplot-with-faceting). Still lots to learn ...

![final-chart](https://user-images.githubusercontent.com/50448656/154820316-5d7aa899-d6d1-4091-aa6c-b1c37d8feffc.png)

### Week 2

Quick chart in Python trying a new library to create waffle charts ([pywaffle](https://pywaffle.readthedocs.io/en/latest/index.html)). Also found a good [tutorial](https://regenerativetoday.com/how-to-build-waffle-charts-in-python/) for creating waffle charts using only matplotlib, pandas and numpy. 

![MakeoverMonday2020W02_use-of-pesticides-USA](https://user-images.githubusercontent.com/50448656/154856274-c1487ffa-1b6e-4161-9ea9-6d8ec254be46.png)

### Week 3

Multiple bar chart in python looking at sugar calorie intake by age group, includes benchmark annotation and arrow pointer. Started exploring [streamlit](https://streamlit.io/) for publishing interactive version of this chart that would allow displaying data by gender. A todo for another day ....

![MakeoverMonday2020W03_sugar-calorie-intake](https://user-images.githubusercontent.com/50448656/155895565-568669c4-304c-438a-85c7-e1e4c387bd1b.png)

### Week 5

Quick one in python looking at who the next James Bond should be by Brexit votes. Used the opportunity to create my first dumbell plot in matplotlib. With a bit more time, I might have added some James Bond design elements, but tried to keep this to 1 hour.

![MakeoverMonday2020W05_brexit-bond](https://user-images.githubusercontent.com/50448656/156924672-cbf65a87-2509-4d7c-a6b6-0d11a4a5208a.png)

Update: Spend a bit more time experimenting adding images to plots. Now shows the 007 logo in the title.

![MakeoverMonday2020W05_brexit-bond](https://user-images.githubusercontent.com/50448656/158057502-54aa3cea-2bf2-45d7-a25e-488b323b03fb.png)


### Week 6

Getting better at adding annotations, found a way of adding fancy arrows with curves and added a custom font (Raleway). This weeks chart looks at how much proportion of people's life is spend with US being at war. Depressing to see that America has been at war for so many years. 

![MakeoverMonday2020W06_US-at-war](https://user-images.githubusercontent.com/50448656/158071933-d127fbe7-0fea-4197-86b1-ee315f397749.png)


