/*
 * Copyright (c) 2007, 2008, 2016, ETH Zurich.
 * All rights reserved.
 *
 * This file is distributed under the terms in the attached LICENSE file.  If
 * you do not find this file, copies can be found by writing to: ETH Zurich
 * D-INFK, Universitaetstrasse 6, CH-8092 Zurich. Attn: Systems Group.
 */

OUTPUT_FORMAT("elf64-littleaarch64")
OUTPUT_ARCH("aarch64")

ENTRY(start)

PHDRS {
    load PT_LOAD ;
    dynamic PT_DYNAMIC ;
}

SECTIONS {
    /* This is a relocatable executable, its actual link address is
     * irrelevant. */
    . = 0x0;
    
    .text : { *(.text); } :load
    .rodata . : { *(.rodata); }
    .data . : { *(.data); }
    .bss . : { *(.bss); }
    /* The linker also spits out a useless GOT and PLT, with nothing in
     * them.  Unfortunately, we can't discard them without the linker
     * complaining about it.  We just waste 32B, and forget about them. */
    .got . : { *(.got); }
    .got.plt . : { *(.got.plt); }
    .rela.dyn . : { *(.rela.dyn); }

    .dynamic . : { *(.dynamic); } :load :dynamic


    /* These sections get discarded */
    /DISCARD/ :
    {
        /* The interpreter section will ask for ld.so, which is wrong. */
        *(.interp);

        /* The dynamic symbol table generated by the linker just has section
         * addresses in it - we don't need it. */
        *(.dynsym);
        *(.dynstr);
        *(.hash);
        *(.note.gnu.build-id);
    }
}
