/*-
 * Copyright (c) 2010 Jilles Tjoelker
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#include <sys/cdefs.h>
__FBSDID("$FreeBSD$");

#include <sys/param.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include "fnmatch_testcases.h"

static int
write_sh_tests(const char *progname, int num)
{
	size_t i;
	struct testcase *t;

	printf("# Generated by %s -s %d, do not edit.\n", progname, num);
	printf("# $" "FreeBSD$\n");
	printf("failures=\n");
	printf("failed() { printf '%%s\\n' \"Failed: $1 '$2' '$3'\"; failures=x$failures; }\n");
	if (num == 1) {
		printf("testmatch() { eval \"case \\$2 in ''$1) ;; *) failed testmatch \\\"\\$@\\\";; esac\"; }\n");
		printf("testnomatch() { eval \"case \\$2 in ''$1) failed testnomatch \\\"\\$@\\\";; esac\"; }\n");
	} else if (num == 2) {
		printf("# We do not treat a backslash specially in this case,\n");
		printf("# but this is not the case in all shells.\n");
		printf("netestmatch() { case $2 in $1) ;; *) failed netestmatch \"$@\";; esac; }\n");
		printf("netestnomatch() { case $2 in $1) failed netestnomatch \"$@\";; esac; }\n");
	}

	for (i = 0; i < nitems(testcases); i++) {
		t = &testcases[i];
		if (strchr(t->pattern, '\'') != NULL ||
		    strchr(t->string, '\'') != NULL)
			continue;
		if (t->flags == 0 && strcmp(t->pattern, "\\") == 0)
			continue;
		if (num == 1 && t->flags == 0)
			printf("test%smatch '%s' '%s'\n",
			    t->result == FNM_NOMATCH ? "no" : "",
			    t->pattern, t->string);
		if (num == 2 && (t->flags == FNM_NOESCAPE ||
		    (t->flags == 0 && strchr(t->pattern, '\\') == NULL)))
			printf("netest%smatch '%s' '%s'\n",
			    t->result == FNM_NOMATCH ? "no" : "",
			    t->pattern, t->string);
	}
	printf("[ -z \"$failures\" ]\n");
	return 0;
}

static void
usage(char *progname)
{
	fprintf(stderr, "usage: %s [-s num]\n", progname);
	fprintf(stderr, "-s option writes tests for sh(1), num is 1 or 2\n");
}

int
main(int argc, char *argv[])
{
	int opt;

	while ((opt = getopt(argc, argv, "s:")) != -1) {
		switch (opt) {
		case 's':
			return (write_sh_tests(argv[0], atoi(optarg)));
		default:
			usage(argv[0]);
			exit(1);
		}
	}
	usage(argv[0]);
	exit(1);
}
