/*-
 * Copyright (c) 2015 Ruslan Bukin <br@bsdpad.com>
 * All rights reserved.
 *
 * Portions of this software were developed by SRI International and the
 * University of Cambridge Computer Laboratory under DARPA/AFRL contract
 * FA8750-10-C-0237 ("CTSRD"), as part of the DARPA CRASH research programme.
 *
 * Portions of this software were developed by the University of Cambridge
 * Computer Laboratory as part of the CTSRD Project, with support from the
 * UK Higher Education Innovation Fund (HEIF).
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#include <machine/asm.h>
__FBSDID("$FreeBSD$");

#include <machine/setjmp.h>

ENTRY(_setjmp)
	/* Store the magic value and stack pointer */
	la	t0, .Lmagic
	ld	t0, 0(t0)
	sd	t0, (0 * 8)(a0)
	sd	sp, (1 * 8)(a0)
	addi	a0, a0, (2 * 8)

	/* Store the general purpose registers and ra */
	sd	s0, (0 * 8)(a0)
	sd	s1, (1 * 8)(a0)
	sd	s2, (2 * 8)(a0)
	sd	s3, (3 * 8)(a0)
	sd	s4, (4 * 8)(a0)
	sd	s5, (5 * 8)(a0)
	sd	s6, (6 * 8)(a0)
	sd	s7, (7 * 8)(a0)
	sd	s8, (8 * 8)(a0)
	sd	s9, (9 * 8)(a0)
	sd	s10, (10 * 8)(a0)
	sd	s11, (11 * 8)(a0)
	sd	ra, (12 * 8)(a0)
	addi	a0, a0, (13 * 8)

#ifndef _STANDALONE
#if 0
	/* RISCVTODO */
	/* Store the vfp registers */
	fsq	fs0, (0 * 16)(a0)
	fsq	fs1, (1 * 16)(a0)
	fsq	fs2, (2 * 16)(a0)
	fsq	fs3, (3 * 16)(a0)
	fsq	fs4, (4 * 16)(a0)
	fsq	fs5, (5 * 16)(a0)
	fsq	fs6, (6 * 16)(a0)
	fsq	fs7, (7 * 16)(a0)
	fsq	fs8, (8 * 16)(a0)
	fsq	fs9, (9 * 16)(a0)
	fsq	fs10, (10 * 16)(a0)
	fsq	fs11, (11 * 16)(a0)
	addi	a0, a0, (12 * 16)
#endif
#endif

	/* Return value */
	li	a0, 0
	ret
	.align	3
.Lmagic:
	.quad	_JB_MAGIC__SETJMP
END(_setjmp)

ENTRY(_longjmp)
	/* Check the magic value */
	ld	t0, 0(a0)
	la	t1, .Lmagic
	ld	t1, 0(t1)
	bne	t0, t1, botch

	/* Restore the stack pointer */
	ld	t0, 8(a0)
	mv	sp, t0
	addi	a0, a0, (2 * 8)

	/* Restore the general purpose registers and ra */
	ld	s0, (0 * 8)(a0)
	ld	s1, (1 * 8)(a0)
	ld	s2, (2 * 8)(a0)
	ld	s3, (3 * 8)(a0)
	ld	s4, (4 * 8)(a0)
	ld	s5, (5 * 8)(a0)
	ld	s6, (6 * 8)(a0)
	ld	s7, (7 * 8)(a0)
	ld	s8, (8 * 8)(a0)
	ld	s9, (9 * 8)(a0)
	ld	s10, (10 * 8)(a0)
	ld	s11, (11 * 8)(a0)
	ld	ra, (12 * 8)(a0)
	addi	a0, a0, (13 * 8)

#ifndef _STANDALONE
#if 0
	/* RISCVTODO */
	/* Restore the vfp registers */
	flq	fs0, (0 * 16)(a0)
	flq	fs1, (1 * 16)(a0)
	flq	fs2, (2 * 16)(a0)
	flq	fs3, (3 * 16)(a0)
	flq	fs4, (4 * 16)(a0)
	flq	fs5, (5 * 16)(a0)
	flq	fs6, (6 * 16)(a0)
	flq	fs7, (7 * 16)(a0)
	flq	fs8, (8 * 16)(a0)
	flq	fs9, (9 * 16)(a0)
	flq	fs10, (10 * 16)(a0)
	flq	fs11, (11 * 16)(a0)
	addi	a0, a0, (12 * 16)
#endif
#endif

	/* Load the return value */
	mv	a0, a1
	ret

botch:
#ifdef _STANDALONE
	j	botch
#else
	call	_C_LABEL(longjmperror)
	call	_C_LABEL(abort)
#endif
END(_longjmp)
