/**
 * \file
 * \brief Kernel memory management.
 */

/*
 * Copyright (c) 2012 ETH Zurich.
 * All rights reserved.
 *
 * This file is distributed under the terms in the attached LICENSE file.
 * If you do not find this file, copies can be found by writing to:
 * ETH Zurich D-INFK, Universitaetstrasse 6, CH-8092 Zurich. Attn: Systems Group.
 */

#ifndef PAGING_H
#define PAGING_H

#include <aos/types.h>
#include <errors/errno.h>

struct mapping_info {
    lpaddr_t pte;       ///< where the capability is mapped
    size_t pte_count;   ///< the amount of PTEs mapped in this mapping
    uint64_t offset;    ///< the offset into the physical region identified by the capability where the mapping begins.
};

struct cte;
struct capability;
void create_mapping_cap(struct cte *mapping_cte, struct capability *cap,
                        struct cte *ptable, cslot_t entry, size_t pte_count);
errval_t compile_vaddr(struct cte *ptable, size_t entry, genvaddr_t *retvaddr);
errval_t unmap_capability(struct cte *mem);
errval_t paging_tlb_flush_range(struct cte *frame, size_t offset, size_t pages);

#endif // PAGING_H
