/**
 * \file coreboot.h
 * \brief boot new core
 */

/*
 * Copyright (c) 2020, ETH Zurich.
 * All rights reserved.
 *
 * This file is distributed under the terms in the attached LICENSE file.
 * If you do not find this file, copies can be found by writing to:
 * ETH Zurich D-INFK, Haldeneggsteig 4, CH-8092 Zurich. Attn: Systems Group.
 */

#ifndef LIBBARRELFISH_COREBOOT_H
#define LIBBARRELFISH_COREBOOT_H

#include <sys/cdefs.h>

__BEGIN_DECLS

/**
 * \brief Boot a core
 *
 * \param mpid          The ARM MPID of the core to be booted
 * \param boot_driver_name   Name of the boot driver binary
 * \param cpu_driver_name    Name of the CPU driver
 * \param init_binary_name          The name of the init binary
 * \param urpc_frame_id Description of what will be passed as URPC frame
 *
 */
errval_t coreboot(coreid_t mpid,
    const char *boot_driver_name,
    const char *cpu_driver_name,
    const char *init_binary_name,
    struct frame_identity urpc_frame_id
);

errval_t forge_bootinfo_ram(struct bootinfo *bootinfo);

errval_t forge_bootinfo_capabilities(
    struct bootinfo *bootinfo,
    struct capref cap_mmstrings_frame
);

__END_DECLS

#endif
