/*
 * Copyright 2015 - 2022 TU Dortmund
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import { Component, OnInit } from '@angular/core';
import { ProjectEnvironmentsViewStoreService } from './project-environments-view-store.service';

@Component({
  selector: 'project-environments-view',
  templateUrl: './project-environments-view.component.html',
  styleUrls: ['./project-environments-view.component.scss'],
  providers: [ProjectEnvironmentsViewStoreService]
})
export class ProjectEnvironmentsViewComponent implements OnInit {

  constructor(public store: ProjectEnvironmentsViewStoreService) {
  }

  ngOnInit() {
    this.store.load();
  }

  trackByIndex(index: number): number {
    return index;
  }
}
