/*
 * Copyright 2015 - 2022 TU Dortmund
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

export class ProjectUrl {
  id: number;
  environment: number;
  name: string;
  url: string;
  default: boolean;

  constructor() {
    this.url = 'http://';
    this.default = false;
  }

  static fromData(data: any): ProjectUrl {
    const u = new ProjectUrl();
    u.id = data.id;
    u.environment = data.environment;
    u.name = data.name;
    u.url = data.url;
    u.default = data.default;
    return u;
  }

  copy(): ProjectUrl {
    return ProjectUrl.fromData(JSON.parse(JSON.stringify(this)));
  }
}
