/*
 * Copyright 2015 - 2022 TU Dortmund
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package de.learnlib.alex.integrationtests.resources.api;

import com.fasterxml.jackson.databind.ObjectMapper;
import javax.ws.rs.client.Client;

public abstract class AbstractApi {

    protected final Client client;

    protected final ObjectMapper objectMapper;

    protected final int port;

    protected AbstractApi(Client client, int port) {
        this.client = client;
        this.port = port;
        this.objectMapper = new ObjectMapper();
    }

    protected String baseUrl() {
        return "http://localhost:" + port + "/rest";
    }
}
