/*
 * Copyright 2015 - 2022 TU Dortmund
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package de.learnlib.alex.data.entities.actions.web;

import static org.junit.jupiter.api.Assertions.assertEquals;
import static org.junit.jupiter.api.Assertions.assertFalse;
import static org.junit.jupiter.api.Assertions.assertThrows;
import static org.junit.jupiter.api.Assertions.assertTrue;

import de.learnlib.alex.data.entities.ExecuteResult;
import de.learnlib.alex.data.entities.Project;
import de.learnlib.alex.data.entities.Symbol;
import de.learnlib.alex.learning.services.connectors.ConnectorManager;
import de.learnlib.alex.learning.services.connectors.VariableStoreConnector;
import de.learnlib.alex.learning.services.connectors.WebSiteConnector;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.openqa.selenium.Alert;
import org.openqa.selenium.NoAlertPresentException;
import org.openqa.selenium.WebDriver;

public class AlertGetTextActionTest {

    private static final String VARIABLE_NAME = "var";

    private AlertGetTextAction action;

    private ConnectorManager connectors;

    private WebSiteConnector webSiteConnector;

    private VariableStoreConnector variableStore;

    private WebDriver.TargetLocator targetLocator;

    @BeforeEach
    public void before() {
        this.webSiteConnector = Mockito.mock(WebSiteConnector.class);
        this.variableStore = new VariableStoreConnector();

        this.connectors = Mockito.mock(ConnectorManager.class);
        Mockito.when(connectors.getConnector(WebSiteConnector.class)).thenReturn(this.webSiteConnector);
        Mockito.when(connectors.getConnector(VariableStoreConnector.class)).thenReturn(this.variableStore);

        final Project project = new Project(1L);
        final Symbol symbol = new Symbol();
        symbol.setId(1L);
        symbol.setProject(project);

        this.action = new AlertGetTextAction();
        this.action.setVariableName(VARIABLE_NAME);
        this.action.setSymbol(symbol);

        this.targetLocator = Mockito.mock(WebDriver.TargetLocator.class);

        final WebDriver wd = Mockito.mock(WebDriver.class);
        Mockito.when(wd.switchTo()).thenReturn(this.targetLocator);
        Mockito.when(this.webSiteConnector.getDriver()).thenReturn(wd);
    }

    @Test
    public void shouldStoreTextInVariableAndSucceed() {
        final Alert alert = Mockito.mock(Alert.class);
        Mockito.when(targetLocator.alert()).thenReturn(alert);
        Mockito.when(alert.getText()).thenReturn("test");

        final ExecuteResult result = action.executeAction(connectors);
        assertTrue(result.isSuccess());
        assertEquals("test", variableStore.get(VARIABLE_NAME));
    }

    @Test
    public void shouldFailWhenNoAlertIsPresent() {
        Mockito.when(targetLocator.alert()).thenThrow(new NoAlertPresentException());

        final ExecuteResult result = action.executeAction(connectors);
        assertFalse(result.isSuccess());
        assertThrows(IllegalStateException.class, () -> variableStore.get(VARIABLE_NAME));
    }

}
