-- create table for model checking configs
CREATE TABLE MODEL_CHECKING_CONFIG
(
    ID          BIGINT GENERATED BY DEFAULT AS IDENTITY,
    MIN_UNFOLDS INTEGER          NOT NULL,
    MULTIPLIER  DOUBLE PRECISION NOT NULL,

    PRIMARY KEY (ID)
);

-- associate model checking configs with learner setups
ALTER TABLE LEARNER_SETUP
    ADD COLUMN MODEL_CHECKING_CONFIG_ID BIGINT;

ALTER TABLE LEARNER_SETUP
    ADD CONSTRAINT FK_LEARNER_SETUP_MODEL_CHECKING_CONFIG
        FOREIGN KEY (MODEL_CHECKING_CONFIG_ID) REFERENCES MODEL_CHECKING_CONFIG;

-- create a model checking config for each learner setup
DO
$$
    DECLARE
        learnerSetupRecord RECORD;
        configId           BIGINT;
    BEGIN
        FOR learnerSetupRecord IN SELECT * FROM LEARNER_SETUP
            LOOP
                INSERT INTO MODEL_CHECKING_CONFIG (MIN_UNFOLDS, MULTIPLIER) VALUES (1, 0.1) RETURNING ID INTO configId;
                UPDATE LEARNER_SETUP SET MODEL_CHECKING_CONFIG_ID = configId WHERE ID = learnerSetupRecord.ID;
            END LOOP;
    END;
$$;

-- create association table for model checking config -> ltl formula suites
CREATE TABLE MODEL_CHECKING_CONFIG_FORMULA_SUITES
(
    MODEL_CHECKING_CONFIG_ID BIGINT NOT NULL,
    FORMULA_SUITES_ID        BIGINT NOT NULL,

    FOREIGN KEY (MODEL_CHECKING_CONFIG_ID) REFERENCES MODEL_CHECKING_CONFIG,
    FOREIGN KEY (FORMULA_SUITES_ID) REFERENCES LTS_FORMULA_SUITE
);

-- create table for model checking result
CREATE TABLE MODEL_CHECKING_RESULT
(
    ID         BIGINT GENERATED BY DEFAULT AS IDENTITY,
    FORMULA_ID BIGINT NOT NULL,
    PREFIX     TEXT[],
    LOOP       TEXT[],

    PRIMARY KEY (ID),
    FOREIGN KEY (FORMULA_ID) REFERENCES LTS_FORMULA
);

-- create association table for learner result step -> model checking results
CREATE TABLE LEARNER_RESULT_STEP_MODEL_CHECKING_RESULTS
(
    LEARNER_RESULT_STEP_ID    BIGINT NOT NULL,
    MODEL_CHECKING_RESULTS_ID BIGINT NOT NULL,

    FOREIGN KEY (LEARNER_RESULT_STEP_ID) REFERENCES LEARNER_RESULT_STEP,
    FOREIGN KEY (MODEL_CHECKING_RESULTS_ID) REFERENCES MODEL_CHECKING_RESULT
)