# coding: utf-8

"""
    Laserfiche Repository API

    Welcome to the Laserfiche API Swagger Playground. You can try out any of our API calls against your live Laserfiche Cloud account. Visit the developer center for more details: <a href=\"https://developer.laserfiche.com\">https://developer.laserfiche.com</a><p>Visit the changelog for the list of changes: <a href=\"/repository/v2/changelog\">/repository/v2/changelog</a></p><p><strong>Build# : </strong>41a7347c0662989661d7ab8105a70d36cb42518e_.20240124.4</p>  # noqa: E501

    OpenAPI spec version: 2
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from laserfiche_api.api_client import ApiClient


class TemplateDefinitionsApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def get_template_definition(self, repository_id, template_id, **kwargs):  # noqa: E501
        """Returns a single template definition object.  # noqa: E501

        - Returns a single template definition (including field definitions, if relevant). - Provide a template definition ID, and get the single template definition associated with that ID. Useful when a route provides a minimal amount of details, and more information about the specific template is needed. - Allowed OData query options: Select - Required OAuth scope: repository.Read  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_template_definition(repository_id, template_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str repository_id: The requested repository ID. (required)
        :param int template_id: The requested template definition ID. (required)
        :param str culture: An optional query parameter used to indicate the locale that should be used for formatting. The value should be a standard language tag.
        :param str select: Limits the properties returned in the result.
        :return: TemplateDefinition
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_template_definition_with_http_info(repository_id, template_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_template_definition_with_http_info(repository_id, template_id, **kwargs)  # noqa: E501
            return data

    def get_template_definition_with_http_info(self, repository_id, template_id, **kwargs):  # noqa: E501
        """Returns a single template definition object.  # noqa: E501

        - Returns a single template definition (including field definitions, if relevant). - Provide a template definition ID, and get the single template definition associated with that ID. Useful when a route provides a minimal amount of details, and more information about the specific template is needed. - Allowed OData query options: Select - Required OAuth scope: repository.Read  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_template_definition_with_http_info(repository_id, template_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str repository_id: The requested repository ID. (required)
        :param int template_id: The requested template definition ID. (required)
        :param str culture: An optional query parameter used to indicate the locale that should be used for formatting. The value should be a standard language tag.
        :param str select: Limits the properties returned in the result.
        :return: TemplateDefinition
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['repository_id', 'template_id', 'culture', 'select']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_template_definition" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'repository_id' is set
        if ('repository_id' not in params or
                params['repository_id'] is None):
            raise ValueError("Missing the required parameter `repository_id` when calling `get_template_definition`")  # noqa: E501
        # verify the required parameter 'template_id' is set
        if ('template_id' not in params or
                params['template_id'] is None):
            raise ValueError("Missing the required parameter `template_id` when calling `get_template_definition`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'repository_id' in params:
            path_params['repositoryId'] = params['repository_id']  # noqa: E501
        if 'template_id' in params:
            path_params['templateId'] = params['template_id']  # noqa: E501

        query_params = []
        if 'culture' in params:
            query_params.append(('culture', params['culture']))  # noqa: E501
        if 'select' in params:
            query_params.append(('$select', params['select']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Authorization', 'OAuth2 Authorization Code Flow']  # noqa: E501

        return self.api_client.call_api(
            '/v2/Repositories/{repositoryId}/TemplateDefinitions/{templateId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TemplateDefinition',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_template_definitions(self, repository_id, **kwargs):  # noqa: E501
        """Returns the template definitions associated with a repository.  # noqa: E501

        - Returns all template definitions (including field definitions) in the repository. If a template name query parameter is given, then a single template definition is returned. - Provide a repository ID, and get a paged listing of template definitions available in the repository. Useful when trying to find a list of all template definitions available, rather than a specific one. - Default page size: 100. Allowed OData query options: Select | Count | OrderBy | Skip | Top | SkipToken | Prefer. - Required OAuth scope: repository.Read  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_template_definitions(repository_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str repository_id: The requested repository ID. (required)
        :param str template_name: An optional query parameter. Can be used to get a single template definition using the template name.
        :param str prefer: An optional OData header. Can be used to set the maximum page size using odata.maxpagesize.
        :param str culture: An optional query parameter used to indicate the locale that should be used for formatting. The value should be a standard language tag.
        :param str select: Limits the properties returned in the result.
        :param str orderby: Specifies the order in which items are returned. The maximum number of expressions is 5.
        :param int top: Limits the number of items returned from a collection.
        :param int skip: Excludes the specified number of items of the queried collection from the result.
        :param bool count: Indicates whether the total count of items within a collection are returned in the result.
        :return: TemplateDefinitionCollectionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_template_definitions_with_http_info(repository_id, **kwargs)  # noqa: E501
        else:
            (data) = self.list_template_definitions_with_http_info(repository_id, **kwargs)  # noqa: E501
            return data

    def list_template_definitions_with_http_info(self, repository_id, **kwargs):  # noqa: E501
        """Returns the template definitions associated with a repository.  # noqa: E501

        - Returns all template definitions (including field definitions) in the repository. If a template name query parameter is given, then a single template definition is returned. - Provide a repository ID, and get a paged listing of template definitions available in the repository. Useful when trying to find a list of all template definitions available, rather than a specific one. - Default page size: 100. Allowed OData query options: Select | Count | OrderBy | Skip | Top | SkipToken | Prefer. - Required OAuth scope: repository.Read  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_template_definitions_with_http_info(repository_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str repository_id: The requested repository ID. (required)
        :param str template_name: An optional query parameter. Can be used to get a single template definition using the template name.
        :param str prefer: An optional OData header. Can be used to set the maximum page size using odata.maxpagesize.
        :param str culture: An optional query parameter used to indicate the locale that should be used for formatting. The value should be a standard language tag.
        :param str select: Limits the properties returned in the result.
        :param str orderby: Specifies the order in which items are returned. The maximum number of expressions is 5.
        :param int top: Limits the number of items returned from a collection.
        :param int skip: Excludes the specified number of items of the queried collection from the result.
        :param bool count: Indicates whether the total count of items within a collection are returned in the result.
        :return: TemplateDefinitionCollectionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['repository_id', 'template_name', 'prefer', 'culture', 'select', 'orderby', 'top', 'skip', 'count']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_template_definitions" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'repository_id' is set
        if ('repository_id' not in params or
                params['repository_id'] is None):
            raise ValueError("Missing the required parameter `repository_id` when calling `list_template_definitions`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'repository_id' in params:
            path_params['repositoryId'] = params['repository_id']  # noqa: E501

        query_params = []
        if 'template_name' in params:
            query_params.append(('templateName', params['template_name']))  # noqa: E501
        if 'culture' in params:
            query_params.append(('culture', params['culture']))  # noqa: E501
        if 'select' in params:
            query_params.append(('$select', params['select']))  # noqa: E501
        if 'orderby' in params:
            query_params.append(('$orderby', params['orderby']))  # noqa: E501
        if 'top' in params:
            query_params.append(('$top', params['top']))  # noqa: E501
        if 'skip' in params:
            query_params.append(('$skip', params['skip']))  # noqa: E501
        if 'count' in params:
            query_params.append(('$count', params['count']))  # noqa: E501

        header_params = {}
        if 'prefer' in params:
            header_params['Prefer'] = params['prefer']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Authorization', 'OAuth2 Authorization Code Flow']  # noqa: E501

        return self.api_client.call_api(
            '/v2/Repositories/{repositoryId}/TemplateDefinitions', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TemplateDefinitionCollectionResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_template_field_definitions_by_template_id(self, repository_id, template_id, **kwargs):  # noqa: E501
        """Returns the field definitions assigned to a template definition (by template definition ID).  # noqa: E501

        - Returns the field definitions assigned to a template definition. - Provide a template definition ID, and get a paged listing of the field definitions assigned to that template.  - Default page size: 100. Allowed OData query options: Select | Count | OrderBy | Skip | Top | SkipToken | Prefer. - Required OAuth scope: repository.Read  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_template_field_definitions_by_template_id(repository_id, template_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str repository_id: The requested repository ID. (required)
        :param int template_id: The requested template definition ID. (required)
        :param str prefer: An optional OData header. Can be used to set the maximum page size using odata.maxpagesize.
        :param str culture: An optional query parameter used to indicate the locale that should be used for formatting. The value should be a standard language tag.
        :param str select: Limits the properties returned in the result.
        :param str orderby: Specifies the order in which items are returned. The maximum number of expressions is 5.
        :param int top: Limits the number of items returned from a collection.
        :param int skip: Excludes the specified number of items of the queried collection from the result.
        :param bool count: Indicates whether the total count of items within a collection are returned in the result.
        :return: TemplateFieldDefinitionCollectionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_template_field_definitions_by_template_id_with_http_info(repository_id, template_id, **kwargs)  # noqa: E501
        else:
            (data) = self.list_template_field_definitions_by_template_id_with_http_info(repository_id, template_id, **kwargs)  # noqa: E501
            return data

    def list_template_field_definitions_by_template_id_with_http_info(self, repository_id, template_id, **kwargs):  # noqa: E501
        """Returns the field definitions assigned to a template definition (by template definition ID).  # noqa: E501

        - Returns the field definitions assigned to a template definition. - Provide a template definition ID, and get a paged listing of the field definitions assigned to that template.  - Default page size: 100. Allowed OData query options: Select | Count | OrderBy | Skip | Top | SkipToken | Prefer. - Required OAuth scope: repository.Read  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_template_field_definitions_by_template_id_with_http_info(repository_id, template_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str repository_id: The requested repository ID. (required)
        :param int template_id: The requested template definition ID. (required)
        :param str prefer: An optional OData header. Can be used to set the maximum page size using odata.maxpagesize.
        :param str culture: An optional query parameter used to indicate the locale that should be used for formatting. The value should be a standard language tag.
        :param str select: Limits the properties returned in the result.
        :param str orderby: Specifies the order in which items are returned. The maximum number of expressions is 5.
        :param int top: Limits the number of items returned from a collection.
        :param int skip: Excludes the specified number of items of the queried collection from the result.
        :param bool count: Indicates whether the total count of items within a collection are returned in the result.
        :return: TemplateFieldDefinitionCollectionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['repository_id', 'template_id', 'prefer', 'culture', 'select', 'orderby', 'top', 'skip', 'count']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_template_field_definitions_by_template_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'repository_id' is set
        if ('repository_id' not in params or
                params['repository_id'] is None):
            raise ValueError("Missing the required parameter `repository_id` when calling `list_template_field_definitions_by_template_id`")  # noqa: E501
        # verify the required parameter 'template_id' is set
        if ('template_id' not in params or
                params['template_id'] is None):
            raise ValueError("Missing the required parameter `template_id` when calling `list_template_field_definitions_by_template_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'repository_id' in params:
            path_params['repositoryId'] = params['repository_id']  # noqa: E501
        if 'template_id' in params:
            path_params['templateId'] = params['template_id']  # noqa: E501

        query_params = []
        if 'culture' in params:
            query_params.append(('culture', params['culture']))  # noqa: E501
        if 'select' in params:
            query_params.append(('$select', params['select']))  # noqa: E501
        if 'orderby' in params:
            query_params.append(('$orderby', params['orderby']))  # noqa: E501
        if 'top' in params:
            query_params.append(('$top', params['top']))  # noqa: E501
        if 'skip' in params:
            query_params.append(('$skip', params['skip']))  # noqa: E501
        if 'count' in params:
            query_params.append(('$count', params['count']))  # noqa: E501

        header_params = {}
        if 'prefer' in params:
            header_params['Prefer'] = params['prefer']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Authorization', 'OAuth2 Authorization Code Flow']  # noqa: E501

        return self.api_client.call_api(
            '/v2/Repositories/{repositoryId}/TemplateDefinitions/{templateId}/FieldDefinitions', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TemplateFieldDefinitionCollectionResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_template_field_definitions_by_template_name(self, repository_id, template_name, **kwargs):  # noqa: E501
        """Returns the field definitions assigned to a template definition (by template definition name).  # noqa: E501

        - Returns the field definitions assigned to a template definition. - Provide a template definition name, and get a paged listing of the field definitions assigned to that template.  - Default page size: 100. Allowed OData query options: Select | Count | OrderBy | Skip | Top | SkipToken | Prefer. - Required OAuth scope: repository.Read  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_template_field_definitions_by_template_name(repository_id, template_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str repository_id: The requested repository ID. (required)
        :param str template_name: A required query parameter for the requested template name. (required)
        :param str prefer: An optional OData header. Can be used to set the maximum page size using odata.maxpagesize.
        :param str culture: An optional query parameter used to indicate the locale that should be used for formatting. The value should be a standard language tag.
        :param str select: Limits the properties returned in the result.
        :param str orderby: Specifies the order in which items are returned. The maximum number of expressions is 5.
        :param int top: Limits the number of items returned from a collection.
        :param int skip: Excludes the specified number of items of the queried collection from the result.
        :param bool count: Indicates whether the total count of items within a collection are returned in the result.
        :return: TemplateFieldDefinitionCollectionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_template_field_definitions_by_template_name_with_http_info(repository_id, template_name, **kwargs)  # noqa: E501
        else:
            (data) = self.list_template_field_definitions_by_template_name_with_http_info(repository_id, template_name, **kwargs)  # noqa: E501
            return data

    def list_template_field_definitions_by_template_name_with_http_info(self, repository_id, template_name, **kwargs):  # noqa: E501
        """Returns the field definitions assigned to a template definition (by template definition name).  # noqa: E501

        - Returns the field definitions assigned to a template definition. - Provide a template definition name, and get a paged listing of the field definitions assigned to that template.  - Default page size: 100. Allowed OData query options: Select | Count | OrderBy | Skip | Top | SkipToken | Prefer. - Required OAuth scope: repository.Read  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_template_field_definitions_by_template_name_with_http_info(repository_id, template_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str repository_id: The requested repository ID. (required)
        :param str template_name: A required query parameter for the requested template name. (required)
        :param str prefer: An optional OData header. Can be used to set the maximum page size using odata.maxpagesize.
        :param str culture: An optional query parameter used to indicate the locale that should be used for formatting. The value should be a standard language tag.
        :param str select: Limits the properties returned in the result.
        :param str orderby: Specifies the order in which items are returned. The maximum number of expressions is 5.
        :param int top: Limits the number of items returned from a collection.
        :param int skip: Excludes the specified number of items of the queried collection from the result.
        :param bool count: Indicates whether the total count of items within a collection are returned in the result.
        :return: TemplateFieldDefinitionCollectionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['repository_id', 'template_name', 'prefer', 'culture', 'select', 'orderby', 'top', 'skip', 'count']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_template_field_definitions_by_template_name" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'repository_id' is set
        if ('repository_id' not in params or
                params['repository_id'] is None):
            raise ValueError("Missing the required parameter `repository_id` when calling `list_template_field_definitions_by_template_name`")  # noqa: E501
        # verify the required parameter 'template_name' is set
        if ('template_name' not in params or
                params['template_name'] is None):
            raise ValueError("Missing the required parameter `template_name` when calling `list_template_field_definitions_by_template_name`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'repository_id' in params:
            path_params['repositoryId'] = params['repository_id']  # noqa: E501

        query_params = []
        if 'template_name' in params:
            query_params.append(('templateName', params['template_name']))  # noqa: E501
        if 'culture' in params:
            query_params.append(('culture', params['culture']))  # noqa: E501
        if 'select' in params:
            query_params.append(('$select', params['select']))  # noqa: E501
        if 'orderby' in params:
            query_params.append(('$orderby', params['orderby']))  # noqa: E501
        if 'top' in params:
            query_params.append(('$top', params['top']))  # noqa: E501
        if 'skip' in params:
            query_params.append(('$skip', params['skip']))  # noqa: E501
        if 'count' in params:
            query_params.append(('$count', params['count']))  # noqa: E501

        header_params = {}
        if 'prefer' in params:
            header_params['Prefer'] = params['prefer']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Authorization', 'OAuth2 Authorization Code Flow']  # noqa: E501

        return self.api_client.call_api(
            '/v2/Repositories/{repositoryId}/TemplateDefinitions/FieldDefinitions', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TemplateFieldDefinitionCollectionResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
