# coding: utf-8

"""
    Laserfiche Repository API

    Welcome to the Laserfiche API Swagger Playground. You can try out any of our API calls against your live Laserfiche Cloud account. Visit the developer center for more details: <a href=\"https://developer.laserfiche.com\">https://developer.laserfiche.com</a><p>Visit the changelog for the list of changes: <a href=\"/repository/v2/changelog\">/repository/v2/changelog</a></p><p><strong>Build# : </strong>41a7347c0662989661d7ab8105a70d36cb42518e_.20240124.4</p>  # noqa: E501

    OpenAPI spec version: 2
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from laserfiche_api.api_client import ApiClient


class TasksApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def cancel_tasks(self, repository_id, **kwargs):  # noqa: E501
        """Starts the cancellation for a set of one or more tasks.  # noqa: E501

        - Starts the cancellation for a set of one or more tasks. - Provide comma-separated list of task IDs to cancel. Should be used if an operation was created in error, or is no longer necessary. - Check the status of the task to determine if the task has been cancelled successfully. - Leave the taskIds query parameter empty, to cancel the list of all the task IDs associated with the current access token. - Rollbacks must be done manually. For example, if a copy operation is started and is halfway complete when canceled, the client application is responsible for cleaning up the files that were successfully copied before the operation was canceled. - Required OAuth scope: None  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cancel_tasks(repository_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str repository_id: The requested repository ID (required)
        :param list[str] task_ids: An array of task IDs. Leave this parameter empty to cancel the list of all the tasks associated with the current access token.
        :return: CancelTasksResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.cancel_tasks_with_http_info(repository_id, **kwargs)  # noqa: E501
        else:
            (data) = self.cancel_tasks_with_http_info(repository_id, **kwargs)  # noqa: E501
            return data

    def cancel_tasks_with_http_info(self, repository_id, **kwargs):  # noqa: E501
        """Starts the cancellation for a set of one or more tasks.  # noqa: E501

        - Starts the cancellation for a set of one or more tasks. - Provide comma-separated list of task IDs to cancel. Should be used if an operation was created in error, or is no longer necessary. - Check the status of the task to determine if the task has been cancelled successfully. - Leave the taskIds query parameter empty, to cancel the list of all the task IDs associated with the current access token. - Rollbacks must be done manually. For example, if a copy operation is started and is halfway complete when canceled, the client application is responsible for cleaning up the files that were successfully copied before the operation was canceled. - Required OAuth scope: None  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cancel_tasks_with_http_info(repository_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str repository_id: The requested repository ID (required)
        :param list[str] task_ids: An array of task IDs. Leave this parameter empty to cancel the list of all the tasks associated with the current access token.
        :return: CancelTasksResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['repository_id', 'task_ids']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cancel_tasks" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'repository_id' is set
        if ('repository_id' not in params or
                params['repository_id'] is None):
            raise ValueError("Missing the required parameter `repository_id` when calling `cancel_tasks`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'repository_id' in params:
            path_params['repositoryId'] = params['repository_id']  # noqa: E501

        query_params = []
        if 'task_ids' in params:
            query_params.append(('taskIds', params['task_ids']))  # noqa: E501
            collection_formats['taskIds'] = 'multi'  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Authorization', 'OAuth2 Authorization Code Flow']  # noqa: E501

        return self.api_client.call_api(
            '/v2/Repositories/{repositoryId}/Tasks', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CancelTasksResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_tasks(self, repository_id, **kwargs):  # noqa: E501
        """Returns the status of a set of one or more tasks.  # noqa: E501

        - Returns the status of a set of one or more tasks. - Provide a comma-separated list of task IDs to get the task status, progress, and any errors that may have occurred. - Leave the taskIds query parameter empty, to get the list of all the task IDs associated with the current access token. - TaskStatus can be one of the following values: NotStarted, InProgress, Completed, Cancelled, or Failed. - This API employs long polling technique and could return the result immediately (e.g. if the export operation is failed or completed successfully) or after at most 60 seconds. - Required OAuth scope: None  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_tasks(repository_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str repository_id: The requested repository ID (required)
        :param list[str] task_ids: An array of task IDs. Leave this parameter empty to get the list of all the tasks associated with the current access token.
        :return: TaskCollectionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_tasks_with_http_info(repository_id, **kwargs)  # noqa: E501
        else:
            (data) = self.list_tasks_with_http_info(repository_id, **kwargs)  # noqa: E501
            return data

    def list_tasks_with_http_info(self, repository_id, **kwargs):  # noqa: E501
        """Returns the status of a set of one or more tasks.  # noqa: E501

        - Returns the status of a set of one or more tasks. - Provide a comma-separated list of task IDs to get the task status, progress, and any errors that may have occurred. - Leave the taskIds query parameter empty, to get the list of all the task IDs associated with the current access token. - TaskStatus can be one of the following values: NotStarted, InProgress, Completed, Cancelled, or Failed. - This API employs long polling technique and could return the result immediately (e.g. if the export operation is failed or completed successfully) or after at most 60 seconds. - Required OAuth scope: None  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_tasks_with_http_info(repository_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str repository_id: The requested repository ID (required)
        :param list[str] task_ids: An array of task IDs. Leave this parameter empty to get the list of all the tasks associated with the current access token.
        :return: TaskCollectionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['repository_id', 'task_ids']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_tasks" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'repository_id' is set
        if ('repository_id' not in params or
                params['repository_id'] is None):
            raise ValueError("Missing the required parameter `repository_id` when calling `list_tasks`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'repository_id' in params:
            path_params['repositoryId'] = params['repository_id']  # noqa: E501

        query_params = []
        if 'task_ids' in params:
            query_params.append(('taskIds', params['task_ids']))  # noqa: E501
            collection_formats['taskIds'] = 'multi'  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Authorization', 'OAuth2 Authorization Code Flow']  # noqa: E501

        return self.api_client.call_api(
            '/v2/Repositories/{repositoryId}/Tasks', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TaskCollectionResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
