# coding: utf-8

"""
    Laserfiche Repository API

    Welcome to the Laserfiche API Swagger Playground. You can try out any of our API calls against your live Laserfiche Cloud account. Visit the developer center for more details: <a href=\"https://developer.laserfiche.com\">https://developer.laserfiche.com</a><p>Visit the changelog for the list of changes: <a href=\"/repository/v2/changelog\">/repository/v2/changelog</a></p><p><strong>Build# : </strong>41a7347c0662989661d7ab8105a70d36cb42518e_.20240124.4</p>  # noqa: E501

    OpenAPI spec version: 2
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class StartSearchEntryRequest(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'search_command': 'str',
        'fuzzy_type': 'OneOfStartSearchEntryRequestFuzzyType',
        'fuzzy_factor': 'int'
    }

    attribute_map = {
        'search_command': 'searchCommand',
        'fuzzy_type': 'fuzzyType',
        'fuzzy_factor': 'fuzzyFactor'
    }

    def __init__(self, search_command=None, fuzzy_type=None, fuzzy_factor=None):  # noqa: E501
        """StartSearchEntryRequest - a model defined in Swagger"""  # noqa: E501
        self._search_command = None
        self._fuzzy_type = None
        self._fuzzy_factor = None
        self.discriminator = None
        self.search_command = search_command
        if fuzzy_type is not None:
            self.fuzzy_type = fuzzy_type
        if fuzzy_factor is not None:
            self.fuzzy_factor = fuzzy_factor

    @property
    def search_command(self):
        """Gets the search_command of this StartSearchEntryRequest.  # noqa: E501

        The search command to run. The search command should follow the Laserfiche search syntax. https://doc.laserfiche.com/laserfiche.documentation/en-us/Default.htm#Search_Syntax.htm  # noqa: E501

        :return: The search_command of this StartSearchEntryRequest.  # noqa: E501
        :rtype: str
        """
        return self._search_command

    @search_command.setter
    def search_command(self, search_command):
        """Sets the search_command of this StartSearchEntryRequest.

        The search command to run. The search command should follow the Laserfiche search syntax. https://doc.laserfiche.com/laserfiche.documentation/en-us/Default.htm#Search_Syntax.htm  # noqa: E501

        :param search_command: The search_command of this StartSearchEntryRequest.  # noqa: E501
        :type: str
        """
        if search_command is None:
            raise ValueError("Invalid value for `search_command`, must not be `None`")  # noqa: E501

        self._search_command = search_command

    @property
    def fuzzy_type(self):
        """Gets the fuzzy_type of this StartSearchEntryRequest.  # noqa: E501

        Fuzzy type (None, Percentage, or NumberOfLetters).  # noqa: E501

        :return: The fuzzy_type of this StartSearchEntryRequest.  # noqa: E501
        :rtype: OneOfStartSearchEntryRequestFuzzyType
        """
        return self._fuzzy_type

    @fuzzy_type.setter
    def fuzzy_type(self, fuzzy_type):
        """Sets the fuzzy_type of this StartSearchEntryRequest.

        Fuzzy type (None, Percentage, or NumberOfLetters).  # noqa: E501

        :param fuzzy_type: The fuzzy_type of this StartSearchEntryRequest.  # noqa: E501
        :type: OneOfStartSearchEntryRequestFuzzyType
        """

        self._fuzzy_type = fuzzy_type

    @property
    def fuzzy_factor(self):
        """Gets the fuzzy_factor of this StartSearchEntryRequest.  # noqa: E501

        Fuzzy factor (percentage as int or int value).  # noqa: E501

        :return: The fuzzy_factor of this StartSearchEntryRequest.  # noqa: E501
        :rtype: int
        """
        return self._fuzzy_factor

    @fuzzy_factor.setter
    def fuzzy_factor(self, fuzzy_factor):
        """Sets the fuzzy_factor of this StartSearchEntryRequest.

        Fuzzy factor (percentage as int or int value).  # noqa: E501

        :param fuzzy_factor: The fuzzy_factor of this StartSearchEntryRequest.  # noqa: E501
        :type: int
        """

        self._fuzzy_factor = fuzzy_factor

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(StartSearchEntryRequest, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, StartSearchEntryRequest):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
