# coding: utf-8

"""
    Laserfiche Repository API

    Welcome to the Laserfiche API Swagger Playground. You can try out any of our API calls against your live Laserfiche Cloud account. Visit the developer center for more details: <a href=\"https://developer.laserfiche.com\">https://developer.laserfiche.com</a><p>Visit the changelog for the list of changes: <a href=\"/repository/v2/changelog\">/repository/v2/changelog</a></p><p><strong>Build# : </strong>41a7347c0662989661d7ab8105a70d36cb42518e_.20240124.4</p>  # noqa: E501

    OpenAPI spec version: 2
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from laserfiche_api.api_client import ApiClient


class EntriesApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def copy_entry(self, body, repository_id, entry_id, **kwargs):  # noqa: E501
        """Copies a new child entry in a folder.  # noqa: E501

        - Copy a new child entry in the designated folder. - Provide the parent folder ID, and based on the request body, copy a child entry of the designated folder. - Required OAuth scope: repository.Write  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.copy_entry(body, repository_id, entry_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CopyEntryRequest body: The request body. (required)
        :param str repository_id: The requested repository ID. (required)
        :param int entry_id: The folder ID that the entry will be created in. (required)
        :param str culture: An optional query parameter used to indicate the locale that should be used. The value should be a standard language tag.
        :return: Entry
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.copy_entry_with_http_info(body, repository_id, entry_id, **kwargs)  # noqa: E501
        else:
            (data) = self.copy_entry_with_http_info(body, repository_id, entry_id, **kwargs)  # noqa: E501
            return data

    def copy_entry_with_http_info(self, body, repository_id, entry_id, **kwargs):  # noqa: E501
        """Copies a new child entry in a folder.  # noqa: E501

        - Copy a new child entry in the designated folder. - Provide the parent folder ID, and based on the request body, copy a child entry of the designated folder. - Required OAuth scope: repository.Write  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.copy_entry_with_http_info(body, repository_id, entry_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CopyEntryRequest body: The request body. (required)
        :param str repository_id: The requested repository ID. (required)
        :param int entry_id: The folder ID that the entry will be created in. (required)
        :param str culture: An optional query parameter used to indicate the locale that should be used. The value should be a standard language tag.
        :return: Entry
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'repository_id', 'entry_id', 'culture']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method copy_entry" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `copy_entry`")  # noqa: E501
        # verify the required parameter 'repository_id' is set
        if ('repository_id' not in params or
                params['repository_id'] is None):
            raise ValueError("Missing the required parameter `repository_id` when calling `copy_entry`")  # noqa: E501
        # verify the required parameter 'entry_id' is set
        if ('entry_id' not in params or
                params['entry_id'] is None):
            raise ValueError("Missing the required parameter `entry_id` when calling `copy_entry`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'repository_id' in params:
            path_params['repositoryId'] = params['repository_id']  # noqa: E501
        if 'entry_id' in params:
            path_params['entryId'] = params['entry_id']  # noqa: E501

        query_params = []
        if 'culture' in params:
            query_params.append(('culture', params['culture']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Authorization', 'OAuth2 Authorization Code Flow']  # noqa: E501

        return self.api_client.call_api(
            '/v2/Repositories/{repositoryId}/Entries/{entryId}/Folder/Copy', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Entry',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_entry(self, body, repository_id, entry_id, **kwargs):  # noqa: E501
        """Creates a new child entry in a folder.  # noqa: E501

        - Create a new child entry in the designated folder. - Provide the parent folder ID, and based on the request body, create a folder/shortcut as a child entry of the designated folder. - Required OAuth scope: repository.Write  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_entry(body, repository_id, entry_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CreateEntryRequest body: The request body. (required)
        :param str repository_id: The requested repository ID. (required)
        :param int entry_id: The folder ID that the entry will be created in. (required)
        :param str culture: An optional query parameter used to indicate the locale that should be used. The value should be a standard language tag.
        :return: Entry
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_entry_with_http_info(body, repository_id, entry_id, **kwargs)  # noqa: E501
        else:
            (data) = self.create_entry_with_http_info(body, repository_id, entry_id, **kwargs)  # noqa: E501
            return data

    def create_entry_with_http_info(self, body, repository_id, entry_id, **kwargs):  # noqa: E501
        """Creates a new child entry in a folder.  # noqa: E501

        - Create a new child entry in the designated folder. - Provide the parent folder ID, and based on the request body, create a folder/shortcut as a child entry of the designated folder. - Required OAuth scope: repository.Write  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_entry_with_http_info(body, repository_id, entry_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CreateEntryRequest body: The request body. (required)
        :param str repository_id: The requested repository ID. (required)
        :param int entry_id: The folder ID that the entry will be created in. (required)
        :param str culture: An optional query parameter used to indicate the locale that should be used. The value should be a standard language tag.
        :return: Entry
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'repository_id', 'entry_id', 'culture']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_entry" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_entry`")  # noqa: E501
        # verify the required parameter 'repository_id' is set
        if ('repository_id' not in params or
                params['repository_id'] is None):
            raise ValueError("Missing the required parameter `repository_id` when calling `create_entry`")  # noqa: E501
        # verify the required parameter 'entry_id' is set
        if ('entry_id' not in params or
                params['entry_id'] is None):
            raise ValueError("Missing the required parameter `entry_id` when calling `create_entry`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'repository_id' in params:
            path_params['repositoryId'] = params['repository_id']  # noqa: E501
        if 'entry_id' in params:
            path_params['entryId'] = params['entry_id']  # noqa: E501

        query_params = []
        if 'culture' in params:
            query_params.append(('culture', params['culture']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Authorization', 'OAuth2 Authorization Code Flow']  # noqa: E501

        return self.api_client.call_api(
            '/v2/Repositories/{repositoryId}/Entries/{entryId}/Folder/Children', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Entry',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_multipart_upload_urls(self, body, repository_id, **kwargs):  # noqa: E501
        """Requests Upload URLs to upload a large file in chunks.  # noqa: E501

        - Requests Upload URLs to upload a large file in chunks. - Returns an UploadId and an array of URLs to which the file chunks should be written in the same order. - To request a new batch of Upload URLs for the same file, set the value of UploadId to the one returned when the first batch of Upload URLs was requested. For requesting the first batch of Upload URLs, leave UploadId empty or null. - Example: if a file is going to be uploaded in 10 chunks, the 10 Upload URLs can be retrieved by two successive calls to this api, each call requesting 5 Upload URLs. For this, the first call should have StartingPartNumber=1 and NumberOfParts=5, and the second call should have StartingPartNumber=6 and NumberOfParts=5, along with UploadId returned in the first call. - Each Upload URL expires after 15 minutes. - Each file chunk written to an Upload URL should be at least 5 MB and at most 5 GB. There is no minimum size limit for the last chunk. - The value of NumberOfParts must be in the range [1, 100], meaning that in each call to this api, a maximum of 100 Upload URLs can be requested.  - The total number of Upload URLs for a single file is 1000, which means (StartingPartNumber + NumberOfParts) should be less than or equal to 1001. - Required OAuth scope: repository.Write  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_multipart_upload_urls(body, repository_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CreateMultipartUploadUrlsRequest body: The request body. (required)
        :param str repository_id: The requested repository ID. (required)
        :return: CreateMultipartUploadUrlsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_multipart_upload_urls_with_http_info(body, repository_id, **kwargs)  # noqa: E501
        else:
            (data) = self.create_multipart_upload_urls_with_http_info(body, repository_id, **kwargs)  # noqa: E501
            return data

    def create_multipart_upload_urls_with_http_info(self, body, repository_id, **kwargs):  # noqa: E501
        """Requests Upload URLs to upload a large file in chunks.  # noqa: E501

        - Requests Upload URLs to upload a large file in chunks. - Returns an UploadId and an array of URLs to which the file chunks should be written in the same order. - To request a new batch of Upload URLs for the same file, set the value of UploadId to the one returned when the first batch of Upload URLs was requested. For requesting the first batch of Upload URLs, leave UploadId empty or null. - Example: if a file is going to be uploaded in 10 chunks, the 10 Upload URLs can be retrieved by two successive calls to this api, each call requesting 5 Upload URLs. For this, the first call should have StartingPartNumber=1 and NumberOfParts=5, and the second call should have StartingPartNumber=6 and NumberOfParts=5, along with UploadId returned in the first call. - Each Upload URL expires after 15 minutes. - Each file chunk written to an Upload URL should be at least 5 MB and at most 5 GB. There is no minimum size limit for the last chunk. - The value of NumberOfParts must be in the range [1, 100], meaning that in each call to this api, a maximum of 100 Upload URLs can be requested.  - The total number of Upload URLs for a single file is 1000, which means (StartingPartNumber + NumberOfParts) should be less than or equal to 1001. - Required OAuth scope: repository.Write  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_multipart_upload_urls_with_http_info(body, repository_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CreateMultipartUploadUrlsRequest body: The request body. (required)
        :param str repository_id: The requested repository ID. (required)
        :return: CreateMultipartUploadUrlsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'repository_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_multipart_upload_urls" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_multipart_upload_urls`")  # noqa: E501
        # verify the required parameter 'repository_id' is set
        if ('repository_id' not in params or
                params['repository_id'] is None):
            raise ValueError("Missing the required parameter `repository_id` when calling `create_multipart_upload_urls`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'repository_id' in params:
            path_params['repositoryId'] = params['repository_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Authorization', 'OAuth2 Authorization Code Flow']  # noqa: E501

        return self.api_client.call_api(
            '/v2/Repositories/{repositoryId}/Entries/CreateMultipartUploadUrls', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateMultipartUploadUrlsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_electronic_document(self, repository_id, entry_id, **kwargs):  # noqa: E501
        """Deletes the edoc associated with an entry.  # noqa: E501

        - Delete the edoc associated with the provided entry ID. - Required OAuth scope: repository.Write  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_electronic_document(repository_id, entry_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str repository_id: The requested repository ID. (required)
        :param int entry_id: The requested document ID. (required)
        :return: Entry
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_electronic_document_with_http_info(repository_id, entry_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_electronic_document_with_http_info(repository_id, entry_id, **kwargs)  # noqa: E501
            return data

    def delete_electronic_document_with_http_info(self, repository_id, entry_id, **kwargs):  # noqa: E501
        """Deletes the edoc associated with an entry.  # noqa: E501

        - Delete the edoc associated with the provided entry ID. - Required OAuth scope: repository.Write  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_electronic_document_with_http_info(repository_id, entry_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str repository_id: The requested repository ID. (required)
        :param int entry_id: The requested document ID. (required)
        :return: Entry
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['repository_id', 'entry_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_electronic_document" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'repository_id' is set
        if ('repository_id' not in params or
                params['repository_id'] is None):
            raise ValueError("Missing the required parameter `repository_id` when calling `delete_electronic_document`")  # noqa: E501
        # verify the required parameter 'entry_id' is set
        if ('entry_id' not in params or
                params['entry_id'] is None):
            raise ValueError("Missing the required parameter `entry_id` when calling `delete_electronic_document`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'repository_id' in params:
            path_params['repositoryId'] = params['repository_id']  # noqa: E501
        if 'entry_id' in params:
            path_params['entryId'] = params['entry_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Authorization', 'OAuth2 Authorization Code Flow']  # noqa: E501

        return self.api_client.call_api(
            '/v2/Repositories/{repositoryId}/Entries/{entryId}/Document/Edoc', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Entry',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_pages(self, repository_id, entry_id, **kwargs):  # noqa: E501
        """Deletes the pages associated with an entry.  # noqa: E501

        - Delete the pages associated with the provided entry ID. If no pageRange is specified, all pages will be deleted. - Optional parameter: pageRange (default empty). The value should be a comma-separated string which contains non-overlapping single values, or page ranges. Ex: \"1,2,3\", \"1-3,5\", \"2-7,10-12.\" - Required OAuth scope: repository.Write  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_pages(repository_id, entry_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str repository_id: The requested repository ID. (required)
        :param int entry_id: The requested document ID. (required)
        :param str page_range: The pages to be deleted.
        :return: Entry
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_pages_with_http_info(repository_id, entry_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_pages_with_http_info(repository_id, entry_id, **kwargs)  # noqa: E501
            return data

    def delete_pages_with_http_info(self, repository_id, entry_id, **kwargs):  # noqa: E501
        """Deletes the pages associated with an entry.  # noqa: E501

        - Delete the pages associated with the provided entry ID. If no pageRange is specified, all pages will be deleted. - Optional parameter: pageRange (default empty). The value should be a comma-separated string which contains non-overlapping single values, or page ranges. Ex: \"1,2,3\", \"1-3,5\", \"2-7,10-12.\" - Required OAuth scope: repository.Write  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_pages_with_http_info(repository_id, entry_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str repository_id: The requested repository ID. (required)
        :param int entry_id: The requested document ID. (required)
        :param str page_range: The pages to be deleted.
        :return: Entry
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['repository_id', 'entry_id', 'page_range']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_pages" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'repository_id' is set
        if ('repository_id' not in params or
                params['repository_id'] is None):
            raise ValueError("Missing the required parameter `repository_id` when calling `delete_pages`")  # noqa: E501
        # verify the required parameter 'entry_id' is set
        if ('entry_id' not in params or
                params['entry_id'] is None):
            raise ValueError("Missing the required parameter `entry_id` when calling `delete_pages`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'repository_id' in params:
            path_params['repositoryId'] = params['repository_id']  # noqa: E501
        if 'entry_id' in params:
            path_params['entryId'] = params['entry_id']  # noqa: E501

        query_params = []
        if 'page_range' in params:
            query_params.append(('pageRange', params['page_range']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Authorization', 'OAuth2 Authorization Code Flow']  # noqa: E501

        return self.api_client.call_api(
            '/v2/Repositories/{repositoryId}/Entries/{entryId}/Document/Pages', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Entry',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def export_entry(self, body, repository_id, entry_id, **kwargs):  # noqa: E501
        """Exports an entry.  # noqa: E501

        - Export an entry. - The export may time out if it takes longer than 60 seconds. This value is subject to change at anytime. Use the long operation asynchronous export if you run into this restriction. - Required OAuth scope: repository.Read  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.export_entry(body, repository_id, entry_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ExportEntryRequest body: The request body. (required)
        :param str repository_id: The requested repository ID. (required)
        :param int entry_id: The ID of entry to export. (required)
        :param str page_range: A comma-separated range of pages to include. Ex: 1,3,4 or 1-3,5-7,9. This value is ignored when exporting as Edoc.
        :return: ExportEntryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.export_entry_with_http_info(body, repository_id, entry_id, **kwargs)  # noqa: E501
        else:
            (data) = self.export_entry_with_http_info(body, repository_id, entry_id, **kwargs)  # noqa: E501
            return data

    def export_entry_with_http_info(self, body, repository_id, entry_id, **kwargs):  # noqa: E501
        """Exports an entry.  # noqa: E501

        - Export an entry. - The export may time out if it takes longer than 60 seconds. This value is subject to change at anytime. Use the long operation asynchronous export if you run into this restriction. - Required OAuth scope: repository.Read  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.export_entry_with_http_info(body, repository_id, entry_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ExportEntryRequest body: The request body. (required)
        :param str repository_id: The requested repository ID. (required)
        :param int entry_id: The ID of entry to export. (required)
        :param str page_range: A comma-separated range of pages to include. Ex: 1,3,4 or 1-3,5-7,9. This value is ignored when exporting as Edoc.
        :return: ExportEntryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'repository_id', 'entry_id', 'page_range']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method export_entry" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `export_entry`")  # noqa: E501
        # verify the required parameter 'repository_id' is set
        if ('repository_id' not in params or
                params['repository_id'] is None):
            raise ValueError("Missing the required parameter `repository_id` when calling `export_entry`")  # noqa: E501
        # verify the required parameter 'entry_id' is set
        if ('entry_id' not in params or
                params['entry_id'] is None):
            raise ValueError("Missing the required parameter `entry_id` when calling `export_entry`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'repository_id' in params:
            path_params['repositoryId'] = params['repository_id']  # noqa: E501
        if 'entry_id' in params:
            path_params['entryId'] = params['entry_id']  # noqa: E501

        query_params = []
        if 'page_range' in params:
            query_params.append(('pageRange', params['page_range']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Authorization', 'OAuth2 Authorization Code Flow']  # noqa: E501

        return self.api_client.call_api(
            '/v2/Repositories/{repositoryId}/Entries/{entryId}/Export', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ExportEntryResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_entry(self, repository_id, entry_id, **kwargs):  # noqa: E501
        """Returns a single entry object.  # noqa: E501

        - Returns a single entry object. - Provide an entry ID, and get the entry associated with that ID. Useful when detailed information about the entry is required, such as metadata, path information, etc. - If the entry is a subtype (Folder, Document, or Shortcut), the entry will automatically be converted to include those model-specific properties. - Allowed OData query options: Select. - When OData Select query option is used, 'entryType' is always included in the result. - Required OAuth scope: repository.Read  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_entry(repository_id, entry_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str repository_id: The requested repository ID. (required)
        :param int entry_id: The requested entry ID. (required)
        :param str select: Limits the properties returned in the result.
        :return: Entry
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_entry_with_http_info(repository_id, entry_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_entry_with_http_info(repository_id, entry_id, **kwargs)  # noqa: E501
            return data

    def get_entry_with_http_info(self, repository_id, entry_id, **kwargs):  # noqa: E501
        """Returns a single entry object.  # noqa: E501

        - Returns a single entry object. - Provide an entry ID, and get the entry associated with that ID. Useful when detailed information about the entry is required, such as metadata, path information, etc. - If the entry is a subtype (Folder, Document, or Shortcut), the entry will automatically be converted to include those model-specific properties. - Allowed OData query options: Select. - When OData Select query option is used, 'entryType' is always included in the result. - Required OAuth scope: repository.Read  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_entry_with_http_info(repository_id, entry_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str repository_id: The requested repository ID. (required)
        :param int entry_id: The requested entry ID. (required)
        :param str select: Limits the properties returned in the result.
        :return: Entry
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['repository_id', 'entry_id', 'select']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_entry" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'repository_id' is set
        if ('repository_id' not in params or
                params['repository_id'] is None):
            raise ValueError("Missing the required parameter `repository_id` when calling `get_entry`")  # noqa: E501
        # verify the required parameter 'entry_id' is set
        if ('entry_id' not in params or
                params['entry_id'] is None):
            raise ValueError("Missing the required parameter `entry_id` when calling `get_entry`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'repository_id' in params:
            path_params['repositoryId'] = params['repository_id']  # noqa: E501
        if 'entry_id' in params:
            path_params['entryId'] = params['entry_id']  # noqa: E501

        query_params = []
        if 'select' in params:
            query_params.append(('$select', params['select']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Authorization', 'OAuth2 Authorization Code Flow']  # noqa: E501

        return self.api_client.call_api(
            '/v2/Repositories/{repositoryId}/Entries/{entryId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Entry',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_entry_by_path(self, repository_id, full_path, **kwargs):  # noqa: E501
        """Returns a single entry object using the entry path.  # noqa: E501

        - Returns a single entry object using the entry path. - Optional query parameter: fallbackToClosestAncestor. Use the fallbackToClosestAncestor query parameter to return the closest existing ancestor if the initial entry path is not found. - Required OAuth scope: repository.Read  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_entry_by_path(repository_id, full_path, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str repository_id: The requested repository ID. (required)
        :param str full_path: The requested entry path. (required)
        :param bool fallback_to_closest_ancestor: An optional query parameter used to indicate whether or not the closest ancestor in the path should be returned if the initial entry path is not found. The default value is false.
        :return: GetEntryByPathResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_entry_by_path_with_http_info(repository_id, full_path, **kwargs)  # noqa: E501
        else:
            (data) = self.get_entry_by_path_with_http_info(repository_id, full_path, **kwargs)  # noqa: E501
            return data

    def get_entry_by_path_with_http_info(self, repository_id, full_path, **kwargs):  # noqa: E501
        """Returns a single entry object using the entry path.  # noqa: E501

        - Returns a single entry object using the entry path. - Optional query parameter: fallbackToClosestAncestor. Use the fallbackToClosestAncestor query parameter to return the closest existing ancestor if the initial entry path is not found. - Required OAuth scope: repository.Read  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_entry_by_path_with_http_info(repository_id, full_path, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str repository_id: The requested repository ID. (required)
        :param str full_path: The requested entry path. (required)
        :param bool fallback_to_closest_ancestor: An optional query parameter used to indicate whether or not the closest ancestor in the path should be returned if the initial entry path is not found. The default value is false.
        :return: GetEntryByPathResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['repository_id', 'full_path', 'fallback_to_closest_ancestor']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_entry_by_path" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'repository_id' is set
        if ('repository_id' not in params or
                params['repository_id'] is None):
            raise ValueError("Missing the required parameter `repository_id` when calling `get_entry_by_path`")  # noqa: E501
        # verify the required parameter 'full_path' is set
        if ('full_path' not in params or
                params['full_path'] is None):
            raise ValueError("Missing the required parameter `full_path` when calling `get_entry_by_path`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'repository_id' in params:
            path_params['repositoryId'] = params['repository_id']  # noqa: E501

        query_params = []
        if 'full_path' in params:
            query_params.append(('fullPath', params['full_path']))  # noqa: E501
        if 'fallback_to_closest_ancestor' in params:
            query_params.append(('fallbackToClosestAncestor', params['fallback_to_closest_ancestor']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Authorization', 'OAuth2 Authorization Code Flow']  # noqa: E501

        return self.api_client.call_api(
            '/v2/Repositories/{repositoryId}/Entries/ByPath', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetEntryByPathResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def import_entry(self, repository_id, entry_id, **kwargs):  # noqa: E501
        """Imports a file into a folder (max length: 100 MB).  # noqa: E501

        - Import a new document in the specified folder, and optionally assigns metadata. - The import may fail if the file is greater than 100 MB or time out if it takes longer than 60 seconds. These values are subject to change at anytime. Use the long operation asynchronous import if you run into these restrictions. - Required OAuth scope: repository.Write  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.import_entry(repository_id, entry_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str repository_id: The requested repository ID. (required)
        :param int entry_id: The entry ID of the folder that the document will be created in. (required)
        :param str file:
        :param ImportEntryRequest request:
        :param str culture: An optional query parameter used to indicate the locale that should be used. The value should be a standard language tag. This may be used when setting field values with tokens.
        :return: Entry
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.import_entry_with_http_info(repository_id, entry_id, **kwargs)  # noqa: E501
        else:
            (data) = self.import_entry_with_http_info(repository_id, entry_id, **kwargs)  # noqa: E501
            return data

    def import_entry_with_http_info(self, repository_id, entry_id, **kwargs):  # noqa: E501
        """Imports a file into a folder (max length: 100 MB).  # noqa: E501

        - Import a new document in the specified folder, and optionally assigns metadata. - The import may fail if the file is greater than 100 MB or time out if it takes longer than 60 seconds. These values are subject to change at anytime. Use the long operation asynchronous import if you run into these restrictions. - Required OAuth scope: repository.Write  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.import_entry_with_http_info(repository_id, entry_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str repository_id: The requested repository ID. (required)
        :param int entry_id: The entry ID of the folder that the document will be created in. (required)
        :param str file:
        :param ImportEntryRequest request:
        :param str culture: An optional query parameter used to indicate the locale that should be used. The value should be a standard language tag. This may be used when setting field values with tokens.
        :return: Entry
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['repository_id', 'entry_id', 'file', 'request', 'culture']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method import_entry" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'repository_id' is set
        if ('repository_id' not in params or
                params['repository_id'] is None):
            raise ValueError("Missing the required parameter `repository_id` when calling `import_entry`")  # noqa: E501
        # verify the required parameter 'entry_id' is set
        if ('entry_id' not in params or
                params['entry_id'] is None):
            raise ValueError("Missing the required parameter `entry_id` when calling `import_entry`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'repository_id' in params:
            path_params['repositoryId'] = params['repository_id']  # noqa: E501
        if 'entry_id' in params:
            path_params['entryId'] = params['entry_id']  # noqa: E501

        query_params = []
        if 'culture' in params:
            query_params.append(('culture', params['culture']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'file' in params:
            local_var_files['file'] = params['file']  # noqa: E501
        if 'request' in params:
            form_params.append(('request', params['request']))  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Authorization', 'OAuth2 Authorization Code Flow']  # noqa: E501

        return self.api_client.call_api(
            '/v2/Repositories/{repositoryId}/Entries/{entryId}/Folder/Import', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Entry',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_dynamic_field_values(self, body, repository_id, entry_id, **kwargs):  # noqa: E501
        """Returns the dynamic field logic values assigned to an entry.  # noqa: E501

        - Returns dynamic field logic values with the current values of the fields in the template. - Provide an entry ID and field values in the JSON body to get dynamic field logic values. - Independent and non-dynamic fields in the request body will be ignored, and only related dynamic field logic values for the assigned template will be returned. - Required OAuth scope: repository.Read  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_dynamic_field_values(body, repository_id, entry_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ListDynamicFieldValuesRequest body: The request body. (required)
        :param str repository_id: The requested repository ID. (required)
        :param int entry_id: The requested entry ID. (required)
        :return: dict(str, list[str])
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_dynamic_field_values_with_http_info(body, repository_id, entry_id, **kwargs)  # noqa: E501
        else:
            (data) = self.list_dynamic_field_values_with_http_info(body, repository_id, entry_id, **kwargs)  # noqa: E501
            return data

    def list_dynamic_field_values_with_http_info(self, body, repository_id, entry_id, **kwargs):  # noqa: E501
        """Returns the dynamic field logic values assigned to an entry.  # noqa: E501

        - Returns dynamic field logic values with the current values of the fields in the template. - Provide an entry ID and field values in the JSON body to get dynamic field logic values. - Independent and non-dynamic fields in the request body will be ignored, and only related dynamic field logic values for the assigned template will be returned. - Required OAuth scope: repository.Read  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_dynamic_field_values_with_http_info(body, repository_id, entry_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ListDynamicFieldValuesRequest body: The request body. (required)
        :param str repository_id: The requested repository ID. (required)
        :param int entry_id: The requested entry ID. (required)
        :return: dict(str, list[str])
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'repository_id', 'entry_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_dynamic_field_values" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `list_dynamic_field_values`")  # noqa: E501
        # verify the required parameter 'repository_id' is set
        if ('repository_id' not in params or
                params['repository_id'] is None):
            raise ValueError("Missing the required parameter `repository_id` when calling `list_dynamic_field_values`")  # noqa: E501
        # verify the required parameter 'entry_id' is set
        if ('entry_id' not in params or
                params['entry_id'] is None):
            raise ValueError("Missing the required parameter `entry_id` when calling `list_dynamic_field_values`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'repository_id' in params:
            path_params['repositoryId'] = params['repository_id']  # noqa: E501
        if 'entry_id' in params:
            path_params['entryId'] = params['entry_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Authorization', 'OAuth2 Authorization Code Flow']  # noqa: E501

        return self.api_client.call_api(
            '/v2/Repositories/{repositoryId}/Entries/{entryId}/Fields/GetDynamicFieldLogicValue', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='dict(str, list[str])',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_entries(self, repository_id, entry_id, **kwargs):  # noqa: E501
        """Returns the children entries of a folder.  # noqa: E501

        - Returns the children entries of a folder in the repository. - Provide an entry ID (must be a folder), and get a paged listing of entries in that folder. Used as a way of navigating through the repository. - Entries returned in the listing are not automatically converted to their subtype (Folder, Shortcut, Document), so clients who want model-specific information should request it via the GET entry by ID route. - Optional query parameters: groupByEntryType (bool). This query parameter decides if results are returned in groups based on their entry type.  - Optionally returns field values for the entries in the folder. Each field name needs to be specified in the request. Maximum limit of 10 field names. If field values are requested, only the first value is returned if it is a multi value field. The remaining field values can be retrieved via the GET fields route. Null or Empty field values should not be used to determine if a field is assigned to the entry. - Default page size: 150. Allowed OData query options: Select | Count | OrderBy | Skip | Top | SkipToken | Prefer. OData $OrderBy syntax should follow: \"PropertyName direction,PropertyName2 direction\". Sort order can be either value \"asc\" or \"desc\". - Required OAuth scope: repository.Read  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_entries(repository_id, entry_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str repository_id: The requested repository ID. (required)
        :param int entry_id: The folder ID. (required)
        :param bool group_by_entry_type: Indicates if the result should be grouped by entry type or not. The default value is false.
        :param list[str] fields: Optional array of field names. Field values corresponding to the given field names will be returned for each entry.
        :param bool format_field_values: Indicates if field values should be formatted. Only applicable if Fields are specified. The default value is false.
        :param str prefer: An optional OData header. Can be used to set the maximum page size using odata.maxpagesize.
        :param str culture: An optional query parameter used to indicate the locale that should be used for formatting. The value should be a standard language tag. The formatFieldValues query parameter must be set to true, otherwise culture will not be used for formatting.
        :param str select: Limits the properties returned in the result.
        :param str orderby: Specifies the order in which items are returned. The maximum number of expressions is 5.
        :param int top: Limits the number of items returned from a collection.
        :param int skip: Excludes the specified number of items of the queried collection from the result.
        :param bool count: Indicates whether the total count of items within a collection are returned in the result.
        :return: EntryCollectionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_entries_with_http_info(repository_id, entry_id, **kwargs)  # noqa: E501
        else:
            (data) = self.list_entries_with_http_info(repository_id, entry_id, **kwargs)  # noqa: E501
            return data

    def list_entries_with_http_info(self, repository_id, entry_id, **kwargs):  # noqa: E501
        """Returns the children entries of a folder.  # noqa: E501

        - Returns the children entries of a folder in the repository. - Provide an entry ID (must be a folder), and get a paged listing of entries in that folder. Used as a way of navigating through the repository. - Entries returned in the listing are not automatically converted to their subtype (Folder, Shortcut, Document), so clients who want model-specific information should request it via the GET entry by ID route. - Optional query parameters: groupByEntryType (bool). This query parameter decides if results are returned in groups based on their entry type.  - Optionally returns field values for the entries in the folder. Each field name needs to be specified in the request. Maximum limit of 10 field names. If field values are requested, only the first value is returned if it is a multi value field. The remaining field values can be retrieved via the GET fields route. Null or Empty field values should not be used to determine if a field is assigned to the entry. - Default page size: 150. Allowed OData query options: Select | Count | OrderBy | Skip | Top | SkipToken | Prefer. OData $OrderBy syntax should follow: \"PropertyName direction,PropertyName2 direction\". Sort order can be either value \"asc\" or \"desc\". - Required OAuth scope: repository.Read  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_entries_with_http_info(repository_id, entry_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str repository_id: The requested repository ID. (required)
        :param int entry_id: The folder ID. (required)
        :param bool group_by_entry_type: Indicates if the result should be grouped by entry type or not. The default value is false.
        :param list[str] fields: Optional array of field names. Field values corresponding to the given field names will be returned for each entry.
        :param bool format_field_values: Indicates if field values should be formatted. Only applicable if Fields are specified. The default value is false.
        :param str prefer: An optional OData header. Can be used to set the maximum page size using odata.maxpagesize.
        :param str culture: An optional query parameter used to indicate the locale that should be used for formatting. The value should be a standard language tag. The formatFieldValues query parameter must be set to true, otherwise culture will not be used for formatting.
        :param str select: Limits the properties returned in the result.
        :param str orderby: Specifies the order in which items are returned. The maximum number of expressions is 5.
        :param int top: Limits the number of items returned from a collection.
        :param int skip: Excludes the specified number of items of the queried collection from the result.
        :param bool count: Indicates whether the total count of items within a collection are returned in the result.
        :return: EntryCollectionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['repository_id', 'entry_id', 'group_by_entry_type', 'fields', 'format_field_values', 'prefer', 'culture', 'select', 'orderby', 'top', 'skip', 'count']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_entries" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'repository_id' is set
        if ('repository_id' not in params or
                params['repository_id'] is None):
            raise ValueError("Missing the required parameter `repository_id` when calling `list_entries`")  # noqa: E501
        # verify the required parameter 'entry_id' is set
        if ('entry_id' not in params or
                params['entry_id'] is None):
            raise ValueError("Missing the required parameter `entry_id` when calling `list_entries`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'repository_id' in params:
            path_params['repositoryId'] = params['repository_id']  # noqa: E501
        if 'entry_id' in params:
            path_params['entryId'] = params['entry_id']  # noqa: E501

        query_params = []
        if 'group_by_entry_type' in params:
            query_params.append(('groupByEntryType', params['group_by_entry_type']))  # noqa: E501
        if 'fields' in params:
            query_params.append(('fields', params['fields']))  # noqa: E501
            collection_formats['fields'] = 'multi'  # noqa: E501
        if 'format_field_values' in params:
            query_params.append(('formatFieldValues', params['format_field_values']))  # noqa: E501
        if 'culture' in params:
            query_params.append(('culture', params['culture']))  # noqa: E501
        if 'select' in params:
            query_params.append(('$select', params['select']))  # noqa: E501
        if 'orderby' in params:
            query_params.append(('$orderby', params['orderby']))  # noqa: E501
        if 'top' in params:
            query_params.append(('$top', params['top']))  # noqa: E501
        if 'skip' in params:
            query_params.append(('$skip', params['skip']))  # noqa: E501
        if 'count' in params:
            query_params.append(('$count', params['count']))  # noqa: E501

        header_params = {}
        if 'prefer' in params:
            header_params['Prefer'] = params['prefer']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Authorization', 'OAuth2 Authorization Code Flow']  # noqa: E501

        return self.api_client.call_api(
            '/v2/Repositories/{repositoryId}/Entries/{entryId}/Folder/Children', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EntryCollectionResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_fields(self, repository_id, entry_id, **kwargs):  # noqa: E501
        """Returns the fields assigned to an entry.  # noqa: E501

        - Returns the fields assigned to an entry. - Provide an entry ID, and get a paged listing of all fields assigned to that entry. - Default page size: 100. Allowed OData query options: Select | Count | OrderBy | Skip | Top | SkipToken | Prefer. - Required OAuth scope: repository.Read  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_fields(repository_id, entry_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str repository_id: The requested repository ID. (required)
        :param int entry_id: The requested entry ID. (required)
        :param str prefer: An optional OData header. Can be used to set the maximum page size using odata.maxpagesize.
        :param bool format_field_values: An optional query parameter used to indicate if the field values should be formatted. The default value is false.
        :param str culture: An optional query parameter used to indicate the locale that should be used for formatting. The value should be a standard language tag. The formatFieldValues query parameter must be set to true, otherwise culture will not be used for formatting.
        :param str select: Limits the properties returned in the result.
        :param str orderby: Specifies the order in which items are returned. The maximum number of expressions is 5.
        :param int top: Limits the number of items returned from a collection.
        :param int skip: Excludes the specified number of items of the queried collection from the result.
        :param bool count: Indicates whether the total count of items within a collection are returned in the result.
        :return: FieldCollectionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_fields_with_http_info(repository_id, entry_id, **kwargs)  # noqa: E501
        else:
            (data) = self.list_fields_with_http_info(repository_id, entry_id, **kwargs)  # noqa: E501
            return data

    def list_fields_with_http_info(self, repository_id, entry_id, **kwargs):  # noqa: E501
        """Returns the fields assigned to an entry.  # noqa: E501

        - Returns the fields assigned to an entry. - Provide an entry ID, and get a paged listing of all fields assigned to that entry. - Default page size: 100. Allowed OData query options: Select | Count | OrderBy | Skip | Top | SkipToken | Prefer. - Required OAuth scope: repository.Read  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_fields_with_http_info(repository_id, entry_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str repository_id: The requested repository ID. (required)
        :param int entry_id: The requested entry ID. (required)
        :param str prefer: An optional OData header. Can be used to set the maximum page size using odata.maxpagesize.
        :param bool format_field_values: An optional query parameter used to indicate if the field values should be formatted. The default value is false.
        :param str culture: An optional query parameter used to indicate the locale that should be used for formatting. The value should be a standard language tag. The formatFieldValues query parameter must be set to true, otherwise culture will not be used for formatting.
        :param str select: Limits the properties returned in the result.
        :param str orderby: Specifies the order in which items are returned. The maximum number of expressions is 5.
        :param int top: Limits the number of items returned from a collection.
        :param int skip: Excludes the specified number of items of the queried collection from the result.
        :param bool count: Indicates whether the total count of items within a collection are returned in the result.
        :return: FieldCollectionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['repository_id', 'entry_id', 'prefer', 'format_field_values', 'culture', 'select', 'orderby', 'top', 'skip', 'count']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_fields" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'repository_id' is set
        if ('repository_id' not in params or
                params['repository_id'] is None):
            raise ValueError("Missing the required parameter `repository_id` when calling `list_fields`")  # noqa: E501
        # verify the required parameter 'entry_id' is set
        if ('entry_id' not in params or
                params['entry_id'] is None):
            raise ValueError("Missing the required parameter `entry_id` when calling `list_fields`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'repository_id' in params:
            path_params['repositoryId'] = params['repository_id']  # noqa: E501
        if 'entry_id' in params:
            path_params['entryId'] = params['entry_id']  # noqa: E501

        query_params = []
        if 'format_field_values' in params:
            query_params.append(('formatFieldValues', params['format_field_values']))  # noqa: E501
        if 'culture' in params:
            query_params.append(('culture', params['culture']))  # noqa: E501
        if 'select' in params:
            query_params.append(('$select', params['select']))  # noqa: E501
        if 'orderby' in params:
            query_params.append(('$orderby', params['orderby']))  # noqa: E501
        if 'top' in params:
            query_params.append(('$top', params['top']))  # noqa: E501
        if 'skip' in params:
            query_params.append(('$skip', params['skip']))  # noqa: E501
        if 'count' in params:
            query_params.append(('$count', params['count']))  # noqa: E501

        header_params = {}
        if 'prefer' in params:
            header_params['Prefer'] = params['prefer']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Authorization', 'OAuth2 Authorization Code Flow']  # noqa: E501

        return self.api_client.call_api(
            '/v2/Repositories/{repositoryId}/Entries/{entryId}/Fields', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='FieldCollectionResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_links(self, repository_id, entry_id, **kwargs):  # noqa: E501
        """Returns the links assigned to an entry.  # noqa: E501

        - Returns the links assigned to an entry. - Provide an entry ID, and get a paged listing of links assigned to that entry. - Default page size: 100. Allowed OData query options: Select | Count | OrderBy | Skip | Top | SkipToken | Prefer. - Required OAuth scope: repository.Read  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_links(repository_id, entry_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str repository_id: The requested repository ID. (required)
        :param int entry_id: The requested entry ID. (required)
        :param str prefer: An optional odata header. Can be used to set the maximum page size using odata.maxpagesize.
        :param str select: Limits the properties returned in the result.
        :param str orderby: Specifies the order in which items are returned. The maximum number of expressions is 5.
        :param int top: Limits the number of items returned from a collection.
        :param int skip: Excludes the specified number of items of the queried collection from the result.
        :param bool count: Indicates whether the total count of items within a collection are returned in the result.
        :return: LinkCollectionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_links_with_http_info(repository_id, entry_id, **kwargs)  # noqa: E501
        else:
            (data) = self.list_links_with_http_info(repository_id, entry_id, **kwargs)  # noqa: E501
            return data

    def list_links_with_http_info(self, repository_id, entry_id, **kwargs):  # noqa: E501
        """Returns the links assigned to an entry.  # noqa: E501

        - Returns the links assigned to an entry. - Provide an entry ID, and get a paged listing of links assigned to that entry. - Default page size: 100. Allowed OData query options: Select | Count | OrderBy | Skip | Top | SkipToken | Prefer. - Required OAuth scope: repository.Read  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_links_with_http_info(repository_id, entry_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str repository_id: The requested repository ID. (required)
        :param int entry_id: The requested entry ID. (required)
        :param str prefer: An optional odata header. Can be used to set the maximum page size using odata.maxpagesize.
        :param str select: Limits the properties returned in the result.
        :param str orderby: Specifies the order in which items are returned. The maximum number of expressions is 5.
        :param int top: Limits the number of items returned from a collection.
        :param int skip: Excludes the specified number of items of the queried collection from the result.
        :param bool count: Indicates whether the total count of items within a collection are returned in the result.
        :return: LinkCollectionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['repository_id', 'entry_id', 'prefer', 'select', 'orderby', 'top', 'skip', 'count']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_links" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'repository_id' is set
        if ('repository_id' not in params or
                params['repository_id'] is None):
            raise ValueError("Missing the required parameter `repository_id` when calling `list_links`")  # noqa: E501
        # verify the required parameter 'entry_id' is set
        if ('entry_id' not in params or
                params['entry_id'] is None):
            raise ValueError("Missing the required parameter `entry_id` when calling `list_links`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'repository_id' in params:
            path_params['repositoryId'] = params['repository_id']  # noqa: E501
        if 'entry_id' in params:
            path_params['entryId'] = params['entry_id']  # noqa: E501

        query_params = []
        if 'select' in params:
            query_params.append(('$select', params['select']))  # noqa: E501
        if 'orderby' in params:
            query_params.append(('$orderby', params['orderby']))  # noqa: E501
        if 'top' in params:
            query_params.append(('$top', params['top']))  # noqa: E501
        if 'skip' in params:
            query_params.append(('$skip', params['skip']))  # noqa: E501
        if 'count' in params:
            query_params.append(('$count', params['count']))  # noqa: E501

        header_params = {}
        if 'prefer' in params:
            header_params['Prefer'] = params['prefer']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Authorization', 'OAuth2 Authorization Code Flow']  # noqa: E501

        return self.api_client.call_api(
            '/v2/Repositories/{repositoryId}/Entries/{entryId}/Links', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='LinkCollectionResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_tags(self, repository_id, entry_id, **kwargs):  # noqa: E501
        """Returns the tags assigned to an entry.  # noqa: E501

        - Returns the tags assigned to an entry. - Provide an entry ID, and get a paged listing of tags assigned to that entry. - Default page size: 100. Allowed OData query options: Select | Count | OrderBy | Skip | Top | SkipToken | Prefer. - Required OAuth scope: repository.Read  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_tags(repository_id, entry_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str repository_id: The requested repository ID. (required)
        :param int entry_id: The requested entry ID. (required)
        :param str prefer: An optional OData header. Can be used to set the maximum page size using odata.maxpagesize.
        :param str select: Limits the properties returned in the result.
        :param str orderby: Specifies the order in which items are returned. The maximum number of expressions is 5.
        :param int top: Limits the number of items returned from a collection.
        :param int skip: Excludes the specified number of items of the queried collection from the result.
        :param bool count: Indicates whether the total count of items within a collection are returned in the result.
        :return: TagCollectionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_tags_with_http_info(repository_id, entry_id, **kwargs)  # noqa: E501
        else:
            (data) = self.list_tags_with_http_info(repository_id, entry_id, **kwargs)  # noqa: E501
            return data

    def list_tags_with_http_info(self, repository_id, entry_id, **kwargs):  # noqa: E501
        """Returns the tags assigned to an entry.  # noqa: E501

        - Returns the tags assigned to an entry. - Provide an entry ID, and get a paged listing of tags assigned to that entry. - Default page size: 100. Allowed OData query options: Select | Count | OrderBy | Skip | Top | SkipToken | Prefer. - Required OAuth scope: repository.Read  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_tags_with_http_info(repository_id, entry_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str repository_id: The requested repository ID. (required)
        :param int entry_id: The requested entry ID. (required)
        :param str prefer: An optional OData header. Can be used to set the maximum page size using odata.maxpagesize.
        :param str select: Limits the properties returned in the result.
        :param str orderby: Specifies the order in which items are returned. The maximum number of expressions is 5.
        :param int top: Limits the number of items returned from a collection.
        :param int skip: Excludes the specified number of items of the queried collection from the result.
        :param bool count: Indicates whether the total count of items within a collection are returned in the result.
        :return: TagCollectionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['repository_id', 'entry_id', 'prefer', 'select', 'orderby', 'top', 'skip', 'count']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_tags" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'repository_id' is set
        if ('repository_id' not in params or
                params['repository_id'] is None):
            raise ValueError("Missing the required parameter `repository_id` when calling `list_tags`")  # noqa: E501
        # verify the required parameter 'entry_id' is set
        if ('entry_id' not in params or
                params['entry_id'] is None):
            raise ValueError("Missing the required parameter `entry_id` when calling `list_tags`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'repository_id' in params:
            path_params['repositoryId'] = params['repository_id']  # noqa: E501
        if 'entry_id' in params:
            path_params['entryId'] = params['entry_id']  # noqa: E501

        query_params = []
        if 'select' in params:
            query_params.append(('$select', params['select']))  # noqa: E501
        if 'orderby' in params:
            query_params.append(('$orderby', params['orderby']))  # noqa: E501
        if 'top' in params:
            query_params.append(('$top', params['top']))  # noqa: E501
        if 'skip' in params:
            query_params.append(('$skip', params['skip']))  # noqa: E501
        if 'count' in params:
            query_params.append(('$count', params['count']))  # noqa: E501

        header_params = {}
        if 'prefer' in params:
            header_params['Prefer'] = params['prefer']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Authorization', 'OAuth2 Authorization Code Flow']  # noqa: E501

        return self.api_client.call_api(
            '/v2/Repositories/{repositoryId}/Entries/{entryId}/Tags', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TagCollectionResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def remove_template(self, repository_id, entry_id, **kwargs):  # noqa: E501
        """Removes the currently assigned template from an entry.  # noqa: E501

        - Remove the currently assigned template from the specified entry. - Provide an entry ID to clear template value on. - If the entry does not have a template assigned, no change will be made. - Required OAuth scope: repository.Write  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_template(repository_id, entry_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str repository_id: The requested repository ID. (required)
        :param int entry_id: The ID of the entry that will have its template removed. (required)
        :return: Entry
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.remove_template_with_http_info(repository_id, entry_id, **kwargs)  # noqa: E501
        else:
            (data) = self.remove_template_with_http_info(repository_id, entry_id, **kwargs)  # noqa: E501
            return data

    def remove_template_with_http_info(self, repository_id, entry_id, **kwargs):  # noqa: E501
        """Removes the currently assigned template from an entry.  # noqa: E501

        - Remove the currently assigned template from the specified entry. - Provide an entry ID to clear template value on. - If the entry does not have a template assigned, no change will be made. - Required OAuth scope: repository.Write  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_template_with_http_info(repository_id, entry_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str repository_id: The requested repository ID. (required)
        :param int entry_id: The ID of the entry that will have its template removed. (required)
        :return: Entry
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['repository_id', 'entry_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method remove_template" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'repository_id' is set
        if ('repository_id' not in params or
                params['repository_id'] is None):
            raise ValueError("Missing the required parameter `repository_id` when calling `remove_template`")  # noqa: E501
        # verify the required parameter 'entry_id' is set
        if ('entry_id' not in params or
                params['entry_id'] is None):
            raise ValueError("Missing the required parameter `entry_id` when calling `remove_template`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'repository_id' in params:
            path_params['repositoryId'] = params['repository_id']  # noqa: E501
        if 'entry_id' in params:
            path_params['entryId'] = params['entry_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Authorization', 'OAuth2 Authorization Code Flow']  # noqa: E501

        return self.api_client.call_api(
            '/v2/Repositories/{repositoryId}/Entries/{entryId}/Template', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Entry',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def set_fields(self, body, repository_id, entry_id, **kwargs):  # noqa: E501
        """Updates the field values assigned to an entry.  # noqa: E501

        - Update the field values assigned to an entry. - Provide the new field values to assign to the entry, and remove/reset all previously assigned field values. - This is an overwrite action. The request body must include all desired field values, including any existing field values that should remain assigned to the entry. Field values that are not included in the request will be deleted from the entry. If the field value that is not included is part of a template, it will still be assigned (as required by the template), but its value will be reset. - Required OAuth scope: repository.Write  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_fields(body, repository_id, entry_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SetFieldsRequest body: The request body. (required)
        :param str repository_id: The requested repository ID. (required)
        :param int entry_id: The entry ID of the entry that will have its fields updated. (required)
        :param str culture: An optional query parameter used to indicate the locale that should be used. The value should be a standard language tag. This may be used when setting field values with tokens.
        :return: FieldCollectionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.set_fields_with_http_info(body, repository_id, entry_id, **kwargs)  # noqa: E501
        else:
            (data) = self.set_fields_with_http_info(body, repository_id, entry_id, **kwargs)  # noqa: E501
            return data

    def set_fields_with_http_info(self, body, repository_id, entry_id, **kwargs):  # noqa: E501
        """Updates the field values assigned to an entry.  # noqa: E501

        - Update the field values assigned to an entry. - Provide the new field values to assign to the entry, and remove/reset all previously assigned field values. - This is an overwrite action. The request body must include all desired field values, including any existing field values that should remain assigned to the entry. Field values that are not included in the request will be deleted from the entry. If the field value that is not included is part of a template, it will still be assigned (as required by the template), but its value will be reset. - Required OAuth scope: repository.Write  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_fields_with_http_info(body, repository_id, entry_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SetFieldsRequest body: The request body. (required)
        :param str repository_id: The requested repository ID. (required)
        :param int entry_id: The entry ID of the entry that will have its fields updated. (required)
        :param str culture: An optional query parameter used to indicate the locale that should be used. The value should be a standard language tag. This may be used when setting field values with tokens.
        :return: FieldCollectionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'repository_id', 'entry_id', 'culture']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method set_fields" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `set_fields`")  # noqa: E501
        # verify the required parameter 'repository_id' is set
        if ('repository_id' not in params or
                params['repository_id'] is None):
            raise ValueError("Missing the required parameter `repository_id` when calling `set_fields`")  # noqa: E501
        # verify the required parameter 'entry_id' is set
        if ('entry_id' not in params or
                params['entry_id'] is None):
            raise ValueError("Missing the required parameter `entry_id` when calling `set_fields`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'repository_id' in params:
            path_params['repositoryId'] = params['repository_id']  # noqa: E501
        if 'entry_id' in params:
            path_params['entryId'] = params['entry_id']  # noqa: E501

        query_params = []
        if 'culture' in params:
            query_params.append(('culture', params['culture']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Authorization', 'OAuth2 Authorization Code Flow']  # noqa: E501

        return self.api_client.call_api(
            '/v2/Repositories/{repositoryId}/Entries/{entryId}/Fields', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='FieldCollectionResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def set_links(self, body, repository_id, entry_id, **kwargs):  # noqa: E501
        """Assigns links to an entry.  # noqa: E501

        - Assign links to an entry. - Provide an entry ID and a list of links to assign to that entry. - This is an overwrite action. The request must include all links to assign to the entry, including existing links that should remain assigned to the entry. - Required OAuth scope: repository.Write  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_links(body, repository_id, entry_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SetLinksRequest body: The request body. (required)
        :param str repository_id: The request repository ID. (required)
        :param int entry_id: The requested entry ID. (required)
        :return: LinkCollectionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.set_links_with_http_info(body, repository_id, entry_id, **kwargs)  # noqa: E501
        else:
            (data) = self.set_links_with_http_info(body, repository_id, entry_id, **kwargs)  # noqa: E501
            return data

    def set_links_with_http_info(self, body, repository_id, entry_id, **kwargs):  # noqa: E501
        """Assigns links to an entry.  # noqa: E501

        - Assign links to an entry. - Provide an entry ID and a list of links to assign to that entry. - This is an overwrite action. The request must include all links to assign to the entry, including existing links that should remain assigned to the entry. - Required OAuth scope: repository.Write  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_links_with_http_info(body, repository_id, entry_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SetLinksRequest body: The request body. (required)
        :param str repository_id: The request repository ID. (required)
        :param int entry_id: The requested entry ID. (required)
        :return: LinkCollectionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'repository_id', 'entry_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method set_links" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `set_links`")  # noqa: E501
        # verify the required parameter 'repository_id' is set
        if ('repository_id' not in params or
                params['repository_id'] is None):
            raise ValueError("Missing the required parameter `repository_id` when calling `set_links`")  # noqa: E501
        # verify the required parameter 'entry_id' is set
        if ('entry_id' not in params or
                params['entry_id'] is None):
            raise ValueError("Missing the required parameter `entry_id` when calling `set_links`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'repository_id' in params:
            path_params['repositoryId'] = params['repository_id']  # noqa: E501
        if 'entry_id' in params:
            path_params['entryId'] = params['entry_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Authorization', 'OAuth2 Authorization Code Flow']  # noqa: E501

        return self.api_client.call_api(
            '/v2/Repositories/{repositoryId}/Entries/{entryId}/Links', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='LinkCollectionResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def set_tags(self, body, repository_id, entry_id, **kwargs):  # noqa: E501
        """Assigns tags to an entry.  # noqa: E501

        - Assign tags to an entry. - Provide an entry ID and a list of tags to assign to that entry. - This is an overwrite action. The request must include all tags to assign to the entry, including existing tags that should remain assigned to the entry. - Required OAuth scope: repository.Write  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_tags(body, repository_id, entry_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SetTagsRequest body: The tags to add. (required)
        :param str repository_id: The requested repository ID. (required)
        :param int entry_id: The requested entry ID. (required)
        :return: TagCollectionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.set_tags_with_http_info(body, repository_id, entry_id, **kwargs)  # noqa: E501
        else:
            (data) = self.set_tags_with_http_info(body, repository_id, entry_id, **kwargs)  # noqa: E501
            return data

    def set_tags_with_http_info(self, body, repository_id, entry_id, **kwargs):  # noqa: E501
        """Assigns tags to an entry.  # noqa: E501

        - Assign tags to an entry. - Provide an entry ID and a list of tags to assign to that entry. - This is an overwrite action. The request must include all tags to assign to the entry, including existing tags that should remain assigned to the entry. - Required OAuth scope: repository.Write  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_tags_with_http_info(body, repository_id, entry_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SetTagsRequest body: The tags to add. (required)
        :param str repository_id: The requested repository ID. (required)
        :param int entry_id: The requested entry ID. (required)
        :return: TagCollectionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'repository_id', 'entry_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method set_tags" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `set_tags`")  # noqa: E501
        # verify the required parameter 'repository_id' is set
        if ('repository_id' not in params or
                params['repository_id'] is None):
            raise ValueError("Missing the required parameter `repository_id` when calling `set_tags`")  # noqa: E501
        # verify the required parameter 'entry_id' is set
        if ('entry_id' not in params or
                params['entry_id'] is None):
            raise ValueError("Missing the required parameter `entry_id` when calling `set_tags`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'repository_id' in params:
            path_params['repositoryId'] = params['repository_id']  # noqa: E501
        if 'entry_id' in params:
            path_params['entryId'] = params['entry_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Authorization', 'OAuth2 Authorization Code Flow']  # noqa: E501

        return self.api_client.call_api(
            '/v2/Repositories/{repositoryId}/Entries/{entryId}/Tags', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TagCollectionResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def set_template(self, body, repository_id, entry_id, **kwargs):  # noqa: E501
        """Assigns a template to an entry.  # noqa: E501

        - Assign a template to an entry. - Provide an entry ID, template name, and a list of template fields to assign to that entry. - Only template values will be modified. Any existing independent fields on the entry will not be modified, nor will they be added if included in the request. The only modification to fields will only occur on templated fields. If the previously assigned template includes common template fields as the newly assigned template, the common field values will not be modified. - Required OAuth scope: repository.Write  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_template(body, repository_id, entry_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SetTemplateRequest body: The template and template fields that will be assigned to the entry. (required)
        :param str repository_id: The requested repository ID. (required)
        :param int entry_id: The ID of entry that will have its template updated. (required)
        :param str culture: An optional query parameter used to indicate the locale that should be used. The value should be a standard language tag. This may be used when setting field values with tokens.
        :return: Entry
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.set_template_with_http_info(body, repository_id, entry_id, **kwargs)  # noqa: E501
        else:
            (data) = self.set_template_with_http_info(body, repository_id, entry_id, **kwargs)  # noqa: E501
            return data

    def set_template_with_http_info(self, body, repository_id, entry_id, **kwargs):  # noqa: E501
        """Assigns a template to an entry.  # noqa: E501

        - Assign a template to an entry. - Provide an entry ID, template name, and a list of template fields to assign to that entry. - Only template values will be modified. Any existing independent fields on the entry will not be modified, nor will they be added if included in the request. The only modification to fields will only occur on templated fields. If the previously assigned template includes common template fields as the newly assigned template, the common field values will not be modified. - Required OAuth scope: repository.Write  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_template_with_http_info(body, repository_id, entry_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SetTemplateRequest body: The template and template fields that will be assigned to the entry. (required)
        :param str repository_id: The requested repository ID. (required)
        :param int entry_id: The ID of entry that will have its template updated. (required)
        :param str culture: An optional query parameter used to indicate the locale that should be used. The value should be a standard language tag. This may be used when setting field values with tokens.
        :return: Entry
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'repository_id', 'entry_id', 'culture']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method set_template" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `set_template`")  # noqa: E501
        # verify the required parameter 'repository_id' is set
        if ('repository_id' not in params or
                params['repository_id'] is None):
            raise ValueError("Missing the required parameter `repository_id` when calling `set_template`")  # noqa: E501
        # verify the required parameter 'entry_id' is set
        if ('entry_id' not in params or
                params['entry_id'] is None):
            raise ValueError("Missing the required parameter `entry_id` when calling `set_template`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'repository_id' in params:
            path_params['repositoryId'] = params['repository_id']  # noqa: E501
        if 'entry_id' in params:
            path_params['entryId'] = params['entry_id']  # noqa: E501

        query_params = []
        if 'culture' in params:
            query_params.append(('culture', params['culture']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Authorization', 'OAuth2 Authorization Code Flow']  # noqa: E501

        return self.api_client.call_api(
            '/v2/Repositories/{repositoryId}/Entries/{entryId}/Template', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Entry',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def start_copy_entry(self, body, repository_id, entry_id, **kwargs):  # noqa: E501
        """Starts an asynchronous copy task to copy an entry into a folder.  # noqa: E501

        - Copy a new child entry in the designated folder async, and potentially return a taskId. - Provide the parent folder ID, and copy an entry as a child of the designated folder. - The status of the operation can be checked via the Tasks route. - Token substitution in the name of the copied entry is not supported. - Required OAuth scope: repository.Write  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.start_copy_entry(body, repository_id, entry_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param StartCopyEntryRequest body: The request body. (required)
        :param str repository_id: The requested repository ID. (required)
        :param int entry_id: The folder ID that the entry will be created in. (required)
        :param str culture: An optional query parameter used to indicate the locale that should be used. The value should be a standard language tag.
        :return: StartTaskResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.start_copy_entry_with_http_info(body, repository_id, entry_id, **kwargs)  # noqa: E501
        else:
            (data) = self.start_copy_entry_with_http_info(body, repository_id, entry_id, **kwargs)  # noqa: E501
            return data

    def start_copy_entry_with_http_info(self, body, repository_id, entry_id, **kwargs):  # noqa: E501
        """Starts an asynchronous copy task to copy an entry into a folder.  # noqa: E501

        - Copy a new child entry in the designated folder async, and potentially return a taskId. - Provide the parent folder ID, and copy an entry as a child of the designated folder. - The status of the operation can be checked via the Tasks route. - Token substitution in the name of the copied entry is not supported. - Required OAuth scope: repository.Write  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.start_copy_entry_with_http_info(body, repository_id, entry_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param StartCopyEntryRequest body: The request body. (required)
        :param str repository_id: The requested repository ID. (required)
        :param int entry_id: The folder ID that the entry will be created in. (required)
        :param str culture: An optional query parameter used to indicate the locale that should be used. The value should be a standard language tag.
        :return: StartTaskResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'repository_id', 'entry_id', 'culture']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method start_copy_entry" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `start_copy_entry`")  # noqa: E501
        # verify the required parameter 'repository_id' is set
        if ('repository_id' not in params or
                params['repository_id'] is None):
            raise ValueError("Missing the required parameter `repository_id` when calling `start_copy_entry`")  # noqa: E501
        # verify the required parameter 'entry_id' is set
        if ('entry_id' not in params or
                params['entry_id'] is None):
            raise ValueError("Missing the required parameter `entry_id` when calling `start_copy_entry`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'repository_id' in params:
            path_params['repositoryId'] = params['repository_id']  # noqa: E501
        if 'entry_id' in params:
            path_params['entryId'] = params['entry_id']  # noqa: E501

        query_params = []
        if 'culture' in params:
            query_params.append(('culture', params['culture']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Authorization', 'OAuth2 Authorization Code Flow']  # noqa: E501

        return self.api_client.call_api(
            '/v2/Repositories/{repositoryId}/Entries/{entryId}/Folder/CopyAsync', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='StartTaskResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def start_delete_entry(self, repository_id, entry_id, **kwargs):  # noqa: E501
        """Starts an asynchronous delete task to delete an entry.  # noqa: E501

        - Begins a task to delete an entry, and returns a taskId. - Provide an entry ID, and queue a delete task to remove it from the repository (includes nested objects if the entry is a Folder type). The entry will not be deleted immediately. - Optionally include an audit reason ID and comment in the JSON body. This route returns a taskId, and will run as an asynchronous operation. Check the progress via the Tasks route. - Required OAuth scope: repository.Write  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.start_delete_entry(repository_id, entry_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str repository_id: The requested repository ID. (required)
        :param int entry_id: The requested entry ID. (required)
        :param StartDeleteEntryRequest body: The submitted audit reason.
        :return: StartTaskResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.start_delete_entry_with_http_info(repository_id, entry_id, **kwargs)  # noqa: E501
        else:
            (data) = self.start_delete_entry_with_http_info(repository_id, entry_id, **kwargs)  # noqa: E501
            return data

    def start_delete_entry_with_http_info(self, repository_id, entry_id, **kwargs):  # noqa: E501
        """Starts an asynchronous delete task to delete an entry.  # noqa: E501

        - Begins a task to delete an entry, and returns a taskId. - Provide an entry ID, and queue a delete task to remove it from the repository (includes nested objects if the entry is a Folder type). The entry will not be deleted immediately. - Optionally include an audit reason ID and comment in the JSON body. This route returns a taskId, and will run as an asynchronous operation. Check the progress via the Tasks route. - Required OAuth scope: repository.Write  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.start_delete_entry_with_http_info(repository_id, entry_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str repository_id: The requested repository ID. (required)
        :param int entry_id: The requested entry ID. (required)
        :param StartDeleteEntryRequest body: The submitted audit reason.
        :return: StartTaskResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['repository_id', 'entry_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method start_delete_entry" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'repository_id' is set
        if ('repository_id' not in params or
                params['repository_id'] is None):
            raise ValueError("Missing the required parameter `repository_id` when calling `start_delete_entry`")  # noqa: E501
        # verify the required parameter 'entry_id' is set
        if ('entry_id' not in params or
                params['entry_id'] is None):
            raise ValueError("Missing the required parameter `entry_id` when calling `start_delete_entry`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'repository_id' in params:
            path_params['repositoryId'] = params['repository_id']  # noqa: E501
        if 'entry_id' in params:
            path_params['entryId'] = params['entry_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Authorization', 'OAuth2 Authorization Code Flow']  # noqa: E501

        return self.api_client.call_api(
            '/v2/Repositories/{repositoryId}/Entries/{entryId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='StartTaskResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def start_export_entry(self, body, repository_id, entry_id, **kwargs):  # noqa: E501
        """Starts an asynchronous export task to export an entry.  # noqa: E501

        - Starts an asynchronous export operation to export an entry. - If successful, it returns a taskId which can be used to check the status of the export operation or download the export result, otherwise, it returns an error. - Required OAuth scope: repository.Read  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.start_export_entry(body, repository_id, entry_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param StartExportEntryRequest body: The request body. (required)
        :param str repository_id: The requested repository ID. (required)
        :param int entry_id: The ID of entry to export. (required)
        :param str page_range: A comma-separated range of pages to include. Ex: 1,3,4 or 1-3,5-7,9. This value is ignored when part=Edoc.
        :return: StartTaskResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.start_export_entry_with_http_info(body, repository_id, entry_id, **kwargs)  # noqa: E501
        else:
            (data) = self.start_export_entry_with_http_info(body, repository_id, entry_id, **kwargs)  # noqa: E501
            return data

    def start_export_entry_with_http_info(self, body, repository_id, entry_id, **kwargs):  # noqa: E501
        """Starts an asynchronous export task to export an entry.  # noqa: E501

        - Starts an asynchronous export operation to export an entry. - If successful, it returns a taskId which can be used to check the status of the export operation or download the export result, otherwise, it returns an error. - Required OAuth scope: repository.Read  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.start_export_entry_with_http_info(body, repository_id, entry_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param StartExportEntryRequest body: The request body. (required)
        :param str repository_id: The requested repository ID. (required)
        :param int entry_id: The ID of entry to export. (required)
        :param str page_range: A comma-separated range of pages to include. Ex: 1,3,4 or 1-3,5-7,9. This value is ignored when part=Edoc.
        :return: StartTaskResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'repository_id', 'entry_id', 'page_range']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method start_export_entry" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `start_export_entry`")  # noqa: E501
        # verify the required parameter 'repository_id' is set
        if ('repository_id' not in params or
                params['repository_id'] is None):
            raise ValueError("Missing the required parameter `repository_id` when calling `start_export_entry`")  # noqa: E501
        # verify the required parameter 'entry_id' is set
        if ('entry_id' not in params or
                params['entry_id'] is None):
            raise ValueError("Missing the required parameter `entry_id` when calling `start_export_entry`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'repository_id' in params:
            path_params['repositoryId'] = params['repository_id']  # noqa: E501
        if 'entry_id' in params:
            path_params['entryId'] = params['entry_id']  # noqa: E501

        query_params = []
        if 'page_range' in params:
            query_params.append(('pageRange', params['page_range']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Authorization', 'OAuth2 Authorization Code Flow']  # noqa: E501

        return self.api_client.call_api(
            '/v2/Repositories/{repositoryId}/Entries/{entryId}/ExportAsync', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='StartTaskResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def start_import_uploaded_parts(self, repository_id, entry_id, **kwargs):  # noqa: E501
        """Starts an asynchronous import task to import a document into a folder.  # noqa: E501

        - Imports a new file in the specified folder. The file should be already written (in chunks) to the upload URLs obtained by calling the Upload api. The maximum file size allowed is 64 GB. - This route does not support partial success. - Required OAuth scope: repository.Write  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.start_import_uploaded_parts(repository_id, entry_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str repository_id: The requested repository ID. (required)
        :param int entry_id: The entry ID of the folder that the document will be created in. (required)
        :param StartImportUploadedPartsRequest body: The request body.
        :param str culture: An optional query parameter used to indicate the locale that should be used. The value should be a standard language tag. This may be used when setting field values with tokens.
        :return: StartTaskResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.start_import_uploaded_parts_with_http_info(repository_id, entry_id, **kwargs)  # noqa: E501
        else:
            (data) = self.start_import_uploaded_parts_with_http_info(repository_id, entry_id, **kwargs)  # noqa: E501
            return data

    def start_import_uploaded_parts_with_http_info(self, repository_id, entry_id, **kwargs):  # noqa: E501
        """Starts an asynchronous import task to import a document into a folder.  # noqa: E501

        - Imports a new file in the specified folder. The file should be already written (in chunks) to the upload URLs obtained by calling the Upload api. The maximum file size allowed is 64 GB. - This route does not support partial success. - Required OAuth scope: repository.Write  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.start_import_uploaded_parts_with_http_info(repository_id, entry_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str repository_id: The requested repository ID. (required)
        :param int entry_id: The entry ID of the folder that the document will be created in. (required)
        :param StartImportUploadedPartsRequest body: The request body.
        :param str culture: An optional query parameter used to indicate the locale that should be used. The value should be a standard language tag. This may be used when setting field values with tokens.
        :return: StartTaskResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['repository_id', 'entry_id', 'body', 'culture']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method start_import_uploaded_parts" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'repository_id' is set
        if ('repository_id' not in params or
                params['repository_id'] is None):
            raise ValueError("Missing the required parameter `repository_id` when calling `start_import_uploaded_parts`")  # noqa: E501
        # verify the required parameter 'entry_id' is set
        if ('entry_id' not in params or
                params['entry_id'] is None):
            raise ValueError("Missing the required parameter `entry_id` when calling `start_import_uploaded_parts`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'repository_id' in params:
            path_params['repositoryId'] = params['repository_id']  # noqa: E501
        if 'entry_id' in params:
            path_params['entryId'] = params['entry_id']  # noqa: E501

        query_params = []
        if 'culture' in params:
            query_params.append(('culture', params['culture']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Authorization', 'OAuth2 Authorization Code Flow']  # noqa: E501

        return self.api_client.call_api(
            '/v2/Repositories/{repositoryId}/Entries/{entryId}/Folder/ImportUploadedParts', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='StartTaskResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_entry(self, body, repository_id, entry_id, **kwargs):  # noqa: E501
        """Update an entry. (Move and/or Rename)  # noqa: E501

        - Update an entry. (Move and/or Rename) - Move an entry to a new folder by setting the ParentId in the request body. - Rename an entry by setting the Name in the request body. - Required OAuth scope: repository.Write  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_entry(body, repository_id, entry_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param UpdateEntryRequest body: The request containing the folder ID that the entry will be moved to and the new name the entry will be renamed to. (required)
        :param str repository_id: The requested repository ID. (required)
        :param int entry_id: The requested entry ID. (required)
        :param str culture: An optional query parameter used to indicate the locale that should be used. The value should be a standard language tag.
        :return: Entry
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_entry_with_http_info(body, repository_id, entry_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_entry_with_http_info(body, repository_id, entry_id, **kwargs)  # noqa: E501
            return data

    def update_entry_with_http_info(self, body, repository_id, entry_id, **kwargs):  # noqa: E501
        """Update an entry. (Move and/or Rename)  # noqa: E501

        - Update an entry. (Move and/or Rename) - Move an entry to a new folder by setting the ParentId in the request body. - Rename an entry by setting the Name in the request body. - Required OAuth scope: repository.Write  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_entry_with_http_info(body, repository_id, entry_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param UpdateEntryRequest body: The request containing the folder ID that the entry will be moved to and the new name the entry will be renamed to. (required)
        :param str repository_id: The requested repository ID. (required)
        :param int entry_id: The requested entry ID. (required)
        :param str culture: An optional query parameter used to indicate the locale that should be used. The value should be a standard language tag.
        :return: Entry
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'repository_id', 'entry_id', 'culture']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_entry" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_entry`")  # noqa: E501
        # verify the required parameter 'repository_id' is set
        if ('repository_id' not in params or
                params['repository_id'] is None):
            raise ValueError("Missing the required parameter `repository_id` when calling `update_entry`")  # noqa: E501
        # verify the required parameter 'entry_id' is set
        if ('entry_id' not in params or
                params['entry_id'] is None):
            raise ValueError("Missing the required parameter `entry_id` when calling `update_entry`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'repository_id' in params:
            path_params['repositoryId'] = params['repository_id']  # noqa: E501
        if 'entry_id' in params:
            path_params['entryId'] = params['entry_id']  # noqa: E501

        query_params = []
        if 'culture' in params:
            query_params.append(('culture', params['culture']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Authorization', 'OAuth2 Authorization Code Flow']  # noqa: E501

        return self.api_client.call_api(
            '/v2/Repositories/{repositoryId}/Entries/{entryId}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Entry',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
