# laserfiche-api
Welcome to the Laserfiche API Swagger Playground. You can try out any of our API calls against your live Laserfiche Cloud account. Visit the developer center for more details: <a href=\"https://developer.laserfiche.com\">https://developer.laserfiche.com</a><p><strong>Build# : </strong>561590</p>

This Python package is automatically generated by the [Swagger Codegen](https://github.com/swagger-api/swagger-codegen) project:

- API version: 1-alpha
- Package version: 1.0.7
- Build package: io.swagger.codegen.v3.generators.python.PythonClientCodegen

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on Github, you can install directly from Github

```sh
pip install git+https://github.com/Layer8Err/laserfiche_api.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/Layer8Err/laserfiche_api.git`)

Then import the package:
```python
import laserfiche_api 
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import laserfiche_api
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function
import time
import laserfiche_api
from laserfiche_api.rest import ApiException
from pprint import pprint


# create an instance of the API class
api_instance = laserfiche_api.AccessTokensApi(laserfiche_api.ApiClient(configuration))
repo_id = 'repo_id_example' # str | The requested repository ID.
body = laserfiche_api.CreateConnectionRequest() # CreateConnectionRequest | The username and password used to create the session connection. (optional)
create_cookie = true # bool | An optional query parameter used to indicate whether a Set-Cookie header containing             the authToken is returned in the response. (optional)
customer_id = 'customer_id_example' # str | The Laserfiche Cloud account ID to use when using username and password to create a session connection. (optional)

try:
    api_response = api_instance.create_access_token(repo_id, body=body, create_cookie=create_cookie, customer_id=customer_id)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AccessTokensApi->create_access_token: %s\n" % e)


# create an instance of the API class
api_instance = laserfiche_api.AccessTokensApi(laserfiche_api.ApiClient(configuration))
repo_id = 'repo_id_example' # str | The requested repository ID.

try:
    api_response = api_instance.invalidate_access_token(repo_id)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AccessTokensApi->invalidate_access_token: %s\n" % e)


# create an instance of the API class
api_instance = laserfiche_api.AccessTokensApi(laserfiche_api.ApiClient(configuration))
repo_id = 'repo_id_example' # str | The requested repository ID.
keep_alive = 'keep_alive_example' # str | An optional Keep-Alive header with timeout value can be used to specify how long the             session should be kept alive when idle. The maximum timeout value is 1 hour. (optional)

try:
    api_response = api_instance.refresh_access_token(repo_id, keep_alive=keep_alive)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AccessTokensApi->refresh_access_token: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to *https://api.laserfiche.com/repository*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AccessTokensApi* | [**create_access_token**](AccessTokensApi.md#create_access_token) | **POST** /v1-alpha/Repositories/{repoId}/AccessTokens/Create | 
*AccessTokensApi* | [**invalidate_access_token**](AccessTokensApi.md#invalidate_access_token) | **POST** /v1-alpha/Repositories/{repoId}/AccessTokens/Invalidate | 
*AccessTokensApi* | [**refresh_access_token**](AccessTokensApi.md#refresh_access_token) | **POST** /v1-alpha/Repositories/{repoId}/AccessTokens/Refresh | 
*AttributesApi* | [**get_trustee_attribute_key_value_pairs**](AttributesApi.md#get_trustee_attribute_key_value_pairs) | **GET** /v1-alpha/Repositories/{repoId}/Attributes | Get the attribute key value pairs associated with the authenticated user.
*AttributesApi* | [**get_trustee_attribute_value_by_key**](AttributesApi.md#get_trustee_attribute_value_by_key) | **GET** /v1-alpha/Repositories/{repoId}/Attributes/{attributeKey} | Get an attribute object by key associated with the authenticated user.
*AuditReasonsApi* | [**get_audit_reasons**](AuditReasonsApi.md#get_audit_reasons) | **GET** /v1-alpha/Repositories/{repoId}/AuditReasons | Get the audit reasons associated with the authenticated user.
*EntriesApi* | [**assign_entry_links**](EntriesApi.md#assign_entry_links) | **PUT** /v1-alpha/Repositories/{repoId}/Entries/{entryId}/links | 
*EntriesApi* | [**assign_field_values**](EntriesApi.md#assign_field_values) | **PUT** /v1-alpha/Repositories/{repoId}/Entries/{entryId}/fields | 
*EntriesApi* | [**assign_tags**](EntriesApi.md#assign_tags) | **PUT** /v1-alpha/Repositories/{repoId}/Entries/{entryId}/tags | 
*EntriesApi* | [**copy_entry_async**](EntriesApi.md#copy_entry_async) | **POST** /v1-alpha/Repositories/{repoId}/Entries/{entryId}/Laserfiche.Repository.Folder/CopyAsync | 
*EntriesApi* | [**create_or_copy_entry**](EntriesApi.md#create_or_copy_entry) | **POST** /v1-alpha/Repositories/{repoId}/Entries/{entryId}/Laserfiche.Repository.Folder/children | 
*EntriesApi* | [**delete_assigned_template**](EntriesApi.md#delete_assigned_template) | **DELETE** /v1-alpha/Repositories/{repoId}/Entries/{entryId}/template | 
*EntriesApi* | [**delete_entry_info**](EntriesApi.md#delete_entry_info) | **DELETE** /v1-alpha/Repositories/{repoId}/Entries/{entryId} | 
*EntriesApi* | [**export_document**](EntriesApi.md#export_document) | **GET** /v1-alpha/Repositories/{repoId}/Entries/{entryId}/Laserfiche.Repository.Document/edoc | 
*EntriesApi* | [**export_document_with_audit_reason**](EntriesApi.md#export_document_with_audit_reason) | **POST** /v1-alpha/Repositories/{repoId}/Entries/{entryId}/Laserfiche.Repository.Document/GetEdocWithAuditReason | 
*EntriesApi* | [**get_document_content_type**](EntriesApi.md#get_document_content_type) | **HEAD** /v1-alpha/Repositories/{repoId}/Entries/{entryId}/Laserfiche.Repository.Document/edoc | 
*EntriesApi* | [**get_dynamic_field_values**](EntriesApi.md#get_dynamic_field_values) | **POST** /v1-alpha/Repositories/{repoId}/Entries/{entryId}/fields/GetDynamicFieldLogicValue | 
*EntriesApi* | [**get_entry**](EntriesApi.md#get_entry) | **GET** /v1-alpha/Repositories/{repoId}/Entries/{entryId} | 
*EntriesApi* | [**get_entry_listing**](EntriesApi.md#get_entry_listing) | **GET** /v1-alpha/Repositories/{repoId}/Entries/{entryId}/Laserfiche.Repository.Folder/children | 
*EntriesApi* | [**get_field_values**](EntriesApi.md#get_field_values) | **GET** /v1-alpha/Repositories/{repoId}/Entries/{entryId}/fields | 
*EntriesApi* | [**get_link_values_from_entry**](EntriesApi.md#get_link_values_from_entry) | **GET** /v1-alpha/Repositories/{repoId}/Entries/{entryId}/links | 
*EntriesApi* | [**get_tags_assigned_to_entry**](EntriesApi.md#get_tags_assigned_to_entry) | **GET** /v1-alpha/Repositories/{repoId}/Entries/{entryId}/tags | 
*EntriesApi* | [**import_document**](EntriesApi.md#import_document) | **POST** /v1-alpha/Repositories/{repoId}/Entries/{parentEntryId}/{fileName} | 
*EntriesApi* | [**move_or_rename_document**](EntriesApi.md#move_or_rename_document) | **PATCH** /v1-alpha/Repositories/{repoId}/Entries/{entryId} | 
*EntriesApi* | [**write_template_value_to_entry**](EntriesApi.md#write_template_value_to_entry) | **PUT** /v1-alpha/Repositories/{repoId}/Entries/{entryId}/template | 
*FieldDefinitionsApi* | [**get_field_definition_by_id**](FieldDefinitionsApi.md#get_field_definition_by_id) | **GET** /v1-alpha/Repositories/{repoId}/FieldDefinitions/{fieldDefinitionId} | 
*FieldDefinitionsApi* | [**get_field_definitions**](FieldDefinitionsApi.md#get_field_definitions) | **GET** /v1-alpha/Repositories/{repoId}/FieldDefinitions | 
*SearchesApi* | [**cancel_or_close_a_search**](SearchesApi.md#cancel_or_close_a_search) | **DELETE** /v1-alpha/Repositories/{repoId}/Searches/{searchToken} | Cancel or close an advanced search.
*SearchesApi* | [**create_search_operation**](SearchesApi.md#create_search_operation) | **POST** /v1-alpha/Repositories/{repoId}/Searches | Run a search in the specified repository.
*SearchesApi* | [**get_search_context_hits**](SearchesApi.md#get_search_context_hits) | **GET** /v1-alpha/Repositories/{repoId}/Searches/{searchToken}/Results/{rowNumber}/ContextHits | 
*SearchesApi* | [**get_search_results**](SearchesApi.md#get_search_results) | **GET** /v1-alpha/Repositories/{repoId}/Searches/{searchToken}/Results | Get the search results listing of a search.
*SearchesApi* | [**get_search_status**](SearchesApi.md#get_search_status) | **GET** /v1-alpha/Repositories/{repoId}/Searches/{searchToken} | Get the status of a search using a token.
*SimpleSearchesApi* | [**create_simple_search_operation**](SimpleSearchesApi.md#create_simple_search_operation) | **POST** /v1-alpha/Repositories/{repoId}/SimpleSearches | 
*TagDefinitionsApi* | [**get_tag_definition_by_id**](TagDefinitionsApi.md#get_tag_definition_by_id) | **GET** /v1-alpha/Repositories/{repoId}/TagDefinitions/{tagId} | 
*TagDefinitionsApi* | [**get_tag_definitions**](TagDefinitionsApi.md#get_tag_definitions) | **GET** /v1-alpha/Repositories/{repoId}/TagDefinitions | 
*TasksApi* | [**cancel_operation**](TasksApi.md#cancel_operation) | **DELETE** /v1-alpha/Repositories/{repoId}/Tasks/{operationToken} | 
*TasksApi* | [**get_operation_status_and_progress**](TasksApi.md#get_operation_status_and_progress) | **GET** /v1-alpha/Repositories/{repoId}/Tasks/{operationToken} | 
*TemplateDefinitionsApi* | [**get_template_definition_by_id**](TemplateDefinitionsApi.md#get_template_definition_by_id) | **GET** /v1-alpha/Repositories/{repoId}/TemplateDefinitions/{templateId} | 
*TemplateDefinitionsApi* | [**get_template_definitions**](TemplateDefinitionsApi.md#get_template_definitions) | **GET** /v1-alpha/Repositories/{repoId}/TemplateDefinitions | 
*TemplateDefinitionsApi* | [**get_template_field_definitions**](TemplateDefinitionsApi.md#get_template_field_definitions) | **GET** /v1-alpha/Repositories/{repoId}/TemplateDefinitions/{templateId}/fields | 

## Documentation For Models

 - [APIServerException](APIServerException.md)
 - [AcceptedOperation](AcceptedOperation.md)
 - [AdvancedSearchRequest](AdvancedSearchRequest.md)
 - [Attribute](Attribute.md)
 - [AuditReasons](AuditReasons.md)
 - [ContextHit](ContextHit.md)
 - [CopyAsyncRequest](CopyAsyncRequest.md)
 - [CreateConnectionRequest](CreateConnectionRequest.md)
 - [CreateEntryOperations](CreateEntryOperations.md)
 - [CreateEntryResult](CreateEntryResult.md)
 - [DeleteEntryWithAuditReason](DeleteEntryWithAuditReason.md)
 - [Document](Document.md)
 - [Edoc](Edoc.md)
 - [Entry](Entry.md)
 - [EntryCreate](EntryCreate.md)
 - [EntryType](EntryType.md)
 - [FieldToUpdate](FieldToUpdate.md)
 - [FieldValue](FieldValue.md)
 - [Folder](Folder.md)
 - [FuzzyType](FuzzyType.md)
 - [GetDynamicFieldLogicValueRequest](GetDynamicFieldLogicValueRequest.md)
 - [GetEdocWithAuditReasonRequest](GetEdocWithAuditReasonRequest.md)
 - [HitType](HitType.md)
 - [LFColor](LFColor.md)
 - [LinkToUpdate](LinkToUpdate.md)
 - [ODataActionParameters](ODataActionParameters.md)
 - [ODataValueOfBoolean](ODataValueOfBoolean.md)
 - [ODataValueOfDateTime](ODataValueOfDateTime.md)
 - [ODataValueOfIListOfContextHit](ODataValueOfIListOfContextHit.md)
 - [ODataValueOfIListOfEntry](ODataValueOfIListOfEntry.md)
 - [ODataValueOfIListOfFieldValue](ODataValueOfIListOfFieldValue.md)
 - [ODataValueOfIListOfTemplateFieldInfo](ODataValueOfIListOfTemplateFieldInfo.md)
 - [ODataValueOfIListOfWEntryLinkInfo](ODataValueOfIListOfWEntryLinkInfo.md)
 - [ODataValueOfIListOfWFieldInfo](ODataValueOfIListOfWFieldInfo.md)
 - [ODataValueOfIListOfWTagInfo](ODataValueOfIListOfWTagInfo.md)
 - [ODataValueOfIListOfWTemplateInfo](ODataValueOfIListOfWTemplateInfo.md)
 - [ODataValueOfListOfAttribute](ODataValueOfListOfAttribute.md)
 - [OneOfAdvancedSearchRequestFuzzyType](OneOfAdvancedSearchRequestFuzzyType.md)
 - [OneOfEntryEntryType](OneOfEntryEntryType.md)
 - [OneOfFieldValueFieldType](OneOfFieldValueFieldType.md)
 - [OneOfPostEntryChildrenRequestEntryType](OneOfPostEntryChildrenRequestEntryType.md)
 - [OneOfWFieldInfoFieldType](OneOfWFieldInfoFieldType.md)
 - [OneOfWFieldInfoFormat](OneOfWFieldInfoFormat.md)
 - [OneOfWTagInfoWatermark](OneOfWTagInfoWatermark.md)
 - [OneOfWTemplateInfoColor](OneOfWTemplateInfoColor.md)
 - [OneOfWatermarkWatermarkPosition](OneOfWatermarkWatermarkPosition.md)
 - [OperationErrorItem](OperationErrorItem.md)
 - [OperationProgress](OperationProgress.md)
 - [OperationStatus](OperationStatus.md)
 - [ParentEntryIdFileNameBody](ParentEntryIdFileNameBody.md)
 - [PatchEntryRequest](PatchEntryRequest.md)
 - [PostEntryChildrenRequest](PostEntryChildrenRequest.md)
 - [PostEntryWithEdocMetadataRequest](PostEntryWithEdocMetadataRequest.md)
 - [PutFieldValsRequest](PutFieldValsRequest.md)
 - [PutLinksRequest](PutLinksRequest.md)
 - [PutTagRequest](PutTagRequest.md)
 - [PutTemplateRequest](PutTemplateRequest.md)
 - [Rule](Rule.md)
 - [SessionKeyInfo](SessionKeyInfo.md)
 - [SetEdoc](SetEdoc.md)
 - [SetFields](SetFields.md)
 - [SetLinks](SetLinks.md)
 - [SetTags](SetTags.md)
 - [SetTemplate](SetTemplate.md)
 - [Shortcut](Shortcut.md)
 - [SimpleSearchRequest](SimpleSearchRequest.md)
 - [TemplateFieldInfo](TemplateFieldInfo.md)
 - [ValueToUpdate](ValueToUpdate.md)
 - [WAuditReason](WAuditReason.md)
 - [WEntryLinkInfo](WEntryLinkInfo.md)
 - [WFieldFormat](WFieldFormat.md)
 - [WFieldInfo](WFieldInfo.md)
 - [WFieldType](WFieldType.md)
 - [WTagInfo](WTagInfo.md)
 - [WTemplateInfo](WTemplateInfo.md)
 - [Watermark](Watermark.md)
 - [WatermarkPosition](WatermarkPosition.md)

## Documentation For Authorization


## Authorization



## Author


