# laserfiche_api

This Laserfiche API SDK is auto-generated by Swagger-Codegen v3.

You can find the PyPi page for this project [here](https://pypi.org/project/laserfiche-api/).

# Documentation

* [Laserfiche API](https://api.laserfiche.com/repository/swagger/index.html)
* [Swagger Codegen](https://swagger.io/tools/swagger-codegen/)

# Build info

The Laserfiche API has been built to work with OpenAPI 3.0.0. Because of this, swagger-codegen v3 must be used.

The `api_gen.sh` script under the `API_GEN` folder will spin up a Docker container running `swagger-codegen-cli-v3` and export the `laserfiche_api` SDK to a folder with the same name.

If the resulting SDK files are pushed to their own PyPi repo, they can be installed with:

```bash
pip install laserfiche-api
```

You can also manually install via setuptools:

```bash
python setup.py install --user
```
_____________________________________________________
# *** Auto-generated laserfiche-api documentation ***

_The following documentation is auto-generated by Swagger-Codegen._
_____________________________________________________

# laserfiche-api
Welcome to the Laserfiche API Swagger Playground. You can try out any of our API calls against your live Laserfiche Cloud account. Visit the developer center for more details: <a href=\"https://developer.laserfiche.com\">https://developer.laserfiche.com</a><p>Visit the changelog for the list of changes: <a href=\"/repository/v2/changelog\">/repository/v2/changelog</a></p><p><strong>Build# : </strong>41a7347c0662989661d7ab8105a70d36cb42518e_.20240124.4</p>

This Python package is automatically generated by the [Swagger Codegen](https://github.com/swagger-api/swagger-codegen) project:

- API version: 2
- Package version: 1.1.0
- Build package: io.swagger.codegen.v3.generators.python.PythonClientCodegen

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on Github, you can install directly from Github

```sh
pip install git+https://github.com/Layer8Err/laserfiche_api.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/Layer8Err/laserfiche_api.git`)

Then import the package:
```python
import laserfiche_api 
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import laserfiche_api
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function
import time
import laserfiche_api
from laserfiche_api.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: OAuth2 Authorization Code Flow
configuration = laserfiche_api.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = laserfiche_api.AttributesApi(laserfiche_api.ApiClient(configuration))
repository_id = 'repository_id_example' # str | The requested repository ID.
attribute_key = 'attribute_key_example' # str | The requested attribute key.
everyone = false # bool | Indicates if attributes associated with the \"Everyone\" group or the currently authenticated user is returned. The default value is false. (optional) (default to false)

try:
    # Returns an attribute object associated with the authenticated user.
    api_response = api_instance.get_attribute(repository_id, attribute_key, everyone=everyone)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AttributesApi->get_attribute: %s\n" % e)

# Configure OAuth2 access token for authorization: OAuth2 Authorization Code Flow
configuration = laserfiche_api.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = laserfiche_api.AttributesApi(laserfiche_api.ApiClient(configuration))
repository_id = 'repository_id_example' # str | The requested repository ID.
everyone = false # bool | Indicates if attributes associated with the \"Everyone\" group or the currently authenticated user is returned. The default value is false. (optional) (default to false)
prefer = 'prefer_example' # str | An optional OData header. Can be used to set the maximum page size using odata.maxpagesize. (optional)
select = 'select_example' # str | Limits the properties returned in the result. (optional)
orderby = 'orderby_example' # str | Specifies the order in which items are returned. The maximum number of expressions is 5. (optional)
top = 56 # int | Limits the number of items returned from a collection. (optional)
skip = 56 # int | Excludes the specified number of items of the queried collection from the result. (optional)
count = true # bool | Indicates whether the total count of items within a collection are returned in the result. (optional)

try:
    # Returns the attribute key value pairs associated with the authenticated user.
    api_response = api_instance.list_attributes(repository_id, everyone=everyone, prefer=prefer, select=select, orderby=orderby, top=top, skip=skip, count=count)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AttributesApi->list_attributes: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to *https://api.laserfiche.com/repository*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AttributesApi* | [**get_attribute**](docs/AttributesApi.md#get_attribute) | **GET** /v2/Repositories/{repositoryId}/Attributes/{attributeKey} | Returns an attribute object associated with the authenticated user.
*AttributesApi* | [**list_attributes**](docs/AttributesApi.md#list_attributes) | **GET** /v2/Repositories/{repositoryId}/Attributes | Returns the attribute key value pairs associated with the authenticated user.
*AuditReasonsApi* | [**list_audit_reasons**](docs/AuditReasonsApi.md#list_audit_reasons) | **GET** /v2/Repositories/{repositoryId}/AuditReasons | Returns the audit reasons associated with the authenticated user.
*EntriesApi* | [**copy_entry**](docs/EntriesApi.md#copy_entry) | **POST** /v2/Repositories/{repositoryId}/Entries/{entryId}/Folder/Copy | Copies a new child entry in a folder.
*EntriesApi* | [**create_entry**](docs/EntriesApi.md#create_entry) | **POST** /v2/Repositories/{repositoryId}/Entries/{entryId}/Folder/Children | Creates a new child entry in a folder.
*EntriesApi* | [**create_multipart_upload_urls**](docs/EntriesApi.md#create_multipart_upload_urls) | **POST** /v2/Repositories/{repositoryId}/Entries/CreateMultipartUploadUrls | Requests Upload URLs to upload a large file in chunks.
*EntriesApi* | [**delete_electronic_document**](docs/EntriesApi.md#delete_electronic_document) | **DELETE** /v2/Repositories/{repositoryId}/Entries/{entryId}/Document/Edoc | Deletes the edoc associated with an entry.
*EntriesApi* | [**delete_pages**](docs/EntriesApi.md#delete_pages) | **DELETE** /v2/Repositories/{repositoryId}/Entries/{entryId}/Document/Pages | Deletes the pages associated with an entry.
*EntriesApi* | [**export_entry**](docs/EntriesApi.md#export_entry) | **POST** /v2/Repositories/{repositoryId}/Entries/{entryId}/Export | Exports an entry.
*EntriesApi* | [**get_entry**](docs/EntriesApi.md#get_entry) | **GET** /v2/Repositories/{repositoryId}/Entries/{entryId} | Returns a single entry object.
*EntriesApi* | [**get_entry_by_path**](docs/EntriesApi.md#get_entry_by_path) | **GET** /v2/Repositories/{repositoryId}/Entries/ByPath | Returns a single entry object using the entry path.
*EntriesApi* | [**import_entry**](docs/EntriesApi.md#import_entry) | **POST** /v2/Repositories/{repositoryId}/Entries/{entryId}/Folder/Import | Imports a file into a folder (max length: 100 MB).
*EntriesApi* | [**list_dynamic_field_values**](docs/EntriesApi.md#list_dynamic_field_values) | **POST** /v2/Repositories/{repositoryId}/Entries/{entryId}/Fields/GetDynamicFieldLogicValue | Returns the dynamic field logic values assigned to an entry.
*EntriesApi* | [**list_entries**](docs/EntriesApi.md#list_entries) | **GET** /v2/Repositories/{repositoryId}/Entries/{entryId}/Folder/Children | Returns the children entries of a folder.
*EntriesApi* | [**list_fields**](docs/EntriesApi.md#list_fields) | **GET** /v2/Repositories/{repositoryId}/Entries/{entryId}/Fields | Returns the fields assigned to an entry.
*EntriesApi* | [**list_links**](docs/EntriesApi.md#list_links) | **GET** /v2/Repositories/{repositoryId}/Entries/{entryId}/Links | Returns the links assigned to an entry.
*EntriesApi* | [**list_tags**](docs/EntriesApi.md#list_tags) | **GET** /v2/Repositories/{repositoryId}/Entries/{entryId}/Tags | Returns the tags assigned to an entry.
*EntriesApi* | [**remove_template**](docs/EntriesApi.md#remove_template) | **DELETE** /v2/Repositories/{repositoryId}/Entries/{entryId}/Template | Removes the currently assigned template from an entry.
*EntriesApi* | [**set_fields**](docs/EntriesApi.md#set_fields) | **PUT** /v2/Repositories/{repositoryId}/Entries/{entryId}/Fields | Updates the field values assigned to an entry.
*EntriesApi* | [**set_links**](docs/EntriesApi.md#set_links) | **PUT** /v2/Repositories/{repositoryId}/Entries/{entryId}/Links | Assigns links to an entry.
*EntriesApi* | [**set_tags**](docs/EntriesApi.md#set_tags) | **PUT** /v2/Repositories/{repositoryId}/Entries/{entryId}/Tags | Assigns tags to an entry.
*EntriesApi* | [**set_template**](docs/EntriesApi.md#set_template) | **PUT** /v2/Repositories/{repositoryId}/Entries/{entryId}/Template | Assigns a template to an entry.
*EntriesApi* | [**start_copy_entry**](docs/EntriesApi.md#start_copy_entry) | **POST** /v2/Repositories/{repositoryId}/Entries/{entryId}/Folder/CopyAsync | Starts an asynchronous copy task to copy an entry into a folder.
*EntriesApi* | [**start_delete_entry**](docs/EntriesApi.md#start_delete_entry) | **DELETE** /v2/Repositories/{repositoryId}/Entries/{entryId} | Starts an asynchronous delete task to delete an entry.
*EntriesApi* | [**start_export_entry**](docs/EntriesApi.md#start_export_entry) | **POST** /v2/Repositories/{repositoryId}/Entries/{entryId}/ExportAsync | Starts an asynchronous export task to export an entry.
*EntriesApi* | [**start_import_uploaded_parts**](docs/EntriesApi.md#start_import_uploaded_parts) | **POST** /v2/Repositories/{repositoryId}/Entries/{entryId}/Folder/ImportUploadedParts | Starts an asynchronous import task to import a document into a folder.
*EntriesApi* | [**update_entry**](docs/EntriesApi.md#update_entry) | **PATCH** /v2/Repositories/{repositoryId}/Entries/{entryId} | Update an entry. (Move and/or Rename)
*FieldDefinitionsApi* | [**get_field_definition**](docs/FieldDefinitionsApi.md#get_field_definition) | **GET** /v2/Repositories/{repositoryId}/FieldDefinitions/{fieldId} | Returns a single field definition object.
*FieldDefinitionsApi* | [**list_field_definitions**](docs/FieldDefinitionsApi.md#list_field_definitions) | **GET** /v2/Repositories/{repositoryId}/FieldDefinitions | Returns the paged listing of the field definitions available in a repository.
*LinkDefinitionsApi* | [**get_link_definition**](docs/LinkDefinitionsApi.md#get_link_definition) | **GET** /v2/Repositories/{repositoryId}/LinkDefinitions/{linkDefinitionId} | Returns a single link definition object.
*LinkDefinitionsApi* | [**list_link_definitions**](docs/LinkDefinitionsApi.md#list_link_definitions) | **GET** /v2/Repositories/{repositoryId}/LinkDefinitions | Returns the link definitions associated with a repository.
*RepositoriesApi* | [**list_repositories**](docs/RepositoriesApi.md#list_repositories) | **GET** /v2/Repositories | Returns the list of repositories accessible to the user.
*SearchesApi* | [**list_search_context_hits**](docs/SearchesApi.md#list_search_context_hits) | **GET** /v2/Repositories/{repositoryId}/Searches/{taskId}/Results/{rowNumber}/ContextHits | Returns the context hits associated with a search result entry.
*SearchesApi* | [**list_search_results**](docs/SearchesApi.md#list_search_results) | **GET** /v2/Repositories/{repositoryId}/Searches/{taskId}/Results | Returns the results listing associated with a search task.
*SearchesApi* | [**start_search_entry**](docs/SearchesApi.md#start_search_entry) | **POST** /v2/Repositories/{repositoryId}/Searches/SearchAsync | Starts an asynchronous search task.
*SimpleSearchesApi* | [**search_entry**](docs/SimpleSearchesApi.md#search_entry) | **POST** /v2/Repositories/{repositoryId}/SimpleSearches | Runs a \&quot;simple\&quot; search operation.
*TagDefinitionsApi* | [**get_tag_definition**](docs/TagDefinitionsApi.md#get_tag_definition) | **GET** /v2/Repositories/{repositoryId}/TagDefinitions/{tagId} | Returns a single tag definition object.
*TagDefinitionsApi* | [**list_tag_definitions**](docs/TagDefinitionsApi.md#list_tag_definitions) | **GET** /v2/Repositories/{repositoryId}/TagDefinitions | Returns the tag definitions associated with a repository.
*TasksApi* | [**cancel_tasks**](docs/TasksApi.md#cancel_tasks) | **DELETE** /v2/Repositories/{repositoryId}/Tasks | Starts the cancellation for a set of one or more tasks.
*TasksApi* | [**list_tasks**](docs/TasksApi.md#list_tasks) | **GET** /v2/Repositories/{repositoryId}/Tasks | Returns the status of a set of one or more tasks.
*TemplateDefinitionsApi* | [**get_template_definition**](docs/TemplateDefinitionsApi.md#get_template_definition) | **GET** /v2/Repositories/{repositoryId}/TemplateDefinitions/{templateId} | Returns a single template definition object.
*TemplateDefinitionsApi* | [**list_template_definitions**](docs/TemplateDefinitionsApi.md#list_template_definitions) | **GET** /v2/Repositories/{repositoryId}/TemplateDefinitions | Returns the template definitions associated with a repository.
*TemplateDefinitionsApi* | [**list_template_field_definitions_by_template_id**](docs/TemplateDefinitionsApi.md#list_template_field_definitions_by_template_id) | **GET** /v2/Repositories/{repositoryId}/TemplateDefinitions/{templateId}/FieldDefinitions | Returns the field definitions assigned to a template definition (by template definition ID).
*TemplateDefinitionsApi* | [**list_template_field_definitions_by_template_name**](docs/TemplateDefinitionsApi.md#list_template_field_definitions_by_template_name) | **GET** /v2/Repositories/{repositoryId}/TemplateDefinitions/FieldDefinitions | Returns the field definitions assigned to a template definition (by template definition name).

## Documentation For Models

 - [Attribute](docs/Attribute.md)
 - [AttributeCollectionResponse](docs/AttributeCollectionResponse.md)
 - [AuditEventType](docs/AuditEventType.md)
 - [AuditReason](docs/AuditReason.md)
 - [AuditReasonCollectionResponse](docs/AuditReasonCollectionResponse.md)
 - [CancelTaskResult](docs/CancelTaskResult.md)
 - [CancelTasksResponse](docs/CancelTasksResponse.md)
 - [CopyEntryRequest](docs/CopyEntryRequest.md)
 - [CreateEntryRequest](docs/CreateEntryRequest.md)
 - [CreateEntryRequestEntryType](docs/CreateEntryRequestEntryType.md)
 - [CreateMultipartUploadUrlsRequest](docs/CreateMultipartUploadUrlsRequest.md)
 - [CreateMultipartUploadUrlsResponse](docs/CreateMultipartUploadUrlsResponse.md)
 - [Document](docs/Document.md)
 - [Entry](docs/Entry.md)
 - [EntryCollectionResponse](docs/EntryCollectionResponse.md)
 - [EntryType](docs/EntryType.md)
 - [ExportEntryRequest](docs/ExportEntryRequest.md)
 - [ExportEntryRequestImageFormat](docs/ExportEntryRequestImageFormat.md)
 - [ExportEntryRequestImageOptions](docs/ExportEntryRequestImageOptions.md)
 - [ExportEntryRequestPart](docs/ExportEntryRequestPart.md)
 - [ExportEntryRequestTextOptions](docs/ExportEntryRequestTextOptions.md)
 - [ExportEntryRequestWatermark](docs/ExportEntryRequestWatermark.md)
 - [ExportEntryResponse](docs/ExportEntryResponse.md)
 - [Field](docs/Field.md)
 - [FieldCollectionResponse](docs/FieldCollectionResponse.md)
 - [FieldDefinition](docs/FieldDefinition.md)
 - [FieldDefinitionCollectionResponse](docs/FieldDefinitionCollectionResponse.md)
 - [FieldFormat](docs/FieldFormat.md)
 - [FieldToUpdate](docs/FieldToUpdate.md)
 - [FieldType](docs/FieldType.md)
 - [Folder](docs/Folder.md)
 - [FolderImportBody](docs/FolderImportBody.md)
 - [FuzzyType](docs/FuzzyType.md)
 - [GeneratePagesImageType](docs/GeneratePagesImageType.md)
 - [GetEntryByPathResponse](docs/GetEntryByPathResponse.md)
 - [HitType](docs/HitType.md)
 - [ImportEntryRequest](docs/ImportEntryRequest.md)
 - [ImportEntryRequestMetadata](docs/ImportEntryRequestMetadata.md)
 - [ImportEntryRequestPdfOptions](docs/ImportEntryRequestPdfOptions.md)
 - [LFColor](docs/LFColor.md)
 - [Link](docs/Link.md)
 - [LinkCollectionResponse](docs/LinkCollectionResponse.md)
 - [LinkDefinition](docs/LinkDefinition.md)
 - [LinkDefinitionCollectionResponse](docs/LinkDefinitionCollectionResponse.md)
 - [LinkToUpdate](docs/LinkToUpdate.md)
 - [ListDynamicFieldValuesRequest](docs/ListDynamicFieldValuesRequest.md)
 - [OneOfAuditReasonAuditEventType](docs/OneOfAuditReasonAuditEventType.md)
 - [OneOfCancelTaskResultTaskType](docs/OneOfCancelTaskResultTaskType.md)
 - [OneOfCreateEntryRequestEntryType](docs/OneOfCreateEntryRequestEntryType.md)
 - [OneOfEntryEntryType](docs/OneOfEntryEntryType.md)
 - [OneOfExportEntryRequestImageOptions](docs/OneOfExportEntryRequestImageOptions.md)
 - [OneOfExportEntryRequestImageOptionsFormat](docs/OneOfExportEntryRequestImageOptionsFormat.md)
 - [OneOfExportEntryRequestImageOptionsWatermark](docs/OneOfExportEntryRequestImageOptionsWatermark.md)
 - [OneOfExportEntryRequestPart](docs/OneOfExportEntryRequestPart.md)
 - [OneOfExportEntryRequestTextOptions](docs/OneOfExportEntryRequestTextOptions.md)
 - [OneOfExportEntryRequestWatermarkPosition](docs/OneOfExportEntryRequestWatermarkPosition.md)
 - [OneOfFieldDefinitionFieldType](docs/OneOfFieldDefinitionFieldType.md)
 - [OneOfFieldDefinitionFormat](docs/OneOfFieldDefinitionFormat.md)
 - [OneOfFieldFieldType](docs/OneOfFieldFieldType.md)
 - [OneOfGetEntryByPathResponseAncestorEntry](docs/OneOfGetEntryByPathResponseAncestorEntry.md)
 - [OneOfGetEntryByPathResponseEntry](docs/OneOfGetEntryByPathResponseEntry.md)
 - [OneOfImportEntryRequestMetadata](docs/OneOfImportEntryRequestMetadata.md)
 - [OneOfImportEntryRequestPdfOptions](docs/OneOfImportEntryRequestPdfOptions.md)
 - [OneOfImportEntryRequestPdfOptionsGeneratePagesImageType](docs/OneOfImportEntryRequestPdfOptionsGeneratePagesImageType.md)
 - [OneOfSearchContextHitHitType](docs/OneOfSearchContextHitHitType.md)
 - [OneOfStartExportEntryRequestImageOptions](docs/OneOfStartExportEntryRequestImageOptions.md)
 - [OneOfStartExportEntryRequestPart](docs/OneOfStartExportEntryRequestPart.md)
 - [OneOfStartExportEntryRequestTextOptions](docs/OneOfStartExportEntryRequestTextOptions.md)
 - [OneOfStartImportUploadedPartsRequestMetadata](docs/OneOfStartImportUploadedPartsRequestMetadata.md)
 - [OneOfStartImportUploadedPartsRequestPdfOptions](docs/OneOfStartImportUploadedPartsRequestPdfOptions.md)
 - [OneOfStartSearchEntryRequestFuzzyType](docs/OneOfStartSearchEntryRequestFuzzyType.md)
 - [OneOfTagDefinitionWatermark](docs/OneOfTagDefinitionWatermark.md)
 - [OneOfTagDefinitionWatermarkPosition](docs/OneOfTagDefinitionWatermarkPosition.md)
 - [OneOfTagWatermark](docs/OneOfTagWatermark.md)
 - [OneOfTaskProgressResult](docs/OneOfTaskProgressResult.md)
 - [OneOfTaskProgressStatus](docs/OneOfTaskProgressStatus.md)
 - [OneOfTaskProgressTaskType](docs/OneOfTaskProgressTaskType.md)
 - [OneOfTemplateDefinitionColor](docs/OneOfTemplateDefinitionColor.md)
 - [ProblemDetails](docs/ProblemDetails.md)
 - [RecordSeries](docs/RecordSeries.md)
 - [Repository](docs/Repository.md)
 - [RepositoryCollectionResponse](docs/RepositoryCollectionResponse.md)
 - [Rule](docs/Rule.md)
 - [SearchContextHit](docs/SearchContextHit.md)
 - [SearchContextHitCollectionResponse](docs/SearchContextHitCollectionResponse.md)
 - [SearchEntryRequest](docs/SearchEntryRequest.md)
 - [SetFieldsRequest](docs/SetFieldsRequest.md)
 - [SetLinksRequest](docs/SetLinksRequest.md)
 - [SetTagsRequest](docs/SetTagsRequest.md)
 - [SetTemplateRequest](docs/SetTemplateRequest.md)
 - [Shortcut](docs/Shortcut.md)
 - [StartCopyEntryRequest](docs/StartCopyEntryRequest.md)
 - [StartDeleteEntryRequest](docs/StartDeleteEntryRequest.md)
 - [StartExportEntryRequest](docs/StartExportEntryRequest.md)
 - [StartImportUploadedPartsRequest](docs/StartImportUploadedPartsRequest.md)
 - [StartSearchEntryRequest](docs/StartSearchEntryRequest.md)
 - [StartTaskResponse](docs/StartTaskResponse.md)
 - [Tag](docs/Tag.md)
 - [TagCollectionResponse](docs/TagCollectionResponse.md)
 - [TagDefinition](docs/TagDefinition.md)
 - [TagDefinitionCollectionResponse](docs/TagDefinitionCollectionResponse.md)
 - [TagDefinitionWatermark](docs/TagDefinitionWatermark.md)
 - [TaskCollectionResponse](docs/TaskCollectionResponse.md)
 - [TaskProgress](docs/TaskProgress.md)
 - [TaskResult](docs/TaskResult.md)
 - [TaskStatus](docs/TaskStatus.md)
 - [TaskType](docs/TaskType.md)
 - [TemplateDefinition](docs/TemplateDefinition.md)
 - [TemplateDefinitionCollectionResponse](docs/TemplateDefinitionCollectionResponse.md)
 - [TemplateFieldDefinition](docs/TemplateFieldDefinition.md)
 - [TemplateFieldDefinitionCollectionResponse](docs/TemplateFieldDefinitionCollectionResponse.md)
 - [UpdateEntryRequest](docs/UpdateEntryRequest.md)
 - [WatermarkPosition](docs/WatermarkPosition.md)

## Documentation For Authorization


## Authorization


## OAuth2 Authorization Code Flow

- **Type**: OAuth
- **Flow**: accessCode
- **Authorization URL**: https://signin.laserfiche.com/oauth/Authorize
- **Scopes**: 
 - **repository.Read**: Allows the app to read the content of Laserfiche repositories on behalf of the signed-in user.
 - **repository.Write**: Allows the app to modify the content of Laserfiche repositories on behalf of the signed-in user.


## Author


