/*
 * THIS FILE WAS GENERATED BY PLOTLY.BLAZOR.GENERATOR
*/

using System;
using System.Collections.Generic;
using System.Diagnostics.CodeAnalysis;
using System.IO;
using System.Linq;
using System.Runtime.Serialization.Formatters.Binary;
using System.Text.Json.Serialization;

namespace Plotly.Blazor.Traces
{
    /// <summary>
    ///     The Sunburst class.
    ///     Implements the <see cref="ITrace" />.
    /// </summary>
    [System.CodeDom.Compiler.GeneratedCode("Plotly.Blazor.Generator", null)]
    [JsonConverter(typeof(PlotlyConverter))]
    [Serializable]
    public class Sunburst : ITrace, IEquatable<Sunburst>
    {
        /// <inheritdoc/>
        [JsonPropertyName(@"type")]
        public TraceTypeEnum? Type { get; } = TraceTypeEnum.Sunburst;

        /// <summary>
        ///     Determines how the items in <c>values</c> are summed. When set to <c>total</c>,
        ///     items in <c>values</c> are taken to be value of all its descendants. When
        ///     set to <c>remainder</c>, items in <c>values</c> corresponding to the root
        ///     and the branches sectors are taken to be the extra part not part of the
        ///     sum of the values at their leaves.
        /// </summary>
        [JsonPropertyName(@"branchvalues")]
        public Plotly.Blazor.Traces.SunburstLib.BranchValuesEnum? BranchValues { get; set;} 

        /// <summary>
        ///     Determines default for <c>values</c> when it is not provided, by inferring
        ///     a 1 for each of the <c>leaves</c> and/or <c>branches</c>, otherwise 0.
        /// </summary>
        [JsonPropertyName(@"count")]
        public Plotly.Blazor.Traces.SunburstLib.CountFlag? Count { get; set;} 

        /// <summary>
        ///     Assigns extra data each datum. This may be useful when listening to hover,
        ///     click and selection events. Note that, <c>scatter</c> traces also appends
        ///     customdata items in the markers DOM elements
        /// </summary>
        [JsonPropertyName(@"customdata")]
        public IList<object> CustomData { get; set;} 

        /// <summary>
        ///     Sets the source reference on Chart Studio Cloud for <c>customdata</c>.
        /// </summary>
        [JsonPropertyName(@"customdatasrc")]
        public string CustomDataSrc { get; set;} 

        /// <summary>
        ///     Gets or sets the Domain.
        /// </summary>
        [JsonPropertyName(@"domain")]
        public Plotly.Blazor.Traces.SunburstLib.Domain Domain { get; set;} 

        /// <summary>
        ///     Determines which trace information appear on hover. If <c>none</c> or <c>skip</c>
        ///     are set, no information is displayed upon hovering. But, if <c>none</c>
        ///     is set, click and hover events are still fired.
        /// </summary>
        [JsonPropertyName(@"hoverinfo")]
        public Plotly.Blazor.Traces.SunburstLib.HoverInfoFlag? HoverInfo { get; set;} 

        /// <summary>
        ///     Determines which trace information appear on hover. If <c>none</c> or <c>skip</c>
        ///     are set, no information is displayed upon hovering. But, if <c>none</c>
        ///     is set, click and hover events are still fired.
        /// </summary>
        [JsonPropertyName(@"hoverinfo")]
        [Array]
        public IList<Plotly.Blazor.Traces.SunburstLib.HoverInfoFlag?> HoverInfoArray { get; set;} 

        /// <summary>
        ///     Sets the source reference on Chart Studio Cloud for <c>hoverinfo</c>.
        /// </summary>
        [JsonPropertyName(@"hoverinfosrc")]
        public string HoverInfoSrc { get; set;} 

        /// <summary>
        ///     Gets or sets the HoverLabel.
        /// </summary>
        [JsonPropertyName(@"hoverlabel")]
        public Plotly.Blazor.Traces.SunburstLib.HoverLabel HoverLabel { get; set;} 

        /// <summary>
        ///     Template string used for rendering the information that appear on hover
        ///     box. Note that this will override <c>hoverinfo</c>. Variables are inserted
        ///     using %{variable}, for example &quot;y: %{y}&quot; as well as %{xother},
        ///     {%_xother}, {%_xother_}, {%xother_}. When showing info for several points,
        ///     <c>xother</c> will be added to those with different x positions from the
        ///     first point. An underscore before or after <c>(x|y)other</c> will add a
        ///     space on that side, only when this field is shown. Numbers are formatted
        ///     using d3-format&#39;s syntax %{variable:d3-format}, for example &quot;Price:
        ///     %{y:$.2f}&quot;. https://github.com/d3/d3-format/tree/v1.4.5#d3-format for
        ///     details on the formatting syntax. Dates are formatted using d3-time-format&#39;s
        ///     syntax %{variable|d3-time-format}, for example &quot;Day: %{2019-01-01|%A}&quot;.
        ///     https://github.com/d3/d3-time-format/tree/v2.2.3#locale_format for details
        ///     on the date formatting syntax. The variables available in <c>hovertemplate</c>
        ///     are the ones emitted as event data described at this link https://plotly.com/javascript/plotlyjs-events/#event-data.
        ///     Additionally, every attributes that can be specified per-point (the ones
        ///     that are &#39;arrayOk: true&#39;) are available. Finally, the template string
        ///     has access to variables <c>currentPath</c>, <c>root</c>, <c>entry</c>, <c>percentRoot</c>,
        ///     <c>percentEntry</c> and <c>percentParent</c>. Anything contained in tag
        ///     <c>&lt;extra&gt;</c> is displayed in the secondary box, for example <c>&lt;extra&gt;{fullData.name}&lt;/extra&gt;</c>.
        ///     To hide the secondary box completely, use an empty tag <c>&lt;extra&gt;&lt;/extra&gt;</c>.
        /// </summary>
        [JsonPropertyName(@"hovertemplate")]
        public string HoverTemplate { get; set;} 

        /// <summary>
        ///     Template string used for rendering the information that appear on hover
        ///     box. Note that this will override <c>hoverinfo</c>. Variables are inserted
        ///     using %{variable}, for example &quot;y: %{y}&quot; as well as %{xother},
        ///     {%_xother}, {%_xother_}, {%xother_}. When showing info for several points,
        ///     <c>xother</c> will be added to those with different x positions from the
        ///     first point. An underscore before or after <c>(x|y)other</c> will add a
        ///     space on that side, only when this field is shown. Numbers are formatted
        ///     using d3-format&#39;s syntax %{variable:d3-format}, for example &quot;Price:
        ///     %{y:$.2f}&quot;. https://github.com/d3/d3-format/tree/v1.4.5#d3-format for
        ///     details on the formatting syntax. Dates are formatted using d3-time-format&#39;s
        ///     syntax %{variable|d3-time-format}, for example &quot;Day: %{2019-01-01|%A}&quot;.
        ///     https://github.com/d3/d3-time-format/tree/v2.2.3#locale_format for details
        ///     on the date formatting syntax. The variables available in <c>hovertemplate</c>
        ///     are the ones emitted as event data described at this link https://plotly.com/javascript/plotlyjs-events/#event-data.
        ///     Additionally, every attributes that can be specified per-point (the ones
        ///     that are &#39;arrayOk: true&#39;) are available. Finally, the template string
        ///     has access to variables <c>currentPath</c>, <c>root</c>, <c>entry</c>, <c>percentRoot</c>,
        ///     <c>percentEntry</c> and <c>percentParent</c>. Anything contained in tag
        ///     <c>&lt;extra&gt;</c> is displayed in the secondary box, for example <c>&lt;extra&gt;{fullData.name}&lt;/extra&gt;</c>.
        ///     To hide the secondary box completely, use an empty tag <c>&lt;extra&gt;&lt;/extra&gt;</c>.
        /// </summary>
        [JsonPropertyName(@"hovertemplate")]
        [Array]
        public IList<string> HoverTemplateArray { get; set;} 

        /// <summary>
        ///     Sets the source reference on Chart Studio Cloud for <c>hovertemplate</c>.
        /// </summary>
        [JsonPropertyName(@"hovertemplatesrc")]
        public string HoverTemplateSrc { get; set;} 

        /// <summary>
        ///     Sets hover text elements associated with each sector. If a single string,
        ///     the same string appears for all data points. If an array of string, the
        ///     items are mapped in order of this trace&#39;s sectors. To be seen, trace
        ///     <c>hoverinfo</c> must contain a <c>text</c> flag.
        /// </summary>
        [JsonPropertyName(@"hovertext")]
        public string HoverText { get; set;} 

        /// <summary>
        ///     Sets hover text elements associated with each sector. If a single string,
        ///     the same string appears for all data points. If an array of string, the
        ///     items are mapped in order of this trace&#39;s sectors. To be seen, trace
        ///     <c>hoverinfo</c> must contain a <c>text</c> flag.
        /// </summary>
        [JsonPropertyName(@"hovertext")]
        [Array]
        public IList<string> HoverTextArray { get; set;} 

        /// <summary>
        ///     Sets the source reference on Chart Studio Cloud for <c>hovertext</c>.
        /// </summary>
        [JsonPropertyName(@"hovertextsrc")]
        public string HoverTextSrc { get; set;} 

        /// <summary>
        ///     Assigns id labels to each datum. These ids for object constancy of data
        ///     points during animation. Should be an array of strings, not numbers or any
        ///     other type.
        /// </summary>
        [JsonPropertyName(@"ids")]
        public IList<object> Ids { get; set;} 

        /// <summary>
        ///     Sets the source reference on Chart Studio Cloud for <c>ids</c>.
        /// </summary>
        [JsonPropertyName(@"idssrc")]
        public string IdsSrc { get; set;} 

        /// <summary>
        ///     Sets the font used for <c>textinfo</c> lying inside the sector.
        /// </summary>
        [JsonPropertyName(@"insidetextfont")]
        public Plotly.Blazor.Traces.SunburstLib.InsideTextFont InsideTextFont { get; set;} 

        /// <summary>
        ///     Controls the orientation of the text inside chart sectors. When set to <c>auto</c>,
        ///     text may be oriented in any direction in order to be as big as possible
        ///     in the middle of a sector. The <c>horizontal</c> option orients text to
        ///     be parallel with the bottom of the chart, and may make text smaller in order
        ///     to achieve that goal. The <c>radial</c> option orients text along the radius
        ///     of the sector. The <c>tangential</c> option orients text perpendicular to
        ///     the radius of the sector.
        /// </summary>
        [JsonPropertyName(@"insidetextorientation")]
        public Plotly.Blazor.Traces.SunburstLib.InsideTextOrientationEnum? InsideTextOrientation { get; set;} 

        /// <summary>
        ///     Sets the labels of each of the sectors.
        /// </summary>
        [JsonPropertyName(@"labels")]
        public IList<object> Labels { get; set;} 

        /// <summary>
        ///     Sets the source reference on Chart Studio Cloud for <c>labels</c>.
        /// </summary>
        [JsonPropertyName(@"labelssrc")]
        public string LabelsSrc { get; set;} 

        /// <summary>
        ///     Gets or sets the Leaf.
        /// </summary>
        [JsonPropertyName(@"leaf")]
        public Plotly.Blazor.Traces.SunburstLib.Leaf Leaf { get; set;} 

        /// <summary>
        ///     Sets the reference to a legend to show this trace in. References to these
        ///     legends are <c>legend</c>, <c>legend2</c>, <c>legend3</c>, etc. Settings
        ///     for these legends are set in the layout, under <c>layout.legend</c>, <c>layout.legend2</c>,
        ///     etc.
        /// </summary>
        [JsonPropertyName(@"legend")]
        public string Legend { get; set;} 

        /// <summary>
        ///     Gets or sets the LegendGroupTitle.
        /// </summary>
        [JsonPropertyName(@"legendgrouptitle")]
        public Plotly.Blazor.Traces.SunburstLib.LegendGroupTitle LegendGroupTitle { get; set;} 

        /// <summary>
        ///     Sets the legend rank for this trace. Items and groups with smaller ranks
        ///     are presented on top/left side while with <c>reversed</c> <c>legend.traceorder</c>
        ///     they are on bottom/right side. The default legendrank is 1000, so that you
        ///     can use ranks less than 1000 to place certain items before all unranked
        ///     items, and ranks greater than 1000 to go after all unranked items. When
        ///     having unranked or equal rank items shapes would be displayed after traces
        ///     i.e. according to their order in data and layout.
        /// </summary>
        [JsonPropertyName(@"legendrank")]
        public decimal? LegendRank { get; set;} 

        /// <summary>
        ///     Sets the width (in px or fraction) of the legend for this trace.
        /// </summary>
        [JsonPropertyName(@"legendwidth")]
        public decimal? LegendWidth { get; set;} 

        /// <summary>
        ///     Sets the level from which this trace hierarchy is rendered. Set <c>level</c>
        ///     to <c>&#39;&#39;</c> to start from the root node in the hierarchy. Must
        ///     be an <c>id</c> if <c>ids</c> is filled in, otherwise plotly attempts to
        ///     find a matching item in <c>labels</c>.
        /// </summary>
        [JsonPropertyName(@"level")]
        public object Level { get; set;} 

        /// <summary>
        ///     Gets or sets the Marker.
        /// </summary>
        [JsonPropertyName(@"marker")]
        public Plotly.Blazor.Traces.SunburstLib.Marker Marker { get; set;} 

        /// <summary>
        ///     Sets the number of rendered sectors from any given <c>level</c>. Set <c>maxdepth</c>
        ///     to <c>-1</c> to render all the levels in the hierarchy.
        /// </summary>
        [JsonPropertyName(@"maxdepth")]
        public int? MaxDepth { get; set;} 

        /// <summary>
        ///     Assigns extra meta information associated with this trace that can be used
        ///     in various text attributes. Attributes such as trace <c>name</c>, graph,
        ///     axis and colorbar <c>title.text</c>, annotation <c>text</c> <c>rangeselector</c>,
        ///     <c>updatemenues</c> and <c>sliders</c> <c>label</c> text all support <c>meta</c>.
        ///     To access the trace <c>meta</c> values in an attribute in the same trace,
        ///     simply use <c>%{meta[i]}</c> where <c>i</c> is the index or key of the <c>meta</c>
        ///     item in question. To access trace <c>meta</c> in layout attributes, use
        ///     <c>%{data[n[.meta[i]}</c> where <c>i</c> is the index or key of the <c>meta</c>
        ///     and <c>n</c> is the trace index.
        /// </summary>
        [JsonPropertyName(@"meta")]
        public object Meta { get; set;} 

        /// <summary>
        ///     Assigns extra meta information associated with this trace that can be used
        ///     in various text attributes. Attributes such as trace <c>name</c>, graph,
        ///     axis and colorbar <c>title.text</c>, annotation <c>text</c> <c>rangeselector</c>,
        ///     <c>updatemenues</c> and <c>sliders</c> <c>label</c> text all support <c>meta</c>.
        ///     To access the trace <c>meta</c> values in an attribute in the same trace,
        ///     simply use <c>%{meta[i]}</c> where <c>i</c> is the index or key of the <c>meta</c>
        ///     item in question. To access trace <c>meta</c> in layout attributes, use
        ///     <c>%{data[n[.meta[i]}</c> where <c>i</c> is the index or key of the <c>meta</c>
        ///     and <c>n</c> is the trace index.
        /// </summary>
        [JsonPropertyName(@"meta")]
        [Array]
        public IList<object> MetaArray { get; set;} 

        /// <summary>
        ///     Sets the source reference on Chart Studio Cloud for <c>meta</c>.
        /// </summary>
        [JsonPropertyName(@"metasrc")]
        public string MetaSrc { get; set;} 

        /// <summary>
        ///     Sets the trace name. The trace name appears as the legend item and on hover.
        /// </summary>
        [JsonPropertyName(@"name")]
        public string Name { get; set;} 

        /// <summary>
        ///     Sets the opacity of the trace.
        /// </summary>
        [JsonPropertyName(@"opacity")]
        public decimal? Opacity { get; set;} 

        /// <summary>
        ///     Sets the font used for <c>textinfo</c> lying outside the sector. This option
        ///     refers to the root of the hierarchy presented at the center of a sunburst
        ///     graph. Please note that if a hierarchy has multiple root nodes, this option
        ///     won&#39;t have any effect and <c>insidetextfont</c> would be used.
        /// </summary>
        [JsonPropertyName(@"outsidetextfont")]
        public Plotly.Blazor.Traces.SunburstLib.OutsideTextFont OutsideTextFont { get; set;} 

        /// <summary>
        ///     Sets the parent sectors for each of the sectors. Empty string items &#39;&#39;
        ///     are understood to reference the root node in the hierarchy. If <c>ids</c>
        ///     is filled, <c>parents</c> items are understood to be <c>ids</c> themselves.
        ///     When <c>ids</c> is not set, plotly attempts to find matching items in <c>labels</c>,
        ///     but beware they must be unique.
        /// </summary>
        [JsonPropertyName(@"parents")]
        public IList<object> Parents { get; set;} 

        /// <summary>
        ///     Sets the source reference on Chart Studio Cloud for <c>parents</c>.
        /// </summary>
        [JsonPropertyName(@"parentssrc")]
        public string ParentsSrc { get; set;} 

        /// <summary>
        ///     Gets or sets the Root.
        /// </summary>
        [JsonPropertyName(@"root")]
        public Plotly.Blazor.Traces.SunburstLib.Root Root { get; set;} 

        /// <summary>
        ///     Rotates the whole diagram counterclockwise by some angle. By default the
        ///     first slice starts at 3 o&#39;clock.
        /// </summary>
        [JsonPropertyName(@"rotation")]
        public decimal? Rotation { get; set;} 

        /// <summary>
        ///     Determines whether or not the sectors are reordered from largest to smallest.
        /// </summary>
        [JsonPropertyName(@"sort")]
        public bool? Sort { get; set;} 

        /// <summary>
        ///     Gets or sets the Stream.
        /// </summary>
        [JsonPropertyName(@"stream")]
        public Plotly.Blazor.Traces.SunburstLib.Stream Stream { get; set;} 

        /// <summary>
        ///     Sets text elements associated with each sector. If trace <c>textinfo</c>
        ///     contains a <c>text</c> flag, these elements will be seen on the chart. If
        ///     trace <c>hoverinfo</c> contains a <c>text</c> flag and <c>hovertext</c>
        ///     is not set, these elements will be seen in the hover labels.
        /// </summary>
        [JsonPropertyName(@"text")]
        public IList<object> Text { get; set;} 

        /// <summary>
        ///     Sets the font used for <c>textinfo</c>.
        /// </summary>
        [JsonPropertyName(@"textfont")]
        public Plotly.Blazor.Traces.SunburstLib.TextFont TextFont { get; set;} 

        /// <summary>
        ///     Determines which trace information appear on the graph.
        /// </summary>
        [JsonPropertyName(@"textinfo")]
        public Plotly.Blazor.Traces.SunburstLib.TextInfoFlag? TextInfo { get; set;} 

        /// <summary>
        ///     Sets the source reference on Chart Studio Cloud for <c>text</c>.
        /// </summary>
        [JsonPropertyName(@"textsrc")]
        public string TextSrc { get; set;} 

        /// <summary>
        ///     Template string used for rendering the information text that appear on points.
        ///     Note that this will override <c>textinfo</c>. Variables are inserted using
        ///     %{variable}, for example &quot;y: %{y}&quot;. Numbers are formatted using
        ///     d3-format&#39;s syntax %{variable:d3-format}, for example &quot;Price: %{y:$.2f}&quot;.
        ///     https://github.com/d3/d3-format/tree/v1.4.5#d3-format for details on the
        ///     formatting syntax. Dates are formatted using d3-time-format&#39;s syntax
        ///     %{variable|d3-time-format}, for example &quot;Day: %{2019-01-01|%A}&quot;.
        ///     https://github.com/d3/d3-time-format/tree/v2.2.3#locale_format for details
        ///     on the date formatting syntax. Every attributes that can be specified per-point
        ///     (the ones that are &#39;arrayOk: true&#39;) are available. Finally, the
        ///     template string has access to variables <c>currentPath</c>, <c>root</c>,
        ///     <c>entry</c>, <c>percentRoot</c>, <c>percentEntry</c>, <c>percentParent</c>,
        ///     <c>label</c> and <c>value</c>.
        /// </summary>
        [JsonPropertyName(@"texttemplate")]
        public string TextTemplate { get; set;} 

        /// <summary>
        ///     Template string used for rendering the information text that appear on points.
        ///     Note that this will override <c>textinfo</c>. Variables are inserted using
        ///     %{variable}, for example &quot;y: %{y}&quot;. Numbers are formatted using
        ///     d3-format&#39;s syntax %{variable:d3-format}, for example &quot;Price: %{y:$.2f}&quot;.
        ///     https://github.com/d3/d3-format/tree/v1.4.5#d3-format for details on the
        ///     formatting syntax. Dates are formatted using d3-time-format&#39;s syntax
        ///     %{variable|d3-time-format}, for example &quot;Day: %{2019-01-01|%A}&quot;.
        ///     https://github.com/d3/d3-time-format/tree/v2.2.3#locale_format for details
        ///     on the date formatting syntax. Every attributes that can be specified per-point
        ///     (the ones that are &#39;arrayOk: true&#39;) are available. Finally, the
        ///     template string has access to variables <c>currentPath</c>, <c>root</c>,
        ///     <c>entry</c>, <c>percentRoot</c>, <c>percentEntry</c>, <c>percentParent</c>,
        ///     <c>label</c> and <c>value</c>.
        /// </summary>
        [JsonPropertyName(@"texttemplate")]
        [Array]
        public IList<string> TextTemplateArray { get; set;} 

        /// <summary>
        ///     Sets the source reference on Chart Studio Cloud for <c>texttemplate</c>.
        /// </summary>
        [JsonPropertyName(@"texttemplatesrc")]
        public string TextTemplateSrc { get; set;} 

        /// <summary>
        ///     Gets or sets the Transforms.
        /// </summary>
        [JsonPropertyName(@"transforms")]
        public IList<ITransform> Transforms { get; set;} 

        /// <summary>
        ///     Assign an id to this trace, Use this to provide object constancy between
        ///     traces during animations and transitions.
        /// </summary>
        [JsonPropertyName(@"uid")]
        public string UId { get; set;} 

        /// <summary>
        ///     Controls persistence of some user-driven changes to the trace: <c>constraintrange</c>
        ///     in <c>parcoords</c> traces, as well as some &#39;editable: true&#39; modifications
        ///     such as <c>name</c> and <c>colorbar.title</c>. Defaults to <c>layout.uirevision</c>.
        ///     Note that other user-driven trace attribute changes are controlled by <c>layout</c>
        ///     attributes: <c>trace.visible</c> is controlled by <c>layout.legend.uirevision</c>,
        ///     <c>selectedpoints</c> is controlled by <c>layout.selectionrevision</c>,
        ///     and <c>colorbar.(x|y)</c> (accessible with &#39;config: {editable: true}&#39;)
        ///     is controlled by <c>layout.editrevision</c>. Trace changes are tracked by
        ///     <c>uid</c>, which only falls back on trace index if no <c>uid</c> is provided.
        ///     So if your app can add/remove traces before the end of the <c>data</c> array,
        ///     such that the same trace has a different index, you can still preserve user-driven
        ///     changes if you give each trace a <c>uid</c> that stays with it as it moves.
        /// </summary>
        [JsonPropertyName(@"uirevision")]
        public object UiRevision { get; set;} 

        /// <summary>
        ///     Sets the values associated with each of the sectors. Use with <c>branchvalues</c>
        ///     to determine how the values are summed.
        /// </summary>
        [JsonPropertyName(@"values")]
        public IList<object> Values { get; set;} 

        /// <summary>
        ///     Sets the source reference on Chart Studio Cloud for <c>values</c>.
        /// </summary>
        [JsonPropertyName(@"valuessrc")]
        public string ValuesSrc { get; set;} 

        /// <summary>
        ///     Determines whether or not this trace is visible. If <c>legendonly</c>, the
        ///     trace is not drawn, but can appear as a legend item (provided that the legend
        ///     itself is visible).
        /// </summary>
        [JsonPropertyName(@"visible")]
        public Plotly.Blazor.Traces.SunburstLib.VisibleEnum? Visible { get; set;} 

        /// <inheritdoc />
        public override bool Equals(object obj)
        {
            if (!(obj is Sunburst other)) return false;

            return ReferenceEquals(this, obj) || Equals(other);
        }

        /// <inheritdoc />
        public bool Equals([AllowNull] Sunburst other)
        {
            if (other == null) return false;
            if (ReferenceEquals(this, other)) return true;

            return 
                (
                    Type == other.Type ||
                    Type != null &&
                    Type.Equals(other.Type)
                ) && 
                (
                    BranchValues == other.BranchValues ||
                    BranchValues != null &&
                    BranchValues.Equals(other.BranchValues)
                ) && 
                (
                    Count == other.Count ||
                    Count != null &&
                    Count.Equals(other.Count)
                ) && 
                (
                    Equals(CustomData, other.CustomData) ||
                    CustomData != null && other.CustomData != null &&
                    CustomData.SequenceEqual(other.CustomData)
                ) &&
                (
                    CustomDataSrc == other.CustomDataSrc ||
                    CustomDataSrc != null &&
                    CustomDataSrc.Equals(other.CustomDataSrc)
                ) && 
                (
                    Domain == other.Domain ||
                    Domain != null &&
                    Domain.Equals(other.Domain)
                ) && 
                (
                    HoverInfo == other.HoverInfo ||
                    HoverInfo != null &&
                    HoverInfo.Equals(other.HoverInfo)
                ) && 
                (
                    Equals(HoverInfoArray, other.HoverInfoArray) ||
                    HoverInfoArray != null && other.HoverInfoArray != null &&
                    HoverInfoArray.SequenceEqual(other.HoverInfoArray)
                ) &&
                (
                    HoverInfoSrc == other.HoverInfoSrc ||
                    HoverInfoSrc != null &&
                    HoverInfoSrc.Equals(other.HoverInfoSrc)
                ) && 
                (
                    HoverLabel == other.HoverLabel ||
                    HoverLabel != null &&
                    HoverLabel.Equals(other.HoverLabel)
                ) && 
                (
                    HoverTemplate == other.HoverTemplate ||
                    HoverTemplate != null &&
                    HoverTemplate.Equals(other.HoverTemplate)
                ) && 
                (
                    Equals(HoverTemplateArray, other.HoverTemplateArray) ||
                    HoverTemplateArray != null && other.HoverTemplateArray != null &&
                    HoverTemplateArray.SequenceEqual(other.HoverTemplateArray)
                ) &&
                (
                    HoverTemplateSrc == other.HoverTemplateSrc ||
                    HoverTemplateSrc != null &&
                    HoverTemplateSrc.Equals(other.HoverTemplateSrc)
                ) && 
                (
                    HoverText == other.HoverText ||
                    HoverText != null &&
                    HoverText.Equals(other.HoverText)
                ) && 
                (
                    Equals(HoverTextArray, other.HoverTextArray) ||
                    HoverTextArray != null && other.HoverTextArray != null &&
                    HoverTextArray.SequenceEqual(other.HoverTextArray)
                ) &&
                (
                    HoverTextSrc == other.HoverTextSrc ||
                    HoverTextSrc != null &&
                    HoverTextSrc.Equals(other.HoverTextSrc)
                ) && 
                (
                    Equals(Ids, other.Ids) ||
                    Ids != null && other.Ids != null &&
                    Ids.SequenceEqual(other.Ids)
                ) &&
                (
                    IdsSrc == other.IdsSrc ||
                    IdsSrc != null &&
                    IdsSrc.Equals(other.IdsSrc)
                ) && 
                (
                    InsideTextFont == other.InsideTextFont ||
                    InsideTextFont != null &&
                    InsideTextFont.Equals(other.InsideTextFont)
                ) && 
                (
                    InsideTextOrientation == other.InsideTextOrientation ||
                    InsideTextOrientation != null &&
                    InsideTextOrientation.Equals(other.InsideTextOrientation)
                ) && 
                (
                    Equals(Labels, other.Labels) ||
                    Labels != null && other.Labels != null &&
                    Labels.SequenceEqual(other.Labels)
                ) &&
                (
                    LabelsSrc == other.LabelsSrc ||
                    LabelsSrc != null &&
                    LabelsSrc.Equals(other.LabelsSrc)
                ) && 
                (
                    Leaf == other.Leaf ||
                    Leaf != null &&
                    Leaf.Equals(other.Leaf)
                ) && 
                (
                    Legend == other.Legend ||
                    Legend != null &&
                    Legend.Equals(other.Legend)
                ) && 
                (
                    LegendGroupTitle == other.LegendGroupTitle ||
                    LegendGroupTitle != null &&
                    LegendGroupTitle.Equals(other.LegendGroupTitle)
                ) && 
                (
                    LegendRank == other.LegendRank ||
                    LegendRank != null &&
                    LegendRank.Equals(other.LegendRank)
                ) && 
                (
                    LegendWidth == other.LegendWidth ||
                    LegendWidth != null &&
                    LegendWidth.Equals(other.LegendWidth)
                ) && 
                (
                    Level == other.Level ||
                    Level != null &&
                    Level.Equals(other.Level)
                ) && 
                (
                    Marker == other.Marker ||
                    Marker != null &&
                    Marker.Equals(other.Marker)
                ) && 
                (
                    MaxDepth == other.MaxDepth ||
                    MaxDepth != null &&
                    MaxDepth.Equals(other.MaxDepth)
                ) && 
                (
                    Meta == other.Meta ||
                    Meta != null &&
                    Meta.Equals(other.Meta)
                ) && 
                (
                    Equals(MetaArray, other.MetaArray) ||
                    MetaArray != null && other.MetaArray != null &&
                    MetaArray.SequenceEqual(other.MetaArray)
                ) &&
                (
                    MetaSrc == other.MetaSrc ||
                    MetaSrc != null &&
                    MetaSrc.Equals(other.MetaSrc)
                ) && 
                (
                    Name == other.Name ||
                    Name != null &&
                    Name.Equals(other.Name)
                ) && 
                (
                    Opacity == other.Opacity ||
                    Opacity != null &&
                    Opacity.Equals(other.Opacity)
                ) && 
                (
                    OutsideTextFont == other.OutsideTextFont ||
                    OutsideTextFont != null &&
                    OutsideTextFont.Equals(other.OutsideTextFont)
                ) && 
                (
                    Equals(Parents, other.Parents) ||
                    Parents != null && other.Parents != null &&
                    Parents.SequenceEqual(other.Parents)
                ) &&
                (
                    ParentsSrc == other.ParentsSrc ||
                    ParentsSrc != null &&
                    ParentsSrc.Equals(other.ParentsSrc)
                ) && 
                (
                    Root == other.Root ||
                    Root != null &&
                    Root.Equals(other.Root)
                ) && 
                (
                    Rotation == other.Rotation ||
                    Rotation != null &&
                    Rotation.Equals(other.Rotation)
                ) && 
                (
                    Sort == other.Sort ||
                    Sort != null &&
                    Sort.Equals(other.Sort)
                ) && 
                (
                    Stream == other.Stream ||
                    Stream != null &&
                    Stream.Equals(other.Stream)
                ) && 
                (
                    Equals(Text, other.Text) ||
                    Text != null && other.Text != null &&
                    Text.SequenceEqual(other.Text)
                ) &&
                (
                    TextFont == other.TextFont ||
                    TextFont != null &&
                    TextFont.Equals(other.TextFont)
                ) && 
                (
                    TextInfo == other.TextInfo ||
                    TextInfo != null &&
                    TextInfo.Equals(other.TextInfo)
                ) && 
                (
                    TextSrc == other.TextSrc ||
                    TextSrc != null &&
                    TextSrc.Equals(other.TextSrc)
                ) && 
                (
                    TextTemplate == other.TextTemplate ||
                    TextTemplate != null &&
                    TextTemplate.Equals(other.TextTemplate)
                ) && 
                (
                    Equals(TextTemplateArray, other.TextTemplateArray) ||
                    TextTemplateArray != null && other.TextTemplateArray != null &&
                    TextTemplateArray.SequenceEqual(other.TextTemplateArray)
                ) &&
                (
                    TextTemplateSrc == other.TextTemplateSrc ||
                    TextTemplateSrc != null &&
                    TextTemplateSrc.Equals(other.TextTemplateSrc)
                ) && 
                (
                    Equals(Transforms, other.Transforms) ||
                    Transforms != null && other.Transforms != null &&
                    Transforms.SequenceEqual(other.Transforms)
                ) &&
                (
                    UId == other.UId ||
                    UId != null &&
                    UId.Equals(other.UId)
                ) && 
                (
                    UiRevision == other.UiRevision ||
                    UiRevision != null &&
                    UiRevision.Equals(other.UiRevision)
                ) && 
                (
                    Equals(Values, other.Values) ||
                    Values != null && other.Values != null &&
                    Values.SequenceEqual(other.Values)
                ) &&
                (
                    ValuesSrc == other.ValuesSrc ||
                    ValuesSrc != null &&
                    ValuesSrc.Equals(other.ValuesSrc)
                ) && 
                (
                    Visible == other.Visible ||
                    Visible != null &&
                    Visible.Equals(other.Visible)
                );
        }

        /// <inheritdoc />
        public override int GetHashCode()
        {
            unchecked // Overflow is fine, just wrap
            {
                var hashCode = 41;
                if (Type != null) hashCode = hashCode * 59 + Type.GetHashCode();
                if (BranchValues != null) hashCode = hashCode * 59 + BranchValues.GetHashCode();
                if (Count != null) hashCode = hashCode * 59 + Count.GetHashCode();
                if (CustomData != null) hashCode = hashCode * 59 + CustomData.GetHashCode();
                if (CustomDataSrc != null) hashCode = hashCode * 59 + CustomDataSrc.GetHashCode();
                if (Domain != null) hashCode = hashCode * 59 + Domain.GetHashCode();
                if (HoverInfo != null) hashCode = hashCode * 59 + HoverInfo.GetHashCode();
                if (HoverInfoArray != null) hashCode = hashCode * 59 + HoverInfoArray.GetHashCode();
                if (HoverInfoSrc != null) hashCode = hashCode * 59 + HoverInfoSrc.GetHashCode();
                if (HoverLabel != null) hashCode = hashCode * 59 + HoverLabel.GetHashCode();
                if (HoverTemplate != null) hashCode = hashCode * 59 + HoverTemplate.GetHashCode();
                if (HoverTemplateArray != null) hashCode = hashCode * 59 + HoverTemplateArray.GetHashCode();
                if (HoverTemplateSrc != null) hashCode = hashCode * 59 + HoverTemplateSrc.GetHashCode();
                if (HoverText != null) hashCode = hashCode * 59 + HoverText.GetHashCode();
                if (HoverTextArray != null) hashCode = hashCode * 59 + HoverTextArray.GetHashCode();
                if (HoverTextSrc != null) hashCode = hashCode * 59 + HoverTextSrc.GetHashCode();
                if (Ids != null) hashCode = hashCode * 59 + Ids.GetHashCode();
                if (IdsSrc != null) hashCode = hashCode * 59 + IdsSrc.GetHashCode();
                if (InsideTextFont != null) hashCode = hashCode * 59 + InsideTextFont.GetHashCode();
                if (InsideTextOrientation != null) hashCode = hashCode * 59 + InsideTextOrientation.GetHashCode();
                if (Labels != null) hashCode = hashCode * 59 + Labels.GetHashCode();
                if (LabelsSrc != null) hashCode = hashCode * 59 + LabelsSrc.GetHashCode();
                if (Leaf != null) hashCode = hashCode * 59 + Leaf.GetHashCode();
                if (Legend != null) hashCode = hashCode * 59 + Legend.GetHashCode();
                if (LegendGroupTitle != null) hashCode = hashCode * 59 + LegendGroupTitle.GetHashCode();
                if (LegendRank != null) hashCode = hashCode * 59 + LegendRank.GetHashCode();
                if (LegendWidth != null) hashCode = hashCode * 59 + LegendWidth.GetHashCode();
                if (Level != null) hashCode = hashCode * 59 + Level.GetHashCode();
                if (Marker != null) hashCode = hashCode * 59 + Marker.GetHashCode();
                if (MaxDepth != null) hashCode = hashCode * 59 + MaxDepth.GetHashCode();
                if (Meta != null) hashCode = hashCode * 59 + Meta.GetHashCode();
                if (MetaArray != null) hashCode = hashCode * 59 + MetaArray.GetHashCode();
                if (MetaSrc != null) hashCode = hashCode * 59 + MetaSrc.GetHashCode();
                if (Name != null) hashCode = hashCode * 59 + Name.GetHashCode();
                if (Opacity != null) hashCode = hashCode * 59 + Opacity.GetHashCode();
                if (OutsideTextFont != null) hashCode = hashCode * 59 + OutsideTextFont.GetHashCode();
                if (Parents != null) hashCode = hashCode * 59 + Parents.GetHashCode();
                if (ParentsSrc != null) hashCode = hashCode * 59 + ParentsSrc.GetHashCode();
                if (Root != null) hashCode = hashCode * 59 + Root.GetHashCode();
                if (Rotation != null) hashCode = hashCode * 59 + Rotation.GetHashCode();
                if (Sort != null) hashCode = hashCode * 59 + Sort.GetHashCode();
                if (Stream != null) hashCode = hashCode * 59 + Stream.GetHashCode();
                if (Text != null) hashCode = hashCode * 59 + Text.GetHashCode();
                if (TextFont != null) hashCode = hashCode * 59 + TextFont.GetHashCode();
                if (TextInfo != null) hashCode = hashCode * 59 + TextInfo.GetHashCode();
                if (TextSrc != null) hashCode = hashCode * 59 + TextSrc.GetHashCode();
                if (TextTemplate != null) hashCode = hashCode * 59 + TextTemplate.GetHashCode();
                if (TextTemplateArray != null) hashCode = hashCode * 59 + TextTemplateArray.GetHashCode();
                if (TextTemplateSrc != null) hashCode = hashCode * 59 + TextTemplateSrc.GetHashCode();
                if (Transforms != null) hashCode = hashCode * 59 + Transforms.GetHashCode();
                if (UId != null) hashCode = hashCode * 59 + UId.GetHashCode();
                if (UiRevision != null) hashCode = hashCode * 59 + UiRevision.GetHashCode();
                if (Values != null) hashCode = hashCode * 59 + Values.GetHashCode();
                if (ValuesSrc != null) hashCode = hashCode * 59 + ValuesSrc.GetHashCode();
                if (Visible != null) hashCode = hashCode * 59 + Visible.GetHashCode();
                return hashCode;
            }
        }

        /// <summary>
        ///     Checks for equality of the left Sunburst and the right Sunburst.
        /// </summary>
        /// <param name="left">Left Sunburst.</param>
        /// <param name="right">Right Sunburst.</param>
        /// <returns>Boolean</returns>
        public static bool operator == (Sunburst left, Sunburst right)
        {
            return Equals(left, right);
        }

        /// <summary>
        ///     Checks for inequality of the left Sunburst and the right Sunburst.
        /// </summary>
        /// <param name="left">Left Sunburst.</param>
        /// <param name="right">Right Sunburst.</param>
        /// <returns>Boolean</returns>
        public static bool operator != (Sunburst left, Sunburst right)
        {
            return !Equals(left, right);
        }

        /// <summary>
        ///     Gets a deep copy of this instance.
        /// </summary>
        /// <returns>Sunburst</returns>
        public Sunburst DeepClone()
        {
            return this.Copy();
        }
    }
}