/*
 * THIS FILE WAS GENERATED BY PLOTLY.BLAZOR.GENERATOR
*/

using System;
using System.Diagnostics.CodeAnalysis;
using System.IO;
using System.Runtime.Serialization.Formatters.Binary;
using System.Text.Json.Serialization;

namespace Plotly.Blazor.Traces.SplomLib.DimensionLib
{
    /// <summary>
    ///     The Axis class.
    /// </summary>
    [System.CodeDom.Compiler.GeneratedCode("Plotly.Blazor.Generator", null)]
    [Serializable]
    public class Axis : IEquatable<Axis>
    {
        /// <summary>
        ///     Determines whether or not the x &amp; y axes generated by this dimension
        ///     match. Equivalent to setting the <c>matches</c> axis attribute in the layout
        ///     with the correct axis id.
        /// </summary>
        [JsonPropertyName(@"matches")]
        public bool? Matches { get; set;} 

        /// <summary>
        ///     Sets the axis type for this dimension&#39;s generated x and y axes. Note
        ///     that the axis <c>type</c> values set in layout take precedence over this
        ///     attribute.
        /// </summary>
        [JsonPropertyName(@"type")]
        public Plotly.Blazor.Traces.SplomLib.DimensionLib.AxisLib.TypeEnum? Type { get; set;} 

        /// <inheritdoc />
        public override bool Equals(object obj)
        {
            if (!(obj is Axis other)) return false;

            return ReferenceEquals(this, obj) || Equals(other);
        }

        /// <inheritdoc />
        public bool Equals([AllowNull] Axis other)
        {
            if (other == null) return false;
            if (ReferenceEquals(this, other)) return true;

            return 
                (
                    Matches == other.Matches ||
                    Matches != null &&
                    Matches.Equals(other.Matches)
                ) && 
                (
                    Type == other.Type ||
                    Type != null &&
                    Type.Equals(other.Type)
                );
        }

        /// <inheritdoc />
        public override int GetHashCode()
        {
            unchecked // Overflow is fine, just wrap
            {
                var hashCode = 41;
                if (Matches != null) hashCode = hashCode * 59 + Matches.GetHashCode();
                if (Type != null) hashCode = hashCode * 59 + Type.GetHashCode();
                return hashCode;
            }
        }

        /// <summary>
        ///     Checks for equality of the left Axis and the right Axis.
        /// </summary>
        /// <param name="left">Left Axis.</param>
        /// <param name="right">Right Axis.</param>
        /// <returns>Boolean</returns>
        public static bool operator == (Axis left, Axis right)
        {
            return Equals(left, right);
        }

        /// <summary>
        ///     Checks for inequality of the left Axis and the right Axis.
        /// </summary>
        /// <param name="left">Left Axis.</param>
        /// <param name="right">Right Axis.</param>
        /// <returns>Boolean</returns>
        public static bool operator != (Axis left, Axis right)
        {
            return !Equals(left, right);
        }

        /// <summary>
        ///     Gets a deep copy of this instance.
        /// </summary>
        /// <returns>Axis</returns>
        public Axis DeepClone()
        {
            return this.Copy();
        }
    }
}