/*
 * THIS FILE WAS GENERATED BY PLOTLY.BLAZOR.GENERATOR
*/

using System;
using System.Collections.Generic;
using System.Diagnostics.CodeAnalysis;
using System.IO;
using System.Linq;
using System.Runtime.Serialization.Formatters.Binary;
using System.Text.Json.Serialization;

namespace Plotly.Blazor.Traces.ScatterMapLib
{
    /// <summary>
    ///     The Cluster class.
    /// </summary>
    [System.CodeDom.Compiler.GeneratedCode("Plotly.Blazor.Generator", null)]
    [JsonConverter(typeof(PlotlyConverter))]
    [Serializable]
    public class Cluster : IEquatable<Cluster>
    {
        /// <summary>
        ///     Sets the color for each cluster step.
        /// </summary>
        [JsonPropertyName(@"color")]
        public object Color { get; set;} 

        /// <summary>
        ///     Sets the color for each cluster step.
        /// </summary>
        [JsonPropertyName(@"color")]
        [Array]
        public IList<object> ColorArray { get; set;} 

        /// <summary>
        ///     Sets the source reference on Chart Studio Cloud for <c>color</c>.
        /// </summary>
        [JsonPropertyName(@"colorsrc")]
        public string ColorSrc { get; set;} 

        /// <summary>
        ///     Determines whether clustering is enabled or disabled.
        /// </summary>
        [JsonPropertyName(@"enabled")]
        public bool? Enabled { get; set;} 

        /// <summary>
        ///     Sets the maximum zoom level. At zoom levels equal to or greater than this,
        ///     points will never be clustered.
        /// </summary>
        [JsonPropertyName(@"maxzoom")]
        public decimal? MaxZoom { get; set;} 

        /// <summary>
        ///     Sets the marker opacity.
        /// </summary>
        [JsonPropertyName(@"opacity")]
        public decimal? Opacity { get; set;} 

        /// <summary>
        ///     Sets the marker opacity.
        /// </summary>
        [JsonPropertyName(@"opacity")]
        [Array]
        public IList<decimal?> OpacityArray { get; set;} 

        /// <summary>
        ///     Sets the source reference on Chart Studio Cloud for <c>opacity</c>.
        /// </summary>
        [JsonPropertyName(@"opacitysrc")]
        public string OpacitySrc { get; set;} 

        /// <summary>
        ///     Sets the size for each cluster step.
        /// </summary>
        [JsonPropertyName(@"size")]
        public decimal? Size { get; set;} 

        /// <summary>
        ///     Sets the size for each cluster step.
        /// </summary>
        [JsonPropertyName(@"size")]
        [Array]
        public IList<decimal?> SizeArray { get; set;} 

        /// <summary>
        ///     Sets the source reference on Chart Studio Cloud for <c>size</c>.
        /// </summary>
        [JsonPropertyName(@"sizesrc")]
        public string SizeSrc { get; set;} 

        /// <summary>
        ///     Sets how many points it takes to create a cluster or advance to the next
        ///     cluster step. Use this in conjunction with arrays for <c>size</c> and /
        ///     or <c>color</c>. If an integer, steps start at multiples of this number.
        ///     If an array, each step extends from the given value until one less than
        ///     the next value.
        /// </summary>
        [JsonPropertyName(@"step")]
        public decimal? Step { get; set;} 

        /// <summary>
        ///     Sets how many points it takes to create a cluster or advance to the next
        ///     cluster step. Use this in conjunction with arrays for <c>size</c> and /
        ///     or <c>color</c>. If an integer, steps start at multiples of this number.
        ///     If an array, each step extends from the given value until one less than
        ///     the next value.
        /// </summary>
        [JsonPropertyName(@"step")]
        [Array]
        public IList<decimal?> StepArray { get; set;} 

        /// <summary>
        ///     Sets the source reference on Chart Studio Cloud for <c>step</c>.
        /// </summary>
        [JsonPropertyName(@"stepsrc")]
        public string StepSrc { get; set;} 

        /// <inheritdoc />
        public override bool Equals(object obj)
        {
            if (!(obj is Cluster other)) return false;

            return ReferenceEquals(this, obj) || Equals(other);
        }

        /// <inheritdoc />
        public bool Equals([AllowNull] Cluster other)
        {
            if (other == null) return false;
            if (ReferenceEquals(this, other)) return true;

            return 
                (
                    Color == other.Color ||
                    Color != null &&
                    Color.Equals(other.Color)
                ) && 
                (
                    Equals(ColorArray, other.ColorArray) ||
                    ColorArray != null && other.ColorArray != null &&
                    ColorArray.SequenceEqual(other.ColorArray)
                ) &&
                (
                    ColorSrc == other.ColorSrc ||
                    ColorSrc != null &&
                    ColorSrc.Equals(other.ColorSrc)
                ) && 
                (
                    Enabled == other.Enabled ||
                    Enabled != null &&
                    Enabled.Equals(other.Enabled)
                ) && 
                (
                    MaxZoom == other.MaxZoom ||
                    MaxZoom != null &&
                    MaxZoom.Equals(other.MaxZoom)
                ) && 
                (
                    Opacity == other.Opacity ||
                    Opacity != null &&
                    Opacity.Equals(other.Opacity)
                ) && 
                (
                    Equals(OpacityArray, other.OpacityArray) ||
                    OpacityArray != null && other.OpacityArray != null &&
                    OpacityArray.SequenceEqual(other.OpacityArray)
                ) &&
                (
                    OpacitySrc == other.OpacitySrc ||
                    OpacitySrc != null &&
                    OpacitySrc.Equals(other.OpacitySrc)
                ) && 
                (
                    Size == other.Size ||
                    Size != null &&
                    Size.Equals(other.Size)
                ) && 
                (
                    Equals(SizeArray, other.SizeArray) ||
                    SizeArray != null && other.SizeArray != null &&
                    SizeArray.SequenceEqual(other.SizeArray)
                ) &&
                (
                    SizeSrc == other.SizeSrc ||
                    SizeSrc != null &&
                    SizeSrc.Equals(other.SizeSrc)
                ) && 
                (
                    Step == other.Step ||
                    Step != null &&
                    Step.Equals(other.Step)
                ) && 
                (
                    Equals(StepArray, other.StepArray) ||
                    StepArray != null && other.StepArray != null &&
                    StepArray.SequenceEqual(other.StepArray)
                ) &&
                (
                    StepSrc == other.StepSrc ||
                    StepSrc != null &&
                    StepSrc.Equals(other.StepSrc)
                );
        }

        /// <inheritdoc />
        public override int GetHashCode()
        {
            unchecked // Overflow is fine, just wrap
            {
                var hashCode = 41;
                if (Color != null) hashCode = hashCode * 59 + Color.GetHashCode();
                if (ColorArray != null) hashCode = hashCode * 59 + ColorArray.GetHashCode();
                if (ColorSrc != null) hashCode = hashCode * 59 + ColorSrc.GetHashCode();
                if (Enabled != null) hashCode = hashCode * 59 + Enabled.GetHashCode();
                if (MaxZoom != null) hashCode = hashCode * 59 + MaxZoom.GetHashCode();
                if (Opacity != null) hashCode = hashCode * 59 + Opacity.GetHashCode();
                if (OpacityArray != null) hashCode = hashCode * 59 + OpacityArray.GetHashCode();
                if (OpacitySrc != null) hashCode = hashCode * 59 + OpacitySrc.GetHashCode();
                if (Size != null) hashCode = hashCode * 59 + Size.GetHashCode();
                if (SizeArray != null) hashCode = hashCode * 59 + SizeArray.GetHashCode();
                if (SizeSrc != null) hashCode = hashCode * 59 + SizeSrc.GetHashCode();
                if (Step != null) hashCode = hashCode * 59 + Step.GetHashCode();
                if (StepArray != null) hashCode = hashCode * 59 + StepArray.GetHashCode();
                if (StepSrc != null) hashCode = hashCode * 59 + StepSrc.GetHashCode();
                return hashCode;
            }
        }

        /// <summary>
        ///     Checks for equality of the left Cluster and the right Cluster.
        /// </summary>
        /// <param name="left">Left Cluster.</param>
        /// <param name="right">Right Cluster.</param>
        /// <returns>Boolean</returns>
        public static bool operator == (Cluster left, Cluster right)
        {
            return Equals(left, right);
        }

        /// <summary>
        ///     Checks for inequality of the left Cluster and the right Cluster.
        /// </summary>
        /// <param name="left">Left Cluster.</param>
        /// <param name="right">Right Cluster.</param>
        /// <returns>Boolean</returns>
        public static bool operator != (Cluster left, Cluster right)
        {
            return !Equals(left, right);
        }

        /// <summary>
        ///     Gets a deep copy of this instance.
        /// </summary>
        /// <returns>Cluster</returns>
        public Cluster DeepClone()
        {
            return this.Copy();
        }
    }
}