/*
 * THIS FILE WAS GENERATED BY PLOTLY.BLAZOR.GENERATOR
*/

using System;
using System.Diagnostics.CodeAnalysis;
using System.IO;
using System.Runtime.Serialization.Formatters.Binary;
using System.Text.Json.Serialization;

namespace Plotly.Blazor.Traces.ScatterLib
{
    /// <summary>
    ///     The FillGradient class.
    /// </summary>
    [System.CodeDom.Compiler.GeneratedCode("Plotly.Blazor.Generator", null)]
    [Serializable]
    public class FillGradient : IEquatable<FillGradient>
    {
        /// <summary>
        ///     Sets the fill gradient colors as a color scale. The color scale is interpreted
        ///     as a gradient applied in the direction specified by <c>orientation</c>,
        ///     from the lowest to the highest value of the scatter plot along that axis,
        ///     or from the center to the most distant point from it, if orientation is
        ///     <c>radial</c>.
        /// </summary>
        [JsonPropertyName(@"colorscale")]
        public object ColorScale { get; set;} 

        /// <summary>
        ///     Sets the gradient start value. It is given as the absolute position on the
        ///     axis determined by the orientiation. E.g., if orientation is <c>horizontal</c>,
        ///     the gradient will be horizontal and start from the x-position given by start.
        ///     If omitted, the gradient starts at the lowest value of the trace along the
        ///     respective axis. Ignored if orientation is <c>radial</c>.
        /// </summary>
        [JsonPropertyName(@"start")]
        public decimal? Start { get; set;} 

        /// <summary>
        ///     Sets the gradient end value. It is given as the absolute position on the
        ///     axis determined by the orientiation. E.g., if orientation is <c>horizontal</c>,
        ///     the gradient will be horizontal and end at the x-position given by end.
        ///     If omitted, the gradient ends at the highest value of the trace along the
        ///     respective axis. Ignored if orientation is <c>radial</c>.
        /// </summary>
        [JsonPropertyName(@"stop")]
        public decimal? Stop { get; set;} 

        /// <summary>
        ///     Sets the type/orientation of the color gradient for the fill. Defaults to
        ///     <c>none</c>.
        /// </summary>
        [JsonPropertyName(@"type")]
        public Plotly.Blazor.Traces.ScatterLib.FillGradientLib.TypeEnum? Type { get; set;} 

        /// <inheritdoc />
        public override bool Equals(object obj)
        {
            if (!(obj is FillGradient other)) return false;

            return ReferenceEquals(this, obj) || Equals(other);
        }

        /// <inheritdoc />
        public bool Equals([AllowNull] FillGradient other)
        {
            if (other == null) return false;
            if (ReferenceEquals(this, other)) return true;

            return 
                (
                    ColorScale == other.ColorScale ||
                    ColorScale != null &&
                    ColorScale.Equals(other.ColorScale)
                ) && 
                (
                    Start == other.Start ||
                    Start != null &&
                    Start.Equals(other.Start)
                ) && 
                (
                    Stop == other.Stop ||
                    Stop != null &&
                    Stop.Equals(other.Stop)
                ) && 
                (
                    Type == other.Type ||
                    Type != null &&
                    Type.Equals(other.Type)
                );
        }

        /// <inheritdoc />
        public override int GetHashCode()
        {
            unchecked // Overflow is fine, just wrap
            {
                var hashCode = 41;
                if (ColorScale != null) hashCode = hashCode * 59 + ColorScale.GetHashCode();
                if (Start != null) hashCode = hashCode * 59 + Start.GetHashCode();
                if (Stop != null) hashCode = hashCode * 59 + Stop.GetHashCode();
                if (Type != null) hashCode = hashCode * 59 + Type.GetHashCode();
                return hashCode;
            }
        }

        /// <summary>
        ///     Checks for equality of the left FillGradient and the right FillGradient.
        /// </summary>
        /// <param name="left">Left FillGradient.</param>
        /// <param name="right">Right FillGradient.</param>
        /// <returns>Boolean</returns>
        public static bool operator == (FillGradient left, FillGradient right)
        {
            return Equals(left, right);
        }

        /// <summary>
        ///     Checks for inequality of the left FillGradient and the right FillGradient.
        /// </summary>
        /// <param name="left">Left FillGradient.</param>
        /// <param name="right">Right FillGradient.</param>
        /// <returns>Boolean</returns>
        public static bool operator != (FillGradient left, FillGradient right)
        {
            return !Equals(left, right);
        }

        /// <summary>
        ///     Gets a deep copy of this instance.
        /// </summary>
        /// <returns>FillGradient</returns>
        public FillGradient DeepClone()
        {
            return this.Copy();
        }
    }
}