/*
 * THIS FILE WAS GENERATED BY PLOTLY.BLAZOR.GENERATOR
*/

using System;
using System.Collections.Generic;
using System.Diagnostics.CodeAnalysis;
using System.IO;
using System.Linq;
using System.Runtime.Serialization.Formatters.Binary;
using System.Text.Json.Serialization;

namespace Plotly.Blazor.Traces.ScatterGlLib
{
    /// <summary>
    ///     The TextFont class.
    /// </summary>
    [System.CodeDom.Compiler.GeneratedCode("Plotly.Blazor.Generator", null)]
    [JsonConverter(typeof(PlotlyConverter))]
    [Serializable]
    public class TextFont : IEquatable<TextFont>
    {
        /// <summary>
        ///     Gets or sets the Color.
        /// </summary>
        [JsonPropertyName(@"color")]
        public object Color { get; set;} 

        /// <summary>
        ///     Gets or sets the Color.
        /// </summary>
        [JsonPropertyName(@"color")]
        [Array]
        public IList<object> ColorArray { get; set;} 

        /// <summary>
        ///     Sets the source reference on Chart Studio Cloud for <c>color</c>.
        /// </summary>
        [JsonPropertyName(@"colorsrc")]
        public string ColorSrc { get; set;} 

        /// <summary>
        ///     HTML font family - the typeface that will be applied by the web browser.
        ///     The web browser will only be able to apply a font if it is available on
        ///     the system which it operates. Provide multiple font families, separated
        ///     by commas, to indicate the preference in which to apply fonts if they aren&#39;t
        ///     available on the system. The Chart Studio Cloud (at https://chart-studio.plotly.com
        ///     or on-premise) generates images on a server, where only a select number
        ///     of fonts are installed and supported. These include <c>Arial</c>, <c>Balto</c>,
        ///     &#39;Courier New&#39;, &#39;Droid Sans&#39;, &#39;Droid Serif&#39;, &#39;Droid
        ///     Sans Mono&#39;, &#39;Gravitas One&#39;, &#39;Old Standard TT&#39;, &#39;Open
        ///     Sans&#39;, <c>Overpass</c>, &#39;PT Sans Narrow&#39;, <c>Raleway</c>, &#39;Times
        ///     New Roman&#39;.
        /// </summary>
        [JsonPropertyName(@"family")]
        public string Family { get; set;} 

        /// <summary>
        ///     HTML font family - the typeface that will be applied by the web browser.
        ///     The web browser will only be able to apply a font if it is available on
        ///     the system which it operates. Provide multiple font families, separated
        ///     by commas, to indicate the preference in which to apply fonts if they aren&#39;t
        ///     available on the system. The Chart Studio Cloud (at https://chart-studio.plotly.com
        ///     or on-premise) generates images on a server, where only a select number
        ///     of fonts are installed and supported. These include <c>Arial</c>, <c>Balto</c>,
        ///     &#39;Courier New&#39;, &#39;Droid Sans&#39;, &#39;Droid Serif&#39;, &#39;Droid
        ///     Sans Mono&#39;, &#39;Gravitas One&#39;, &#39;Old Standard TT&#39;, &#39;Open
        ///     Sans&#39;, <c>Overpass</c>, &#39;PT Sans Narrow&#39;, <c>Raleway</c>, &#39;Times
        ///     New Roman&#39;.
        /// </summary>
        [JsonPropertyName(@"family")]
        [Array]
        public IList<string> FamilyArray { get; set;} 

        /// <summary>
        ///     Sets the source reference on Chart Studio Cloud for <c>family</c>.
        /// </summary>
        [JsonPropertyName(@"familysrc")]
        public string FamilySrc { get; set;} 

        /// <summary>
        ///     Gets or sets the Size.
        /// </summary>
        [JsonPropertyName(@"size")]
        public decimal? Size { get; set;} 

        /// <summary>
        ///     Gets or sets the Size.
        /// </summary>
        [JsonPropertyName(@"size")]
        [Array]
        public IList<decimal?> SizeArray { get; set;} 

        /// <summary>
        ///     Sets the source reference on Chart Studio Cloud for <c>size</c>.
        /// </summary>
        [JsonPropertyName(@"sizesrc")]
        public string SizeSrc { get; set;} 

        /// <summary>
        ///     Sets whether a font should be styled with a normal or italic face from its
        ///     family.
        /// </summary>
        [JsonPropertyName(@"style")]
        public Plotly.Blazor.Traces.ScatterGlLib.TextFontLib.StyleEnum? Style { get; set;} 

        /// <summary>
        ///     Sets whether a font should be styled with a normal or italic face from its
        ///     family.
        /// </summary>
        [JsonPropertyName(@"style")]
        [Array]
        public IList<Plotly.Blazor.Traces.ScatterGlLib.TextFontLib.StyleEnum?> StyleArray { get; set;} 

        /// <summary>
        ///     Sets the source reference on Chart Studio Cloud for <c>style</c>.
        /// </summary>
        [JsonPropertyName(@"stylesrc")]
        public string StyleSrc { get; set;} 

        /// <summary>
        ///     Sets the variant of the font.
        /// </summary>
        [JsonPropertyName(@"variant")]
        public Plotly.Blazor.Traces.ScatterGlLib.TextFontLib.VariantEnum? Variant { get; set;} 

        /// <summary>
        ///     Sets the variant of the font.
        /// </summary>
        [JsonPropertyName(@"variant")]
        [Array]
        public IList<Plotly.Blazor.Traces.ScatterGlLib.TextFontLib.VariantEnum?> VariantArray { get; set;} 

        /// <summary>
        ///     Sets the source reference on Chart Studio Cloud for <c>variant</c>.
        /// </summary>
        [JsonPropertyName(@"variantsrc")]
        public string VariantSrc { get; set;} 

        /// <summary>
        ///     Sets the weight (or boldness) of the font.
        /// </summary>
        [JsonPropertyName(@"weight")]
        public Plotly.Blazor.Traces.ScatterGlLib.TextFontLib.WeightEnum? Weight { get; set;} 

        /// <summary>
        ///     Sets the weight (or boldness) of the font.
        /// </summary>
        [JsonPropertyName(@"weight")]
        [Array]
        public IList<Plotly.Blazor.Traces.ScatterGlLib.TextFontLib.WeightEnum?> WeightArray { get; set;} 

        /// <summary>
        ///     Sets the source reference on Chart Studio Cloud for <c>weight</c>.
        /// </summary>
        [JsonPropertyName(@"weightsrc")]
        public string WeightSrc { get; set;} 

        /// <inheritdoc />
        public override bool Equals(object obj)
        {
            if (!(obj is TextFont other)) return false;

            return ReferenceEquals(this, obj) || Equals(other);
        }

        /// <inheritdoc />
        public bool Equals([AllowNull] TextFont other)
        {
            if (other == null) return false;
            if (ReferenceEquals(this, other)) return true;

            return 
                (
                    Color == other.Color ||
                    Color != null &&
                    Color.Equals(other.Color)
                ) && 
                (
                    Equals(ColorArray, other.ColorArray) ||
                    ColorArray != null && other.ColorArray != null &&
                    ColorArray.SequenceEqual(other.ColorArray)
                ) &&
                (
                    ColorSrc == other.ColorSrc ||
                    ColorSrc != null &&
                    ColorSrc.Equals(other.ColorSrc)
                ) && 
                (
                    Family == other.Family ||
                    Family != null &&
                    Family.Equals(other.Family)
                ) && 
                (
                    Equals(FamilyArray, other.FamilyArray) ||
                    FamilyArray != null && other.FamilyArray != null &&
                    FamilyArray.SequenceEqual(other.FamilyArray)
                ) &&
                (
                    FamilySrc == other.FamilySrc ||
                    FamilySrc != null &&
                    FamilySrc.Equals(other.FamilySrc)
                ) && 
                (
                    Size == other.Size ||
                    Size != null &&
                    Size.Equals(other.Size)
                ) && 
                (
                    Equals(SizeArray, other.SizeArray) ||
                    SizeArray != null && other.SizeArray != null &&
                    SizeArray.SequenceEqual(other.SizeArray)
                ) &&
                (
                    SizeSrc == other.SizeSrc ||
                    SizeSrc != null &&
                    SizeSrc.Equals(other.SizeSrc)
                ) && 
                (
                    Style == other.Style ||
                    Style != null &&
                    Style.Equals(other.Style)
                ) && 
                (
                    Equals(StyleArray, other.StyleArray) ||
                    StyleArray != null && other.StyleArray != null &&
                    StyleArray.SequenceEqual(other.StyleArray)
                ) &&
                (
                    StyleSrc == other.StyleSrc ||
                    StyleSrc != null &&
                    StyleSrc.Equals(other.StyleSrc)
                ) && 
                (
                    Variant == other.Variant ||
                    Variant != null &&
                    Variant.Equals(other.Variant)
                ) && 
                (
                    Equals(VariantArray, other.VariantArray) ||
                    VariantArray != null && other.VariantArray != null &&
                    VariantArray.SequenceEqual(other.VariantArray)
                ) &&
                (
                    VariantSrc == other.VariantSrc ||
                    VariantSrc != null &&
                    VariantSrc.Equals(other.VariantSrc)
                ) && 
                (
                    Weight == other.Weight ||
                    Weight != null &&
                    Weight.Equals(other.Weight)
                ) && 
                (
                    Equals(WeightArray, other.WeightArray) ||
                    WeightArray != null && other.WeightArray != null &&
                    WeightArray.SequenceEqual(other.WeightArray)
                ) &&
                (
                    WeightSrc == other.WeightSrc ||
                    WeightSrc != null &&
                    WeightSrc.Equals(other.WeightSrc)
                );
        }

        /// <inheritdoc />
        public override int GetHashCode()
        {
            unchecked // Overflow is fine, just wrap
            {
                var hashCode = 41;
                if (Color != null) hashCode = hashCode * 59 + Color.GetHashCode();
                if (ColorArray != null) hashCode = hashCode * 59 + ColorArray.GetHashCode();
                if (ColorSrc != null) hashCode = hashCode * 59 + ColorSrc.GetHashCode();
                if (Family != null) hashCode = hashCode * 59 + Family.GetHashCode();
                if (FamilyArray != null) hashCode = hashCode * 59 + FamilyArray.GetHashCode();
                if (FamilySrc != null) hashCode = hashCode * 59 + FamilySrc.GetHashCode();
                if (Size != null) hashCode = hashCode * 59 + Size.GetHashCode();
                if (SizeArray != null) hashCode = hashCode * 59 + SizeArray.GetHashCode();
                if (SizeSrc != null) hashCode = hashCode * 59 + SizeSrc.GetHashCode();
                if (Style != null) hashCode = hashCode * 59 + Style.GetHashCode();
                if (StyleArray != null) hashCode = hashCode * 59 + StyleArray.GetHashCode();
                if (StyleSrc != null) hashCode = hashCode * 59 + StyleSrc.GetHashCode();
                if (Variant != null) hashCode = hashCode * 59 + Variant.GetHashCode();
                if (VariantArray != null) hashCode = hashCode * 59 + VariantArray.GetHashCode();
                if (VariantSrc != null) hashCode = hashCode * 59 + VariantSrc.GetHashCode();
                if (Weight != null) hashCode = hashCode * 59 + Weight.GetHashCode();
                if (WeightArray != null) hashCode = hashCode * 59 + WeightArray.GetHashCode();
                if (WeightSrc != null) hashCode = hashCode * 59 + WeightSrc.GetHashCode();
                return hashCode;
            }
        }

        /// <summary>
        ///     Checks for equality of the left TextFont and the right TextFont.
        /// </summary>
        /// <param name="left">Left TextFont.</param>
        /// <param name="right">Right TextFont.</param>
        /// <returns>Boolean</returns>
        public static bool operator == (TextFont left, TextFont right)
        {
            return Equals(left, right);
        }

        /// <summary>
        ///     Checks for inequality of the left TextFont and the right TextFont.
        /// </summary>
        /// <param name="left">Left TextFont.</param>
        /// <param name="right">Right TextFont.</param>
        /// <returns>Boolean</returns>
        public static bool operator != (TextFont left, TextFont right)
        {
            return !Equals(left, right);
        }

        /// <summary>
        ///     Gets a deep copy of this instance.
        /// </summary>
        /// <returns>TextFont</returns>
        public TextFont DeepClone()
        {
            return this.Copy();
        }
    }
}