/*
 * THIS FILE WAS GENERATED BY PLOTLY.BLAZOR.GENERATOR
*/

using System;
using System.Collections.Generic;
using System.Diagnostics.CodeAnalysis;
using System.IO;
using System.Linq;
using System.Runtime.Serialization.Formatters.Binary;
using System.Text.Json.Serialization;

namespace Plotly.Blazor.Traces
{
    /// <summary>
    ///     The Scatter class.
    ///     Implements the <see cref="ITrace" />.
    /// </summary>
    [System.CodeDom.Compiler.GeneratedCode("Plotly.Blazor.Generator", null)]
    [JsonConverter(typeof(PlotlyConverter))]
    [Serializable]
    public class Scatter : ITrace, IEquatable<Scatter>
    {
        /// <inheritdoc/>
        [JsonPropertyName(@"type")]
        public TraceTypeEnum? Type { get; } = TraceTypeEnum.Scatter;

        /// <summary>
        ///     Set several traces linked to the same position axis or matching axes to
        ///     the same alignmentgroup. This controls whether bars compute their positional
        ///     range dependently or independently.
        /// </summary>
        [JsonPropertyName(@"alignmentgroup")]
        public string AlignmentGroup { get; set;} 

        /// <summary>
        ///     Determines whether or not markers and text nodes are clipped about the subplot
        ///     axes. To show markers and text nodes above axis lines and tick labels, make
        ///     sure to set <c>xaxis.layer</c> and <c>yaxis.layer</c> to &#39;below traces&#39;.
        /// </summary>
        [JsonPropertyName(@"cliponaxis")]
        public bool? ClipOnAxis { get; set;} 

        /// <summary>
        ///     Determines whether or not gaps (i.e. {nan} or missing values) in the provided
        ///     data arrays are connected.
        /// </summary>
        [JsonPropertyName(@"connectgaps")]
        public bool? ConnectGaps { get; set;} 

        /// <summary>
        ///     Assigns extra data each datum. This may be useful when listening to hover,
        ///     click and selection events. Note that, <c>scatter</c> traces also appends
        ///     customdata items in the markers DOM elements
        /// </summary>
        [JsonPropertyName(@"customdata")]
        public IList<object> CustomData { get; set;} 

        /// <summary>
        ///     Sets the source reference on Chart Studio Cloud for <c>customdata</c>.
        /// </summary>
        [JsonPropertyName(@"customdatasrc")]
        public string CustomDataSrc { get; set;} 

        /// <summary>
        ///     Sets the x coordinate step. See <c>x0</c> for more info.
        /// </summary>
        [JsonPropertyName(@"dx")]
        public decimal? DX { get; set;} 

        /// <summary>
        ///     Sets the y coordinate step. See <c>y0</c> for more info.
        /// </summary>
        [JsonPropertyName(@"dy")]
        public decimal? Dy { get; set;} 

        /// <summary>
        ///     Gets or sets the ErrorX.
        /// </summary>
        [JsonPropertyName(@"error_x")]
        public Plotly.Blazor.Traces.ScatterLib.ErrorX ErrorX { get; set;} 

        /// <summary>
        ///     Gets or sets the ErrorY.
        /// </summary>
        [JsonPropertyName(@"error_y")]
        public Plotly.Blazor.Traces.ScatterLib.ErrorY ErrorY { get; set;} 

        /// <summary>
        ///     Sets the area to fill with a solid color. Defaults to <c>none</c> unless
        ///     this trace is stacked, then it gets <c>tonexty</c> (<c>tonextx</c>) if <c>orientation</c>
        ///     is <c>v</c> (<c>h</c>) Use with <c>fillcolor</c> if not <c>none</c>. <c>tozerox</c>
        ///     and <c>tozeroy</c> fill to x=0 and y=0 respectively. <c>tonextx</c> and
        ///     <c>tonexty</c> fill between the endpoints of this trace and the endpoints
        ///     of the trace before it, connecting those endpoints with straight lines (to
        ///     make a stacked area graph); if there is no trace before it, they behave
        ///     like <c>tozerox</c> and <c>tozeroy</c>. <c>toself</c> connects the endpoints
        ///     of the trace (or each segment of the trace if it has gaps) into a closed
        ///     shape. <c>tonext</c> fills the space between two traces if one completely
        ///     encloses the other (eg consecutive contour lines), and behaves like <c>toself</c>
        ///     if there is no trace before it. <c>tonext</c> should not be used if one
        ///     trace does not enclose the other. Traces in a <c>stackgroup</c> will only
        ///     fill to (or be filled to) other traces in the same group. With multiple
        ///     <c>stackgroup</c>s or some traces stacked and some not, if fill-linked traces
        ///     are not already consecutive, the later ones will be pushed down in the drawing
        ///     order.
        /// </summary>
        [JsonPropertyName(@"fill")]
        public Plotly.Blazor.Traces.ScatterLib.FillEnum? Fill { get; set;} 

        /// <summary>
        ///     Sets the fill color. Defaults to a half-transparent variant of the line
        ///     color, marker color, or marker line color, whichever is available. If fillgradient
        ///     is specified, fillcolor is ignored except for setting the background color
        ///     of the hover label, if any.
        /// </summary>
        [JsonPropertyName(@"fillcolor")]
        public object FillColor { get; set;} 

        /// <summary>
        ///     Sets a fill gradient. If not specified, the fillcolor is used instead.
        /// </summary>
        [JsonPropertyName(@"fillgradient")]
        public Plotly.Blazor.Traces.ScatterLib.FillGradient FillGradient { get; set;} 

        /// <summary>
        ///     Sets the pattern within the marker.
        /// </summary>
        [JsonPropertyName(@"fillpattern")]
        public Plotly.Blazor.Traces.ScatterLib.FillPattern FillPattern { get; set;} 

        /// <summary>
        ///     Only relevant when <c>stackgroup</c> is used, and only the first <c>groupnorm</c>
        ///     found in the <c>stackgroup</c> will be used - including if <c>visible</c>
        ///     is <c>legendonly</c> but not if it is <c>false</c>. Sets the normalization
        ///     for the sum of this <c>stackgroup</c>. With <c>fraction</c>, the value of
        ///     each trace at each location is divided by the sum of all trace values at
        ///     that location. <c>percent</c> is the same but multiplied by 100 to show
        ///     percentages. If there are multiple subplots, or multiple <c>stackgroup</c>s
        ///     on one subplot, each will be normalized within its own set.
        /// </summary>
        [JsonPropertyName(@"groupnorm")]
        public Plotly.Blazor.Traces.ScatterLib.GroupNormEnum? GroupNorm { get; set;} 

        /// <summary>
        ///     Determines which trace information appear on hover. If <c>none</c> or <c>skip</c>
        ///     are set, no information is displayed upon hovering. But, if <c>none</c>
        ///     is set, click and hover events are still fired.
        /// </summary>
        [JsonPropertyName(@"hoverinfo")]
        public Plotly.Blazor.Traces.ScatterLib.HoverInfoFlag? HoverInfo { get; set;} 

        /// <summary>
        ///     Determines which trace information appear on hover. If <c>none</c> or <c>skip</c>
        ///     are set, no information is displayed upon hovering. But, if <c>none</c>
        ///     is set, click and hover events are still fired.
        /// </summary>
        [JsonPropertyName(@"hoverinfo")]
        [Array]
        public IList<Plotly.Blazor.Traces.ScatterLib.HoverInfoFlag?> HoverInfoArray { get; set;} 

        /// <summary>
        ///     Sets the source reference on Chart Studio Cloud for <c>hoverinfo</c>.
        /// </summary>
        [JsonPropertyName(@"hoverinfosrc")]
        public string HoverInfoSrc { get; set;} 

        /// <summary>
        ///     Gets or sets the HoverLabel.
        /// </summary>
        [JsonPropertyName(@"hoverlabel")]
        public Plotly.Blazor.Traces.ScatterLib.HoverLabel HoverLabel { get; set;} 

        /// <summary>
        ///     Do the hover effects highlight individual points (markers or line points)
        ///     or do they highlight filled regions? If the fill is <c>toself</c> or <c>tonext</c>
        ///     and there are no markers or text, then the default is <c>fills</c>, otherwise
        ///     it is <c>points</c>.
        /// </summary>
        [JsonPropertyName(@"hoveron")]
        public Plotly.Blazor.Traces.ScatterLib.HoverOnFlag? HoverOn { get; set;} 

        /// <summary>
        ///     Template string used for rendering the information that appear on hover
        ///     box. Note that this will override <c>hoverinfo</c>. Variables are inserted
        ///     using %{variable}, for example &quot;y: %{y}&quot; as well as %{xother},
        ///     {%_xother}, {%_xother_}, {%xother_}. When showing info for several points,
        ///     <c>xother</c> will be added to those with different x positions from the
        ///     first point. An underscore before or after <c>(x|y)other</c> will add a
        ///     space on that side, only when this field is shown. Numbers are formatted
        ///     using d3-format&#39;s syntax %{variable:d3-format}, for example &quot;Price:
        ///     %{y:$.2f}&quot;. https://github.com/d3/d3-format/tree/v1.4.5#d3-format for
        ///     details on the formatting syntax. Dates are formatted using d3-time-format&#39;s
        ///     syntax %{variable|d3-time-format}, for example &quot;Day: %{2019-01-01|%A}&quot;.
        ///     https://github.com/d3/d3-time-format/tree/v2.2.3#locale_format for details
        ///     on the date formatting syntax. The variables available in <c>hovertemplate</c>
        ///     are the ones emitted as event data described at this link https://plotly.com/javascript/plotlyjs-events/#event-data.
        ///     Additionally, every attributes that can be specified per-point (the ones
        ///     that are &#39;arrayOk: true&#39;) are available.  Anything contained in
        ///     tag <c>&lt;extra&gt;</c> is displayed in the secondary box, for example
        ///     <c>&lt;extra&gt;{fullData.name}&lt;/extra&gt;</c>. To hide the secondary
        ///     box completely, use an empty tag <c>&lt;extra&gt;&lt;/extra&gt;</c>.
        /// </summary>
        [JsonPropertyName(@"hovertemplate")]
        public string HoverTemplate { get; set;} 

        /// <summary>
        ///     Template string used for rendering the information that appear on hover
        ///     box. Note that this will override <c>hoverinfo</c>. Variables are inserted
        ///     using %{variable}, for example &quot;y: %{y}&quot; as well as %{xother},
        ///     {%_xother}, {%_xother_}, {%xother_}. When showing info for several points,
        ///     <c>xother</c> will be added to those with different x positions from the
        ///     first point. An underscore before or after <c>(x|y)other</c> will add a
        ///     space on that side, only when this field is shown. Numbers are formatted
        ///     using d3-format&#39;s syntax %{variable:d3-format}, for example &quot;Price:
        ///     %{y:$.2f}&quot;. https://github.com/d3/d3-format/tree/v1.4.5#d3-format for
        ///     details on the formatting syntax. Dates are formatted using d3-time-format&#39;s
        ///     syntax %{variable|d3-time-format}, for example &quot;Day: %{2019-01-01|%A}&quot;.
        ///     https://github.com/d3/d3-time-format/tree/v2.2.3#locale_format for details
        ///     on the date formatting syntax. The variables available in <c>hovertemplate</c>
        ///     are the ones emitted as event data described at this link https://plotly.com/javascript/plotlyjs-events/#event-data.
        ///     Additionally, every attributes that can be specified per-point (the ones
        ///     that are &#39;arrayOk: true&#39;) are available.  Anything contained in
        ///     tag <c>&lt;extra&gt;</c> is displayed in the secondary box, for example
        ///     <c>&lt;extra&gt;{fullData.name}&lt;/extra&gt;</c>. To hide the secondary
        ///     box completely, use an empty tag <c>&lt;extra&gt;&lt;/extra&gt;</c>.
        /// </summary>
        [JsonPropertyName(@"hovertemplate")]
        [Array]
        public IList<string> HoverTemplateArray { get; set;} 

        /// <summary>
        ///     Sets the source reference on Chart Studio Cloud for <c>hovertemplate</c>.
        /// </summary>
        [JsonPropertyName(@"hovertemplatesrc")]
        public string HoverTemplateSrc { get; set;} 

        /// <summary>
        ///     Sets hover text elements associated with each (x,y) pair. If a single string,
        ///     the same string appears over all the data points. If an array of string,
        ///     the items are mapped in order to the this trace&#39;s (x,y) coordinates.
        ///     To be seen, trace <c>hoverinfo</c> must contain a <c>text</c> flag.
        /// </summary>
        [JsonPropertyName(@"hovertext")]
        public string HoverText { get; set;} 

        /// <summary>
        ///     Sets hover text elements associated with each (x,y) pair. If a single string,
        ///     the same string appears over all the data points. If an array of string,
        ///     the items are mapped in order to the this trace&#39;s (x,y) coordinates.
        ///     To be seen, trace <c>hoverinfo</c> must contain a <c>text</c> flag.
        /// </summary>
        [JsonPropertyName(@"hovertext")]
        [Array]
        public IList<string> HoverTextArray { get; set;} 

        /// <summary>
        ///     Sets the source reference on Chart Studio Cloud for <c>hovertext</c>.
        /// </summary>
        [JsonPropertyName(@"hovertextsrc")]
        public string HoverTextSrc { get; set;} 

        /// <summary>
        ///     Assigns id labels to each datum. These ids for object constancy of data
        ///     points during animation. Should be an array of strings, not numbers or any
        ///     other type.
        /// </summary>
        [JsonPropertyName(@"ids")]
        public IList<object> Ids { get; set;} 

        /// <summary>
        ///     Sets the source reference on Chart Studio Cloud for <c>ids</c>.
        /// </summary>
        [JsonPropertyName(@"idssrc")]
        public string IdsSrc { get; set;} 

        /// <summary>
        ///     Sets the reference to a legend to show this trace in. References to these
        ///     legends are <c>legend</c>, <c>legend2</c>, <c>legend3</c>, etc. Settings
        ///     for these legends are set in the layout, under <c>layout.legend</c>, <c>layout.legend2</c>,
        ///     etc.
        /// </summary>
        [JsonPropertyName(@"legend")]
        public string Legend { get; set;} 

        /// <summary>
        ///     Sets the legend group for this trace. Traces and shapes part of the same
        ///     legend group hide/show at the same time when toggling legend items.
        /// </summary>
        [JsonPropertyName(@"legendgroup")]
        public string LegendGroup { get; set;} 

        /// <summary>
        ///     Gets or sets the LegendGroupTitle.
        /// </summary>
        [JsonPropertyName(@"legendgrouptitle")]
        public Plotly.Blazor.Traces.ScatterLib.LegendGroupTitle LegendGroupTitle { get; set;} 

        /// <summary>
        ///     Sets the legend rank for this trace. Items and groups with smaller ranks
        ///     are presented on top/left side while with <c>reversed</c> <c>legend.traceorder</c>
        ///     they are on bottom/right side. The default legendrank is 1000, so that you
        ///     can use ranks less than 1000 to place certain items before all unranked
        ///     items, and ranks greater than 1000 to go after all unranked items. When
        ///     having unranked or equal rank items shapes would be displayed after traces
        ///     i.e. according to their order in data and layout.
        /// </summary>
        [JsonPropertyName(@"legendrank")]
        public decimal? LegendRank { get; set;} 

        /// <summary>
        ///     Sets the width (in px or fraction) of the legend for this trace.
        /// </summary>
        [JsonPropertyName(@"legendwidth")]
        public decimal? LegendWidth { get; set;} 

        /// <summary>
        ///     Gets or sets the Line.
        /// </summary>
        [JsonPropertyName(@"line")]
        public Plotly.Blazor.Traces.ScatterLib.Line Line { get; set;} 

        /// <summary>
        ///     Gets or sets the Marker.
        /// </summary>
        [JsonPropertyName(@"marker")]
        public Plotly.Blazor.Traces.ScatterLib.Marker Marker { get; set;} 

        /// <summary>
        ///     Assigns extra meta information associated with this trace that can be used
        ///     in various text attributes. Attributes such as trace <c>name</c>, graph,
        ///     axis and colorbar <c>title.text</c>, annotation <c>text</c> <c>rangeselector</c>,
        ///     <c>updatemenues</c> and <c>sliders</c> <c>label</c> text all support <c>meta</c>.
        ///     To access the trace <c>meta</c> values in an attribute in the same trace,
        ///     simply use <c>%{meta[i]}</c> where <c>i</c> is the index or key of the <c>meta</c>
        ///     item in question. To access trace <c>meta</c> in layout attributes, use
        ///     <c>%{data[n[.meta[i]}</c> where <c>i</c> is the index or key of the <c>meta</c>
        ///     and <c>n</c> is the trace index.
        /// </summary>
        [JsonPropertyName(@"meta")]
        public object Meta { get; set;} 

        /// <summary>
        ///     Assigns extra meta information associated with this trace that can be used
        ///     in various text attributes. Attributes such as trace <c>name</c>, graph,
        ///     axis and colorbar <c>title.text</c>, annotation <c>text</c> <c>rangeselector</c>,
        ///     <c>updatemenues</c> and <c>sliders</c> <c>label</c> text all support <c>meta</c>.
        ///     To access the trace <c>meta</c> values in an attribute in the same trace,
        ///     simply use <c>%{meta[i]}</c> where <c>i</c> is the index or key of the <c>meta</c>
        ///     item in question. To access trace <c>meta</c> in layout attributes, use
        ///     <c>%{data[n[.meta[i]}</c> where <c>i</c> is the index or key of the <c>meta</c>
        ///     and <c>n</c> is the trace index.
        /// </summary>
        [JsonPropertyName(@"meta")]
        [Array]
        public IList<object> MetaArray { get; set;} 

        /// <summary>
        ///     Sets the source reference on Chart Studio Cloud for <c>meta</c>.
        /// </summary>
        [JsonPropertyName(@"metasrc")]
        public string MetaSrc { get; set;} 

        /// <summary>
        ///     Determines the drawing mode for this scatter trace. If the provided <c>mode</c>
        ///     includes <c>text</c> then the <c>text</c> elements appear at the coordinates.
        ///     Otherwise, the <c>text</c> elements appear on hover. If there are less than
        ///     20 points and the trace is not stacked then the default is <c>lines+markers</c>.
        ///     Otherwise, <c>lines</c>.
        /// </summary>
        [JsonPropertyName(@"mode")]
        public Plotly.Blazor.Traces.ScatterLib.ModeFlag? Mode { get; set;} 

        /// <summary>
        ///     Sets the trace name. The trace name appears as the legend item and on hover.
        /// </summary>
        [JsonPropertyName(@"name")]
        public string Name { get; set;} 

        /// <summary>
        ///     Set several traces linked to the same position axis or matching axes to
        ///     the same offsetgroup where bars of the same position coordinate will line
        ///     up.
        /// </summary>
        [JsonPropertyName(@"offsetgroup")]
        public string OffsetGroup { get; set;} 

        /// <summary>
        ///     Sets the opacity of the trace.
        /// </summary>
        [JsonPropertyName(@"opacity")]
        public decimal? Opacity { get; set;} 

        /// <summary>
        ///     Only relevant in the following cases: 1. when <c>scattermode</c> is set
        ///     to <c>group</c>. 2. when <c>stackgroup</c> is used, and only the first <c>orientation</c>
        ///     found in the <c>stackgroup</c> will be used - including if <c>visible</c>
        ///     is <c>legendonly</c> but not if it is <c>false</c>. Sets the stacking direction.
        ///     With <c>v</c> (<c>h</c>), the y (x) values of subsequent traces are added.
        ///     Also affects the default value of <c>fill</c>.
        /// </summary>
        [JsonPropertyName(@"orientation")]
        public Plotly.Blazor.Traces.ScatterLib.OrientationEnum? Orientation { get; set;} 

        /// <summary>
        ///     Gets or sets the Selected.
        /// </summary>
        [JsonPropertyName(@"selected")]
        public Plotly.Blazor.Traces.ScatterLib.Selected Selected { get; set;} 

        /// <summary>
        ///     Array containing integer indices of selected points. Has an effect only
        ///     for traces that support selections. Note that an empty array means an empty
        ///     selection where the <c>unselected</c> are turned on for all points, whereas,
        ///     any other non-array values means no selection all where the <c>selected</c>
        ///     and <c>unselected</c> styles have no effect.
        /// </summary>
        [JsonPropertyName(@"selectedpoints")]
        public object SelectedPoints { get; set;} 

        /// <summary>
        ///     Determines whether or not an item corresponding to this trace is shown in
        ///     the legend.
        /// </summary>
        [JsonPropertyName(@"showlegend")]
        public bool? ShowLegend { get; set;} 

        /// <summary>
        ///     Only relevant when <c>stackgroup</c> is used, and only the first <c>stackgaps</c>
        ///     found in the <c>stackgroup</c> will be used - including if <c>visible</c>
        ///     is <c>legendonly</c> but not if it is <c>false</c>. Determines how we handle
        ///     locations at which other traces in this group have data but this one does
        ///     not. With &#39;infer zero&#39; we insert a zero at these locations. With
        ///     <c>interpolate</c> we linearly interpolate between existing values, and
        ///     extrapolate a constant beyond the existing values.
        /// </summary>
        [JsonPropertyName(@"stackgaps")]
        public Plotly.Blazor.Traces.ScatterLib.StackGapsEnum? StackGaps { get; set;} 

        /// <summary>
        ///     Set several scatter traces (on the same subplot) to the same stackgroup
        ///     in order to add their y values (or their x values if <c>orientation</c>
        ///     is <c>h</c>). If blank or omitted this trace will not be stacked. Stacking
        ///     also turns <c>fill</c> on by default, using <c>tonexty</c> (<c>tonextx</c>)
        ///     if <c>orientation</c> is <c>h</c> (<c>v</c>) and sets the default <c>mode</c>
        ///     to <c>lines</c> irrespective of point count. You can only stack on a numeric
        ///     (linear or log) axis. Traces in a <c>stackgroup</c> will only fill to (or
        ///     be filled to) other traces in the same group. With multiple <c>stackgroup</c>s
        ///     or some traces stacked and some not, if fill-linked traces are not already
        ///     consecutive, the later ones will be pushed down in the drawing order.
        /// </summary>
        [JsonPropertyName(@"stackgroup")]
        public string StackGroup { get; set;} 

        /// <summary>
        ///     Gets or sets the Stream.
        /// </summary>
        [JsonPropertyName(@"stream")]
        public Plotly.Blazor.Traces.ScatterLib.Stream Stream { get; set;} 

        /// <summary>
        ///     Sets text elements associated with each (x,y) pair. If a single string,
        ///     the same string appears over all the data points. If an array of string,
        ///     the items are mapped in order to the this trace&#39;s (x,y) coordinates.
        ///     If trace <c>hoverinfo</c> contains a <c>text</c> flag and <c>hovertext</c>
        ///     is not set, these elements will be seen in the hover labels.
        /// </summary>
        [JsonPropertyName(@"text")]
        public string Text { get; set;} 

        /// <summary>
        ///     Sets text elements associated with each (x,y) pair. If a single string,
        ///     the same string appears over all the data points. If an array of string,
        ///     the items are mapped in order to the this trace&#39;s (x,y) coordinates.
        ///     If trace <c>hoverinfo</c> contains a <c>text</c> flag and <c>hovertext</c>
        ///     is not set, these elements will be seen in the hover labels.
        /// </summary>
        [JsonPropertyName(@"text")]
        [Array]
        public IList<string> TextArray { get; set;} 

        /// <summary>
        ///     Sets the text font.
        /// </summary>
        [JsonPropertyName(@"textfont")]
        public Plotly.Blazor.Traces.ScatterLib.TextFont TextFont { get; set;} 

        /// <summary>
        ///     Sets the positions of the <c>text</c> elements with respects to the (x,y)
        ///     coordinates.
        /// </summary>
        [JsonPropertyName(@"textposition")]
        public Plotly.Blazor.Traces.ScatterLib.TextPositionEnum? TextPosition { get; set;} 

        /// <summary>
        ///     Sets the positions of the <c>text</c> elements with respects to the (x,y)
        ///     coordinates.
        /// </summary>
        [JsonPropertyName(@"textposition")]
        [Array]
        public IList<Plotly.Blazor.Traces.ScatterLib.TextPositionEnum?> TextPositionArray { get; set;} 

        /// <summary>
        ///     Sets the source reference on Chart Studio Cloud for <c>textposition</c>.
        /// </summary>
        [JsonPropertyName(@"textpositionsrc")]
        public string TextPositionSrc { get; set;} 

        /// <summary>
        ///     Sets the source reference on Chart Studio Cloud for <c>text</c>.
        /// </summary>
        [JsonPropertyName(@"textsrc")]
        public string TextSrc { get; set;} 

        /// <summary>
        ///     Template string used for rendering the information text that appear on points.
        ///     Note that this will override <c>textinfo</c>. Variables are inserted using
        ///     %{variable}, for example &quot;y: %{y}&quot;. Numbers are formatted using
        ///     d3-format&#39;s syntax %{variable:d3-format}, for example &quot;Price: %{y:$.2f}&quot;.
        ///     https://github.com/d3/d3-format/tree/v1.4.5#d3-format for details on the
        ///     formatting syntax. Dates are formatted using d3-time-format&#39;s syntax
        ///     %{variable|d3-time-format}, for example &quot;Day: %{2019-01-01|%A}&quot;.
        ///     https://github.com/d3/d3-time-format/tree/v2.2.3#locale_format for details
        ///     on the date formatting syntax. Every attributes that can be specified per-point
        ///     (the ones that are &#39;arrayOk: true&#39;) are available. 
        /// </summary>
        [JsonPropertyName(@"texttemplate")]
        public string TextTemplate { get; set;} 

        /// <summary>
        ///     Template string used for rendering the information text that appear on points.
        ///     Note that this will override <c>textinfo</c>. Variables are inserted using
        ///     %{variable}, for example &quot;y: %{y}&quot;. Numbers are formatted using
        ///     d3-format&#39;s syntax %{variable:d3-format}, for example &quot;Price: %{y:$.2f}&quot;.
        ///     https://github.com/d3/d3-format/tree/v1.4.5#d3-format for details on the
        ///     formatting syntax. Dates are formatted using d3-time-format&#39;s syntax
        ///     %{variable|d3-time-format}, for example &quot;Day: %{2019-01-01|%A}&quot;.
        ///     https://github.com/d3/d3-time-format/tree/v2.2.3#locale_format for details
        ///     on the date formatting syntax. Every attributes that can be specified per-point
        ///     (the ones that are &#39;arrayOk: true&#39;) are available. 
        /// </summary>
        [JsonPropertyName(@"texttemplate")]
        [Array]
        public IList<string> TextTemplateArray { get; set;} 

        /// <summary>
        ///     Sets the source reference on Chart Studio Cloud for <c>texttemplate</c>.
        /// </summary>
        [JsonPropertyName(@"texttemplatesrc")]
        public string TextTemplateSrc { get; set;} 

        /// <summary>
        ///     Gets or sets the Transforms.
        /// </summary>
        [JsonPropertyName(@"transforms")]
        public IList<ITransform> Transforms { get; set;} 

        /// <summary>
        ///     Assign an id to this trace, Use this to provide object constancy between
        ///     traces during animations and transitions.
        /// </summary>
        [JsonPropertyName(@"uid")]
        public string UId { get; set;} 

        /// <summary>
        ///     Controls persistence of some user-driven changes to the trace: <c>constraintrange</c>
        ///     in <c>parcoords</c> traces, as well as some &#39;editable: true&#39; modifications
        ///     such as <c>name</c> and <c>colorbar.title</c>. Defaults to <c>layout.uirevision</c>.
        ///     Note that other user-driven trace attribute changes are controlled by <c>layout</c>
        ///     attributes: <c>trace.visible</c> is controlled by <c>layout.legend.uirevision</c>,
        ///     <c>selectedpoints</c> is controlled by <c>layout.selectionrevision</c>,
        ///     and <c>colorbar.(x|y)</c> (accessible with &#39;config: {editable: true}&#39;)
        ///     is controlled by <c>layout.editrevision</c>. Trace changes are tracked by
        ///     <c>uid</c>, which only falls back on trace index if no <c>uid</c> is provided.
        ///     So if your app can add/remove traces before the end of the <c>data</c> array,
        ///     such that the same trace has a different index, you can still preserve user-driven
        ///     changes if you give each trace a <c>uid</c> that stays with it as it moves.
        /// </summary>
        [JsonPropertyName(@"uirevision")]
        public object UiRevision { get; set;} 

        /// <summary>
        ///     Gets or sets the Unselected.
        /// </summary>
        [JsonPropertyName(@"unselected")]
        public Plotly.Blazor.Traces.ScatterLib.Unselected Unselected { get; set;} 

        /// <summary>
        ///     Determines whether or not this trace is visible. If <c>legendonly</c>, the
        ///     trace is not drawn, but can appear as a legend item (provided that the legend
        ///     itself is visible).
        /// </summary>
        [JsonPropertyName(@"visible")]
        public Plotly.Blazor.Traces.ScatterLib.VisibleEnum? Visible { get; set;} 

        /// <summary>
        ///     Sets the x coordinates.
        /// </summary>
        [JsonPropertyName(@"x")]
        public IList<object> X { get; set;} 

        /// <summary>
        ///     Alternate to <c>x</c>. Builds a linear space of x coordinates. Use with
        ///     <c>dx</c> where <c>x0</c> is the starting coordinate and <c>dx</c> the step.
        /// </summary>
        [JsonPropertyName(@"x0")]
        public object X0 { get; set;} 

        /// <summary>
        ///     Sets a reference between this trace&#39;s x coordinates and a 2D cartesian
        ///     x axis. If <c>x</c> (the default value), the x coordinates refer to <c>layout.xaxis</c>.
        ///     If <c>x2</c>, the x coordinates refer to <c>layout.xaxis2</c>, and so on.
        /// </summary>
        [JsonPropertyName(@"xaxis")]
        public string XAxis { get; set;} 

        /// <summary>
        ///     Sets the calendar system to use with <c>x</c> date data.
        /// </summary>
        [JsonPropertyName(@"xcalendar")]
        public Plotly.Blazor.Traces.ScatterLib.XCalendarEnum? XCalendar { get; set;} 

        /// <summary>
        ///     Sets the hover text formatting rulefor <c>x</c>  using d3 formatting mini-languages
        ///     which are very similar to those in Python. For numbers, see: https://github.com/d3/d3-format/tree/v1.4.5#d3-format.
        ///     And for dates see: https://github.com/d3/d3-time-format/tree/v2.2.3#locale_format.
        ///     We add two items to d3&#39;s date formatter: <c>%h</c> for half of the year
        ///     as a decimal number as well as <c>%{n}f</c> for fractional seconds with
        ///     n digits. For example, &#39;2016-10-13 09:15:23.456&#39; with tickformat
        ///     <c>%H~%M~%S.%2f</c> would display <c>09~15~23.46</c>By default the values
        ///     are formatted using <c>xaxis.hoverformat</c>.
        /// </summary>
        [JsonPropertyName(@"xhoverformat")]
        public string XHoverFormat { get; set;} 

        /// <summary>
        ///     Only relevant when the axis <c>type</c> is <c>date</c>. Sets the period
        ///     positioning in milliseconds or <c>M&lt;n&gt;</c> on the x axis. Special
        ///     values in the form of <c>M&lt;n&gt;</c> could be used to declare the number
        ///     of months. In this case <c>n</c> must be a positive integer.
        /// </summary>
        [JsonPropertyName(@"xperiod")]
        public object XPeriod { get; set;} 

        /// <summary>
        ///     Only relevant when the axis <c>type</c> is <c>date</c>. Sets the base for
        ///     period positioning in milliseconds or date string on the x0 axis. When <c>x0period</c>
        ///     is round number of weeks, the <c>x0period0</c> by default would be on a
        ///     Sunday i.e. 2000-01-02, otherwise it would be at 2000-01-01.
        /// </summary>
        [JsonPropertyName(@"xperiod0")]
        public object XPeriod0 { get; set;} 

        /// <summary>
        ///     Only relevant when the axis <c>type</c> is <c>date</c>. Sets the alignment
        ///     of data points on the x axis.
        /// </summary>
        [JsonPropertyName(@"xperiodalignment")]
        public Plotly.Blazor.Traces.ScatterLib.XPeriodAlignmentEnum? XPeriodAlignment { get; set;} 

        /// <summary>
        ///     Sets the source reference on Chart Studio Cloud for <c>x</c>.
        /// </summary>
        [JsonPropertyName(@"xsrc")]
        public string XSrc { get; set;} 

        /// <summary>
        ///     Sets the y coordinates.
        /// </summary>
        [JsonPropertyName(@"y")]
        public IList<object> Y { get; set;} 

        /// <summary>
        ///     Alternate to <c>y</c>. Builds a linear space of y coordinates. Use with
        ///     <c>dy</c> where <c>y0</c> is the starting coordinate and <c>dy</c> the step.
        /// </summary>
        [JsonPropertyName(@"y0")]
        public object Y0 { get; set;} 

        /// <summary>
        ///     Sets a reference between this trace&#39;s y coordinates and a 2D cartesian
        ///     y axis. If <c>y</c> (the default value), the y coordinates refer to <c>layout.yaxis</c>.
        ///     If <c>y2</c>, the y coordinates refer to <c>layout.yaxis2</c>, and so on.
        /// </summary>
        [JsonPropertyName(@"yaxis")]
        public string YAxis { get; set;} 

        /// <summary>
        ///     Sets the calendar system to use with <c>y</c> date data.
        /// </summary>
        [JsonPropertyName(@"ycalendar")]
        public Plotly.Blazor.Traces.ScatterLib.YCalendarEnum? YCalendar { get; set;} 

        /// <summary>
        ///     Sets the hover text formatting rulefor <c>y</c>  using d3 formatting mini-languages
        ///     which are very similar to those in Python. For numbers, see: https://github.com/d3/d3-format/tree/v1.4.5#d3-format.
        ///     And for dates see: https://github.com/d3/d3-time-format/tree/v2.2.3#locale_format.
        ///     We add two items to d3&#39;s date formatter: <c>%h</c> for half of the year
        ///     as a decimal number as well as <c>%{n}f</c> for fractional seconds with
        ///     n digits. For example, &#39;2016-10-13 09:15:23.456&#39; with tickformat
        ///     <c>%H~%M~%S.%2f</c> would display <c>09~15~23.46</c>By default the values
        ///     are formatted using <c>yaxis.hoverformat</c>.
        /// </summary>
        [JsonPropertyName(@"yhoverformat")]
        public string YHoverFormat { get; set;} 

        /// <summary>
        ///     Only relevant when the axis <c>type</c> is <c>date</c>. Sets the period
        ///     positioning in milliseconds or <c>M&lt;n&gt;</c> on the y axis. Special
        ///     values in the form of <c>M&lt;n&gt;</c> could be used to declare the number
        ///     of months. In this case <c>n</c> must be a positive integer.
        /// </summary>
        [JsonPropertyName(@"yperiod")]
        public object YPeriod { get; set;} 

        /// <summary>
        ///     Only relevant when the axis <c>type</c> is <c>date</c>. Sets the base for
        ///     period positioning in milliseconds or date string on the y0 axis. When <c>y0period</c>
        ///     is round number of weeks, the <c>y0period0</c> by default would be on a
        ///     Sunday i.e. 2000-01-02, otherwise it would be at 2000-01-01.
        /// </summary>
        [JsonPropertyName(@"yperiod0")]
        public object YPeriod0 { get; set;} 

        /// <summary>
        ///     Only relevant when the axis <c>type</c> is <c>date</c>. Sets the alignment
        ///     of data points on the y axis.
        /// </summary>
        [JsonPropertyName(@"yperiodalignment")]
        public Plotly.Blazor.Traces.ScatterLib.YPeriodAlignmentEnum? YPeriodAlignment { get; set;} 

        /// <summary>
        ///     Sets the source reference on Chart Studio Cloud for <c>y</c>.
        /// </summary>
        [JsonPropertyName(@"ysrc")]
        public string YSrc { get; set;} 

        /// <summary>
        ///     Sets the layer on which this trace is displayed, relative to other SVG traces
        ///     on the same subplot. SVG traces with higher <c>zorder</c> appear in front
        ///     of those with lower <c>zorder</c>.
        /// </summary>
        [JsonPropertyName(@"zorder")]
        public int? ZOrder { get; set;} 

        /// <inheritdoc />
        public override bool Equals(object obj)
        {
            if (!(obj is Scatter other)) return false;

            return ReferenceEquals(this, obj) || Equals(other);
        }

        /// <inheritdoc />
        public bool Equals([AllowNull] Scatter other)
        {
            if (other == null) return false;
            if (ReferenceEquals(this, other)) return true;

            return 
                (
                    Type == other.Type ||
                    Type != null &&
                    Type.Equals(other.Type)
                ) && 
                (
                    AlignmentGroup == other.AlignmentGroup ||
                    AlignmentGroup != null &&
                    AlignmentGroup.Equals(other.AlignmentGroup)
                ) && 
                (
                    ClipOnAxis == other.ClipOnAxis ||
                    ClipOnAxis != null &&
                    ClipOnAxis.Equals(other.ClipOnAxis)
                ) && 
                (
                    ConnectGaps == other.ConnectGaps ||
                    ConnectGaps != null &&
                    ConnectGaps.Equals(other.ConnectGaps)
                ) && 
                (
                    Equals(CustomData, other.CustomData) ||
                    CustomData != null && other.CustomData != null &&
                    CustomData.SequenceEqual(other.CustomData)
                ) &&
                (
                    CustomDataSrc == other.CustomDataSrc ||
                    CustomDataSrc != null &&
                    CustomDataSrc.Equals(other.CustomDataSrc)
                ) && 
                (
                    DX == other.DX ||
                    DX != null &&
                    DX.Equals(other.DX)
                ) && 
                (
                    Dy == other.Dy ||
                    Dy != null &&
                    Dy.Equals(other.Dy)
                ) && 
                (
                    ErrorX == other.ErrorX ||
                    ErrorX != null &&
                    ErrorX.Equals(other.ErrorX)
                ) && 
                (
                    ErrorY == other.ErrorY ||
                    ErrorY != null &&
                    ErrorY.Equals(other.ErrorY)
                ) && 
                (
                    Fill == other.Fill ||
                    Fill != null &&
                    Fill.Equals(other.Fill)
                ) && 
                (
                    FillColor == other.FillColor ||
                    FillColor != null &&
                    FillColor.Equals(other.FillColor)
                ) && 
                (
                    FillGradient == other.FillGradient ||
                    FillGradient != null &&
                    FillGradient.Equals(other.FillGradient)
                ) && 
                (
                    FillPattern == other.FillPattern ||
                    FillPattern != null &&
                    FillPattern.Equals(other.FillPattern)
                ) && 
                (
                    GroupNorm == other.GroupNorm ||
                    GroupNorm != null &&
                    GroupNorm.Equals(other.GroupNorm)
                ) && 
                (
                    HoverInfo == other.HoverInfo ||
                    HoverInfo != null &&
                    HoverInfo.Equals(other.HoverInfo)
                ) && 
                (
                    Equals(HoverInfoArray, other.HoverInfoArray) ||
                    HoverInfoArray != null && other.HoverInfoArray != null &&
                    HoverInfoArray.SequenceEqual(other.HoverInfoArray)
                ) &&
                (
                    HoverInfoSrc == other.HoverInfoSrc ||
                    HoverInfoSrc != null &&
                    HoverInfoSrc.Equals(other.HoverInfoSrc)
                ) && 
                (
                    HoverLabel == other.HoverLabel ||
                    HoverLabel != null &&
                    HoverLabel.Equals(other.HoverLabel)
                ) && 
                (
                    HoverOn == other.HoverOn ||
                    HoverOn != null &&
                    HoverOn.Equals(other.HoverOn)
                ) && 
                (
                    HoverTemplate == other.HoverTemplate ||
                    HoverTemplate != null &&
                    HoverTemplate.Equals(other.HoverTemplate)
                ) && 
                (
                    Equals(HoverTemplateArray, other.HoverTemplateArray) ||
                    HoverTemplateArray != null && other.HoverTemplateArray != null &&
                    HoverTemplateArray.SequenceEqual(other.HoverTemplateArray)
                ) &&
                (
                    HoverTemplateSrc == other.HoverTemplateSrc ||
                    HoverTemplateSrc != null &&
                    HoverTemplateSrc.Equals(other.HoverTemplateSrc)
                ) && 
                (
                    HoverText == other.HoverText ||
                    HoverText != null &&
                    HoverText.Equals(other.HoverText)
                ) && 
                (
                    Equals(HoverTextArray, other.HoverTextArray) ||
                    HoverTextArray != null && other.HoverTextArray != null &&
                    HoverTextArray.SequenceEqual(other.HoverTextArray)
                ) &&
                (
                    HoverTextSrc == other.HoverTextSrc ||
                    HoverTextSrc != null &&
                    HoverTextSrc.Equals(other.HoverTextSrc)
                ) && 
                (
                    Equals(Ids, other.Ids) ||
                    Ids != null && other.Ids != null &&
                    Ids.SequenceEqual(other.Ids)
                ) &&
                (
                    IdsSrc == other.IdsSrc ||
                    IdsSrc != null &&
                    IdsSrc.Equals(other.IdsSrc)
                ) && 
                (
                    Legend == other.Legend ||
                    Legend != null &&
                    Legend.Equals(other.Legend)
                ) && 
                (
                    LegendGroup == other.LegendGroup ||
                    LegendGroup != null &&
                    LegendGroup.Equals(other.LegendGroup)
                ) && 
                (
                    LegendGroupTitle == other.LegendGroupTitle ||
                    LegendGroupTitle != null &&
                    LegendGroupTitle.Equals(other.LegendGroupTitle)
                ) && 
                (
                    LegendRank == other.LegendRank ||
                    LegendRank != null &&
                    LegendRank.Equals(other.LegendRank)
                ) && 
                (
                    LegendWidth == other.LegendWidth ||
                    LegendWidth != null &&
                    LegendWidth.Equals(other.LegendWidth)
                ) && 
                (
                    Line == other.Line ||
                    Line != null &&
                    Line.Equals(other.Line)
                ) && 
                (
                    Marker == other.Marker ||
                    Marker != null &&
                    Marker.Equals(other.Marker)
                ) && 
                (
                    Meta == other.Meta ||
                    Meta != null &&
                    Meta.Equals(other.Meta)
                ) && 
                (
                    Equals(MetaArray, other.MetaArray) ||
                    MetaArray != null && other.MetaArray != null &&
                    MetaArray.SequenceEqual(other.MetaArray)
                ) &&
                (
                    MetaSrc == other.MetaSrc ||
                    MetaSrc != null &&
                    MetaSrc.Equals(other.MetaSrc)
                ) && 
                (
                    Mode == other.Mode ||
                    Mode != null &&
                    Mode.Equals(other.Mode)
                ) && 
                (
                    Name == other.Name ||
                    Name != null &&
                    Name.Equals(other.Name)
                ) && 
                (
                    OffsetGroup == other.OffsetGroup ||
                    OffsetGroup != null &&
                    OffsetGroup.Equals(other.OffsetGroup)
                ) && 
                (
                    Opacity == other.Opacity ||
                    Opacity != null &&
                    Opacity.Equals(other.Opacity)
                ) && 
                (
                    Orientation == other.Orientation ||
                    Orientation != null &&
                    Orientation.Equals(other.Orientation)
                ) && 
                (
                    Selected == other.Selected ||
                    Selected != null &&
                    Selected.Equals(other.Selected)
                ) && 
                (
                    SelectedPoints == other.SelectedPoints ||
                    SelectedPoints != null &&
                    SelectedPoints.Equals(other.SelectedPoints)
                ) && 
                (
                    ShowLegend == other.ShowLegend ||
                    ShowLegend != null &&
                    ShowLegend.Equals(other.ShowLegend)
                ) && 
                (
                    StackGaps == other.StackGaps ||
                    StackGaps != null &&
                    StackGaps.Equals(other.StackGaps)
                ) && 
                (
                    StackGroup == other.StackGroup ||
                    StackGroup != null &&
                    StackGroup.Equals(other.StackGroup)
                ) && 
                (
                    Stream == other.Stream ||
                    Stream != null &&
                    Stream.Equals(other.Stream)
                ) && 
                (
                    Text == other.Text ||
                    Text != null &&
                    Text.Equals(other.Text)
                ) && 
                (
                    Equals(TextArray, other.TextArray) ||
                    TextArray != null && other.TextArray != null &&
                    TextArray.SequenceEqual(other.TextArray)
                ) &&
                (
                    TextFont == other.TextFont ||
                    TextFont != null &&
                    TextFont.Equals(other.TextFont)
                ) && 
                (
                    TextPosition == other.TextPosition ||
                    TextPosition != null &&
                    TextPosition.Equals(other.TextPosition)
                ) && 
                (
                    Equals(TextPositionArray, other.TextPositionArray) ||
                    TextPositionArray != null && other.TextPositionArray != null &&
                    TextPositionArray.SequenceEqual(other.TextPositionArray)
                ) &&
                (
                    TextPositionSrc == other.TextPositionSrc ||
                    TextPositionSrc != null &&
                    TextPositionSrc.Equals(other.TextPositionSrc)
                ) && 
                (
                    TextSrc == other.TextSrc ||
                    TextSrc != null &&
                    TextSrc.Equals(other.TextSrc)
                ) && 
                (
                    TextTemplate == other.TextTemplate ||
                    TextTemplate != null &&
                    TextTemplate.Equals(other.TextTemplate)
                ) && 
                (
                    Equals(TextTemplateArray, other.TextTemplateArray) ||
                    TextTemplateArray != null && other.TextTemplateArray != null &&
                    TextTemplateArray.SequenceEqual(other.TextTemplateArray)
                ) &&
                (
                    TextTemplateSrc == other.TextTemplateSrc ||
                    TextTemplateSrc != null &&
                    TextTemplateSrc.Equals(other.TextTemplateSrc)
                ) && 
                (
                    Equals(Transforms, other.Transforms) ||
                    Transforms != null && other.Transforms != null &&
                    Transforms.SequenceEqual(other.Transforms)
                ) &&
                (
                    UId == other.UId ||
                    UId != null &&
                    UId.Equals(other.UId)
                ) && 
                (
                    UiRevision == other.UiRevision ||
                    UiRevision != null &&
                    UiRevision.Equals(other.UiRevision)
                ) && 
                (
                    Unselected == other.Unselected ||
                    Unselected != null &&
                    Unselected.Equals(other.Unselected)
                ) && 
                (
                    Visible == other.Visible ||
                    Visible != null &&
                    Visible.Equals(other.Visible)
                ) && 
                (
                    Equals(X, other.X) ||
                    X != null && other.X != null &&
                    X.SequenceEqual(other.X)
                ) &&
                (
                    X0 == other.X0 ||
                    X0 != null &&
                    X0.Equals(other.X0)
                ) && 
                (
                    XAxis == other.XAxis ||
                    XAxis != null &&
                    XAxis.Equals(other.XAxis)
                ) && 
                (
                    XCalendar == other.XCalendar ||
                    XCalendar != null &&
                    XCalendar.Equals(other.XCalendar)
                ) && 
                (
                    XHoverFormat == other.XHoverFormat ||
                    XHoverFormat != null &&
                    XHoverFormat.Equals(other.XHoverFormat)
                ) && 
                (
                    XPeriod == other.XPeriod ||
                    XPeriod != null &&
                    XPeriod.Equals(other.XPeriod)
                ) && 
                (
                    XPeriod0 == other.XPeriod0 ||
                    XPeriod0 != null &&
                    XPeriod0.Equals(other.XPeriod0)
                ) && 
                (
                    XPeriodAlignment == other.XPeriodAlignment ||
                    XPeriodAlignment != null &&
                    XPeriodAlignment.Equals(other.XPeriodAlignment)
                ) && 
                (
                    XSrc == other.XSrc ||
                    XSrc != null &&
                    XSrc.Equals(other.XSrc)
                ) && 
                (
                    Equals(Y, other.Y) ||
                    Y != null && other.Y != null &&
                    Y.SequenceEqual(other.Y)
                ) &&
                (
                    Y0 == other.Y0 ||
                    Y0 != null &&
                    Y0.Equals(other.Y0)
                ) && 
                (
                    YAxis == other.YAxis ||
                    YAxis != null &&
                    YAxis.Equals(other.YAxis)
                ) && 
                (
                    YCalendar == other.YCalendar ||
                    YCalendar != null &&
                    YCalendar.Equals(other.YCalendar)
                ) && 
                (
                    YHoverFormat == other.YHoverFormat ||
                    YHoverFormat != null &&
                    YHoverFormat.Equals(other.YHoverFormat)
                ) && 
                (
                    YPeriod == other.YPeriod ||
                    YPeriod != null &&
                    YPeriod.Equals(other.YPeriod)
                ) && 
                (
                    YPeriod0 == other.YPeriod0 ||
                    YPeriod0 != null &&
                    YPeriod0.Equals(other.YPeriod0)
                ) && 
                (
                    YPeriodAlignment == other.YPeriodAlignment ||
                    YPeriodAlignment != null &&
                    YPeriodAlignment.Equals(other.YPeriodAlignment)
                ) && 
                (
                    YSrc == other.YSrc ||
                    YSrc != null &&
                    YSrc.Equals(other.YSrc)
                ) && 
                (
                    ZOrder == other.ZOrder ||
                    ZOrder != null &&
                    ZOrder.Equals(other.ZOrder)
                );
        }

        /// <inheritdoc />
        public override int GetHashCode()
        {
            unchecked // Overflow is fine, just wrap
            {
                var hashCode = 41;
                if (Type != null) hashCode = hashCode * 59 + Type.GetHashCode();
                if (AlignmentGroup != null) hashCode = hashCode * 59 + AlignmentGroup.GetHashCode();
                if (ClipOnAxis != null) hashCode = hashCode * 59 + ClipOnAxis.GetHashCode();
                if (ConnectGaps != null) hashCode = hashCode * 59 + ConnectGaps.GetHashCode();
                if (CustomData != null) hashCode = hashCode * 59 + CustomData.GetHashCode();
                if (CustomDataSrc != null) hashCode = hashCode * 59 + CustomDataSrc.GetHashCode();
                if (DX != null) hashCode = hashCode * 59 + DX.GetHashCode();
                if (Dy != null) hashCode = hashCode * 59 + Dy.GetHashCode();
                if (ErrorX != null) hashCode = hashCode * 59 + ErrorX.GetHashCode();
                if (ErrorY != null) hashCode = hashCode * 59 + ErrorY.GetHashCode();
                if (Fill != null) hashCode = hashCode * 59 + Fill.GetHashCode();
                if (FillColor != null) hashCode = hashCode * 59 + FillColor.GetHashCode();
                if (FillGradient != null) hashCode = hashCode * 59 + FillGradient.GetHashCode();
                if (FillPattern != null) hashCode = hashCode * 59 + FillPattern.GetHashCode();
                if (GroupNorm != null) hashCode = hashCode * 59 + GroupNorm.GetHashCode();
                if (HoverInfo != null) hashCode = hashCode * 59 + HoverInfo.GetHashCode();
                if (HoverInfoArray != null) hashCode = hashCode * 59 + HoverInfoArray.GetHashCode();
                if (HoverInfoSrc != null) hashCode = hashCode * 59 + HoverInfoSrc.GetHashCode();
                if (HoverLabel != null) hashCode = hashCode * 59 + HoverLabel.GetHashCode();
                if (HoverOn != null) hashCode = hashCode * 59 + HoverOn.GetHashCode();
                if (HoverTemplate != null) hashCode = hashCode * 59 + HoverTemplate.GetHashCode();
                if (HoverTemplateArray != null) hashCode = hashCode * 59 + HoverTemplateArray.GetHashCode();
                if (HoverTemplateSrc != null) hashCode = hashCode * 59 + HoverTemplateSrc.GetHashCode();
                if (HoverText != null) hashCode = hashCode * 59 + HoverText.GetHashCode();
                if (HoverTextArray != null) hashCode = hashCode * 59 + HoverTextArray.GetHashCode();
                if (HoverTextSrc != null) hashCode = hashCode * 59 + HoverTextSrc.GetHashCode();
                if (Ids != null) hashCode = hashCode * 59 + Ids.GetHashCode();
                if (IdsSrc != null) hashCode = hashCode * 59 + IdsSrc.GetHashCode();
                if (Legend != null) hashCode = hashCode * 59 + Legend.GetHashCode();
                if (LegendGroup != null) hashCode = hashCode * 59 + LegendGroup.GetHashCode();
                if (LegendGroupTitle != null) hashCode = hashCode * 59 + LegendGroupTitle.GetHashCode();
                if (LegendRank != null) hashCode = hashCode * 59 + LegendRank.GetHashCode();
                if (LegendWidth != null) hashCode = hashCode * 59 + LegendWidth.GetHashCode();
                if (Line != null) hashCode = hashCode * 59 + Line.GetHashCode();
                if (Marker != null) hashCode = hashCode * 59 + Marker.GetHashCode();
                if (Meta != null) hashCode = hashCode * 59 + Meta.GetHashCode();
                if (MetaArray != null) hashCode = hashCode * 59 + MetaArray.GetHashCode();
                if (MetaSrc != null) hashCode = hashCode * 59 + MetaSrc.GetHashCode();
                if (Mode != null) hashCode = hashCode * 59 + Mode.GetHashCode();
                if (Name != null) hashCode = hashCode * 59 + Name.GetHashCode();
                if (OffsetGroup != null) hashCode = hashCode * 59 + OffsetGroup.GetHashCode();
                if (Opacity != null) hashCode = hashCode * 59 + Opacity.GetHashCode();
                if (Orientation != null) hashCode = hashCode * 59 + Orientation.GetHashCode();
                if (Selected != null) hashCode = hashCode * 59 + Selected.GetHashCode();
                if (SelectedPoints != null) hashCode = hashCode * 59 + SelectedPoints.GetHashCode();
                if (ShowLegend != null) hashCode = hashCode * 59 + ShowLegend.GetHashCode();
                if (StackGaps != null) hashCode = hashCode * 59 + StackGaps.GetHashCode();
                if (StackGroup != null) hashCode = hashCode * 59 + StackGroup.GetHashCode();
                if (Stream != null) hashCode = hashCode * 59 + Stream.GetHashCode();
                if (Text != null) hashCode = hashCode * 59 + Text.GetHashCode();
                if (TextArray != null) hashCode = hashCode * 59 + TextArray.GetHashCode();
                if (TextFont != null) hashCode = hashCode * 59 + TextFont.GetHashCode();
                if (TextPosition != null) hashCode = hashCode * 59 + TextPosition.GetHashCode();
                if (TextPositionArray != null) hashCode = hashCode * 59 + TextPositionArray.GetHashCode();
                if (TextPositionSrc != null) hashCode = hashCode * 59 + TextPositionSrc.GetHashCode();
                if (TextSrc != null) hashCode = hashCode * 59 + TextSrc.GetHashCode();
                if (TextTemplate != null) hashCode = hashCode * 59 + TextTemplate.GetHashCode();
                if (TextTemplateArray != null) hashCode = hashCode * 59 + TextTemplateArray.GetHashCode();
                if (TextTemplateSrc != null) hashCode = hashCode * 59 + TextTemplateSrc.GetHashCode();
                if (Transforms != null) hashCode = hashCode * 59 + Transforms.GetHashCode();
                if (UId != null) hashCode = hashCode * 59 + UId.GetHashCode();
                if (UiRevision != null) hashCode = hashCode * 59 + UiRevision.GetHashCode();
                if (Unselected != null) hashCode = hashCode * 59 + Unselected.GetHashCode();
                if (Visible != null) hashCode = hashCode * 59 + Visible.GetHashCode();
                if (X != null) hashCode = hashCode * 59 + X.GetHashCode();
                if (X0 != null) hashCode = hashCode * 59 + X0.GetHashCode();
                if (XAxis != null) hashCode = hashCode * 59 + XAxis.GetHashCode();
                if (XCalendar != null) hashCode = hashCode * 59 + XCalendar.GetHashCode();
                if (XHoverFormat != null) hashCode = hashCode * 59 + XHoverFormat.GetHashCode();
                if (XPeriod != null) hashCode = hashCode * 59 + XPeriod.GetHashCode();
                if (XPeriod0 != null) hashCode = hashCode * 59 + XPeriod0.GetHashCode();
                if (XPeriodAlignment != null) hashCode = hashCode * 59 + XPeriodAlignment.GetHashCode();
                if (XSrc != null) hashCode = hashCode * 59 + XSrc.GetHashCode();
                if (Y != null) hashCode = hashCode * 59 + Y.GetHashCode();
                if (Y0 != null) hashCode = hashCode * 59 + Y0.GetHashCode();
                if (YAxis != null) hashCode = hashCode * 59 + YAxis.GetHashCode();
                if (YCalendar != null) hashCode = hashCode * 59 + YCalendar.GetHashCode();
                if (YHoverFormat != null) hashCode = hashCode * 59 + YHoverFormat.GetHashCode();
                if (YPeriod != null) hashCode = hashCode * 59 + YPeriod.GetHashCode();
                if (YPeriod0 != null) hashCode = hashCode * 59 + YPeriod0.GetHashCode();
                if (YPeriodAlignment != null) hashCode = hashCode * 59 + YPeriodAlignment.GetHashCode();
                if (YSrc != null) hashCode = hashCode * 59 + YSrc.GetHashCode();
                if (ZOrder != null) hashCode = hashCode * 59 + ZOrder.GetHashCode();
                return hashCode;
            }
        }

        /// <summary>
        ///     Checks for equality of the left Scatter and the right Scatter.
        /// </summary>
        /// <param name="left">Left Scatter.</param>
        /// <param name="right">Right Scatter.</param>
        /// <returns>Boolean</returns>
        public static bool operator == (Scatter left, Scatter right)
        {
            return Equals(left, right);
        }

        /// <summary>
        ///     Checks for inequality of the left Scatter and the right Scatter.
        /// </summary>
        /// <param name="left">Left Scatter.</param>
        /// <param name="right">Right Scatter.</param>
        /// <returns>Boolean</returns>
        public static bool operator != (Scatter left, Scatter right)
        {
            return !Equals(left, right);
        }

        /// <summary>
        ///     Gets a deep copy of this instance.
        /// </summary>
        /// <returns>Scatter</returns>
        public Scatter DeepClone()
        {
            return this.Copy();
        }
    }
}