/*
 * THIS FILE WAS GENERATED BY PLOTLY.BLAZOR.GENERATOR
*/

using System;
using System.Collections.Generic;
using System.Diagnostics.CodeAnalysis;
using System.IO;
using System.Linq;
using System.Runtime.Serialization.Formatters.Binary;
using System.Text.Json.Serialization;

namespace Plotly.Blazor.Traces.SankeyLib
{
    /// <summary>
    ///     The Link class.
    /// </summary>
    [System.CodeDom.Compiler.GeneratedCode("Plotly.Blazor.Generator", null)]
    [JsonConverter(typeof(PlotlyConverter))]
    [Serializable]
    public class Link : IEquatable<Link>
    {
        /// <summary>
        ///     Sets the length (in px) of the links arrow, if 0 no arrow will be drawn.
        /// </summary>
        [JsonPropertyName(@"arrowlen")]
        public decimal? ArrowLen { get; set;} 

        /// <summary>
        ///     Sets the <c>link</c> color. It can be a single value, or an array for specifying
        ///     color for each <c>link</c>. If <c>link.color</c> is omitted, then by default,
        ///     a translucent grey link will be used.
        /// </summary>
        [JsonPropertyName(@"color")]
        public object Color { get; set;} 

        /// <summary>
        ///     Sets the <c>link</c> color. It can be a single value, or an array for specifying
        ///     color for each <c>link</c>. If <c>link.color</c> is omitted, then by default,
        ///     a translucent grey link will be used.
        /// </summary>
        [JsonPropertyName(@"color")]
        [Array]
        public IList<object> ColorArray { get; set;} 

        /// <summary>
        ///     Gets or sets the ColorScales.
        /// </summary>
        [JsonPropertyName(@"colorscales")]
        public IList<Plotly.Blazor.Traces.SankeyLib.LinkLib.ConcentrationScales> ColorScales { get; set;} 

        /// <summary>
        ///     Sets the source reference on Chart Studio Cloud for <c>color</c>.
        /// </summary>
        [JsonPropertyName(@"colorsrc")]
        public string ColorSrc { get; set;} 

        /// <summary>
        ///     Assigns extra data to each link.
        /// </summary>
        [JsonPropertyName(@"customdata")]
        public IList<object> CustomData { get; set;} 

        /// <summary>
        ///     Sets the source reference on Chart Studio Cloud for <c>customdata</c>.
        /// </summary>
        [JsonPropertyName(@"customdatasrc")]
        public string CustomDataSrc { get; set;} 

        /// <summary>
        ///     Sets the <c>link</c> hover color. It can be a single value, or an array
        ///     for specifying hover colors for each <c>link</c>. If <c>link.hovercolor</c>
        ///     is omitted, then by default, links will become slightly more opaque when
        ///     hovered over.
        /// </summary>
        [JsonPropertyName(@"hovercolor")]
        public object HoverColor { get; set;} 

        /// <summary>
        ///     Sets the <c>link</c> hover color. It can be a single value, or an array
        ///     for specifying hover colors for each <c>link</c>. If <c>link.hovercolor</c>
        ///     is omitted, then by default, links will become slightly more opaque when
        ///     hovered over.
        /// </summary>
        [JsonPropertyName(@"hovercolor")]
        [Array]
        public IList<object> HoverColorArray { get; set;} 

        /// <summary>
        ///     Sets the source reference on Chart Studio Cloud for <c>hovercolor</c>.
        /// </summary>
        [JsonPropertyName(@"hovercolorsrc")]
        public string HoverColorSrc { get; set;} 

        /// <summary>
        ///     Determines which trace information appear when hovering links. If <c>none</c>
        ///     or <c>skip</c> are set, no information is displayed upon hovering. But,
        ///     if <c>none</c> is set, click and hover events are still fired.
        /// </summary>
        [JsonPropertyName(@"hoverinfo")]
        public Plotly.Blazor.Traces.SankeyLib.LinkLib.HoverInfoEnum? HoverInfo { get; set;} 

        /// <summary>
        ///     Gets or sets the HoverLabel.
        /// </summary>
        [JsonPropertyName(@"hoverlabel")]
        public Plotly.Blazor.Traces.SankeyLib.LinkLib.HoverLabel HoverLabel { get; set;} 

        /// <summary>
        ///     Template string used for rendering the information that appear on hover
        ///     box. Note that this will override <c>hoverinfo</c>. Variables are inserted
        ///     using %{variable}, for example &quot;y: %{y}&quot; as well as %{xother},
        ///     {%_xother}, {%_xother_}, {%xother_}. When showing info for several points,
        ///     <c>xother</c> will be added to those with different x positions from the
        ///     first point. An underscore before or after <c>(x|y)other</c> will add a
        ///     space on that side, only when this field is shown. Numbers are formatted
        ///     using d3-format&#39;s syntax %{variable:d3-format}, for example &quot;Price:
        ///     %{y:$.2f}&quot;. https://github.com/d3/d3-format/tree/v1.4.5#d3-format for
        ///     details on the formatting syntax. Dates are formatted using d3-time-format&#39;s
        ///     syntax %{variable|d3-time-format}, for example &quot;Day: %{2019-01-01|%A}&quot;.
        ///     https://github.com/d3/d3-time-format/tree/v2.2.3#locale_format for details
        ///     on the date formatting syntax. The variables available in <c>hovertemplate</c>
        ///     are the ones emitted as event data described at this link https://plotly.com/javascript/plotlyjs-events/#event-data.
        ///     Additionally, every attributes that can be specified per-point (the ones
        ///     that are &#39;arrayOk: true&#39;) are available.  Variables <c>source</c>
        ///     and <c>target</c> are node objects.Finally, the template string has access
        ///     to variables <c>value</c> and <c>label</c>. Anything contained in tag <c>&lt;extra&gt;</c>
        ///     is displayed in the secondary box, for example <c>&lt;extra&gt;{fullData.name}&lt;/extra&gt;</c>.
        ///     To hide the secondary box completely, use an empty tag <c>&lt;extra&gt;&lt;/extra&gt;</c>.
        /// </summary>
        [JsonPropertyName(@"hovertemplate")]
        public string HoverTemplate { get; set;} 

        /// <summary>
        ///     Template string used for rendering the information that appear on hover
        ///     box. Note that this will override <c>hoverinfo</c>. Variables are inserted
        ///     using %{variable}, for example &quot;y: %{y}&quot; as well as %{xother},
        ///     {%_xother}, {%_xother_}, {%xother_}. When showing info for several points,
        ///     <c>xother</c> will be added to those with different x positions from the
        ///     first point. An underscore before or after <c>(x|y)other</c> will add a
        ///     space on that side, only when this field is shown. Numbers are formatted
        ///     using d3-format&#39;s syntax %{variable:d3-format}, for example &quot;Price:
        ///     %{y:$.2f}&quot;. https://github.com/d3/d3-format/tree/v1.4.5#d3-format for
        ///     details on the formatting syntax. Dates are formatted using d3-time-format&#39;s
        ///     syntax %{variable|d3-time-format}, for example &quot;Day: %{2019-01-01|%A}&quot;.
        ///     https://github.com/d3/d3-time-format/tree/v2.2.3#locale_format for details
        ///     on the date formatting syntax. The variables available in <c>hovertemplate</c>
        ///     are the ones emitted as event data described at this link https://plotly.com/javascript/plotlyjs-events/#event-data.
        ///     Additionally, every attributes that can be specified per-point (the ones
        ///     that are &#39;arrayOk: true&#39;) are available.  Variables <c>source</c>
        ///     and <c>target</c> are node objects.Finally, the template string has access
        ///     to variables <c>value</c> and <c>label</c>. Anything contained in tag <c>&lt;extra&gt;</c>
        ///     is displayed in the secondary box, for example <c>&lt;extra&gt;{fullData.name}&lt;/extra&gt;</c>.
        ///     To hide the secondary box completely, use an empty tag <c>&lt;extra&gt;&lt;/extra&gt;</c>.
        /// </summary>
        [JsonPropertyName(@"hovertemplate")]
        [Array]
        public IList<string> HoverTemplateArray { get; set;} 

        /// <summary>
        ///     Sets the source reference on Chart Studio Cloud for <c>hovertemplate</c>.
        /// </summary>
        [JsonPropertyName(@"hovertemplatesrc")]
        public string HoverTemplateSrc { get; set;} 

        /// <summary>
        ///     The shown name of the link.
        /// </summary>
        [JsonPropertyName(@"label")]
        public IList<object> Label { get; set;} 

        /// <summary>
        ///     Sets the source reference on Chart Studio Cloud for <c>label</c>.
        /// </summary>
        [JsonPropertyName(@"labelsrc")]
        public string LabelSrc { get; set;} 

        /// <summary>
        ///     Gets or sets the Line.
        /// </summary>
        [JsonPropertyName(@"line")]
        public Plotly.Blazor.Traces.SankeyLib.LinkLib.Line Line { get; set;} 

        /// <summary>
        ///     An integer number &#39;[0..nodes.length - 1]&#39; that represents the source
        ///     node.
        /// </summary>
        [JsonPropertyName(@"source")]
        public IList<object> Source { get; set;} 

        /// <summary>
        ///     Sets the source reference on Chart Studio Cloud for <c>source</c>.
        /// </summary>
        [JsonPropertyName(@"sourcesrc")]
        public string SourceSrc { get; set;} 

        /// <summary>
        ///     An integer number &#39;[0..nodes.length - 1]&#39; that represents the target
        ///     node.
        /// </summary>
        [JsonPropertyName(@"target")]
        public IList<object> Target { get; set;} 

        /// <summary>
        ///     Sets the source reference on Chart Studio Cloud for <c>target</c>.
        /// </summary>
        [JsonPropertyName(@"targetsrc")]
        public string TargetSrc { get; set;} 

        /// <summary>
        ///     A numeric value representing the flow volume value.
        /// </summary>
        [JsonPropertyName(@"value")]
        public IList<object> Value { get; set;} 

        /// <summary>
        ///     Sets the source reference on Chart Studio Cloud for <c>value</c>.
        /// </summary>
        [JsonPropertyName(@"valuesrc")]
        public string ValueSrc { get; set;} 

        /// <inheritdoc />
        public override bool Equals(object obj)
        {
            if (!(obj is Link other)) return false;

            return ReferenceEquals(this, obj) || Equals(other);
        }

        /// <inheritdoc />
        public bool Equals([AllowNull] Link other)
        {
            if (other == null) return false;
            if (ReferenceEquals(this, other)) return true;

            return 
                (
                    ArrowLen == other.ArrowLen ||
                    ArrowLen != null &&
                    ArrowLen.Equals(other.ArrowLen)
                ) && 
                (
                    Color == other.Color ||
                    Color != null &&
                    Color.Equals(other.Color)
                ) && 
                (
                    Equals(ColorArray, other.ColorArray) ||
                    ColorArray != null && other.ColorArray != null &&
                    ColorArray.SequenceEqual(other.ColorArray)
                ) &&
                (
                    Equals(ColorScales, other.ColorScales) ||
                    ColorScales != null && other.ColorScales != null &&
                    ColorScales.SequenceEqual(other.ColorScales)
                ) &&
                (
                    ColorSrc == other.ColorSrc ||
                    ColorSrc != null &&
                    ColorSrc.Equals(other.ColorSrc)
                ) && 
                (
                    Equals(CustomData, other.CustomData) ||
                    CustomData != null && other.CustomData != null &&
                    CustomData.SequenceEqual(other.CustomData)
                ) &&
                (
                    CustomDataSrc == other.CustomDataSrc ||
                    CustomDataSrc != null &&
                    CustomDataSrc.Equals(other.CustomDataSrc)
                ) && 
                (
                    HoverColor == other.HoverColor ||
                    HoverColor != null &&
                    HoverColor.Equals(other.HoverColor)
                ) && 
                (
                    Equals(HoverColorArray, other.HoverColorArray) ||
                    HoverColorArray != null && other.HoverColorArray != null &&
                    HoverColorArray.SequenceEqual(other.HoverColorArray)
                ) &&
                (
                    HoverColorSrc == other.HoverColorSrc ||
                    HoverColorSrc != null &&
                    HoverColorSrc.Equals(other.HoverColorSrc)
                ) && 
                (
                    HoverInfo == other.HoverInfo ||
                    HoverInfo != null &&
                    HoverInfo.Equals(other.HoverInfo)
                ) && 
                (
                    HoverLabel == other.HoverLabel ||
                    HoverLabel != null &&
                    HoverLabel.Equals(other.HoverLabel)
                ) && 
                (
                    HoverTemplate == other.HoverTemplate ||
                    HoverTemplate != null &&
                    HoverTemplate.Equals(other.HoverTemplate)
                ) && 
                (
                    Equals(HoverTemplateArray, other.HoverTemplateArray) ||
                    HoverTemplateArray != null && other.HoverTemplateArray != null &&
                    HoverTemplateArray.SequenceEqual(other.HoverTemplateArray)
                ) &&
                (
                    HoverTemplateSrc == other.HoverTemplateSrc ||
                    HoverTemplateSrc != null &&
                    HoverTemplateSrc.Equals(other.HoverTemplateSrc)
                ) && 
                (
                    Equals(Label, other.Label) ||
                    Label != null && other.Label != null &&
                    Label.SequenceEqual(other.Label)
                ) &&
                (
                    LabelSrc == other.LabelSrc ||
                    LabelSrc != null &&
                    LabelSrc.Equals(other.LabelSrc)
                ) && 
                (
                    Line == other.Line ||
                    Line != null &&
                    Line.Equals(other.Line)
                ) && 
                (
                    Equals(Source, other.Source) ||
                    Source != null && other.Source != null &&
                    Source.SequenceEqual(other.Source)
                ) &&
                (
                    SourceSrc == other.SourceSrc ||
                    SourceSrc != null &&
                    SourceSrc.Equals(other.SourceSrc)
                ) && 
                (
                    Equals(Target, other.Target) ||
                    Target != null && other.Target != null &&
                    Target.SequenceEqual(other.Target)
                ) &&
                (
                    TargetSrc == other.TargetSrc ||
                    TargetSrc != null &&
                    TargetSrc.Equals(other.TargetSrc)
                ) && 
                (
                    Equals(Value, other.Value) ||
                    Value != null && other.Value != null &&
                    Value.SequenceEqual(other.Value)
                ) &&
                (
                    ValueSrc == other.ValueSrc ||
                    ValueSrc != null &&
                    ValueSrc.Equals(other.ValueSrc)
                );
        }

        /// <inheritdoc />
        public override int GetHashCode()
        {
            unchecked // Overflow is fine, just wrap
            {
                var hashCode = 41;
                if (ArrowLen != null) hashCode = hashCode * 59 + ArrowLen.GetHashCode();
                if (Color != null) hashCode = hashCode * 59 + Color.GetHashCode();
                if (ColorArray != null) hashCode = hashCode * 59 + ColorArray.GetHashCode();
                if (ColorScales != null) hashCode = hashCode * 59 + ColorScales.GetHashCode();
                if (ColorSrc != null) hashCode = hashCode * 59 + ColorSrc.GetHashCode();
                if (CustomData != null) hashCode = hashCode * 59 + CustomData.GetHashCode();
                if (CustomDataSrc != null) hashCode = hashCode * 59 + CustomDataSrc.GetHashCode();
                if (HoverColor != null) hashCode = hashCode * 59 + HoverColor.GetHashCode();
                if (HoverColorArray != null) hashCode = hashCode * 59 + HoverColorArray.GetHashCode();
                if (HoverColorSrc != null) hashCode = hashCode * 59 + HoverColorSrc.GetHashCode();
                if (HoverInfo != null) hashCode = hashCode * 59 + HoverInfo.GetHashCode();
                if (HoverLabel != null) hashCode = hashCode * 59 + HoverLabel.GetHashCode();
                if (HoverTemplate != null) hashCode = hashCode * 59 + HoverTemplate.GetHashCode();
                if (HoverTemplateArray != null) hashCode = hashCode * 59 + HoverTemplateArray.GetHashCode();
                if (HoverTemplateSrc != null) hashCode = hashCode * 59 + HoverTemplateSrc.GetHashCode();
                if (Label != null) hashCode = hashCode * 59 + Label.GetHashCode();
                if (LabelSrc != null) hashCode = hashCode * 59 + LabelSrc.GetHashCode();
                if (Line != null) hashCode = hashCode * 59 + Line.GetHashCode();
                if (Source != null) hashCode = hashCode * 59 + Source.GetHashCode();
                if (SourceSrc != null) hashCode = hashCode * 59 + SourceSrc.GetHashCode();
                if (Target != null) hashCode = hashCode * 59 + Target.GetHashCode();
                if (TargetSrc != null) hashCode = hashCode * 59 + TargetSrc.GetHashCode();
                if (Value != null) hashCode = hashCode * 59 + Value.GetHashCode();
                if (ValueSrc != null) hashCode = hashCode * 59 + ValueSrc.GetHashCode();
                return hashCode;
            }
        }

        /// <summary>
        ///     Checks for equality of the left Link and the right Link.
        /// </summary>
        /// <param name="left">Left Link.</param>
        /// <param name="right">Right Link.</param>
        /// <returns>Boolean</returns>
        public static bool operator == (Link left, Link right)
        {
            return Equals(left, right);
        }

        /// <summary>
        ///     Checks for inequality of the left Link and the right Link.
        /// </summary>
        /// <param name="left">Left Link.</param>
        /// <param name="right">Right Link.</param>
        /// <returns>Boolean</returns>
        public static bool operator != (Link left, Link right)
        {
            return !Equals(left, right);
        }

        /// <summary>
        ///     Gets a deep copy of this instance.
        /// </summary>
        /// <returns>Link</returns>
        public Link DeepClone()
        {
            return this.Copy();
        }
    }
}