/*
 * THIS FILE WAS GENERATED BY PLOTLY.BLAZOR.GENERATOR
*/

using System;
using System.Collections.Generic;
using System.Diagnostics.CodeAnalysis;
using System.IO;
using System.Linq;
using System.Runtime.Serialization.Formatters.Binary;
using System.Text.Json.Serialization;

namespace Plotly.Blazor.Traces.PieLib
{
    /// <summary>
    ///     The Marker class.
    /// </summary>
    [System.CodeDom.Compiler.GeneratedCode("Plotly.Blazor.Generator", null)]
    [Serializable]
    public class Marker : IEquatable<Marker>
    {
        /// <summary>
        ///     Sets the color of each sector. If not specified, the default trace color
        ///     set is used to pick the sector colors.
        /// </summary>
        [JsonPropertyName(@"colors")]
        public IList<object> Colors { get; set;} 

        /// <summary>
        ///     Sets the source reference on Chart Studio Cloud for <c>colors</c>.
        /// </summary>
        [JsonPropertyName(@"colorssrc")]
        public string ColorsSrc { get; set;} 

        /// <summary>
        ///     Gets or sets the Line.
        /// </summary>
        [JsonPropertyName(@"line")]
        public Plotly.Blazor.Traces.PieLib.MarkerLib.Line Line { get; set;} 

        /// <summary>
        ///     Sets the pattern within the marker.
        /// </summary>
        [JsonPropertyName(@"pattern")]
        public Plotly.Blazor.Traces.PieLib.MarkerLib.Pattern Pattern { get; set;} 

        /// <inheritdoc />
        public override bool Equals(object obj)
        {
            if (!(obj is Marker other)) return false;

            return ReferenceEquals(this, obj) || Equals(other);
        }

        /// <inheritdoc />
        public bool Equals([AllowNull] Marker other)
        {
            if (other == null) return false;
            if (ReferenceEquals(this, other)) return true;

            return 
                (
                    Equals(Colors, other.Colors) ||
                    Colors != null && other.Colors != null &&
                    Colors.SequenceEqual(other.Colors)
                ) &&
                (
                    ColorsSrc == other.ColorsSrc ||
                    ColorsSrc != null &&
                    ColorsSrc.Equals(other.ColorsSrc)
                ) && 
                (
                    Line == other.Line ||
                    Line != null &&
                    Line.Equals(other.Line)
                ) && 
                (
                    Pattern == other.Pattern ||
                    Pattern != null &&
                    Pattern.Equals(other.Pattern)
                );
        }

        /// <inheritdoc />
        public override int GetHashCode()
        {
            unchecked // Overflow is fine, just wrap
            {
                var hashCode = 41;
                if (Colors != null) hashCode = hashCode * 59 + Colors.GetHashCode();
                if (ColorsSrc != null) hashCode = hashCode * 59 + ColorsSrc.GetHashCode();
                if (Line != null) hashCode = hashCode * 59 + Line.GetHashCode();
                if (Pattern != null) hashCode = hashCode * 59 + Pattern.GetHashCode();
                return hashCode;
            }
        }

        /// <summary>
        ///     Checks for equality of the left Marker and the right Marker.
        /// </summary>
        /// <param name="left">Left Marker.</param>
        /// <param name="right">Right Marker.</param>
        /// <returns>Boolean</returns>
        public static bool operator == (Marker left, Marker right)
        {
            return Equals(left, right);
        }

        /// <summary>
        ///     Checks for inequality of the left Marker and the right Marker.
        /// </summary>
        /// <param name="left">Left Marker.</param>
        /// <param name="right">Right Marker.</param>
        /// <returns>Boolean</returns>
        public static bool operator != (Marker left, Marker right)
        {
            return !Equals(left, right);
        }

        /// <summary>
        ///     Gets a deep copy of this instance.
        /// </summary>
        /// <returns>Marker</returns>
        public Marker DeepClone()
        {
            return this.Copy();
        }
    }
}